/*
 * Decompiled with CFR 0.152.
 */
package com.github.rossrao.auctioneer.commands;

import com.github.rossrao.auctioneer.Auctioneer;
import com.github.rossrao.auctioneer.auction.AuctionData;
import com.github.rossrao.auctioneer.auction.handlers.AuctionHandler;
import com.github.rossrao.auctioneer.auction.menus.ItemsUI;
import com.github.rossrao.auctioneer.auction.menus.JoinUI;
import com.github.rossrao.auctioneer.auction.menus.RewardCollectorUI;
import com.github.rossrao.auctioneer.data.ConfigValues;
import com.github.rossrao.auctioneer.enums.JoiningType;
import com.github.rossrao.auctioneer.utils.Utils;
import com.github.rossrao.auctioneer.utils.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class AuctioneerCommand
implements CommandExecutor,
TabCompleter {
    private Auctioneer auctioneer;
    private List<String> args_zero;
    private List<String> args_zero_admin;
    private List<String> args_one;

    public AuctioneerCommand(Auctioneer auctioneer) {
        this.auctioneer = auctioneer;
        this.args_zero = Arrays.asList("join", "rewards");
        this.args_zero_admin = Arrays.asList("admin", "join", "rewards");
        this.args_one = Arrays.asList("start", "setDisplayLocation", "setNPCSpawnLocation", "setNPCTeleportLocation", "setPlayerTeleportLocation", "reload", "edit", "end", "forceStart", "removeArmorStands");
        auctioneer.getCommand("auctioneer").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender commandSender, Command command, String string2, String[] stringArray) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(Utils.colorize("This command cannot be ran in the console..."));
            return true;
        }
        Player player = (Player)commandSender;
        if (!player.hasPermission(ConfigValues.auctioneer_command_permission)) {
            player.sendMessage(Utils.colorize(ConfigValues.no_permission_message));
            return true;
        }
        if (stringArray.length < 1) {
            if (player.hasPermission(ConfigValues.admin_command_permission)) {
                ConfigValues.admin_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
            }
            ConfigValues.auctioneer_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("join")) {
            if (ConfigValues.joining_type == JoiningType.COMMAND) {
                AuctionHandler.addParticipant(player);
            } else {
                player.openInventory(new JoinUI(this.auctioneer).open(player));
            }
            return true;
        }
        if (stringArray[0].equalsIgnoreCase("rewards")) {
            player.openInventory(new RewardCollectorUI(this.auctioneer).open(player));
        } else if (stringArray[0].equalsIgnoreCase("admin")) {
            if (!player.hasPermission(ConfigValues.admin_command_permission)) {
                player.sendMessage(Utils.colorize(ConfigValues.no_permission_message));
                return true;
            }
            if (stringArray.length < 2) {
                ConfigValues.admin_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("start")) {
                AuctionData auctionData = new AuctionData();
                if (Auctioneer.isCitizensEnabled() && ConfigValues.npc_enabled) {
                    if (auctionData.getDisplayLocation() == null || auctionData.getPlayerTeleportLocation() == null || auctionData.getNPCSpawnLocation() == null || auctionData.getNPCTeleportLocation() == null) {
                        player.sendMessage(Utils.colorize("&bBefore the Auctioneer plugin is used, please set it up properly"));
                        player.sendMessage(Utils.colorize(""));
                        player.sendMessage(Utils.colorize("&f&lHow to set up:"));
                        player.sendMessage(Utils.colorize("&b1. Set display location with &b/auctioneer admin setDisplayLocation"));
                        player.sendMessage(Utils.colorize("&b2. Set player teleport location with &b/auctioneer admin setPlayerTeleportLocation"));
                        player.sendMessage(Utils.colorize("&b3. Set npc spawn location with &b/auctioneer admin setNPCSpawnLocation"));
                        player.sendMessage(Utils.colorize("&b4. Set npc teleport location with &b/auctioneer admin setNPCTeleportLocation"));
                        player.sendMessage(Utils.colorize(""));
                        player.sendMessage(Utils.colorize("&9Make sure to add items to the auction with &3/auctioneer admin edit &9too!"));
                        return true;
                    }
                } else if (auctionData.getDisplayLocation() == null || auctionData.getPlayerTeleportLocation() == null) {
                    player.sendMessage(Utils.colorize("&bBefore the Auctioneer plugin is used, please set it up properly"));
                    player.sendMessage(Utils.colorize(""));
                    player.sendMessage(Utils.colorize("&f&lHow to set up:"));
                    player.sendMessage(Utils.colorize("&b1. Set display location with &b/auctioneer admin setDisplayLocation"));
                    player.sendMessage(Utils.colorize("&b2. Set player teleport location with &b/auctioneer admin setPlayerTeleportLocation"));
                    player.sendMessage(Utils.colorize(""));
                    player.sendMessage(Utils.colorize("&9Make sure to add items to the auction with &3/auctioneer admin edit &9too!"));
                    return true;
                }
                if (AuctionHandler.active || AuctionHandler.auctionOpen.get()) {
                    player.sendMessage(Utils.colorize("&cThere is already an auction in progress!"));
                    return true;
                }
                new AuctionHandler().start();
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("setDisplayLocation")) {
                Block block = player.getTargetBlock(null, 5);
                if (block == null || block.getType() != XMaterial.GLASS.parseMaterial()) {
                    player.sendMessage(Utils.colorize("&cYou must be looking at a glass block to set the display location."));
                    return true;
                }
                new AuctionData().setDisplayLocation(block.getLocation());
                player.sendMessage(Utils.colorize("&bLocation set."));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("setNPCSpawnLocation")) {
                new AuctionData().setNPCSpawnLocation(player.getLocation());
                player.sendMessage(Utils.colorize("&bLocation set."));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("setNPCTeleportLocation")) {
                new AuctionData().setNPCTeleportLocation(player.getLocation());
                player.sendMessage(Utils.colorize("&bLocation set."));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("setPlayerTeleportLocation")) {
                new AuctionData().setPlayerTeleportLocation(player.getLocation());
                player.sendMessage(Utils.colorize("&bLocation set."));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("reload")) {
                this.auctioneer.reloadConfig();
                new ConfigValues();
                player.sendMessage(Utils.colorize("&bReloaded!"));
                return true;
            }
            if (stringArray[1].equalsIgnoreCase("edit")) {
                player.openInventory(new ItemsUI(this.auctioneer).open(player, 1));
            } else {
                if (stringArray[1].equalsIgnoreCase("end")) {
                    if (AuctionHandler.active || AuctionHandler.auctionOpen.get()) {
                        AuctionHandler.forceEnd();
                    } else {
                        player.sendMessage(Utils.colorize("&cThere are no auctions to end..."));
                    }
                    return true;
                }
                if (stringArray[1].equalsIgnoreCase("forceStart")) {
                    if (AuctionHandler.active) {
                        AuctionHandler.counter.set(ConfigValues.join_time * 59);
                    } else {
                        player.sendMessage(Utils.colorize("&cThere are no auctions to force start..."));
                    }
                    return true;
                }
                if (stringArray[1].equalsIgnoreCase("removeArmorStands")) {
                    for (Entity entity : player.getWorld().getNearbyEntities(player.getLocation(), 1.0, 5.0, 1.0)) {
                        if (!(entity instanceof ArmorStand)) continue;
                        entity.remove();
                    }
                    return true;
                }
                ConfigValues.admin_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
                ConfigValues.auctioneer_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
            }
        } else {
            if (player.hasPermission(ConfigValues.admin_command_permission)) {
                ConfigValues.admin_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
            }
            ConfigValues.auctioneer_help.forEach(string -> player.sendMessage(Utils.colorize(string)));
            return true;
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String string, String[] stringArray) {
        if (stringArray.length == 1) {
            if (commandSender.hasPermission(ConfigValues.admin_command_permission)) {
                return (List)StringUtil.copyPartialMatches((String)stringArray[0], this.args_zero_admin, new ArrayList());
            }
            return (List)StringUtil.copyPartialMatches((String)stringArray[0], this.args_zero, new ArrayList());
        }
        if (stringArray.length == 2 && commandSender.hasPermission(ConfigValues.admin_command_permission) && stringArray[0].equalsIgnoreCase("admin")) {
            return (List)StringUtil.copyPartialMatches((String)stringArray[1], this.args_one, new ArrayList());
        }
        return null;
    }
}

