/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.core;

import org.black_ixx.bossshop.core.prices.BSPriceType;
import org.black_ixx.bossshop.managers.ClassManager;
import org.bukkit.entity.Player;

public class BSMultiplier {
    public static final int RANGE_ALL = 0;
    public static final int RANGE_PRICE_ONLY = 1;
    public static final int RANGE_REWARD_ONLY = 2;
    private String permission = "Permission.Node";
    private BSPriceType type = BSPriceType.Nothing;
    private double multiplier = 1.0;
    private int range = 0;

    public BSMultiplier(String config_line) {
        String[] parts = config_line.split(":", 4);
        if (parts.length != 3 && parts.length != 4) {
            ClassManager.manager.getBugFinder().warn("Invalid Multiplier Group Line... \"" + config_line + "\"! It should look like this: \"Permission.Node:<type>:<multiplier>:<price/reward/both>\"");
            return;
        }
        String permission = parts[0].trim();
        if (parts[1].trim().equalsIgnoreCase("<type>")) {
            return;
        }
        BSPriceType type = BSPriceType.detectType(parts[1].trim());
        double multiplier = 1.0;
        int range = 0;
        if (type == null || !type.supportsMultipliers()) {
            ClassManager.manager.getBugFinder().warn("Invalid Multiplier Group Line... \"" + config_line + "\"! It should look like this: \"Permission.Node:<type>:<multiplier>:<price/reward/both>\". '" + parts[1].trim() + "' does not support multipliers!");
            return;
        }
        try {
            multiplier = Double.parseDouble(parts[2].trim());
        }
        catch (Exception e) {
            ClassManager.manager.getBugFinder().warn("Invalid Multiplier Group Line... \"" + config_line + "\"! It should look like this: \"Permission.Node:<type>:<multiplier>:<price/reward/both>\". '" + parts[2].trim() + "' is no valid multiplier... What you can use instead (examples): 0.25, 0.3, 0.75, 1.0, 1.5, 2.0 etc.!");
            return;
        }
        if (parts.length >= 4) {
            String rs = parts[3].trim();
            if (rs.equalsIgnoreCase("price")) {
                range = 1;
            } else if (rs.equalsIgnoreCase("reward")) {
                range = 2;
            }
        }
        this.setup(permission, type, multiplier, range);
    }

    public BSMultiplier(String permission, BSPriceType type, double multiplier, int range) {
        this.setup(permission, type, multiplier, range);
    }

    public void setup(String permission, BSPriceType type, double multiplier, int range) {
        this.permission = permission;
        this.type = type;
        this.multiplier = multiplier;
        this.range = range;
    }

    public boolean isValid() {
        return this.type.supportsMultipliers();
    }

    public BSPriceType getType() {
        return this.type;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasPermission(Player p) {
        return p.hasPermission(this.permission);
    }

    public double calculateValue(Player p, BSPriceType type, double d, int range) {
        if (this.isMultiplierActive(p, type, range)) {
            switch (this.range) {
                case 0: {
                    switch (range) {
                        case 0: {
                            return d * this.multiplier;
                        }
                        case 1: {
                            return d * this.multiplier;
                        }
                        case 2: {
                            return d / this.multiplier;
                        }
                    }
                }
                case 2: {
                    if (range != 0 && range != 2) break;
                    d *= this.multiplier;
                    break;
                }
                case 1: {
                    if (range != 0 && range != 1) break;
                    d *= this.multiplier;
                }
            }
        }
        return d;
    }

    public boolean isMultiplierActive(Player p, BSPriceType type, int range) {
        return this.type == type && this.hasPermission(p) && this.isInRange(range);
    }

    public boolean isInRange(int range) {
        switch (range) {
            case 0: {
                return true;
            }
            case 2: {
                return this.range == 2 || this.range == 0;
            }
            case 1: {
                return this.range == 1 || this.range == 0;
            }
        }
        return false;
    }

    public double calculateWithMultiplier(double d) {
        return d * this.multiplier;
    }

    public int calculateWithMultiplier(int d) {
        return (int)((double)d * this.multiplier);
    }
}

