/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.misc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.misc.Enchant;
import org.black_ixx.bossshop.misc.MathTools;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;

public class InputReader {
    public static String readString(Object o, boolean lowercase) {
        if (o == null) {
            return null;
        }
        String s = String.valueOf(o);
        if (s != null && lowercase) {
            s = s.toLowerCase();
        }
        return s;
    }

    public static List<String> readStringList(Object o) {
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            ArrayList<String> list = new ArrayList<String>();
            list.add((String)o);
            return list;
        }
        return null;
    }

    public static List<List<String>> readStringListList(Object o) {
        if (!(o instanceof List)) {
            return null;
        }
        List list = (List)o;
        if (list.isEmpty()) {
            return null;
        }
        if (list.get(0) instanceof List) {
            return (List)o;
        }
        ArrayList<List<String>> main = new ArrayList<List<String>>();
        main.add((List)o);
        return main;
    }

    public static List<ItemStack> readItemList(Object o, boolean final_version) {
        List<List<String>> list = InputReader.readStringListList(o);
        if (list != null) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (List<String> s : list) {
                items.add(ClassManager.manager.getItemStackCreator().createItemStack(s, final_version));
            }
            return items;
        }
        return null;
    }

    public static ItemStack readItem(Object o, boolean final_version) {
        List<ItemStack> list = InputReader.readItemList(o, final_version);
        if (list != null & !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public static Enchant readEnchant(Object o) {
        String[] parts;
        String s = InputReader.readString(o, false);
        if (s != null && (parts = s.split("#", 2)).length == 2) {
            int lvl;
            String p_name = parts[0].trim();
            String p_level = parts[1].trim();
            try {
                lvl = Integer.parseInt(p_level);
            }
            catch (NumberFormatException ex) {
                ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + p_level + "' is not a valid enchantment level.");
                return null;
            }
            Enchantment e = InputReader.readEnchantment(p_name);
            if (e == null) {
                ClassManager.manager.getBugFinder().severe("Mistake in Config: '" + p_name + "' is not a valid enchantment name/id.");
                return null;
            }
            return new Enchant(e, lvl);
        }
        return null;
    }

    public static Enchantment readEnchantment(String name) {
        if (name != null) {
            return EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)name.toLowerCase()));
        }
        return null;
    }

    public static boolean getBoolean(String s, boolean def) {
        if (s != null) {
            if (s.equalsIgnoreCase(Boolean.TRUE.toString()) || s.equalsIgnoreCase("yes")) {
                return true;
            }
            if (s.equalsIgnoreCase(Boolean.FALSE.toString()) || s.equalsIgnoreCase("no")) {
                return false;
            }
        }
        return def;
    }

    public static double getDouble(Object o, double exception) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return MathTools.calculate(s, exception);
            }
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return ((Long)o).longValue();
        }
        return exception;
    }

    public static int getInt(Object o, int exception) {
        if (o instanceof String) {
            String s = (String)o;
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return (int)InputReader.getDouble(s, exception);
            }
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            double d = (Double)o;
            return (int)d;
        }
        return exception;
    }

    public static HashMap<Integer, String> readTimedCommands(Object o) {
        List<String> list = InputReader.readStringList(o);
        if (list != null) {
            HashMap<Integer, String> cmds = new HashMap<Integer, String>();
            for (String s : list) {
                try {
                    String[] parts = s.split(":", 2);
                    String a1 = parts[0].trim();
                    int i = Integer.parseInt(a1);
                    String cmd = parts[1].trim();
                    cmds.put(i, cmd);
                }
                catch (Exception e) {
                    return null;
                }
            }
            return cmds;
        }
        return null;
    }

    public static Material readMaterial(String s) {
        Material m = Material.matchMaterial((String)s, (boolean)false);
        if (m == null) {
            m = Material.matchMaterial((String)s, (boolean)true);
        }
        return m;
    }

    public static EntityType readEntityType(String s) {
        for (EntityType e : EntityType.values()) {
            if (!e.name().replace("_", "").equalsIgnoreCase(s.replace("_", ""))) continue;
            return e;
        }
        return null;
    }
}

