/*
 * Decompiled with CFR 0.152.
 */
package org.black_ixx.bossshop.managers.serverpinging;

import java.util.List;
import org.black_ixx.bossshop.BossShop;
import org.black_ixx.bossshop.managers.ClassManager;
import org.black_ixx.bossshop.managers.serverpinging.ServerConnector;
import org.black_ixx.bossshop.managers.serverpinging.ServerInfo;

public class ServerConnectorSmart
implements ServerConnector {
    private List<ServerConnector> modules;
    private ServerConnector current;
    private int current_id = -1;
    private boolean had_success;
    private int fails_amount;

    public ServerConnectorSmart(List<ServerConnector> modules) {
        this.modules = modules;
        this.had_success = ClassManager.manager.getStorageManager().getConfig().contains("serverpinging.connector");
        int connector_type = ClassManager.manager.getStorageManager().getConfig().getInt("serverpinging.connector");
        if (connector_type >= 0 && connector_type < modules.size()) {
            this.current_id = connector_type;
            this.current = modules.get(this.current_id);
        } else {
            this.next();
        }
    }

    public void next() {
        if (this.modules != null) {
            ++this.current_id;
            if (this.modules.size() <= this.current_id) {
                this.current_id = 0;
            }
            this.current = this.modules.get(this.current_id);
        }
    }

    @Override
    public boolean update(ServerInfo info) {
        if (this.current != null) {
            if (info.isWaiting()) {
                return false;
            }
            info.setBeingPinged(true);
            if (this.current.update(info)) {
                if (!this.had_success) {
                    ClassManager.manager.getStorageManager().getConfig().set("serverpinging.connector", (Object)this.current_id);
                    BossShop.log("Saving ServerPinging Connector '" + this.current.getClass() + "' to be instantly used next time.");
                    this.had_success = true;
                    this.fails_amount = 0;
                }
                info.setBeingPinged(false);
                return true;
            }
            info.hadNoSuccess();
            ++this.fails_amount;
            boolean next = false;
            if (this.had_success) {
                if (this.fails_amount > 50 & !ClassManager.manager.getSettings().getServerPingingFixConnector()) {
                    this.had_success = false;
                    next = true;
                }
            } else if (this.fails_amount > 4) {
                next = true;
            }
            if (next) {
                ClassManager.manager.getBugFinder().warn("[ServerPinging] Connector '" + this.current.getClass() + "' does not seem to fit.. Trying an other Connector type.");
                this.fails_amount = 0;
                this.next();
            }
        }
        info.setBeingPinged(false);
        return false;
    }
}

