/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7;

import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.IWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.WrappedState;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.IWorldGuardImplementation;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.flag.AbstractWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.region.WrappedRegion;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.implementation.v7.utility.WorldGuardFlagUtilities;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.region.IWrappedRegion;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ICuboidSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.IPolygonalSelection;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.selection.ISelection;
import com.sk89q.minecraft.util.commands.CommandException;
import com.sk89q.worldedit.IncompleteRegionException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Polygonal2DRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.DoubleFlag;
import com.sk89q.worldguard.protection.flags.EnumFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.IntegerFlag;
import com.sk89q.worldguard.protection.flags.LocationFlag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.StringFlag;
import com.sk89q.worldguard.protection.flags.VectorFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.managers.RegionManager;
import com.sk89q.worldguard.protection.regions.ProtectedCuboidRegion;
import com.sk89q.worldguard.protection.regions.ProtectedPolygonalRegion;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class WorldGuardImplementation
implements IWorldGuardImplementation {
    private final WorldGuard core = WorldGuard.getInstance();
    private final FlagRegistry flagRegistry = this.core.getFlagRegistry();
    private final WorldGuardPlugin worldGuardPlugin = WorldGuardPlugin.inst();
    private final WorldEditPlugin worldEditPlugin;

    public WorldGuardImplementation() {
        try {
            this.worldEditPlugin = this.worldGuardPlugin.getWorldEdit();
        }
        catch (CommandException commandException) {
            throw new RuntimeException(commandException);
        }
    }

    private Optional<LocalPlayer> wrapPlayer(Player player) {
        return Optional.ofNullable(player).map(player2 -> this.worldGuardPlugin.wrapPlayer(player));
    }

    private Optional<RegionManager> getWorldManager(@NonNull org.bukkit.World world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        return Optional.ofNullable(this.core.getPlatform().getRegionContainer().get(BukkitAdapter.adapt((org.bukkit.World)world)));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(regionManager -> regionManager.getApplicableRegions(BukkitAdapter.asBlockVector((Location)location)));
    }

    private Optional<ApplicableRegionSet> getApplicableRegions(@NonNull Location location, @NonNull Location location2) {
        if (location == null) {
            throw new NullPointerException("minimum is marked non-null but is null");
        }
        if (location2 == null) {
            throw new NullPointerException("maximum is marked non-null but is null");
        }
        return this.getWorldManager(location.getWorld()).map(regionManager -> regionManager.getApplicableRegions((ProtectedRegion)new ProtectedCuboidRegion("temp", BukkitAdapter.asBlockVector((Location)location), BukkitAdapter.asBlockVector((Location)location2))));
    }

    private <V> Optional<V> queryValue(Player player, @NonNull Location location, @NonNull Flag<V> flag) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        return this.getApplicableRegions(location).map(applicableRegionSet -> applicableRegionSet.queryValue((RegionAssociable)this.wrapPlayer(player).orElse(null), flag));
    }

    @Override
    public JavaPlugin getWorldGuardPlugin() {
        return WorldGuardPlugin.inst();
    }

    @Override
    public int getApiVersion() {
        return 7;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> getFlag(String string, Class<T> clazz) {
        return Optional.ofNullable(this.flagRegistry.get(string)).map(flag -> WorldGuardFlagUtilities.wrap(flag, clazz));
    }

    @Override
    public <T> Optional<T> queryFlag(Player player, Location location, IWrappedFlag<T> iWrappedFlag) {
        AbstractWrappedFlag abstractWrappedFlag = (AbstractWrappedFlag)iWrappedFlag;
        return this.queryValue(player, location, abstractWrappedFlag.getHandle()).flatMap(object -> abstractWrappedFlag.fromWGValue(object));
    }

    @Override
    public Map<IWrappedFlag<?>, Object> queryApplicableFlags(Player player, Location location) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location).orElse(null);
        if (applicableRegionSet == null) {
            return Collections.emptyMap();
        }
        LocalPlayer localPlayer = this.wrapPlayer(player).orElse(null);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        for (ProtectedRegion protectedRegion : applicableRegionSet.getRegions()) {
            for (Flag flag : protectedRegion.getFlags().keySet()) {
                Object object;
                if (!hashSet.add(flag.getName()) || (object = applicableRegionSet.queryValue((RegionAssociable)localPlayer, flag)) == null) continue;
                try {
                    Map.Entry<IWrappedFlag<?>, Object> entry = WorldGuardFlagUtilities.wrap(flag, object);
                    hashMap.put(entry.getKey(), entry.getValue());
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return hashMap;
    }

    @Override
    public <T> Optional<IWrappedFlag<T>> registerFlag(String string, Class<T> clazz, T t) {
        StateFlag stateFlag;
        if (clazz.equals(WrappedState.class)) {
            stateFlag = new StateFlag(string, t == WrappedState.ALLOW);
        } else if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            stateFlag = new BooleanFlag(string);
        } else if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            stateFlag = new DoubleFlag(string);
        } else if (clazz.equals(Enum.class)) {
            stateFlag = new EnumFlag(string, clazz);
        } else if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            stateFlag = new IntegerFlag(string);
        } else if (clazz.equals(Location.class)) {
            stateFlag = new LocationFlag(string);
        } else if (clazz.equals(String.class)) {
            stateFlag = new StringFlag(string, (String)t);
        } else if (clazz.equals(Vector.class)) {
            stateFlag = new VectorFlag(string);
        } else {
            throw new IllegalArgumentException("Unsupported flag type " + clazz.getName());
        }
        try {
            this.flagRegistry.register((Flag)stateFlag);
            return Optional.of(WorldGuardFlagUtilities.wrap(stateFlag, clazz));
        }
        catch (FlagConflictException flagConflictException) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<IWrappedRegion> getRegion(org.bukkit.World world, String string) {
        return this.getWorldManager(world).map(regionManager -> regionManager.getRegion(string)).map(protectedRegion -> new WrappedRegion(world, (ProtectedRegion)protectedRegion));
    }

    @Override
    public Map<String, IWrappedRegion> getRegions(org.bukkit.World world) {
        RegionManager regionManager = this.core.getPlatform().getRegionContainer().get((World)new BukkitWorld(world));
        if (regionManager == null) {
            return Collections.emptyMap();
        }
        Map map = regionManager.getRegions();
        HashMap<String, IWrappedRegion> hashMap = new HashMap<String, IWrappedRegion>();
        map.forEach((string, protectedRegion) -> {
            IWrappedRegion cfr_ignored_0 = hashMap.put((String)string, new WrappedRegion(world, (ProtectedRegion)protectedRegion));
        });
        return hashMap;
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location).orElse(null);
        if (applicableRegionSet == null) {
            return Collections.emptySet();
        }
        return applicableRegionSet.getRegions().stream().map(protectedRegion -> new WrappedRegion(location.getWorld(), (ProtectedRegion)protectedRegion)).collect(Collectors.toSet());
    }

    @Override
    public Set<IWrappedRegion> getRegions(Location location, Location location2) {
        ApplicableRegionSet applicableRegionSet = this.getApplicableRegions(location, location2).orElse(null);
        if (applicableRegionSet == null) {
            return Collections.emptySet();
        }
        return applicableRegionSet.getRegions().stream().map(protectedRegion -> new WrappedRegion(location.getWorld(), (ProtectedRegion)protectedRegion)).collect(Collectors.toSet());
    }

    @Override
    public Optional<IWrappedRegion> addRegion(String string, List<Location> list, int n, int n2) {
        Object object;
        ProtectedCuboidRegion protectedCuboidRegion;
        org.bukkit.World world = list.get(0).getWorld();
        if (list.size() == 2) {
            protectedCuboidRegion = new ProtectedCuboidRegion(string, BukkitAdapter.asBlockVector((Location)list.get(0)), BukkitAdapter.asBlockVector((Location)list.get(1)));
        } else {
            object = list.stream().map(location -> BukkitAdapter.asBlockVector((Location)location).toBlockVector2()).collect(Collectors.toList());
            protectedCuboidRegion = new ProtectedPolygonalRegion(string, object, n, n2);
        }
        object = this.getWorldManager(world);
        if (((Optional)object).isPresent()) {
            ((RegionManager)((Optional)object).get()).addRegion((ProtectedRegion)protectedCuboidRegion);
            return Optional.of(new WrappedRegion(world, (ProtectedRegion)protectedCuboidRegion));
        }
        return Optional.empty();
    }

    @Override
    public Optional<Set<IWrappedRegion>> removeRegion(org.bukkit.World world, String string) {
        Optional<Set> optional = this.getWorldManager(world).map(regionManager -> regionManager.removeRegion(string));
        return optional.map(set -> set.stream().map(protectedRegion -> new WrappedRegion(world, (ProtectedRegion)protectedRegion)).collect(Collectors.toSet()));
    }

    @Override
    public Optional<ISelection> getPlayerSelection(@NonNull Player player) {
        Region region2;
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        try {
            region2 = this.worldEditPlugin.getSession(player).getSelection(BukkitAdapter.adapt((org.bukkit.World)player.getWorld()));
        }
        catch (IncompleteRegionException incompleteRegionException) {
            region2 = null;
        }
        return Optional.ofNullable(region2).map(region -> {
            final org.bukkit.World world = Optional.ofNullable(region.getWorld()).map(BukkitAdapter::adapt).orElse(null);
            if (world == null) {
                return null;
            }
            if (region instanceof CuboidRegion) {
                return new ICuboidSelection((Region)region){
                    final /* synthetic */ Region val$selection;
                    {
                        this.val$selection = region;
                    }

                    @Override
                    public Location getMinimumPoint() {
                        return BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)this.val$selection.getMinimumPoint());
                    }

                    @Override
                    public Location getMaximumPoint() {
                        return BukkitAdapter.adapt((org.bukkit.World)world, (BlockVector3)this.val$selection.getMaximumPoint());
                    }
                };
            }
            if (region instanceof Polygonal2DRegion) {
                return new IPolygonalSelection((Region)region, world){
                    final /* synthetic */ Region val$selection;
                    final /* synthetic */ org.bukkit.World val$world;
                    {
                        this.val$selection = region;
                        this.val$world = world;
                    }

                    @Override
                    public Set<Location> getPoints() {
                        return ((Polygonal2DRegion)this.val$selection).getPoints().stream().map(BlockVector2::toBlockVector3).map(blockVector3 -> BukkitAdapter.adapt((org.bukkit.World)this.val$world, (BlockVector3)blockVector3)).collect(Collectors.toSet());
                    }

                    @Override
                    public int getMinimumY() {
                        return this.val$selection.getMinimumPoint().getBlockY();
                    }

                    @Override
                    public int getMaximumY() {
                        return this.val$selection.getMaximumPoint().getBlockY();
                    }
                };
            }
            throw new UnsupportedOperationException("Unsupported " + region.getClass().getSimpleName() + " selection!");
        });
    }
}

