/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.listeners;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackSkinApplyEvent;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackSkinPurchaseEvent;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackTankUseEvent;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackUpgradeEvent;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackUpgradePurchaseEvent;
import com.alonsoaliaga.betterbackpacks.enums.TankType;
import com.alonsoaliaga.betterbackpacks.enums.UpgradeType;
import com.alonsoaliaga.betterbackpacks.others.BackpackHolder;
import com.alonsoaliaga.betterbackpacks.others.BackpackSkin;
import com.alonsoaliaga.betterbackpacks.others.BuyerSkinUpgrade;
import com.alonsoaliaga.betterbackpacks.others.OwnerSkinUpgrade;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.others.TierBackpack;
import com.alonsoaliaga.betterbackpacks.others.UpgradeData;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTListCompound;
import java.util.HashMap;
import java.util.TreeMap;
import java.util.UUID;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class ClickListener
implements Listener {
    private BetterBackpacks plugin;
    private boolean honeyAllowed;
    private boolean powderSnowAllowed;
    private Material HONEY_BOTTLE;
    private Material POWDER_SNOW_BUCKET;
    private final String RESPECT_MY_WORK = "997807";

    public ClickListener(BetterBackpacks betterBackpacks) {
        this.plugin = betterBackpacks;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)betterBackpacks);
        this.honeyAllowed = LocalUtils.findMaterialOrDefault("HONEY_BOTTLE", null) != null;
        this.powderSnowAllowed = LocalUtils.findMaterialOrDefault("POWDER_SNOW_BUCKET", null) != null;
        this.HONEY_BOTTLE = this.honeyAllowed ? LocalUtils.findMaterial("HONEY_BOTTLE") : Material.GLASS;
        LocalUtils.logp(this.honeyAllowed ? "Honey support found. Enabling.." : "Honey support not found. Skipping..");
        this.POWDER_SNOW_BUCKET = this.powderSnowAllowed ? LocalUtils.findMaterial("POWDER_SNOW_BUCKET") : Material.GLASS;
        LocalUtils.logp(this.powderSnowAllowed ? "Powder Snow support found. Enabling.." : "Powder Snow support not found. Skipping..");
        this.reloadMessages();
    }

    public void reloadMessages() {
        FileConfiguration fileConfiguration = this.plugin.getFiles().getConfig().get();
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onClick(InventoryClickEvent inventoryClickEvent) {
        if (inventoryClickEvent.getInventory().getHolder() instanceof BackpackHolder) {
            BackpackHolder backpackHolder = (BackpackHolder)inventoryClickEvent.getInventory().getHolder();
            Player player = (Player)inventoryClickEvent.getWhoClicked();
            if (backpackHolder.getType() == 0) {
                inventoryClickEvent.setCancelled(true);
                if (inventoryClickEvent.getRawSlot() == 1) {
                    player.closeInventory();
                    return;
                }
                if (inventoryClickEvent.getRawSlot() == 33 && player.hasPermission(this.plugin.permissions.adminPermission) && inventoryClickEvent.getCurrentItem() != null && inventoryClickEvent.getCurrentItem().getType() == this.plugin.backpackMaterial) {
                    int n = backpackHolder.getTier();
                    NBTItem nBTItem = new NBTItem(inventoryClickEvent.getCurrentItem());
                    if (nBTItem.hasKey("betterbackpacks-backpack").booleanValue()) {
                        NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
                    } else {
                        NBTCompound nBTCompound = nBTItem.addCompound("betterbackpacks-backpack");
                        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
                        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
                    }
                    player.getInventory().addItem(new ItemStack[]{nBTItem.getItem()});
                    player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                } else if (inventoryClickEvent.getRawSlot() >= 2 && inventoryClickEvent.getRawSlot() <= 7) {
                    int n = inventoryClickEvent.getRawSlot() - 1;
                    if (this.plugin.backpacksRecipesMap.containsKey(n) && this.plugin.hasTierAllowed(player, n)) {
                        player.openInventory(this.plugin.backpacksRecipesMap.get(n));
                    } else {
                        player.sendMessage(this.plugin.backpackRecipeMessageMap.get(n));
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    }
                }
            } else if (backpackHolder.getType() == 1) {
                inventoryClickEvent.setCancelled(true);
                if (!this.plugin.uniqueBackpacks) {
                    player.closeInventory();
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                if (this.plugin.uniqueBackpacksMap.containsKey(inventoryClickEvent.getRawSlot()) && player.hasPermission(this.plugin.permissions.adminPermission)) {
                    player.closeInventory();
                    this.plugin.openUniqueTierGUI(player, this.plugin.uniqueBackpacksMap.get(inventoryClickEvent.getRawSlot()));
                    player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                }
            } else if (backpackHolder.getType() == 2) {
                inventoryClickEvent.setCancelled(true);
                if (!player.hasPermission(this.plugin.permissions.adminPermission)) {
                    player.closeInventory();
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                if (inventoryClickEvent.getRawSlot() == 10) {
                    player.closeInventory();
                    player.openInventory(this.plugin.uniqueInventory);
                    player.playSound(player.getLocation(), Sounds.CLICK_OFF.getSound(), 1.0f, 1.0f);
                } else if (inventoryClickEvent.getRawSlot() >= 11 && inventoryClickEvent.getRawSlot() <= 16) {
                    player.closeInventory();
                    if (player.getInventory().firstEmpty() == -1) {
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    } else {
                        int n = inventoryClickEvent.getRawSlot() - 10;
                        ItemStack itemStack2 = backpackHolder.getNbtItem().getItem();
                        ItemMeta itemMeta = itemStack2.getItemMeta();
                        TierBackpack tierBackpack = this.plugin.tierBackpacksMap.get(n);
                        itemMeta.setDisplayName(tierBackpack.getDisplayname());
                        itemMeta.setLore(tierBackpack.getLore());
                        itemStack2.setItemMeta(itemMeta);
                        NBTItem nBTItem = new NBTItem(itemStack2);
                        NBTCompound nBTCompound = nBTItem.hasKey("betterbackpacks-backpack") != false ? nBTItem.getCompound("betterbackpacks-backpack") : nBTItem.addCompound("betterbackpacks-backpack");
                        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n));
                        nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
                        player.getInventory().addItem(new ItemStack[]{nBTItem.getItem()});
                        player.playSound(player.getLocation(), Sounds.EXP_ORB.getSound(), 1.0f, 1.0f);
                    }
                }
            } else if (backpackHolder.getType() == 3) {
                ItemStack itemStack3;
                if (!player.getUniqueId().equals(backpackHolder.getOpener())) {
                    inventoryClickEvent.setCancelled(true);
                    return;
                }
                if (inventoryClickEvent.getClick() == ClickType.NUMBER_KEY) {
                    if (this.plugin.messages.cannotNumberKey != null) {
                        LocalUtils.sendActionBar((AlonsoUtils.AlonsoPlugin)this.plugin, player, this.plugin.messages.cannotNumberKey);
                    }
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    inventoryClickEvent.setCancelled(true);
                    return;
                }
                ItemStack itemStack4 = inventoryClickEvent.getCurrentItem();
                if (itemStack4 != null && this.plugin.disabledLeftClickMaterials.contains(itemStack4.getType()) && (inventoryClickEvent.getClick() == ClickType.SHIFT_RIGHT || inventoryClickEvent.getClick() == ClickType.RIGHT)) {
                    if (this.plugin.messages.cannotRightClick != null) {
                        LocalUtils.sendActionBar((AlonsoUtils.AlonsoPlugin)this.plugin, player, this.plugin.messages.cannotRightClick);
                    }
                    player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    inventoryClickEvent.setCancelled(true);
                    return;
                }
                if (inventoryClickEvent.getRawSlot() == 0) {
                    inventoryClickEvent.setCancelled(true);
                    if (this.plugin.permissions.tankLeftPermission != null && !player.hasPermission(this.plugin.permissions.tankLeftPermission) && !player.hasPermission(this.plugin.permissions.adminPermission)) {
                        player.sendMessage(this.plugin.messages.tankLeftUseNoPermission);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                } else if (inventoryClickEvent.getRawSlot() == 8) {
                    inventoryClickEvent.setCancelled(true);
                    if (this.plugin.permissions.tankRightPermission != null && !player.hasPermission(this.plugin.permissions.tankRightPermission) && !player.hasPermission(this.plugin.permissions.adminPermission)) {
                        player.sendMessage(this.plugin.messages.tankRightUseNoPermission);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                } else {
                    NBTItem nBTItem;
                    if (inventoryClickEvent.getClickedInventory() != null && inventoryClickEvent.getClickedInventory().getHolder() instanceof Player && itemStack4 != null && itemStack4.getType() == this.plugin.backpackMaterial && (nBTItem = new NBTItem(itemStack4)).hasKey("betterbackpacks-backpack").booleanValue()) {
                        if (!this.plugin.backpackception) {
                            inventoryClickEvent.setCancelled(true);
                            return;
                        }
                        NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                        if (nBTCompound.hasKey("betterbackpacks-backpack-uuid").booleanValue()) {
                            String string = nBTCompound.getString("betterbackpacks-backpack-uuid");
                            if (backpackHolder.getBackpackUUID().equals(string)) {
                                inventoryClickEvent.setCancelled(true);
                                return;
                            }
                        }
                    }
                    return;
                }
                if ((itemStack3 = inventoryClickEvent.getCursor()) != null && itemStack3.getType() != Material.AIR) {
                    boolean bl;
                    int n = inventoryClickEvent.getRawSlot() == 0 ? backpackHolder.getFirstTankType() : backpackHolder.getSecondTankType();
                    int n2 = inventoryClickEvent.getRawSlot() == 0 ? backpackHolder.getFirstTankLevel() : backpackHolder.getSecondTankLevel();
                    boolean bl2 = bl = inventoryClickEvent.getRawSlot() == 0;
                    if (n == -1) {
                        if (itemStack3.getAmount() > 0) {
                            if (itemStack3.getType() == Material.WATER_BUCKET) {
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, 0, 1, TankType.WATER, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankType(0);
                                    backpackHolder.setFirstTankLevel(1);
                                } else {
                                    backpackHolder.setSecondTankType(0);
                                    backpackHolder.setSecondTankLevel(1);
                                }
                                player.playSound(player.getLocation(), Sounds.WATER.getSound(), 1.0f, 1.0f);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(0).getDisplay(1));
                            } else if (itemStack3.getType() == Material.LAVA_BUCKET) {
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, 0, 1, TankType.LAVA, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankType(1);
                                    backpackHolder.setFirstTankLevel(1);
                                } else {
                                    backpackHolder.setSecondTankType(1);
                                    backpackHolder.setSecondTankLevel(1);
                                }
                                player.playSound(player.getLocation(), Sounds.LAVA.getSound(), 1.0f, 1.0f);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(1).getDisplay(1));
                            } else if (itemStack3.getType() == Material.MILK_BUCKET) {
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, 0, 1, TankType.MILK, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankType(2);
                                    backpackHolder.setFirstTankLevel(1);
                                } else {
                                    backpackHolder.setSecondTankType(2);
                                    backpackHolder.setSecondTankLevel(1);
                                }
                                player.playSound(player.getLocation(), Sounds.COW_IDLE.getSound(), 1.0f, 1.0f);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(2).getDisplay(1));
                            } else if (this.honeyAllowed && itemStack3.getType() == this.HONEY_BOTTLE) {
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, 0, 1, TankType.HONEY, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.GLASS_BOTTLE));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankType(3);
                                    backpackHolder.setFirstTankLevel(1);
                                } else {
                                    backpackHolder.setSecondTankType(3);
                                    backpackHolder.setSecondTankLevel(1);
                                }
                                player.playSound(player.getLocation(), Sounds.BREWING.getSound(), 1.0f, 1.0f);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(3).getDisplay(1));
                            } else if (this.powderSnowAllowed && itemStack3.getType() == this.POWDER_SNOW_BUCKET) {
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, 0, 1, TankType.POWDER_SNOW, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankType(TankType.POWDER_SNOW.getId());
                                    backpackHolder.setFirstTankLevel(1);
                                } else {
                                    backpackHolder.setSecondTankType(TankType.POWDER_SNOW.getId());
                                    backpackHolder.setSecondTankLevel(1);
                                }
                                player.playSound(player.getLocation(), Sounds.BLOCK_POWDER_SNOW_PLACE.getSound(), 1.0f, 1.0f);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(TankType.POWDER_SNOW.getId()).getDisplay(1));
                            }
                        }
                        return;
                    }
                    if (n == 0) {
                        if (itemStack3.getAmount() > 0) {
                            if (itemStack3.getType() == Material.WATER_BUCKET) {
                                if (n2 >= 6) {
                                    return;
                                }
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, n2, n2 + 1, TankType.WATER, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(0).getDisplay(backpackHolder.getFirstTankLevel()));
                                } else {
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(0).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.WATER.getSound(), 1.0f, 1.0f);
                            } else if (itemStack3.getType() == Material.BUCKET) {
                                Object object;
                                if (bl) {
                                    if (backpackHolder.getFirstTankLevel() <= 1) {
                                        object = new BackpackTankUseEvent(player, 1, 0, TankType.WATER, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankType(-1);
                                        backpackHolder.setFirstTankLevel(0);
                                        inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                    } else {
                                        object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.WATER, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() - 1);
                                        inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(0).getDisplay(backpackHolder.getFirstTankLevel()));
                                    }
                                } else if (backpackHolder.getSecondTankLevel() <= 1) {
                                    object = new BackpackTankUseEvent(player, 1, 0, TankType.WATER, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankType(-1);
                                    backpackHolder.setSecondTankLevel(0);
                                    inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                } else {
                                    object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.WATER, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() - 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(0).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.WATER_BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    object = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.WATER_BUCKET)});
                                    if (!((HashMap)object).isEmpty()) {
                                        ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.WATER.getSound(), 1.0f, 1.0f);
                            }
                        }
                    } else if (n == 1) {
                        if (itemStack3.getAmount() > 0) {
                            if (itemStack3.getType() == Material.LAVA_BUCKET) {
                                if (n2 >= 6) {
                                    return;
                                }
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, n2, n2 + 1, TankType.LAVA, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(1).getDisplay(backpackHolder.getFirstTankLevel()));
                                } else {
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(1).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.LAVA.getSound(), 1.0f, 1.0f);
                            } else if (itemStack3.getType() == Material.BUCKET) {
                                Object object;
                                if (bl) {
                                    if (backpackHolder.getFirstTankLevel() <= 1) {
                                        object = new BackpackTankUseEvent(player, 1, 0, TankType.LAVA, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankType(-1);
                                        backpackHolder.setFirstTankLevel(0);
                                        inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                    } else {
                                        object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.LAVA, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() - 1);
                                        inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(1).getDisplay(backpackHolder.getFirstTankLevel()));
                                    }
                                } else if (backpackHolder.getSecondTankLevel() <= 1) {
                                    object = new BackpackTankUseEvent(player, 1, 0, TankType.LAVA, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankType(-1);
                                    backpackHolder.setSecondTankLevel(0);
                                    inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                } else {
                                    object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.LAVA, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() - 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(1).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.LAVA_BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    object = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.LAVA_BUCKET)});
                                    if (!((HashMap)object).isEmpty()) {
                                        ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.LAVA.getSound(), 1.0f, 1.0f);
                            }
                        }
                    } else if (n == 2) {
                        if (itemStack3.getAmount() > 0) {
                            if (itemStack3.getType() == Material.MILK_BUCKET) {
                                if (n2 >= 6) {
                                    return;
                                }
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, n2, n2 + 1, TankType.MILK, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(2).getDisplay(backpackHolder.getFirstTankLevel()));
                                } else {
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(2).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.COW_IDLE.getSound(), 1.0f, 1.0f);
                            } else if (itemStack3.getType() == Material.BUCKET) {
                                Object object;
                                if (bl) {
                                    if (backpackHolder.getFirstTankLevel() <= 1) {
                                        object = new BackpackTankUseEvent(player, 1, 0, TankType.MILK, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankType(-1);
                                        backpackHolder.setFirstTankLevel(0);
                                        inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                    } else {
                                        object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.MILK, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() - 1);
                                        inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(2).getDisplay(backpackHolder.getFirstTankLevel()));
                                    }
                                } else if (backpackHolder.getSecondTankLevel() <= 1) {
                                    object = new BackpackTankUseEvent(player, 1, 0, TankType.MILK, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankType(-1);
                                    backpackHolder.setSecondTankLevel(0);
                                    inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                } else {
                                    object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.MILK, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() - 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(2).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.MILK_BUCKET));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    object = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.MILK_BUCKET)});
                                    if (!((HashMap)object).isEmpty()) {
                                        ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.COW_IDLE.getSound(), 1.0f, 1.0f);
                            }
                        }
                    } else if (this.honeyAllowed && n == 3) {
                        if (itemStack3.getAmount() > 0) {
                            if (itemStack3.getType() == this.HONEY_BOTTLE) {
                                if (n2 >= 6) {
                                    return;
                                }
                                BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, n2, n2 + 1, TankType.HONEY, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                                if (backpackTankUseEvent.isCancelled()) {
                                    return;
                                }
                                if (bl) {
                                    backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(3).getDisplay(backpackHolder.getFirstTankLevel()));
                                } else {
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() + 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(3).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(Material.GLASS_BOTTLE));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.GLASS_BOTTLE)});
                                    if (!hashMap.isEmpty()) {
                                        hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.BREWING.getSound(), 1.0f, 1.0f);
                            } else if (itemStack3.getType() == Material.GLASS_BOTTLE) {
                                Object object;
                                if (bl) {
                                    if (backpackHolder.getFirstTankLevel() <= 1) {
                                        object = new BackpackTankUseEvent(player, 1, 0, TankType.HONEY, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankType(-1);
                                        backpackHolder.setFirstTankLevel(0);
                                        inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                    } else {
                                        object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.HONEY, bl);
                                        Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                        if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                            return;
                                        }
                                        backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() - 1);
                                        inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(3).getDisplay(backpackHolder.getFirstTankLevel()));
                                    }
                                } else if (backpackHolder.getSecondTankLevel() <= 1) {
                                    object = new BackpackTankUseEvent(player, 1, 0, TankType.HONEY, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankType(-1);
                                    backpackHolder.setSecondTankLevel(0);
                                    inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                } else {
                                    object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.HONEY, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() - 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(3).getDisplay(backpackHolder.getSecondTankLevel()));
                                }
                                if (itemStack3.getAmount() == 1) {
                                    inventoryClickEvent.getView().setCursor(new ItemStack(this.HONEY_BOTTLE));
                                } else {
                                    itemStack3.setAmount(itemStack3.getAmount() - 1);
                                    object = player.getInventory().addItem(new ItemStack[]{new ItemStack(this.HONEY_BOTTLE)});
                                    if (!((HashMap)object).isEmpty()) {
                                        ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                    }
                                }
                                player.playSound(player.getLocation(), Sounds.BREWING.getSound(), 1.0f, 1.0f);
                            }
                        }
                    } else if (this.powderSnowAllowed && n == 4 && itemStack3.getAmount() > 0) {
                        if (itemStack3.getType() == this.POWDER_SNOW_BUCKET) {
                            if (n2 >= 6) {
                                return;
                            }
                            BackpackTankUseEvent backpackTankUseEvent = new BackpackTankUseEvent(player, n2, n2 + 1, TankType.POWDER_SNOW, bl);
                            Bukkit.getServer().getPluginManager().callEvent((Event)backpackTankUseEvent);
                            if (backpackTankUseEvent.isCancelled()) {
                                return;
                            }
                            if (bl) {
                                backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() + 1);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(TankType.POWDER_SNOW.getId()).getDisplay(backpackHolder.getFirstTankLevel()));
                            } else {
                                backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() + 1);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(TankType.POWDER_SNOW.getId()).getDisplay(backpackHolder.getSecondTankLevel()));
                            }
                            if (itemStack3.getAmount() == 1) {
                                inventoryClickEvent.getView().setCursor(new ItemStack(Material.BUCKET));
                            } else {
                                itemStack3.setAmount(itemStack3.getAmount() - 1);
                                HashMap hashMap = player.getInventory().addItem(new ItemStack[]{new ItemStack(Material.BUCKET)});
                                if (!hashMap.isEmpty()) {
                                    hashMap.values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                }
                            }
                            player.playSound(player.getLocation(), Sounds.BLOCK_POWDER_SNOW_PLACE.getSound(), 1.0f, 1.0f);
                        } else if (itemStack3.getType() == Material.BUCKET) {
                            Object object;
                            if (bl) {
                                if (backpackHolder.getFirstTankLevel() <= 1) {
                                    object = new BackpackTankUseEvent(player, 1, 0, TankType.POWDER_SNOW, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setFirstTankType(-1);
                                    backpackHolder.setFirstTankLevel(0);
                                    inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                                } else {
                                    object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.POWDER_SNOW, bl);
                                    Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                    if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                        return;
                                    }
                                    backpackHolder.setFirstTankLevel(backpackHolder.getFirstTankLevel() - 1);
                                    inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(TankType.POWDER_SNOW.getId()).getDisplay(backpackHolder.getFirstTankLevel()));
                                }
                            } else if (backpackHolder.getSecondTankLevel() <= 1) {
                                object = new BackpackTankUseEvent(player, 1, 0, TankType.POWDER_SNOW, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                    return;
                                }
                                backpackHolder.setSecondTankType(-1);
                                backpackHolder.setSecondTankLevel(0);
                                inventoryClickEvent.setCurrentItem(this.plugin.emptyTank);
                            } else {
                                object = new BackpackTankUseEvent(player, n2, n2 - 1, TankType.POWDER_SNOW, bl);
                                Bukkit.getServer().getPluginManager().callEvent((Event)object);
                                if (((BackpackTankUseEvent)((Object)object)).isCancelled()) {
                                    return;
                                }
                                backpackHolder.setSecondTankLevel(backpackHolder.getSecondTankLevel() - 1);
                                inventoryClickEvent.setCurrentItem(this.plugin.tanksMap.get(TankType.POWDER_SNOW.getId()).getDisplay(backpackHolder.getSecondTankLevel()));
                            }
                            if (itemStack3.getAmount() == 1) {
                                inventoryClickEvent.getView().setCursor(new ItemStack(this.POWDER_SNOW_BUCKET));
                            } else {
                                itemStack3.setAmount(itemStack3.getAmount() - 1);
                                object = player.getInventory().addItem(new ItemStack[]{new ItemStack(this.POWDER_SNOW_BUCKET)});
                                if (!((HashMap)object).isEmpty()) {
                                    ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                                }
                            }
                            player.playSound(player.getLocation(), Sounds.BLOCK_POWDER_SNOW_PLACE.getSound(), 1.0f, 1.0f);
                        }
                    }
                }
            } else if (backpackHolder.getType() == 4) {
                inventoryClickEvent.setCancelled(true);
                if (inventoryClickEvent.getRawSlot() == this.plugin.closeSkinsSlot) {
                    player.closeInventory();
                    player.playSound(player.getLocation(), Sounds.CLICK_OFF.getSound(), 1.0f, 1.0f);
                    if (this.plugin.closeSkinsCommand != null) {
                        this.plugin.closeSkinsCommand.runCommand(player);
                    }
                } else if (inventoryClickEvent.getRawSlot() == this.plugin.previousSlot) {
                    if (backpackHolder.getPage() <= 1) {
                        return;
                    }
                    this.plugin.openSkinsShop(player, backpackHolder.getPage() - 1, true);
                    player.playSound(player.getLocation(), Sounds.CLICK_ON.getSound(), 1.0f, 1.0f);
                } else if (inventoryClickEvent.getRawSlot() == this.plugin.nextSlot) {
                    if (backpackHolder.getPage() >= this.plugin.skinsPageMap.size()) {
                        return;
                    }
                    this.plugin.openSkinsShop(player, backpackHolder.getPage() + 1, true);
                    player.playSound(player.getLocation(), Sounds.CLICK_ON.getSound(), 1.0f, 1.0f);
                } else {
                    TreeMap<Integer, BackpackSkin> treeMap = this.plugin.skinsPageMap.get(backpackHolder.getPage());
                    if (treeMap.containsKey(inventoryClickEvent.getRawSlot())) {
                        Object object;
                        BackpackSkin backpackSkin = treeMap.get(inventoryClickEvent.getRawSlot());
                        if (!backpackSkin.hasPermission(player)) {
                            player.sendMessage(backpackSkin.getNoPermissionMessage());
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        if (!backpackSkin.isFree()) {
                            if (!this.plugin.economySupport) {
                                player.sendMessage(this.plugin.messages.economyNotSupported);
                                player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                return;
                            }
                            if (!this.plugin.economy.has((OfflinePlayer)player, (double)backpackSkin.getPrice())) {
                                player.sendMessage(backpackSkin.getNotEnoughMoneyMessage());
                                player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                return;
                            }
                            object = new BackpackSkinPurchaseEvent(player, backpackSkin.getIdentifier(), backpackSkin.getPrice());
                            Bukkit.getPluginManager().callEvent((Event)object);
                            if (((BackpackSkinPurchaseEvent)((Object)object)).isCancelled()) {
                                if (this.plugin.debugMode) {
                                    LocalUtils.logp("BackpackSkinPurchaseEvent (" + backpackSkin.getIdentifier() + ") was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                                }
                                return;
                            }
                            EconomyResponse economyResponse = this.plugin.economy.withdrawPlayer((OfflinePlayer)player, (double)backpackSkin.getPrice());
                            if (!economyResponse.transactionSuccess()) {
                                if (this.plugin.debugMode) {
                                    LocalUtils.logp("Transaction error for '" + player.getName() + "' player: " + economyResponse.errorMessage);
                                }
                                player.sendMessage(this.plugin.messages.transactionError.replace("{ERROR}", economyResponse.errorMessage));
                                player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                                return;
                            }
                        } else {
                            object = new BackpackSkinPurchaseEvent(player, backpackSkin.getIdentifier(), backpackSkin.getPrice());
                            Bukkit.getPluginManager().callEvent((Event)object);
                            if (((BackpackSkinPurchaseEvent)((Object)object)).isCancelled()) {
                                if (this.plugin.debugMode) {
                                    LocalUtils.logp("BackpackSkinPurchaseEvent " + backpackSkin.getIdentifier() + " was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                                }
                                return;
                            }
                        }
                        if (!((HashMap)(object = player.getInventory().addItem(new ItemStack[]{backpackSkin.getSkinItem()}))).isEmpty()) {
                            ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                        }
                        player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                        player.sendMessage(this.plugin.messages.skinPurchased.replace("{SKIN}", backpackSkin.getDisplayName()).replace("{PRICE}", String.valueOf(backpackSkin.getPrice())));
                    }
                }
            } else if (backpackHolder.getType() == 5) {
                inventoryClickEvent.setCancelled(true);
                if (inventoryClickEvent.getRawSlot() == this.plugin.closeUpgradesSlot) {
                    player.closeInventory();
                    player.playSound(player.getLocation(), Sounds.CLICK_OFF.getSound(), 1.0f, 1.0f);
                    if (this.plugin.closeUpgradesCommand != null) {
                        this.plugin.closeUpgradesCommand.runCommand(player);
                    }
                }
                if (this.plugin.upgradesSlotsMap.containsKey(inventoryClickEvent.getRawSlot())) {
                    Object object;
                    UpgradeData upgradeData = this.plugin.upgradesSlotsMap.get(inventoryClickEvent.getRawSlot());
                    if (!upgradeData.hasPermission(player)) {
                        player.sendMessage(upgradeData.getNoPermissionMessage());
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (!upgradeData.isFree()) {
                        if (!this.plugin.economySupport) {
                            player.sendMessage(this.plugin.messages.economyNotSupported);
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        if (!this.plugin.economy.has((OfflinePlayer)player, (double)upgradeData.getPrice())) {
                            player.sendMessage(upgradeData.getNotEnoughMoneyMessage());
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        object = new BackpackUpgradePurchaseEvent(player, upgradeData.getType(), upgradeData.getPrice());
                        Bukkit.getPluginManager().callEvent((Event)object);
                        if (((BackpackUpgradePurchaseEvent)((Object)object)).isCancelled()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("BackpackUpgradePurchaseEvent (" + upgradeData.getType().name() + ") was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                            }
                            return;
                        }
                        EconomyResponse economyResponse = this.plugin.economy.withdrawPlayer((OfflinePlayer)player, (double)upgradeData.getPrice());
                        if (!economyResponse.transactionSuccess()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("Transaction error for '" + player.getName() + "' player: " + economyResponse.errorMessage);
                            }
                            player.sendMessage(this.plugin.messages.transactionError.replace("{ERROR}", economyResponse.errorMessage));
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                    } else {
                        object = new BackpackUpgradePurchaseEvent(player, upgradeData.getType(), upgradeData.getPrice());
                        Bukkit.getPluginManager().callEvent((Event)object);
                        if (((BackpackUpgradePurchaseEvent)((Object)object)).isCancelled()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("BackpackUpgradePurchaseEvent (" + upgradeData.getType().name() + ") was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                            }
                            return;
                        }
                    }
                    if (!((HashMap)(object = player.getInventory().addItem(new ItemStack[]{upgradeData.getUpgradeItem(player)}))).isEmpty()) {
                        ((HashMap)object).values().forEach(itemStack -> player.getWorld().dropItemNaturally(player.getLocation(), itemStack));
                    }
                    player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                    player.sendMessage(this.plugin.messages.upgradePurchased.replace("{UPGRADE}", upgradeData.getDisplayName(player)).replace("{PRICE}", String.valueOf(upgradeData.getPrice())));
                }
            } else {
                inventoryClickEvent.setCancelled(true);
            }
        } else {
            NBTItem nBTItem;
            if (inventoryClickEvent.isCancelled()) {
                return;
            }
            if (inventoryClickEvent.getCursor() != null && inventoryClickEvent.getCursor().getType() == this.plugin.backpackMaterial && inventoryClickEvent.getCurrentItem() != null && inventoryClickEvent.getCurrentItem().getType() == this.plugin.backpackMaterial && (nBTItem = new NBTItem(inventoryClickEvent.getCurrentItem())).hasKey("betterbackpacks-backpack").booleanValue()) {
                NBTItem nBTItem2 = new NBTItem(inventoryClickEvent.getCursor());
                if (nBTItem2.hasKey("betterbackpacks-skin").booleanValue()) {
                    String string;
                    NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                    Player player = (Player)inventoryClickEvent.getWhoClicked();
                    inventoryClickEvent.setCancelled(true);
                    if (this.plugin.permissions.skinsApplyPermission != null && player.hasPermission(this.plugin.permissions.skinsApplyPermission)) {
                        player.sendMessage(this.plugin.messages.skinsNoPermission);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (!nBTCompound.hasKey("betterbackpacks-backpack-uuid").booleanValue()) {
                        player.sendMessage(this.plugin.messages.corruptedBackpack);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    NBTCompound nBTCompound2 = nBTItem2.getCompound("betterbackpacks-skin");
                    if (!nBTCompound2.hasKey("betterbackpacks-skin-uuid").booleanValue()) {
                        player.sendMessage(this.plugin.messages.corruptedSkin);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (nBTCompound2.hasKey("betterbackpacks-skin-strict-permission").booleanValue() && !player.hasPermission(string = nBTCompound2.getString("betterbackpacks-skin-strict-permission"))) {
                        String string2 = nBTCompound2.hasKey("betterbackpacks-skin-strict-permission-message") != false ? LocalUtils.colorize(nBTCompound2.getString("betterbackpacks-skin-strict-permission-message")) : this.plugin.messages.cannotApplySkin;
                        player.sendMessage(string2.replace("{PERMISSION}", string));
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    string = nBTCompound2.getString("betterbackpacks-skin-texture");
                    String string3 = nBTCompound2.hasKey("betterbackpacks-skin-rename") != false ? nBTCompound2.getString("betterbackpacks-skin-rename") : null;
                    BackpackSkinApplyEvent backpackSkinApplyEvent = new BackpackSkinApplyEvent(player, string, string3);
                    Bukkit.getPluginManager().callEvent((Event)backpackSkinApplyEvent);
                    if (backpackSkinApplyEvent.isCancelled()) {
                        if (this.plugin.debugMode) {
                            LocalUtils.logp("BackpackSkinApplyEvent was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                        }
                        return;
                    }
                    nBTCompound.setString("betterbackpacks-backpack-texture", backpackSkinApplyEvent.getNewTexture());
                    NBTCompound nBTCompound3 = nBTItem.getCompound("SkullOwner");
                    NBTListCompound nBTListCompound = nBTCompound3.getCompound("Properties").getCompoundList("textures").get(0);
                    nBTListCompound.setString("Value", backpackSkinApplyEvent.getNewTexture());
                    ItemStack itemStack5 = nBTItem.getItem();
                    if (backpackSkinApplyEvent.getNewDisplayName() != null) {
                        ItemMeta itemMeta = itemStack5.getItemMeta();
                        itemMeta.setDisplayName(LocalUtils.colorize(backpackSkinApplyEvent.getNewDisplayName()));
                        itemStack5.setItemMeta(itemMeta);
                    }
                    if (this.plugin.getPluginUtils().isCustomModelSupported()) {
                        int n;
                        int n3 = n = inventoryClickEvent.getCursor().getItemMeta().hasCustomModelData() ? inventoryClickEvent.getCursor().getItemMeta().getCustomModelData() : 0;
                        if (n >= 0) {
                            ItemMeta itemMeta = itemStack5.getItemMeta();
                            itemMeta.setCustomModelData(Integer.valueOf(n));
                            itemStack5.setItemMeta(itemMeta);
                        }
                    }
                    inventoryClickEvent.setCurrentItem(itemStack5);
                    if (inventoryClickEvent.getCursor().getAmount() > 1) {
                        inventoryClickEvent.getCursor().setAmount(inventoryClickEvent.getCursor().getAmount() - 1);
                    } else {
                        inventoryClickEvent.getView().setCursor(null);
                    }
                    player.sendMessage(this.plugin.messages.skinApplied.replace("{SKIN}", nBTCompound2.getString("betterbackpacks-skin-displayname")));
                    player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                } else if (nBTItem2.hasKey("betterbackpacks-upgrade").booleanValue()) {
                    NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                    Player player = (Player)inventoryClickEvent.getWhoClicked();
                    inventoryClickEvent.setCancelled(true);
                    if (this.plugin.permissions.upgradesApplyPermission != null && player.hasPermission(this.plugin.permissions.upgradesApplyPermission)) {
                        player.sendMessage(this.plugin.messages.upgradesNoPermission);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (!nBTCompound.hasKey("betterbackpacks-backpack-uuid").booleanValue()) {
                        player.sendMessage(this.plugin.messages.corruptedBackpack);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    NBTCompound nBTCompound4 = nBTItem2.getCompound("betterbackpacks-upgrade");
                    if (!nBTCompound4.hasKey("betterbackpacks-upgrade-uuid").booleanValue() || !nBTCompound4.hasKey("betterbackpacks-upgrade-type").booleanValue()) {
                        player.sendMessage(this.plugin.messages.corruptedUpgrade);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    int n = nBTCompound4.getInteger("betterbackpacks-upgrade-type");
                    if (!this.plugin.upgradesLevelMap.containsKey(n)) {
                        player.sendMessage(this.plugin.messages.corruptedUpgrade);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    if (!nBTCompound.hasKey("betterbackpacks-backpack-tier").booleanValue()) {
                        player.sendMessage(this.plugin.messages.cannotUpgradeSecutiry);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    UpgradeData upgradeData = this.plugin.upgradesLevelMap.get(n);
                    if (upgradeData.isStrict() && !player.hasPermission(upgradeData.getPermission())) {
                        player.sendMessage(upgradeData.getCannotApplyPermission());
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                    int n4 = nBTCompound.getInteger("betterbackpacks-backpack-tier");
                    if (n <= 1) {
                        ItemStack itemStack6;
                        if (n4 >= 6) {
                            player.sendMessage(this.plugin.messages.upgradeAlreadyLastTier);
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        int n5 = n4 + 1;
                        BackpackUpgradeEvent backpackUpgradeEvent = new BackpackUpgradeEvent(player, UpgradeType.ONE_TIER, n4, n5);
                        Bukkit.getPluginManager().callEvent((Event)backpackUpgradeEvent);
                        if (backpackUpgradeEvent.isCancelled()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("BackpackUpgradeEvent (ONE_TIER) was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                            }
                            return;
                        }
                        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n5));
                        TierBackpack tierBackpack = this.plugin.tierBackpacksMap.get(n5);
                        if (!nBTCompound.hasKey("betterbackpacks-backpack-texture").booleanValue()) {
                            NBTCompound nBTCompound5 = nBTItem.getCompound("SkullOwner");
                            NBTListCompound nBTListCompound = nBTCompound5.getCompound("Properties").getCompoundList("textures").get(0);
                            nBTListCompound.setString("Value", tierBackpack.getTexture());
                            itemStack6 = nBTItem.getItem();
                            ItemMeta itemMeta = itemStack6.getItemMeta();
                            itemMeta.setDisplayName(tierBackpack.getDisplayname());
                            itemMeta.setLore(tierBackpack.getLore());
                            itemStack6.setItemMeta(itemMeta);
                        } else {
                            itemStack6 = nBTItem.getItem();
                            ItemMeta itemMeta = itemStack6.getItemMeta();
                            itemMeta.setLore(tierBackpack.getLore());
                            itemStack6.setItemMeta(itemMeta);
                        }
                        inventoryClickEvent.setCurrentItem(itemStack6);
                        if (inventoryClickEvent.getCursor().getAmount() > 1) {
                            inventoryClickEvent.getCursor().setAmount(inventoryClickEvent.getCursor().getAmount() - 1);
                        } else {
                            inventoryClickEvent.getView().setCursor(null);
                        }
                        player.sendMessage(this.plugin.messages.oneUpgradeSuccess.replace("{OLD_SIZE}", String.valueOf(n4 * 9)).replace("{NEW_SIZE}", String.valueOf(n5 * 9)).replace("{OLD_TIER}", String.valueOf(n4)).replace("{NEW_TIER}", String.valueOf(n5)));
                        player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                    } else if (n <= 6) {
                        ItemStack itemStack7;
                        if (n4 >= 6) {
                            player.sendMessage(this.plugin.messages.upgradeAlreadyLastTier);
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        if (n4 >= n) {
                            player.sendMessage(this.plugin.messages.upgradeBackpackTierIsGreater);
                            player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        int n6 = n;
                        BackpackUpgradeEvent backpackUpgradeEvent = new BackpackUpgradeEvent(player, UpgradeType.getById(n), n4, n6);
                        Bukkit.getPluginManager().callEvent((Event)backpackUpgradeEvent);
                        if (backpackUpgradeEvent.isCancelled()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("BackpackUpgradeEvent (" + upgradeData.getType().name() + ") was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                            }
                            return;
                        }
                        nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(n6));
                        TierBackpack tierBackpack = this.plugin.tierBackpacksMap.get(n6);
                        if (!nBTCompound.hasKey("betterbackpacks-backpack-texture").booleanValue()) {
                            NBTCompound nBTCompound6 = nBTItem.getCompound("SkullOwner");
                            NBTListCompound nBTListCompound = nBTCompound6.getCompound("Properties").getCompoundList("textures").get(0);
                            nBTListCompound.setString("Value", tierBackpack.getTexture());
                            itemStack7 = nBTItem.getItem();
                            ItemMeta itemMeta = itemStack7.getItemMeta();
                            itemMeta.setDisplayName(tierBackpack.getDisplayname());
                            itemMeta.setLore(tierBackpack.getLore());
                            itemStack7.setItemMeta(itemMeta);
                        } else {
                            itemStack7 = nBTItem.getItem();
                            ItemMeta itemMeta = itemStack7.getItemMeta();
                            itemMeta.setLore(tierBackpack.getLore());
                            itemStack7.setItemMeta(itemMeta);
                        }
                        inventoryClickEvent.setCurrentItem(itemStack7);
                        if (inventoryClickEvent.getCursor().getAmount() > 1) {
                            inventoryClickEvent.getCursor().setAmount(inventoryClickEvent.getCursor().getAmount() - 1);
                        } else {
                            inventoryClickEvent.getView().setCursor(null);
                        }
                        player.sendMessage(this.plugin.messages.directUpgradeSuccess.replace("{OLD_SIZE}", String.valueOf(n4 * 9)).replace("{NEW_SIZE}", String.valueOf(n6 * 9)).replace("{OLD_TIER}", String.valueOf(n4)).replace("{NEW_TIER}", String.valueOf(n6)));
                        player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                    } else if (n <= 8) {
                        ItemStack itemStack8;
                        BackpackUpgradeEvent backpackUpgradeEvent = new BackpackUpgradeEvent(player, UpgradeType.getById(n), n4, n4);
                        Bukkit.getPluginManager().callEvent((Event)backpackUpgradeEvent);
                        if (backpackUpgradeEvent.isCancelled()) {
                            if (this.plugin.debugMode) {
                                LocalUtils.logp("BackpackUpgradeEvent (" + upgradeData.getType().name() + ") was fired correctly by BetterBackpacks Pro but it was cancelled by other plugin.");
                            }
                            return;
                        }
                        if (n == 7) {
                            OwnerSkinUpgrade ownerSkinUpgrade = (OwnerSkinUpgrade)upgradeData;
                            nBTCompound.setString("betterbackpacks-backpack-texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=");
                            itemStack8 = nBTItem.getItem();
                            SkullMeta skullMeta = (SkullMeta)itemStack8.getItemMeta();
                            LocalUtils.setSkullOwner(player, skullMeta);
                            if (ownerSkinUpgrade.hasRename()) {
                                skullMeta.setDisplayName(ownerSkinUpgrade.getRename(player));
                            }
                            itemStack8.setItemMeta((ItemMeta)skullMeta);
                        } else {
                            String string = nBTCompound4.getString("betterbackpacks-upgrade-buyer-name");
                            String string4 = nBTCompound4.getString("betterbackpacks-upgrade-buyer-uuid");
                            UUID uUID = AlonsoUtils.UNKNOWN_UUID;
                            try {
                                uUID = UUID.fromString(string4);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            nBTCompound.setString("betterbackpacks-backpack-texture", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0=");
                            itemStack8 = nBTItem.getItem();
                            SkullMeta skullMeta = (SkullMeta)itemStack8.getItemMeta();
                            LocalUtils.setSkullOwner(string, uUID, skullMeta);
                            BuyerSkinUpgrade buyerSkinUpgrade = (BuyerSkinUpgrade)upgradeData;
                            if (buyerSkinUpgrade.hasRename()) {
                                if (nBTCompound4.hasKey("betterbackpacks-upgrade-rename").booleanValue()) {
                                    skullMeta.setDisplayName(nBTCompound4.getString("betterbackpacks-upgrade-rename"));
                                } else {
                                    skullMeta.setDisplayName(buyerSkinUpgrade.getRename(player));
                                }
                            }
                            itemStack8.setItemMeta((ItemMeta)skullMeta);
                        }
                        inventoryClickEvent.setCurrentItem(itemStack8);
                        if (inventoryClickEvent.getCursor().getAmount() > 1) {
                            inventoryClickEvent.getCursor().setAmount(inventoryClickEvent.getCursor().getAmount() - 1);
                        } else {
                            inventoryClickEvent.getView().setCursor(null);
                        }
                        player.sendMessage((n == 7 ? this.plugin.messages.upgradeOwnerSkin : this.plugin.messages.upgradeBuyerSkin).replace("{UPGRADE}", upgradeData.getDisplayName(player)));
                        player.playSound(player.getLocation(), Sounds.LEVEL_UP.getSound(), 1.0f, 1.0f);
                    } else {
                        player.sendMessage(this.plugin.messages.unknownUpgrade);
                        player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                        return;
                    }
                }
            }
        }
    }
}

