/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.listeners;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackCloseEvent;
import com.alonsoaliaga.betterbackpacks.others.BackpackHolder;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.utils.Base64Serialization;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class CloseListener
implements Listener {
    private BetterBackpacks plugin;

    public CloseListener(BetterBackpacks betterBackpacks) {
        this.plugin = betterBackpacks;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)betterBackpacks);
        this.reloadMessages();
    }

    public void reloadMessages() {
    }

    @EventHandler
    public void onClose(InventoryCloseEvent inventoryCloseEvent) {
        BackpackHolder backpackHolder;
        if (inventoryCloseEvent.getInventory().getHolder() instanceof BackpackHolder && (backpackHolder = (BackpackHolder)inventoryCloseEvent.getInventory().getHolder()).getType() == 3) {
            this.plugin.interactListener.interactSet.add(inventoryCloseEvent.getPlayer().getUniqueId());
            inventoryCloseEvent.getPlayer().getInventory().setHeldItemSlot(backpackHolder.getHotBarSlot());
            ItemStack itemStack = this.plugin.getPluginUtils().isV1_8() ? inventoryCloseEvent.getPlayer().getItemInHand() : inventoryCloseEvent.getPlayer().getInventory().getItemInMainHand();
            if (itemStack != null && itemStack.getType() == this.plugin.backpackMaterial) {
                NBTItem nBTItem = new NBTItem(itemStack);
                if (nBTItem.hasKey("betterbackpacks-backpack").booleanValue()) {
                    NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                    if (nBTCompound.hasKey("betterbackpacks-backpack-uuid").booleanValue()) {
                        String string = nBTCompound.getString("betterbackpacks-backpack-uuid");
                        if (backpackHolder.getBackpackUUID().equals(string)) {
                            Player player = (Player)inventoryCloseEvent.getPlayer();
                            nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(inventoryCloseEvent.getView().getTopInventory().getSize() / 9));
                            nBTCompound.setByteArray("betterbackpacks-backpack-content", Base64Serialization.toBase64(inventoryCloseEvent.getView().getTopInventory(), backpackHolder));
                            player.playSound(player.getLocation(), Sounds.CHEST_CLOSE.getSound(), 1.0f, 1.0f);
                            ItemStack itemStack2 = nBTItem.getItem();
                            if (itemStack2.getAmount() != 1) {
                                itemStack2.setAmount(1);
                            }
                            inventoryCloseEvent.getPlayer().getInventory().setHeldItemSlot(backpackHolder.getHotBarSlot());
                            if (this.plugin.getPluginUtils().isV1_8()) {
                                player.setItemInHand(itemStack2);
                            } else {
                                player.getInventory().setItemInMainHand(itemStack2);
                            }
                            inventoryCloseEvent.getPlayer().getInventory().setHeldItemSlot(backpackHolder.getHotBarSlot());
                            BackpackCloseEvent backpackCloseEvent = new BackpackCloseEvent(player, string);
                            this.plugin.getServer().getPluginManager().callEvent((Event)backpackCloseEvent);
                            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.interactListener.interactSet.remove(inventoryCloseEvent.getPlayer().getUniqueId()), 10L);
                        }
                    } else {
                        this.plugin.interactListener.interactSet.remove(inventoryCloseEvent.getPlayer().getUniqueId());
                    }
                } else {
                    this.plugin.interactListener.interactSet.remove(inventoryCloseEvent.getPlayer().getUniqueId());
                }
            } else {
                this.plugin.interactListener.interactSet.remove(inventoryCloseEvent.getPlayer().getUniqueId());
            }
        }
    }
}

