/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.listeners;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackCraftEvent;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.plugin.Plugin;

public class CraftListener
implements Listener {
    private BetterBackpacks plugin;

    public CraftListener(BetterBackpacks betterBackpacks) {
        this.plugin = betterBackpacks;
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)betterBackpacks);
        this.reloadMessages();
    }

    public void reloadMessages() {
        FileConfiguration fileConfiguration = this.plugin.getFiles().getConfig().get();
    }

    @EventHandler
    public void onCraft(CraftItemEvent craftItemEvent) {
        NBTItem nBTItem;
        if (craftItemEvent.getCurrentItem() != null && craftItemEvent.getCurrentItem().getType() == this.plugin.backpackMaterial && (nBTItem = new NBTItem(craftItemEvent.getCurrentItem())).hasKey("betterbackpacks-backpack").booleanValue()) {
            NBTCompound nBTCompound;
            Player player = (Player)craftItemEvent.getWhoClicked();
            NBTCompound nBTCompound2 = nBTItem.getCompound("betterbackpacks-backpack");
            if (!nBTCompound2.hasKey("betterbackpacks-backpack-tier").booleanValue()) {
                craftItemEvent.setCancelled(true);
                player.sendMessage(this.plugin.messages.unknownErrorCrafting);
                return;
            }
            int n = nBTCompound2.getInteger("betterbackpacks-backpack-tier");
            if (this.plugin.permissions.tierPermission != null && !this.plugin.hasTierAllowed(player, n)) {
                craftItemEvent.setCancelled(true);
                player.sendMessage(this.plugin.backpackCraftMessageMap.get(n));
                player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                return;
            }
            if (craftItemEvent.isShiftClick()) {
                craftItemEvent.setCancelled(true);
                player.sendMessage(this.plugin.messages.cannotCraftMoreThanOneAtTheSameTime);
                player.playSound(player.getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                return;
            }
            BackpackCraftEvent backpackCraftEvent = new BackpackCraftEvent(player, n);
            this.plugin.getServer().getPluginManager().callEvent((Event)backpackCraftEvent);
            if (backpackCraftEvent.isCancelled()) {
                craftItemEvent.setCancelled(true);
                return;
            }
            NBTItem nBTItem2 = this.plugin.backpacksMap.getOrDefault(backpackCraftEvent.getTier(), nBTItem);
            if (nBTItem2.hasKey("betterbackpacks-backpack").booleanValue()) {
                nBTCompound = nBTItem2.getCompound("betterbackpacks-backpack");
            } else {
                nBTCompound = nBTItem2.addCompound("betterbackpacks-backpack");
                nBTCompound.setInteger("betterbackpacks-backpack-tier", Integer.valueOf(backpackCraftEvent.getTier()));
            }
            nBTCompound.setString("betterbackpacks-backpack-uuid", UUID.randomUUID().toString());
            craftItemEvent.setCurrentItem(nBTItem2.getItem());
            player.playSound(player.getLocation(), Sounds.PICKUP.getSound(), 1.0f, 1.0f);
        }
    }
}

