/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.listeners;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.api.events.BackpackOpenEvent;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.WorldGuardWrapper;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.IWrappedFlag;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.flag.WrappedState;
import com.alonsoaliaga.betterbackpacks.libraries.worldguardwrapper.region.IWrappedRegion;
import com.alonsoaliaga.betterbackpacks.others.BackpackHolder;
import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.utils.Base64Serialization;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class InteractListener
implements Listener {
    private BetterBackpacks plugin;
    public HashSet<UUID> interactSet;

    public InteractListener(BetterBackpacks betterBackpacks) {
        this.plugin = betterBackpacks;
        this.interactSet = new HashSet();
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)betterBackpacks);
        this.reloadMessages();
    }

    public void reloadMessages() {
        FileConfiguration fileConfiguration = this.plugin.getFiles().getConfig().get();
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent playerInteractEvent) {
        if (playerInteractEvent.hasItem() && (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) && playerInteractEvent.getItem().getType() == this.plugin.backpackMaterial) {
            NBTItem nBTItem = new NBTItem(playerInteractEvent.getItem(), true);
            if (nBTItem.hasKey("betterbackpacks-backpack").booleanValue()) {
                if (this.interactSet.contains(playerInteractEvent.getPlayer().getUniqueId())) {
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.cooldownMessage);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    playerInteractEvent.setCancelled(true);
                    return;
                }
                this.interactSet.add(playerInteractEvent.getPlayer().getUniqueId());
                playerInteractEvent.setCancelled(true);
                if (!this.plugin.getPluginUtils().isV1_8() && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.onlyMainHand);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                if (this.plugin.permissions.usePermission != null && !playerInteractEvent.getPlayer().hasPermission(this.plugin.permissions.usePermission)) {
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.backpackUseNoPermission);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                if (this.plugin.disabledWorlds.contains(playerInteractEvent.getPlayer().getWorld().getName())) {
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.disabledWorld);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                if (!this.canUseBackpack(playerInteractEvent.getPlayer())) {
                    if (!this.plugin.messages.worldGuardDisabledRegion.isEmpty()) {
                        playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.worldGuardDisabledRegion);
                        playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    }
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    return;
                }
                if (playerInteractEvent.getItem().getAmount() != 1) {
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.cannotStacked);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                NBTCompound nBTCompound = nBTItem.getCompound("betterbackpacks-backpack");
                if (nBTCompound.hasKey("betterbackpacks-backpack-uuid").booleanValue()) {
                    int n = playerInteractEvent.getPlayer().getInventory().getHeldItemSlot();
                    if (nBTCompound.hasKey("betterbackpacks-backpack-content").booleanValue()) {
                        Inventory inventory;
                        String string;
                        byte[] byArray = nBTCompound.getByteArray("betterbackpacks-backpack-content");
                        ItemMeta itemMeta = playerInteractEvent.getItem().getItemMeta();
                        String string2 = string = itemMeta.hasDisplayName() ? itemMeta.getDisplayName() : this.plugin.messages.backpackTitle;
                        if (nBTCompound.hasKey("betterbackpacks-backpack-tier").booleanValue()) {
                            int n2 = nBTCompound.getInteger("betterbackpacks-backpack-tier");
                            inventory = Base64Serialization.fromBase64(byArray, playerInteractEvent.getPlayer().getUniqueId(), string, n2, n);
                        } else {
                            inventory = Base64Serialization.fromBase64(byArray, playerInteractEvent.getPlayer().getUniqueId(), string, n);
                        }
                        if (inventory == null) {
                            this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                            String string3 = "ALP-2";
                            playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.useUnknownError.replace("{CODE}", string3));
                            playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                            return;
                        }
                        BackpackOpenEvent backpackOpenEvent = new BackpackOpenEvent(playerInteractEvent.getPlayer(), nBTCompound.getString("betterbackpacks-backpack-uuid"));
                        this.plugin.getServer().getPluginManager().callEvent((Event)backpackOpenEvent);
                        if (backpackOpenEvent.isCancelled()) {
                            this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                            return;
                        }
                        playerInteractEvent.getPlayer().openInventory(inventory);
                        playerInteractEvent.getPlayer().getInventory().setHeldItemSlot(n);
                        playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
                        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId()), 10L);
                        return;
                    }
                    if (nBTCompound.hasKey("betterbackpacks-backpack-tier").booleanValue()) {
                        BackpackOpenEvent backpackOpenEvent = new BackpackOpenEvent(playerInteractEvent.getPlayer(), nBTCompound.getString("betterbackpacks-backpack-uuid"));
                        this.plugin.getServer().getPluginManager().callEvent((Event)backpackOpenEvent);
                        if (backpackOpenEvent.isCancelled()) {
                            this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                            return;
                        }
                        int n3 = nBTCompound.getInteger("betterbackpacks-backpack-tier");
                        String string = nBTCompound.getString("betterbackpacks-backpack-uuid");
                        ItemMeta itemMeta = playerInteractEvent.getItem().getItemMeta();
                        String string4 = itemMeta.hasDisplayName() ? itemMeta.getDisplayName() : this.plugin.messages.backpackTitle;
                        Inventory inventory = Bukkit.createInventory((InventoryHolder)new BackpackHolder(playerInteractEvent.getPlayer().getUniqueId(), string, -1, 0, -1, 0, n), (int)(n3 * 9), (String)LocalUtils.fixInventoryTitle(string4));
                        inventory.setItem(0, this.plugin.emptyTank);
                        inventory.setItem(8, this.plugin.emptyTank);
                        playerInteractEvent.getPlayer().openInventory(inventory);
                        playerInteractEvent.getPlayer().getInventory().setHeldItemSlot(n);
                        playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.CHEST_OPEN.getSound(), 1.0f, 1.0f);
                        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId()), 10L);
                        return;
                    }
                } else {
                    this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                    playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.corruptedBackpack);
                    playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                    return;
                }
                this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                String string = "ALP-3";
                this.interactSet.remove(playerInteractEvent.getPlayer().getUniqueId());
                playerInteractEvent.getPlayer().sendMessage(this.plugin.messages.useUnknownError.replace("{CODE}", string));
                playerInteractEvent.getPlayer().playSound(playerInteractEvent.getPlayer().getLocation(), Sounds.ANVIL_LAND.getSound(), 1.0f, 1.0f);
                return;
            }
            if (nBTItem.hasKey("betterbackpacks-skin").booleanValue()) {
                playerInteractEvent.setCancelled(true);
            } else if (nBTItem.hasKey("betterbackpacks-upgrade").booleanValue()) {
                playerInteractEvent.setCancelled(true);
            }
        }
    }

    public boolean canUseBackpack(Player player) {
        if (this.plugin.worldGuardSupport) {
            IWrappedFlag<?> iWrappedFlag = null;
            WrappedState wrappedState = null;
            Set<IWrappedRegion> set = WorldGuardWrapper.getInstance().getRegions(player.getLocation());
            if (!set.isEmpty()) {
                Map<IWrappedFlag<?>, Object> map = WorldGuardWrapper.getInstance().queryApplicableFlags(player, player.getLocation());
                if (!map.isEmpty()) {
                    for (Map.Entry<IWrappedFlag<?>, Object> entry : map.entrySet()) {
                        if (this.plugin.debugMode) {
                            Bukkit.broadcastMessage((String)("\u00a7c[" + player.getName() + "] \u00a7bChecking flag '" + entry.getKey().getName() + "' with value: \u00a76" + entry.getValue().toString()));
                        }
                        if (!entry.getKey().getName().equals("betterbackpacks-can-use-backpack")) continue;
                        iWrappedFlag = entry.getKey();
                        if (entry.getValue() instanceof WrappedState) {
                            wrappedState = (WrappedState)((Object)entry.getValue());
                            break;
                        }
                        return this.plugin.defaultFlagIfNotSelected;
                    }
                    if (wrappedState == null) {
                        if (this.plugin.debugMode) {
                            Bukkit.broadcastMessage((String)("\u00a7c[" + player.getName() + "] \u00a7eValue of '" + "betterbackpacks-can-use-backpack" + "' flag is: \u00a7a" + wrappedState));
                        }
                        return this.plugin.defaultFlagIfNotSelected;
                    }
                    if (this.plugin.debugMode) {
                        Bukkit.broadcastMessage((String)("\u00a7c[" + player.getName() + "] \u00a7eValue of '" + "betterbackpacks-can-use-backpack" + "' flag is: \u00a7a" + wrappedState + " \u00a7eName: \u00a7a" + iWrappedFlag.getName() + " \u00a7etoString: \u00a7a" + iWrappedFlag.toString() + " \u00a72Class name: \u00a7b" + ((Object)((Object)wrappedState)).getClass().getName()));
                    }
                    return wrappedState == WrappedState.ALLOW;
                }
                if (this.plugin.debugMode) {
                    Bukkit.broadcastMessage((String)("\u00a7c[" + player.getName() + "] \u00a7eValue of '" + "betterbackpacks-can-use-backpack" + "' flag is: \u00a7a" + wrappedState + " \u00a7cNo flags selected specified for the regions."));
                }
                return this.plugin.defaultFlagIfNotSelected;
            }
            return true;
        }
        return true;
    }
}

