/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.ItemUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class BackpackSkin {
    private final String identifier;
    private final String texture;
    private final String displayName;
    private final String permission;
    private final boolean strict;
    private final int price;
    private final int customModelData;
    private final String rename;
    private final String originalRename;
    private final List<String> shopLore;
    private final List<String> itemLore;
    private final String noPermissionMessage;
    private final String notEnoughMoneyMessage;
    private final String cannotApplyPermission;
    private ItemStack shopItem;
    private ItemStack skinItem;

    public BackpackSkin(String string, String string3, String string4, String string5, boolean bl, int n, int n2, String string6, List<String> list, List<String> list2, String string7, String string8, String string9) {
        this.identifier = string;
        this.texture = string3;
        this.displayName = LocalUtils.colorize(string4);
        this.permission = string5.equalsIgnoreCase("none") ? null : string5;
        this.strict = bl && this.permission != null;
        this.price = Math.max(0, n);
        this.customModelData = Math.max(0, n2);
        this.originalRename = string6.equalsIgnoreCase("none") ? null : string6;
        this.rename = string6.equalsIgnoreCase("none") ? null : LocalUtils.colorize(string6);
        String string10 = BetterBackpacks.getInstance().messages.moneyFormat;
        this.shopLore = list.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string10).replace("{PRICE}", String.valueOf(this.price)).replace("{RENAME}", this.rename == null ? "&eRemove this line!" : this.rename))).collect(Collectors.toList());
        this.itemLore = list2.stream().map(string2 -> LocalUtils.colorize(string2.replace("{PRICE}", string10).replace("{PRICE}", String.valueOf(this.price)).replace("{RENAME}", this.rename == null ? "&eRemove this line!" : this.rename))).collect(Collectors.toList());
        this.noPermissionMessage = LocalUtils.colorize(string7);
        this.notEnoughMoneyMessage = LocalUtils.colorize(string8);
        this.cannotApplyPermission = string9;
        this.buildItem();
    }

    private void buildItem() {
        ItemMeta itemMeta;
        this.shopItem = ItemUtils.buildHead(this.displayName, this.shopLore, this.texture, AlonsoUtils.UNKNOWN_UUID);
        if (this.customModelData > 0) {
            itemMeta = this.shopItem.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            this.shopItem.setItemMeta(itemMeta);
        }
        this.skinItem = ItemUtils.buildHead(this.displayName, this.itemLore, this.texture, AlonsoUtils.UNKNOWN_UUID);
        if (this.customModelData > 0) {
            itemMeta = this.skinItem.getItemMeta();
            itemMeta.setCustomModelData(Integer.valueOf(this.customModelData));
            this.skinItem.setItemMeta(itemMeta);
        }
        itemMeta = new NBTItem(this.skinItem);
        NBTCompound nBTCompound = itemMeta.addCompound("betterbackpacks-skin");
        nBTCompound.setString("betterbackpacks-skin-displayname", this.displayName);
        nBTCompound.setString("betterbackpacks-skin-texture", this.texture);
        nBTCompound.setString("betterbackpacks-skin-uuid", AlonsoUtils.DEVELOPER_UUID.toString());
        if (this.strict) {
            nBTCompound.setString("betterbackpacks-skin-strict-permission", this.permission);
            nBTCompound.setString("betterbackpacks-skin-strict-permission-message", this.cannotApplyPermission);
        }
        if (this.originalRename != null) {
            nBTCompound.setString("betterbackpacks-skin-rename", this.originalRename);
        }
        this.skinItem = itemMeta.getItem();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public boolean hasPermission() {
        return this.permission != null;
    }

    public boolean hasPermission(@Nonnull Player player) {
        return this.permission == null || player.hasPermission(this.permission);
    }

    public String getPermission() {
        return this.permission;
    }

    public boolean hasRename() {
        return this.originalRename != null;
    }

    public String getRename() {
        return this.originalRename;
    }

    public ItemStack getShopItem() {
        return this.shopItem;
    }

    public ItemStack getSkinItem() {
        return this.skinItem;
    }

    public boolean isFree() {
        return this.price == 0;
    }

    public int getPrice() {
        return this.price;
    }

    public String getNoPermissionMessage() {
        return this.noPermissionMessage;
    }

    public String getNotEnoughMoneyMessage() {
        return this.notEnoughMoneyMessage;
    }

    public String getCannotApplyPermission() {
        return this.cannotApplyPermission;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isStrict() {
        return this.strict;
    }
}

