/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import javax.annotation.Nonnull;
import org.bukkit.Material;

public enum Color {
    BLACK(0),
    RED(1),
    GREEN(2),
    BROWN(3),
    BLUE(4),
    PURPLE(5),
    CYAN(6),
    LIGHT_GRAY(7),
    GRAY(8),
    PINK(9),
    LIME(10),
    YELLOW(11),
    LIGHT_BLUE(12),
    MAGENTA(13),
    ORANGE(14),
    WHITE(15);

    private short data;

    private Color(int n2) {
        this.data = (short)n2;
    }

    public String getName() {
        return this.name();
    }

    public short getData() {
        return this.data;
    }

    public static Color getByName(String string) {
        for (Color color : Color.values()) {
            if (!color.name().equalsIgnoreCase(string)) continue;
            return color;
        }
        return null;
    }

    public static Color getByName(String string, Color color) {
        for (Color color2 : Color.values()) {
            if (!color2.name().equalsIgnoreCase(string)) continue;
            return color2;
        }
        return color;
    }

    public static Color getById(int n) {
        for (Color color : Color.values()) {
            if (color.data != n) continue;
            return color;
        }
        return null;
    }

    public static Color getById(int n, Color color) {
        for (Color color2 : Color.values()) {
            if (color2.data != n) continue;
            return color2;
        }
        return color;
    }

    public static Color getById(short s) {
        for (Color color : Color.values()) {
            if (color.data != s) continue;
            return color;
        }
        return null;
    }

    public static Color getById(short s, Color color) {
        for (Color color2 : Color.values()) {
            if (color2.data != s) continue;
            return color2;
        }
        return color;
    }

    public short forBed() {
        return (short)(15 - this.data);
    }

    public short forGlass() {
        return (short)(15 - this.data);
    }

    public short forWool() {
        return (short)(15 - this.data);
    }

    public short forCarpet() {
        return (short)(15 - this.data);
    }

    public short forConcrete() {
        return (short)(15 - this.data);
    }

    public short forDye() {
        return this.data;
    }

    public short forBanner() {
        return this.data;
    }

    public short forMaterial(@Nonnull Material material) {
        if (material == null) {
            return 0;
        }
        String string = material.name();
        if (string.contains("GLASS")) {
            return this.forGlass();
        }
        if (string.equals("BED") || string.endsWith("_BED")) {
            return this.forBed();
        }
        if (string.contains("CONCRETE")) {
            return this.forConcrete();
        }
        if (string.equals("INK_SAC") || string.equals("INK_SACK") || string.endsWith("_DYE")) {
            return this.forDye();
        }
        if (string.contains("BANNER")) {
            return this.forBanner();
        }
        if (string.contains("WOOL") || string.contains("CARPET")) {
            return this.forWool();
        }
        return this.data;
    }
}

