/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.others.Sounds;
import com.alonsoaliaga.betterbackpacks.utils.AlonsoUtils;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandData {
    private String command;
    private Sound sound = null;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private CommandType commandType;

    public CommandData(String string) {
        this.command = string.trim();
        this.commandType = CommandType.getCommandType(this.command);
        this.loadCommand();
    }

    private void loadCommand() {
        if (this.command.startsWith(this.commandType.prefix)) {
            this.command = this.command.substring(this.commandType.prefix.length()).trim();
        }
        switch (this.commandType) {
            case PLAYER: 
            case CONSOLE: {
                if (!this.command.startsWith("/")) break;
                this.command = this.command.substring(1);
                break;
            }
            case BROADCAST_SOUND_WORLD: 
            case BROADCAST_SOUND: 
            case SOUND: {
                String[] stringArray = this.command.split(":");
                this.sound = LocalUtils.findSound(stringArray[0], Sounds.EXP_ORB.getSound());
                if (stringArray.length < 2) break;
                try {
                    this.volume = Float.parseFloat(stringArray[1]);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (stringArray.length < 3) break;
                try {
                    this.pitch = Float.parseFloat(stringArray[2]);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public void runCommand(Player player) {
        String string = this.command;
        if (player != null) {
            string = string.replace("{PLAYER}", player.getName()).replace("{WORLD}", player.getWorld().getName()).replace("{X}", String.valueOf(player.getLocation().getBlockX())).replace("{Y}", String.valueOf(player.getLocation().getBlockY())).replace("{Z}", String.valueOf(player.getLocation().getBlockZ())).replace("{UUID}", player.getUniqueId().toString());
            if (AlonsoUtils.PluginUtils.hasPlaceholderApiSupport()) {
                string = PlaceholderAPI.setPlaceholders((Player)player, (String)string);
            }
        }
        switch (this.commandType) {
            case CHAT: {
                if (player == null) break;
                player.chat(LocalUtils.colorize(string));
                break;
            }
            case MESSAGE: {
                if (player == null) break;
                player.sendMessage(LocalUtils.colorize(string));
                break;
            }
            case CONSOLE: {
                Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), string);
                break;
            }
            case BROADCAST_WORLD: {
                if (player == null) break;
                string = LocalUtils.colorize(string);
                for (Player player2 : player.getWorld().getPlayers()) {
                    player2.sendMessage(string);
                }
                break;
            }
            case BROADCAST: {
                string = LocalUtils.colorize(string);
                Bukkit.broadcastMessage((String)string);
                break;
            }
            case BROADCAST_SOUND_WORLD: {
                if (player == null || this.sound == null) break;
                for (Player player3 : player.getWorld().getPlayers()) {
                    player3.playSound(player3.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case BROADCAST_SOUND: {
                if (this.sound == null) break;
                for (Player player4 : Bukkit.getOnlinePlayers()) {
                    player4.playSound(player4.getLocation(), this.sound, this.volume, this.pitch);
                }
                break;
            }
            case SOUND: {
                if (player == null || this.sound == null) break;
                player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
                break;
            }
            default: {
                if (player == null) break;
                Bukkit.getServer().dispatchCommand((CommandSender)player, string);
            }
        }
    }

    public static enum CommandType {
        CHAT("[CHAT]"),
        CONSOLE("[CONSOLE]"),
        BROADCAST("[BROADCAST]"),
        BROADCAST_SOUND("[BROADCAST_SOUND]"),
        BROADCAST_SOUND_WORLD("[BROADCAST_SOUND_WORLD]"),
        BROADCAST_WORLD("[BROADCAST_WORLD]"),
        MESSAGE("[MESSAGE]"),
        PLAYER("[PLAYER]"),
        SOUND("[SOUND]");

        private String prefix;

        private CommandType(String string2) {
            this.prefix = string2;
        }

        public static CommandType getCommandType(String string, CommandType commandType) {
            for (CommandType commandType2 : CommandType.values()) {
                if (!string.startsWith(commandType2.prefix)) continue;
                return commandType2;
            }
            return commandType;
        }

        public static CommandType getCommandType(String string) {
            return CommandType.getCommandType(string, PLAYER);
        }
    }
}

