/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.others;

import com.alonsoaliaga.betterbackpacks.others.Color;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public enum DyeableType {
    BANNER("_BANNER", "BANNER", true),
    BED("_BED", "BED", false),
    CARPET("_CARPET", "CARPET", true),
    CONCRETE("_CONCRETE", "CONCRETE", true),
    CONCRETE_POWDER("_CONCRETE_POWDER", "CONCRETE_POWDER", true),
    DYE("_DYE", "INK_SACK", true),
    GLASS("_STAINED_GLASS", "STAINED_GLASS", true),
    GLASS_PANE("_STAINED_GLASS_PANE", "STAINED_GLASS_PANE", true),
    GLAZED_TERRACOTTA("_GLAZED_TERRACOTTA", "STAINED_CLAY", true),
    SHULKER_BOX("_SHULKER_BOX", "SHULKER_BOX", false),
    TERRACOTTA("_TERRACOTTA", "STAINED_CLAY", true),
    WOOL("_WOOL", "WOOL", true);

    private final String component;
    private final String legacy;
    private boolean legacyDyeAllowed;

    private DyeableType(String string2, String string3, boolean bl) {
        this.component = string2;
        this.legacy = string3;
        this.legacyDyeAllowed = bl;
    }

    public ItemStack getItemStack(Color color) {
        color = color == null ? Color.WHITE : color;
        try {
            return new ItemStack(Material.valueOf((String)(color.name() + this.component)));
        }
        catch (Throwable throwable) {
            try {
                Material material = Material.valueOf((String)this.legacy);
                return this.legacyDyeAllowed ? LocalUtils.createOnlyDurability(material, color.forMaterial(material)) : new ItemStack(material);
            }
            catch (Throwable throwable2) {
                return new ItemStack(Material.COBBLESTONE);
            }
        }
    }

    public static DyeableType fromString(String string, DyeableType dyeableType) {
        try {
            return DyeableType.valueOf(string);
        }
        catch (Throwable throwable) {
            return dyeableType;
        }
    }
}

