/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.utils;

import com.alonsoaliaga.betterbackpacks.others.BackpackHolder;
import com.alonsoaliaga.betterbackpacks.utils.BukkitSerializers;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;

public class Base64Serialization {
    public static byte[] toBase64(Inventory inventory, BackpackHolder backpackHolder) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)byteArrayOutputStream);
            bukkitObjectOutputStream.writeInt(inventory.getSize());
            int n = backpackHolder.getFirstTankType();
            bukkitObjectOutputStream.writeInt(n);
            bukkitObjectOutputStream.writeInt(n == -1 ? 0 : backpackHolder.getFirstTankLevel());
            int n2 = backpackHolder.getSecondTankType();
            bukkitObjectOutputStream.writeInt(n2);
            bukkitObjectOutputStream.writeInt(n2 == -1 ? 0 : backpackHolder.getSecondTankLevel());
            bukkitObjectOutputStream.writeObject((Object)backpackHolder.getBackpackUUID());
            BukkitSerializers.saveItems(inventory.getContents(), (OutputStream)bukkitObjectOutputStream);
            bukkitObjectOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            LocalUtils.logp("Error saving backpack: " + exception.getMessage());
            return null;
        }
    }

    public static Inventory fromBase64(byte[] byArray, UUID uUID, String string, int n) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)byteArrayInputStream);
            int n2 = bukkitObjectInputStream.readInt();
            int n3 = bukkitObjectInputStream.readInt();
            int n4 = bukkitObjectInputStream.readInt();
            int n5 = bukkitObjectInputStream.readInt();
            int n6 = bukkitObjectInputStream.readInt();
            String string2 = (String)bukkitObjectInputStream.readObject();
            Inventory inventory = Bukkit.getServer().createInventory((InventoryHolder)new BackpackHolder(uUID, string2, n3, n3 == -1 ? 0 : n4, n5, n5 == -1 ? 0 : n6, n), n2, LocalUtils.fixInventoryTitle(string));
            ItemStack[] itemStackArray = BukkitSerializers.loadItems((InputStream)bukkitObjectInputStream);
            inventory.setContents(itemStackArray);
            return inventory;
        }
        catch (Exception exception) {
            LocalUtils.logp("Error loading backpack: " + exception.getMessage());
            return null;
        }
    }

    public static Inventory fromBase64(byte[] byArray, UUID uUID, String string, int n, int n2) {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            BukkitObjectInputStream bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)byteArrayInputStream);
            int n3 = bukkitObjectInputStream.readInt();
            int n4 = bukkitObjectInputStream.readInt();
            int n5 = bukkitObjectInputStream.readInt();
            int n6 = bukkitObjectInputStream.readInt();
            int n7 = bukkitObjectInputStream.readInt();
            String string2 = (String)bukkitObjectInputStream.readObject();
            Inventory inventory = Bukkit.getServer().createInventory((InventoryHolder)new BackpackHolder(uUID, string2, n4, n4 == -1 ? 0 : n5, n6, n6 == -1 ? 0 : n7, n2), n * 9, LocalUtils.fixInventoryTitle(string));
            ItemStack[] itemStackArray = BukkitSerializers.loadItems((InputStream)bukkitObjectInputStream);
            inventory.setContents(itemStackArray);
            return inventory;
        }
        catch (Exception exception) {
            LocalUtils.logp("Error loading backpack: " + exception.getMessage());
            return null;
        }
    }
}

