/*
 * Decompiled with CFR 0.152.
 */
package com.alonsoaliaga.betterbackpacks.utils;

import com.alonsoaliaga.betterbackpacks.BetterBackpacks;
import com.alonsoaliaga.betterbackpacks.utils.LocalUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import de.tr7zw.nbtapi.NBTCompound;
import de.tr7zw.nbtapi.NBTItem;
import de.tr7zw.nbtapi.NBTListCompound;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class ItemUtils {
    private static ItemStack headItemSample;
    private static boolean gameProfileSupport;
    private static boolean setOwningPlayerSupport;
    private static boolean methodSetProfileSupport;
    private static boolean oldItemStackSupport;
    private static boolean nbtAPISupport;
    public static Constructor<?> CONSTRUCTOR_ITEM_STACK_OLD;
    public static Field PROFILE_FIELD;
    public static Method METHOD_SET_PROFILE;
    public static Method METHOD_SET_OWNER;

    public static SkullMeta setOwnerPlayer(SkullMeta skullMeta, UUID uUID, String string) {
        if (setOwningPlayerSupport) {
            skullMeta.setOwningPlayer(uUID == null ? Bukkit.getOfflinePlayer((String)string) : Bukkit.getOfflinePlayer((UUID)uUID));
        } else if (METHOD_SET_OWNER != null) {
            try {
                METHOD_SET_OWNER.invoke((Object)skullMeta, string);
            }
            catch (Throwable throwable) {
                if (BetterBackpacks.getInstance().debugMode) {
                    LocalUtils.logp("SkullMeta#setOwner failed using reflections. Stacktrace is because debug mode is enabled!");
                    throwable.printStackTrace();
                }
                LocalUtils.logp("SkullMeta#setOwner failed using reflections: " + throwable.getMessage());
            }
        }
        return skullMeta;
    }

    public static ItemStack getHeadBase() {
        return headItemSample.clone();
    }

    public static ItemStack buildHead(String string, UUID uUID) {
        ItemStack itemStack = headItemSample.clone();
        if (string.isEmpty()) {
            return itemStack;
        }
        if (gameProfileSupport) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            GameProfile gameProfile = new GameProfile(uUID, null);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
            if (!methodSetProfileSupport) {
                block9: {
                    try {
                        PROFILE_FIELD.set(skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block9;
                        LocalUtils.logp("Error with reflections for 'profile' field. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
                itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            } else {
                block10: {
                    try {
                        METHOD_SET_PROFILE.invoke((Object)skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block10;
                        LocalUtils.logp("Error with reflections for 'setProfile' method. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(headItemSample.clone());
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", uUID);
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static ItemStack buildHead(String string) {
        ItemStack itemStack = headItemSample.clone();
        if (string.isEmpty()) {
            return itemStack;
        }
        if (gameProfileSupport) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), null);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
            if (!methodSetProfileSupport) {
                block9: {
                    try {
                        PROFILE_FIELD.set(skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block9;
                        LocalUtils.logp("Error with reflections for 'profile' field. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
                itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            } else {
                block10: {
                    try {
                        METHOD_SET_PROFILE.invoke((Object)skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block10;
                        LocalUtils.logp("Error with reflections for 'setProfile' method. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(headItemSample.clone());
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", UUID.randomUUID());
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static ItemStack addTexture(ItemStack itemStack, String string, UUID uUID) {
        if (gameProfileSupport) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            GameProfile gameProfile = new GameProfile(uUID, null);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string));
            if (!methodSetProfileSupport) {
                block8: {
                    try {
                        PROFILE_FIELD.set(skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block8;
                        LocalUtils.logp("Error with reflections for 'profile' field. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
                itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            } else {
                block9: {
                    try {
                        METHOD_SET_PROFILE.invoke((Object)skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block9;
                        LocalUtils.logp("Error with reflections for 'setProfile' method. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(itemStack);
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", uUID);
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static ItemStack buildHead(String string, List<String> list, String string2, UUID uUID) {
        ItemStack itemStack = headItemSample.clone();
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (string != null) {
            itemMeta.setDisplayName(string);
        }
        if (list != null && !list.isEmpty()) {
            itemMeta.setLore(list);
        }
        itemStack.setItemMeta(itemMeta);
        if (gameProfileSupport) {
            SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
            GameProfile gameProfile = new GameProfile(uUID, null);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", string2));
            if (!methodSetProfileSupport) {
                block10: {
                    try {
                        PROFILE_FIELD.set(skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block10;
                        LocalUtils.logp("Error with reflections for 'profile' field. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
                itemStack = ItemStack.deserialize((Map)itemStack.serialize());
            } else {
                block11: {
                    try {
                        METHOD_SET_PROFILE.invoke((Object)skullMeta, gameProfile);
                    }
                    catch (Throwable throwable) {
                        if (!BetterBackpacks.getInstance().debugMode) break block11;
                        LocalUtils.logp("Error with reflections for 'setProfile' method. This is a debug message!");
                        throwable.printStackTrace();
                    }
                }
                itemStack.setItemMeta((ItemMeta)skullMeta);
            }
            return itemStack;
        }
        if (nbtAPISupport) {
            NBTItem nBTItem = new NBTItem(itemStack);
            NBTCompound nBTCompound = nBTItem.addCompound("SkullOwner");
            LocalUtils.setUUID(nBTCompound, "Id", uUID);
            NBTListCompound nBTListCompound = nBTCompound.addCompound("Properties").getCompoundList("textures").addCompound();
            nBTListCompound.setString("Signature", "XpRfRz6/vXE6ip7/vq+40H6W70GFB0yjG6k8hG4pmFdnJFR+VQhslE0gXX/i0OAGThcAVSIT+/W1685wUxNofAiy+EhcxGNxNSJkYfOgXEVHTCuugpr+EQCUBI6muHDKms3PqY8ECxdbFTUEuWxdeiJsGt9VjHZMmUukkGhk0IobjQS3hjQ44FiT1tXuUU86oAxqjlKFpXG/iXtpcoXa33IObSI1S3gCKzVPOkMGlHZqRqKKElB54I2Qo4g5CJ+noudIDTzxPFwEEM6XrbM0YBi+SOdRvTbmrlkWF+ndzVWEINoEf++2hkO0gfeCqFqSMHuklMSgeNr/YtFZC5ShJRRv7zbyNF33jZ5DYNVR+KAK9iLO6prZhCVUkZxb1/BjOze6aN7kyN01u3nurKX6n3yQsoQQ0anDW6gNLKzO/mCvoCEvgecjaOQarktl/xYtD4YvdTTlnAlv2bfcXUtc++3UPIUbzf/jpf2g2wf6BGomzFteyPDu4USjBdpeWMBz9PxVzlVpDAtBYClFH/PFEQHMDtL5Q+VxUPu52XlzlUreMHpLT9EL92xwCAwVBBhrarQQWuLjAQXkp3oBdw6hlX6Fj0AafMJuGkFrYzcD7nNr61l9ErZmTWnqTxkJWZfZxmYBsFgV35SKc8rkRSHBNjcdKJZVN4GA+ZQH5B55mi4=");
            nBTListCompound.setString("Value", string2);
            return nBTItem.getItem();
        }
        return itemStack;
    }

    public static ItemStack buildHead(String string, List<String> list, String string2) {
        return ItemUtils.buildHead(string, list, string2, UUID.randomUUID());
    }

    public static boolean isCustomHeadSupported() {
        return gameProfileSupport || nbtAPISupport;
    }

    public static ItemStack createDurabilityItem(Material material, int n, boolean bl) {
        if (oldItemStackSupport) {
            try {
                return (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (short)n);
            }
            catch (Throwable throwable) {
                if (BetterBackpacks.getInstance().debugMode) {
                    LocalUtils.loge("Error creating new instance for ItemStack using reflections..");
                    throwable.printStackTrace();
                }
                return new ItemStack(material);
            }
        }
        if (bl) {
            ItemStack itemStack = new ItemStack(material);
            ItemMeta itemMeta = itemStack.getItemMeta();
            if (itemMeta instanceof Damageable) {
                ((Damageable)itemMeta).setDamage(n);
                itemStack.setItemMeta(itemMeta);
            }
            return itemStack;
        }
        return new ItemStack(material);
    }

    static {
        String string;
        SkullMeta skullMeta;
        ItemStack itemStack;
        gameProfileSupport = false;
        setOwningPlayerSupport = false;
        methodSetProfileSupport = false;
        CONSTRUCTOR_ITEM_STACK_OLD = null;
        PROFILE_FIELD = null;
        METHOD_SET_PROFILE = null;
        METHOD_SET_OWNER = null;
        try {
            CONSTRUCTOR_ITEM_STACK_OLD = ItemStack.class.getConstructor(Material.class, Integer.TYPE, Short.TYPE);
            oldItemStackSupport = true;
            LocalUtils.logp("Old ItemStack constructor is available!");
        }
        catch (Throwable throwable) {
            oldItemStackSupport = false;
            LocalUtils.logp("Old ItemStack constructor is not available!");
        }
        Material material = LocalUtils.findMaterial("PLAYER_HEAD", "SKULL_ITEM");
        if (material.name().equals("PLAYER_HEAD")) {
            headItemSample = new ItemStack(material);
        } else {
            try {
                headItemSample = (ItemStack)CONSTRUCTOR_ITEM_STACK_OLD.newInstance(material, 1, (byte)3);
            }
            catch (Throwable throwable) {
                headItemSample = new ItemStack(material, 1, 3);
            }
        }
        try {
            itemStack = headItemSample.clone();
            skullMeta = (SkullMeta)itemStack.getItemMeta();
            string = UUID.randomUUID().toString().substring(0, 16);
            GameProfile gameProfile = new GameProfile(UUID.randomUUID(), string);
            gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
            PROFILE_FIELD = skullMeta.getClass().getDeclaredField("profile");
            PROFILE_FIELD.setAccessible(true);
            PROFILE_FIELD.set(skullMeta, gameProfile);
            itemStack.setItemMeta((ItemMeta)skullMeta);
            gameProfileSupport = true;
            LocalUtils.logp("GameProfile field is available for heads. Hooking..");
        }
        catch (Throwable throwable) {
            PROFILE_FIELD = null;
            LocalUtils.logp("GameProfile field is not available for heads. Using NBTAPI if available..");
        }
        try {
            SkullMeta.class.getMethod("setOwningPlayer", OfflinePlayer.class);
            LocalUtils.logp("SkullMeta#setOwningPlayer method is available for heads.");
            setOwningPlayerSupport = true;
        }
        catch (Throwable throwable) {
            try {
                METHOD_SET_OWNER = SkullMeta.class.getMethod("setOwner", String.class);
                LocalUtils.logp("SkullMeta#setOwner method is available for heads.");
            }
            catch (Throwable throwable2) {
                LocalUtils.logp("SkullMeta#setOwner method is not available for heads. Using NBTAPI if available..");
            }
        }
        try {
            itemStack = headItemSample.clone();
            skullMeta = (SkullMeta)itemStack.getItemMeta();
            string = new GameProfile(UUID.randomUUID(), null);
            string.getProperties().put((Object)"textures", (Object)new Property("textures", "ewogICJ0aW1lc3RhbXAiIDogMTU5NDQ0NjkyMDI5NiwKICAicHJvZmlsZUlkIiA6ICJlMWMxYTE5NDdlODY0MTRmODZiYjQyZDgyYTIxY2ZiOCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbG9uc29BbGlhZ2EiLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTY4YWE3NGNjODg1NzgwNjBkMGZlM2JkOTA4YjM0ZjY5ZjEyZTA3ZjFmODljNWRkYzE1ZTZiZjYwZjA0Y2NjNiIKICAgIH0KICB9Cn0="));
            METHOD_SET_PROFILE = SkullMeta.class.getDeclaredMethod("setProfile", GameProfile.class);
            METHOD_SET_PROFILE.setAccessible(true);
            METHOD_SET_PROFILE.invoke((Object)skullMeta, string);
            itemStack.setItemMeta((ItemMeta)skullMeta);
            methodSetProfileSupport = true;
            LocalUtils.logp("GameProfile setProfile method is available for heads. Using..");
        }
        catch (Throwable throwable) {
            METHOD_SET_PROFILE = null;
            LocalUtils.logp("GameProfile setProfile is not available for heads. Ignoring..");
        }
        nbtAPISupport = Bukkit.getServer().getPluginManager().getPlugin("NBTAPI") != null;
    }
}

