/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari;

import com.codahale.metrics.health.HealthCheckRegistry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.betterfarming.hikari.HikariConfigMXBean;
import me.angeschossen.betterfarming.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.betterfarming.hikari.util.PropertyElf;
import me.angeschossen.betterfarming.hikari.util.UtilityElf;
import me.angeschossen.betterfarming.slf4j.Logger;
import me.angeschossen.betterfarming.slf4j.LoggerFactory;

public class HikariConfig
implements HikariConfigMXBean {
    private static final Logger RLHXh = LoggerFactory.getLogger(HikariConfig.class);
    private static final char[] HXvGq = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final long pdjAO = TimeUnit.SECONDS.toMillis(30L);
    private static final long UhzX = TimeUnit.SECONDS.toMillis(5L);
    private static final long Dgduf = Long.getLong("me.angeschossen.betterfarming.hikari.timeoutMs.floor", 250L);
    private static final long ztTjN = TimeUnit.MINUTES.toMillis(10L);
    private static final long JHesM = TimeUnit.MINUTES.toMillis(30L);
    private static final long igzHW = 0L;
    private static final int SknVT = 10;
    private static boolean lGdKv = false;
    private volatile String DFkJL;
    private volatile long BdHcv;
    private volatile long OvlG;
    private volatile long AgSRZ;
    private volatile long cKfg;
    private volatile long rndpt;
    private volatile int Vjrip = -1;
    private volatile int ygtt = -1;
    private volatile String VRYJH;
    private volatile String wybtH;
    private long wGVzD = 1L;
    private String AEoc;
    private String XOcdi;
    private String ePuVM;
    private String wGFda;
    private String MNeU;
    private String wioZV;
    private String dnWao;
    private String yxKwI;
    private String QuX;
    private String VujKn;
    private boolean xVwuT = true;
    private boolean RLjFP;
    private boolean dORdH;
    private boolean QdMvq;
    private boolean BydZN;
    private DataSource ocaDd;
    private Properties eLmec = new Properties();
    private ThreadFactory mrvkV;
    private ScheduledExecutorService GmGh;
    private MetricsTrackerFactory CQLE;
    private Object cXcnX;
    private Object nEN;
    private Properties BHOg = new Properties();
    private long zdwSN = 0L;
    private volatile boolean WfUJF;

    public HikariConfig() {
        this.rndpt = JHesM;
        this.BdHcv = pdjAO;
        this.OvlG = UhzX;
        this.AgSRZ = ztTjN;
        String string = System.getProperty("hikaricp.configurationFile");
        if (string != null) {
            this.HXvGq(string);
        }
    }

    public HikariConfig(Properties properties) {
        this();
        PropertyElf.setTargetFromProperties(this, properties);
    }

    public HikariConfig(String string) {
        this();
        this.HXvGq(string);
    }

    @Override
    public String getCatalog() {
        return this.DFkJL;
    }

    @Override
    public void setCatalog(String string) {
        this.DFkJL = string;
    }

    @Override
    public long getConnectionTimeout() {
        return this.BdHcv;
    }

    @Override
    public void setConnectionTimeout(long l) {
        if (l == 0L) {
            this.BdHcv = Integer.MAX_VALUE;
        } else {
            if (l < Dgduf) {
                throw new IllegalArgumentException("connectionTimeout cannot be less than " + Dgduf + "ms");
            }
            this.BdHcv = l;
        }
    }

    @Override
    public long getIdleTimeout() {
        return this.AgSRZ;
    }

    @Override
    public void setIdleTimeout(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("idleTimeout cannot be negative");
        }
        this.AgSRZ = l;
    }

    @Override
    public long getLeakDetectionThreshold() {
        return this.cKfg;
    }

    @Override
    public void setLeakDetectionThreshold(long l) {
        this.cKfg = l;
    }

    @Override
    public long getMaxLifetime() {
        return this.rndpt;
    }

    @Override
    public void setMaxLifetime(long l) {
        this.rndpt = l;
    }

    @Override
    public int getMaximumPoolSize() {
        return this.Vjrip;
    }

    @Override
    public void setMaximumPoolSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("maxPoolSize cannot be less than 1");
        }
        this.Vjrip = n;
    }

    @Override
    public int getMinimumIdle() {
        return this.ygtt;
    }

    @Override
    public void setMinimumIdle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minimumIdle cannot be negative");
        }
        this.ygtt = n;
    }

    public String getPassword() {
        return this.wybtH;
    }

    @Override
    public void setPassword(String string) {
        this.wybtH = string;
    }

    public String getUsername() {
        return this.VRYJH;
    }

    @Override
    public void setUsername(String string) {
        this.VRYJH = string;
    }

    @Override
    public long getValidationTimeout() {
        return this.OvlG;
    }

    @Override
    public void setValidationTimeout(long l) {
        if (l < Dgduf) {
            throw new IllegalArgumentException("validationTimeout cannot be less than " + Dgduf + "ms");
        }
        this.OvlG = l;
    }

    public String getConnectionTestQuery() {
        return this.XOcdi;
    }

    public void setConnectionTestQuery(String string) {
        this.pdjAO();
        this.XOcdi = string;
    }

    public String getConnectionInitSql() {
        return this.AEoc;
    }

    public void setConnectionInitSql(String string) {
        this.pdjAO();
        this.AEoc = string;
    }

    public DataSource getDataSource() {
        return this.ocaDd;
    }

    public void setDataSource(DataSource dataSource) {
        this.pdjAO();
        this.ocaDd = dataSource;
    }

    public String getDataSourceClassName() {
        return this.ePuVM;
    }

    public void setDataSourceClassName(String string) {
        this.pdjAO();
        this.ePuVM = string;
    }

    public void addDataSourceProperty(String string, Object object) {
        this.pdjAO();
        this.eLmec.put(string, object);
    }

    public String getDataSourceJNDI() {
        return this.wGFda;
    }

    public void setDataSourceJNDI(String string) {
        this.pdjAO();
        this.wGFda = string;
    }

    public Properties getDataSourceProperties() {
        return this.eLmec;
    }

    public void setDataSourceProperties(Properties properties) {
        this.pdjAO();
        this.eLmec.putAll((Map<?, ?>)properties);
    }

    public String getDriverClassName() {
        return this.MNeU;
    }

    public void setDriverClassName(String string) {
        this.pdjAO();
        Class<?> clazz = this.RLHXh(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                RLHXh.debug("Driver class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            RLHXh.error("Failed to load driver class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load driver class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.MNeU = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public String getJdbcUrl() {
        return this.dnWao;
    }

    public void setJdbcUrl(String string) {
        this.pdjAO();
        this.dnWao = string;
    }

    public boolean isAutoCommit() {
        return this.xVwuT;
    }

    public void setAutoCommit(boolean bl) {
        this.pdjAO();
        this.xVwuT = bl;
    }

    public boolean isAllowPoolSuspension() {
        return this.BydZN;
    }

    public void setAllowPoolSuspension(boolean bl) {
        this.pdjAO();
        this.BydZN = bl;
    }

    public long getInitializationFailTimeout() {
        return this.wGVzD;
    }

    public void setInitializationFailTimeout(long l) {
        this.pdjAO();
        this.wGVzD = l;
    }

    public boolean isIsolateInternalQueries() {
        return this.dORdH;
    }

    public void setIsolateInternalQueries(boolean bl) {
        this.pdjAO();
        this.dORdH = bl;
    }

    public MetricsTrackerFactory getMetricsTrackerFactory() {
        return this.CQLE;
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        if (this.cXcnX != null) {
            throw new IllegalStateException("cannot use setMetricsTrackerFactory() and setMetricRegistry() together");
        }
        this.CQLE = metricsTrackerFactory;
    }

    public Object getMetricRegistry() {
        return this.cXcnX;
    }

    public void setMetricRegistry(Object object) {
        if (this.CQLE != null) {
            throw new IllegalStateException("cannot use setMetricRegistry() and setMetricsTrackerFactory() together");
        }
        if (object != null && !UtilityElf.safeIsAssignableFrom(object = this.RLHXh(object), "com.codahale.metrics.MetricRegistry") && !UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            throw new IllegalArgumentException("Class must be instance of com.codahale.metrics.MetricRegistry or io.micrometer.core.instrument.MeterRegistry");
        }
        this.cXcnX = object;
    }

    public Object getHealthCheckRegistry() {
        return this.nEN;
    }

    public void setHealthCheckRegistry(Object object) {
        this.pdjAO();
        if (object != null && !((object = this.RLHXh(object)) instanceof HealthCheckRegistry)) {
            throw new IllegalArgumentException("Class must be an instance of com.codahale.metrics.health.HealthCheckRegistry");
        }
        this.nEN = object;
    }

    public Properties getHealthCheckProperties() {
        return this.BHOg;
    }

    public void setHealthCheckProperties(Properties properties) {
        this.pdjAO();
        this.BHOg.putAll((Map<?, ?>)properties);
    }

    public void addHealthCheckProperty(String string, String string2) {
        this.pdjAO();
        this.BHOg.setProperty(string, string2);
    }

    public long getKeepaliveTime() {
        return this.zdwSN;
    }

    public void setKeepaliveTime(long l) {
        this.zdwSN = l;
    }

    public boolean isReadOnly() {
        return this.RLjFP;
    }

    public void setReadOnly(boolean bl) {
        this.pdjAO();
        this.RLjFP = bl;
    }

    public boolean isRegisterMbeans() {
        return this.QdMvq;
    }

    public void setRegisterMbeans(boolean bl) {
        this.pdjAO();
        this.QdMvq = bl;
    }

    @Override
    public String getPoolName() {
        return this.yxKwI;
    }

    public void setPoolName(String string) {
        this.pdjAO();
        this.yxKwI = string;
    }

    public ScheduledExecutorService getScheduledExecutor() {
        return this.GmGh;
    }

    public void setScheduledExecutor(ScheduledExecutorService scheduledExecutorService) {
        this.pdjAO();
        this.GmGh = scheduledExecutorService;
    }

    public String getTransactionIsolation() {
        return this.VujKn;
    }

    public String getSchema() {
        return this.QuX;
    }

    public void setSchema(String string) {
        this.pdjAO();
        this.QuX = string;
    }

    public String getExceptionOverrideClassName() {
        return this.wioZV;
    }

    public void setExceptionOverrideClassName(String string) {
        this.pdjAO();
        Class<?> clazz = this.RLHXh(string);
        try {
            if (clazz == null) {
                clazz = this.getClass().getClassLoader().loadClass(string);
                RLHXh.debug("SQLExceptionOverride class {} found in the HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            RLHXh.error("Failed to load SQLExceptionOverride class {} from HikariConfig class classloader {}", (Object)string, (Object)this.getClass().getClassLoader());
        }
        if (clazz == null) {
            throw new RuntimeException("Failed to load SQLExceptionOverride class " + string + " in either of HikariConfig class loader or Thread context classloader");
        }
        try {
            clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.wioZV = string;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to instantiate class " + string, exception);
        }
    }

    public void setTransactionIsolation(String string) {
        this.pdjAO();
        this.VujKn = string;
    }

    public ThreadFactory getThreadFactory() {
        return this.mrvkV;
    }

    public void setThreadFactory(ThreadFactory threadFactory) {
        this.pdjAO();
        this.mrvkV = threadFactory;
    }

    void RLHXh() {
        this.WfUJF = true;
    }

    public void copyStateTo(HikariConfig hikariConfig) {
        for (Field field : HikariConfig.class.getDeclaredFields()) {
            if (Modifier.isFinal(field.getModifiers())) continue;
            field.setAccessible(true);
            try {
                field.set(hikariConfig, field.get(this));
            }
            catch (Exception exception) {
                throw new RuntimeException("Failed to copy HikariConfig state: " + exception.getMessage(), exception);
            }
        }
        hikariConfig.WfUJF = false;
    }

    private Class<?> RLHXh(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            try {
                Class<?> clazz = classLoader.loadClass(string);
                RLHXh.debug("Driver class {} found in Thread context class loader {}", (Object)string, (Object)classLoader);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                RLHXh.debug("Driver class {} not found in Thread context class loader {}, trying classloader {}", string, classLoader, this.getClass().getClassLoader());
            }
        }
        return null;
    }

    public void validate() {
        if (this.yxKwI == null) {
            this.yxKwI = this.Dgduf();
        } else if (this.QdMvq && this.yxKwI.contains(":")) {
            throw new IllegalArgumentException("poolName cannot contain ':' when used with JMX");
        }
        this.DFkJL = UtilityElf.getNullIfEmpty(this.DFkJL);
        this.AEoc = UtilityElf.getNullIfEmpty(this.AEoc);
        this.XOcdi = UtilityElf.getNullIfEmpty(this.XOcdi);
        this.VujKn = UtilityElf.getNullIfEmpty(this.VujKn);
        this.ePuVM = UtilityElf.getNullIfEmpty(this.ePuVM);
        this.wGFda = UtilityElf.getNullIfEmpty(this.wGFda);
        this.MNeU = UtilityElf.getNullIfEmpty(this.MNeU);
        this.dnWao = UtilityElf.getNullIfEmpty(this.dnWao);
        if (this.ocaDd != null) {
            if (this.ePuVM != null) {
                RLHXh.warn("{} - using dataSource and ignoring dataSourceClassName.", (Object)this.yxKwI);
            }
        } else if (this.ePuVM != null) {
            if (this.MNeU != null) {
                RLHXh.error("{} - cannot use driverClassName and dataSourceClassName together.", (Object)this.yxKwI);
                throw new IllegalStateException("cannot use driverClassName and dataSourceClassName together.");
            }
            if (this.dnWao != null) {
                RLHXh.warn("{} - using dataSourceClassName and ignoring jdbcUrl.", (Object)this.yxKwI);
            }
        } else if (this.dnWao == null && this.wGFda == null) {
            if (this.MNeU != null) {
                RLHXh.error("{} - jdbcUrl is required with driverClassName.", (Object)this.yxKwI);
                throw new IllegalArgumentException("jdbcUrl is required with driverClassName.");
            }
            RLHXh.error("{} - dataSource or dataSourceClassName or jdbcUrl is required.", (Object)this.yxKwI);
            throw new IllegalArgumentException("dataSource or dataSourceClassName or jdbcUrl is required.");
        }
        this.HXvGq();
        if (RLHXh.isDebugEnabled() || lGdKv) {
            this.UhzX();
        }
    }

    private void HXvGq() {
        if (this.rndpt != 0L && this.rndpt < TimeUnit.SECONDS.toMillis(30L)) {
            RLHXh.warn("{} - maxLifetime is less than 30000ms, setting to default {}ms.", (Object)this.yxKwI, (Object)JHesM);
            this.rndpt = JHesM;
        }
        if (this.zdwSN != 0L && this.zdwSN < TimeUnit.SECONDS.toMillis(30L)) {
            RLHXh.warn("{} - keepaliveTime is less than 30000ms, disabling it.", (Object)this.yxKwI);
            this.zdwSN = 0L;
        }
        if (this.zdwSN != 0L && this.rndpt != 0L && this.zdwSN >= this.rndpt) {
            RLHXh.warn("{} - keepaliveTime is greater than or equal to maxLifetime, disabling it.", (Object)this.yxKwI);
            this.zdwSN = 0L;
        }
        if (this.cKfg > 0L && !lGdKv && (this.cKfg < TimeUnit.SECONDS.toMillis(2L) || this.cKfg > this.rndpt && this.rndpt > 0L)) {
            RLHXh.warn("{} - leakDetectionThreshold is less than 2000ms or more than maxLifetime, disabling it.", (Object)this.yxKwI);
            this.cKfg = 0L;
        }
        if (this.BdHcv < Dgduf) {
            RLHXh.warn("{} - connectionTimeout is less than {}ms, setting to {}ms.", this.yxKwI, Dgduf, pdjAO);
            this.BdHcv = pdjAO;
        }
        if (this.OvlG < Dgduf) {
            RLHXh.warn("{} - validationTimeout is less than {}ms, setting to {}ms.", this.yxKwI, Dgduf, UhzX);
            this.OvlG = UhzX;
        }
        if (this.Vjrip < 1) {
            this.Vjrip = 10;
        }
        if (this.ygtt < 0 || this.ygtt > this.Vjrip) {
            this.ygtt = this.Vjrip;
        }
        if (this.AgSRZ + TimeUnit.SECONDS.toMillis(1L) > this.rndpt && this.rndpt > 0L && this.ygtt < this.Vjrip) {
            RLHXh.warn("{} - idleTimeout is close to or more than maxLifetime, disabling it.", (Object)this.yxKwI);
            this.AgSRZ = 0L;
        } else if (this.AgSRZ != 0L && this.AgSRZ < TimeUnit.SECONDS.toMillis(10L) && this.ygtt < this.Vjrip) {
            RLHXh.warn("{} - idleTimeout is less than 10000ms, setting to default {}ms.", (Object)this.yxKwI, (Object)ztTjN);
            this.AgSRZ = ztTjN;
        } else if (this.AgSRZ != ztTjN && this.AgSRZ != 0L && this.ygtt == this.Vjrip) {
            RLHXh.warn("{} - idleTimeout has been set but has no effect because the pool is operating as a fixed size pool.", (Object)this.yxKwI);
        }
    }

    private void pdjAO() {
        if (this.WfUJF) {
            throw new IllegalStateException("The configuration of the pool is sealed once started. Use HikariConfigMXBean for runtime changes.");
        }
    }

    private void UhzX() {
        RLHXh.debug("{} - configuration:", (Object)this.yxKwI);
        TreeSet<String> treeSet = new TreeSet<String>(PropertyElf.getPropertyNames(HikariConfig.class));
        for (String string : treeSet) {
            try {
                Object object = PropertyElf.getProperty(string, this);
                if ("dataSourceProperties".equals(string)) {
                    Properties properties = PropertyElf.copyProperties(this.eLmec);
                    properties.setProperty("password", "<masked>");
                    object = properties;
                }
                if ("initializationFailTimeout".equals(string) && this.wGVzD == Long.MAX_VALUE) {
                    object = "infinite";
                } else if ("transactionIsolation".equals(string) && this.VujKn == null) {
                    object = "default";
                } else if (string.matches("scheduledExecutorService|threadFactory") && object == null) {
                    object = "internal";
                } else if (string.contains("jdbcUrl") && object instanceof String) {
                    object = ((String)object).replaceAll("([?&;]password=)[^&#;]*(.*)", "$1<masked>$2");
                } else if (string.contains("password")) {
                    object = "<masked>";
                } else if (object instanceof String) {
                    object = "\"" + object + "\"";
                } else if (object == null) {
                    object = "none";
                }
                RLHXh.debug("{}{}", (Object)(string + "................................................".substring(0, 32)), object);
            }
            catch (Exception exception) {}
        }
    }

    private void HXvGq(String string) {
        block9: {
            File file = new File(string);
            try (InputStream inputStream = file.isFile() ? new FileInputStream(file) : this.getClass().getResourceAsStream(string);){
                if (inputStream != null) {
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    PropertyElf.setTargetFromProperties(this, properties);
                    break block9;
                }
                throw new IllegalArgumentException("Cannot find property file: " + string);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to read property file", iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String Dgduf() {
        String string = "HikariPool-";
        try {
            Properties properties = System.getProperties();
            synchronized (properties) {
                String string2 = String.valueOf(Integer.getInteger("me.angeschossen.betterfarming.hikari.pool_number", 0) + 1);
                System.setProperty("me.angeschossen.betterfarming.hikari.pool_number", string2);
                return "HikariPool-" + string2;
            }
        }
        catch (AccessControlException accessControlException) {
            ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
            StringBuilder stringBuilder = new StringBuilder("HikariPool-");
            for (int i = 0; i < 4; ++i) {
                stringBuilder.append(HXvGq[threadLocalRandom.nextInt(62)]);
            }
            RLHXh.info("assigned random pool name '{}' (security manager prevented access to system properties)", (Object)stringBuilder);
            return stringBuilder.toString();
        }
    }

    private Object RLHXh(Object object) {
        if (object instanceof String) {
            try {
                InitialContext initialContext = new InitialContext();
                return initialContext.lookup((String)object);
            }
            catch (NamingException namingException) {
                throw new IllegalArgumentException(namingException);
            }
        }
        return object;
    }
}

