/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import me.angeschossen.betterfarming.hikari.HikariConfig;
import me.angeschossen.betterfarming.hikari.HikariDataSource;
import me.angeschossen.betterfarming.hikari.util.PropertyElf;

public class HikariJNDIFactory
implements ObjectFactory {
    @Override
    public synchronized Object getObjectInstance(Object object, Name name, Context context, Hashtable<?, ?> hashtable) {
        if (object instanceof Reference && "javax.sql.DataSource".equals(((Reference)object).getClassName())) {
            Reference reference = (Reference)object;
            Set<String> set = PropertyElf.getPropertyNames(HikariConfig.class);
            Properties properties = new Properties();
            Enumeration<RefAddr> enumeration = reference.getAll();
            while (enumeration.hasMoreElements()) {
                RefAddr refAddr = enumeration.nextElement();
                String string = refAddr.getType();
                if (!string.startsWith("dataSource.") && !set.contains(string)) continue;
                properties.setProperty(string, refAddr.getContent().toString());
            }
            return this.RLHXh(properties, context);
        }
        return null;
    }

    private DataSource RLHXh(Properties properties, Context context) {
        String string = properties.getProperty("dataSourceJNDI");
        if (string != null) {
            return this.RLHXh(properties, context, string);
        }
        return new HikariDataSource(new HikariConfig(properties));
    }

    private DataSource RLHXh(Properties properties, Context context, String string) {
        Object object;
        if (context == null) {
            throw new RuntimeException("JNDI context does not found for dataSourceJNDI : " + string);
        }
        DataSource dataSource = (DataSource)context.lookup(string);
        if (dataSource == null) {
            object = new InitialContext();
            dataSource = (DataSource)object.lookup(string);
            object.close();
        }
        if (dataSource != null) {
            object = new HikariConfig(properties);
            ((HikariConfig)object).setDataSource(dataSource);
            return new HikariDataSource((HikariConfig)object);
        }
        return null;
    }
}

