/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.metrics.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Summary;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import me.angeschossen.betterfarming.hikari.metrics.IMetricsTracker;
import me.angeschossen.betterfarming.hikari.metrics.prometheus.HikariCPCollector;
import me.angeschossen.betterfarming.hikari.metrics.prometheus.PrometheusMetricsTrackerFactory;

class PrometheusMetricsTracker
implements IMetricsTracker {
    private static final Counter RLHXh = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Summary HXvGq = PrometheusMetricsTracker.RLHXh("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)");
    private static final Summary pdjAO = PrometheusMetricsTracker.RLHXh("hikaricp_connection_usage_millis", "Connection usage (ms)");
    private static final Summary UhzX = PrometheusMetricsTracker.RLHXh("hikaricp_connection_creation_millis", "Connection creation (ms)");
    private static final Map<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus> Dgduf = new ConcurrentHashMap<CollectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus>();
    private final String ztTjN;
    private final HikariCPCollector JHesM;
    private final Counter.Child igzHW;
    private final Summary.Child SknVT;
    private final Summary.Child lGdKv;
    private final Summary.Child DFkJL;

    PrometheusMetricsTracker(String string, CollectorRegistry collectorRegistry, HikariCPCollector hikariCPCollector) {
        this.RLHXh(collectorRegistry);
        this.ztTjN = string;
        this.JHesM = hikariCPCollector;
        this.igzHW = (Counter.Child)RLHXh.labels(new String[]{string});
        this.SknVT = (Summary.Child)HXvGq.labels(new String[]{string});
        this.lGdKv = (Summary.Child)pdjAO.labels(new String[]{string});
        this.DFkJL = (Summary.Child)UhzX.labels(new String[]{string});
    }

    private void RLHXh(CollectorRegistry collectorRegistry) {
        if (Dgduf.putIfAbsent(collectorRegistry, PrometheusMetricsTrackerFactory.RegistrationStatus.REGISTERED) == null) {
            RLHXh.register(collectorRegistry);
            HXvGq.register(collectorRegistry);
            pdjAO.register(collectorRegistry);
            UhzX.register(collectorRegistry);
        }
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.SknVT.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.lGdKv.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.DFkJL.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.igzHW.inc();
    }

    private static Summary RLHXh(String string, String string2) {
        return ((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).quantile(0.5, 0.05).quantile(0.95, 0.01).quantile(0.99, 0.001).maxAgeSeconds(TimeUnit.MINUTES.toSeconds(5L)).ageBuckets(5).create();
    }

    @Override
    public void close() {
        this.JHesM.RLHXh(this.ztTjN);
        RLHXh.remove(new String[]{this.ztTjN});
        HXvGq.remove(new String[]{this.ztTjN});
        pdjAO.remove(new String[]{this.ztTjN});
        UhzX.remove(new String[]{this.ztTjN});
    }
}

