/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.pool;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.health.HealthCheckRegistry;
import io.micrometer.core.instrument.MeterRegistry;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import me.angeschossen.betterfarming.hikari.HikariConfig;
import me.angeschossen.betterfarming.hikari.HikariPoolMXBean;
import me.angeschossen.betterfarming.hikari.metrics.MetricsTrackerFactory;
import me.angeschossen.betterfarming.hikari.metrics.PoolStats;
import me.angeschossen.betterfarming.hikari.metrics.dropwizard.CodahaleHealthChecker;
import me.angeschossen.betterfarming.hikari.metrics.dropwizard.CodahaleMetricsTrackerFactory;
import me.angeschossen.betterfarming.hikari.metrics.micrometer.MicrometerMetricsTrackerFactory;
import me.angeschossen.betterfarming.hikari.pool.PoolBase;
import me.angeschossen.betterfarming.hikari.pool.PoolEntry;
import me.angeschossen.betterfarming.hikari.pool.ProxyConnection;
import me.angeschossen.betterfarming.hikari.pool.ProxyLeakTaskFactory;
import me.angeschossen.betterfarming.hikari.util.ClockSource;
import me.angeschossen.betterfarming.hikari.util.ConcurrentBag;
import me.angeschossen.betterfarming.hikari.util.SuspendResumeLock;
import me.angeschossen.betterfarming.hikari.util.UtilityElf;
import me.angeschossen.betterfarming.slf4j.Logger;
import me.angeschossen.betterfarming.slf4j.LoggerFactory;

public final class HikariPool
extends PoolBase
implements HikariPoolMXBean,
ConcurrentBag.IBagStateListener {
    private final Logger JHesM = LoggerFactory.getLogger(HikariPool.class);
    public static final int POOL_NORMAL = 0;
    public static final int POOL_SUSPENDED = 1;
    public static final int POOL_SHUTDOWN = 2;
    public volatile int poolState;
    private final long igzHW = Long.getLong("me.angeschossen.betterfarming.hikari.aliveBypassWindowMs", TimeUnit.MILLISECONDS.toMillis(500L));
    private final long SknVT = Long.getLong("me.angeschossen.betterfarming.hikari.housekeeping.periodMs", TimeUnit.SECONDS.toMillis(30L));
    private static final String lGdKv = "(connection was evicted)";
    private static final String DFkJL = "(connection is dead)";
    private final PoolEntryCreator BdHcv = new PoolEntryCreator(null);
    private final PoolEntryCreator OvlG = new PoolEntryCreator("After adding ");
    private final Collection<Runnable> AgSRZ;
    private final ThreadPoolExecutor cKfg;
    private final ThreadPoolExecutor rndpt;
    private final ConcurrentBag<PoolEntry> Vjrip = new ConcurrentBag(this);
    private final ProxyLeakTaskFactory ygtt;
    private final SuspendResumeLock VRYJH;
    private final ScheduledExecutorService wybtH;
    private ScheduledFuture<?> wGVzD;

    public HikariPool(HikariConfig hikariConfig) {
        super(hikariConfig);
        this.VRYJH = hikariConfig.isAllowPoolSuspension() ? new SuspendResumeLock() : SuspendResumeLock.FAUX_LOCK;
        this.wybtH = this.SknVT();
        this.igzHW();
        if (hikariConfig.getMetricsTrackerFactory() != null) {
            this.setMetricsTrackerFactory(hikariConfig.getMetricsTrackerFactory());
        } else {
            this.setMetricRegistry(hikariConfig.getMetricRegistry());
        }
        this.setHealthCheckRegistry(hikariConfig.getHealthCheckRegistry());
        this.RLHXh(this, true);
        ThreadFactory threadFactory = hikariConfig.getThreadFactory();
        int n = hikariConfig.getMaximumPoolSize();
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(n);
        this.AgSRZ = Collections.unmodifiableCollection(linkedBlockingQueue);
        this.cKfg = UtilityElf.createThreadPoolExecutor(linkedBlockingQueue, this.poolName + " connection adder", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy());
        this.rndpt = UtilityElf.createThreadPoolExecutor(n, this.poolName + " connection closer", threadFactory, (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        this.ygtt = new ProxyLeakTaskFactory(hikariConfig.getLeakDetectionThreshold(), this.wybtH);
        this.wGVzD = this.wybtH.scheduleWithFixedDelay(new HouseKeeper(), 100L, this.SknVT, TimeUnit.MILLISECONDS);
        if (Boolean.getBoolean("me.angeschossen.betterfarming.hikari.blockUntilFilled") && hikariConfig.getInitializationFailTimeout() > 1L) {
            this.cKfg.setMaximumPoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            this.cKfg.setCorePoolSize(Math.min(16, Runtime.getRuntime().availableProcessors()));
            long l = ClockSource.currentTime();
            while (ClockSource.elapsedMillis(l) < hikariConfig.getInitializationFailTimeout() && this.getTotalConnections() < hikariConfig.getMinimumIdle()) {
                UtilityElf.quietlySleep(TimeUnit.MILLISECONDS.toMillis(100L));
            }
            this.cKfg.setCorePoolSize(1);
            this.cKfg.setMaximumPoolSize(1);
        }
    }

    public Connection getConnection() {
        return this.getConnection(this.UhzX);
    }

    /*
     * Exception decompiling
     */
    public Connection getConnection(long var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[WHILELOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        block8: {
            this.poolState = 2;
            if (this.cKfg != null) break block8;
            this.RLHXh("After shutdown ");
            this.RLHXh(this, false);
            this.RLHXh.close();
            return;
        }
        try {
            this.RLHXh("Before shutdown ");
            if (this.wGVzD != null) {
                this.wGVzD.cancel(false);
                this.wGVzD = null;
            }
            this.softEvictConnections();
            this.cKfg.shutdown();
            this.cKfg.awaitTermination(this.Dgduf(), TimeUnit.SECONDS);
            this.lGdKv();
            this.Vjrip.close();
            ThreadPoolExecutor threadPoolExecutor = UtilityElf.createThreadPoolExecutor(this.config.getMaximumPoolSize(), this.poolName + " connection assassinator", this.config.getThreadFactory(), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                long l = ClockSource.currentTime();
                do {
                    this.RLHXh(threadPoolExecutor);
                    this.softEvictConnections();
                } while (this.getTotalConnections() > 0 && ClockSource.elapsedMillis(l) < TimeUnit.SECONDS.toMillis(10L));
            }
            finally {
                threadPoolExecutor.shutdown();
                threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            this.UhzX();
            this.rndpt.shutdown();
            this.rndpt.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            this.RLHXh("After shutdown ");
            this.RLHXh(this, false);
            this.RLHXh.close();
            throw throwable;
        }
        this.RLHXh("After shutdown ");
        this.RLHXh(this, false);
        this.RLHXh.close();
    }

    public void evictConnection(Connection connection) {
        ProxyConnection proxyConnection = (ProxyConnection)connection;
        proxyConnection.SknVT();
        try {
            this.RLHXh(proxyConnection.JHesM(), "(connection evicted by user)", !connection.isClosed());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public void setMetricRegistry(Object object) {
        if (object != null && UtilityElf.safeIsAssignableFrom(object, "com.codahale.metrics.MetricRegistry")) {
            this.setMetricsTrackerFactory(new CodahaleMetricsTrackerFactory((MetricRegistry)object));
        } else if (object != null && UtilityElf.safeIsAssignableFrom(object, "io.micrometer.core.instrument.MeterRegistry")) {
            this.setMetricsTrackerFactory(new MicrometerMetricsTrackerFactory((MeterRegistry)object));
        } else {
            this.setMetricsTrackerFactory(null);
        }
    }

    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        this.RLHXh = metricsTrackerFactory != null ? new PoolBase.MetricsTrackerDelegate(metricsTrackerFactory.create(this.config.getPoolName(), this.DFkJL())) : new PoolBase.NopMetricsTrackerDelegate();
    }

    public void setHealthCheckRegistry(Object object) {
        if (object != null) {
            CodahaleHealthChecker.registerHealthChecks(this, this.config, (HealthCheckRegistry)object);
        }
    }

    @Override
    public void addBagItem(int n) {
        boolean bl;
        boolean bl2 = bl = n - this.AgSRZ.size() >= 0;
        if (bl) {
            this.cKfg.submit(this.BdHcv);
        } else {
            this.JHesM.debug("{} - Add connection elided, waiting {}, queue {}", this.poolName, n, this.AgSRZ.size());
        }
    }

    @Override
    public int getActiveConnections() {
        return this.Vjrip.getCount(1);
    }

    @Override
    public int getIdleConnections() {
        return this.Vjrip.getCount(0);
    }

    @Override
    public int getTotalConnections() {
        return this.Vjrip.size();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.Vjrip.getWaitingThreadCount();
    }

    @Override
    public void softEvictConnections() {
        this.Vjrip.values().forEach(poolEntry -> this.RLHXh((PoolEntry)poolEntry, "(connection evicted)", false));
    }

    @Override
    public synchronized void suspendPool() {
        if (this.VRYJH == SuspendResumeLock.FAUX_LOCK) {
            throw new IllegalStateException(this.poolName + " - is not suspendable");
        }
        if (this.poolState != 1) {
            this.VRYJH.suspend();
            this.poolState = 1;
        }
    }

    @Override
    public synchronized void resumePool() {
        if (this.poolState == 1) {
            this.poolState = 0;
            this.JHesM();
            this.VRYJH.resume();
        }
    }

    void RLHXh(String ... stringArray) {
        if (this.JHesM.isDebugEnabled()) {
            this.JHesM.debug("{} - {}stats (total={}, active={}, idle={}, waiting={})", this.poolName, stringArray.length > 0 ? stringArray[0] : "", this.getTotalConnections(), this.getActiveConnections(), this.getIdleConnections(), this.getThreadsAwaitingConnection());
        }
    }

    @Override
    void RLHXh(PoolEntry poolEntry) {
        this.RLHXh.recordConnectionUsage(poolEntry);
        this.Vjrip.requite(poolEntry);
    }

    void RLHXh(PoolEntry poolEntry, String string) {
        if (this.Vjrip.remove(poolEntry)) {
            Connection connection = poolEntry.ztTjN();
            this.rndpt.execute(() -> {
                this.RLHXh(connection, string);
                if (this.poolState == 0) {
                    this.JHesM();
                }
            });
        }
    }

    int[] RLHXh() {
        return this.Vjrip.getStateCounts();
    }

    private PoolEntry ztTjN() {
        block6: {
            try {
                long l;
                long l2;
                PoolEntry poolEntry = this.pdjAO();
                long l3 = this.config.getMaxLifetime();
                if (l3 > 0L) {
                    l2 = l3 > 10000L ? ThreadLocalRandom.current().nextLong(l3 / 40L) : 0L;
                    l = l3 - l2;
                    poolEntry.RLHXh(this.wybtH.schedule(new MaxLifetimeTask(poolEntry), l, TimeUnit.MILLISECONDS));
                }
                if ((l2 = this.config.getKeepaliveTime()) > 0L) {
                    l = ThreadLocalRandom.current().nextLong(l2 / 10L);
                    long l4 = l2 - l;
                    poolEntry.setKeepalive(this.wybtH.scheduleWithFixedDelay(new KeepaliveTask(poolEntry), l4, l4, TimeUnit.MILLISECONDS));
                }
                return poolEntry;
            }
            catch (PoolBase.ConnectionSetupException connectionSetupException) {
                if (this.poolState == 0) {
                    this.JHesM.error("{} - Error thrown while acquiring connection from data source", (Object)this.poolName, (Object)connectionSetupException.getCause());
                    this.pdjAO.set(connectionSetupException);
                }
            }
            catch (Exception exception) {
                if (this.poolState != 0) break block6;
                this.JHesM.debug("{} - Cannot acquire connection from data source", (Object)this.poolName, (Object)exception);
            }
        }
        return null;
    }

    private synchronized void JHesM() {
        int n = Math.min(this.config.getMaximumPoolSize() - this.getTotalConnections(), this.config.getMinimumIdle() - this.getIdleConnections()) - this.AgSRZ.size();
        if (n <= 0) {
            this.JHesM.debug("{} - Fill pool skipped, pool is at sufficient level.", (Object)this.poolName);
        }
        for (int i = 0; i < n; ++i) {
            this.cKfg.submit(i < n - 1 ? this.BdHcv : this.OvlG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void RLHXh(ExecutorService executorService) {
        for (PoolEntry poolEntry : this.Vjrip.values(1)) {
            Connection connection = poolEntry.ztTjN();
            try {
                connection.abort(executorService);
            }
            catch (Throwable throwable) {
                this.RLHXh(connection, "(connection aborted during shutdown)");
            }
            finally {
                this.Vjrip.remove(poolEntry);
            }
        }
    }

    private void igzHW() {
        long l = this.config.getInitializationFailTimeout();
        if (l < 0L) {
            return;
        }
        long l2 = ClockSource.currentTime();
        do {
            PoolEntry poolEntry;
            if ((poolEntry = this.ztTjN()) != null) {
                if (this.config.getMinimumIdle() > 0) {
                    this.Vjrip.add(poolEntry);
                    this.JHesM.debug("{} - Added connection {}", (Object)this.poolName, (Object)poolEntry.RLHXh);
                } else {
                    this.RLHXh(poolEntry.ztTjN(), "(initialization check complete and minimumIdle is zero)");
                }
                return;
            }
            if (this.HXvGq() instanceof PoolBase.ConnectionSetupException) {
                this.RLHXh(this.HXvGq().getCause());
            }
            UtilityElf.quietlySleep(TimeUnit.SECONDS.toMillis(1L));
        } while (ClockSource.elapsedMillis(l2) < l);
        if (l > 0L) {
            this.RLHXh(this.HXvGq());
        }
    }

    private void RLHXh(Throwable throwable) {
        this.JHesM.error("{} - Exception during pool initialization.", (Object)this.poolName, (Object)throwable);
        this.lGdKv();
        throw new PoolInitializationException(throwable);
    }

    private boolean RLHXh(PoolEntry poolEntry, String string, boolean bl) {
        poolEntry.pdjAO();
        if (bl || this.Vjrip.reserve(poolEntry)) {
            this.RLHXh(poolEntry, string);
            return true;
        }
        return false;
    }

    private ScheduledExecutorService SknVT() {
        if (this.config.getScheduledExecutor() == null) {
            ThreadFactory threadFactory = Optional.ofNullable(this.config.getThreadFactory()).orElseGet(() -> new UtilityElf.DefaultThreadFactory(this.poolName + " housekeeper", true));
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory, new ThreadPoolExecutor.DiscardPolicy());
            scheduledThreadPoolExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            scheduledThreadPoolExecutor.setRemoveOnCancelPolicy(true);
            return scheduledThreadPoolExecutor;
        }
        return this.config.getScheduledExecutor();
    }

    private void lGdKv() {
        if (this.config.getScheduledExecutor() == null) {
            this.wybtH.shutdownNow();
        }
    }

    private PoolStats DFkJL() {
        return new PoolStats(TimeUnit.SECONDS.toMillis(1L)){

            @Override
            protected void update() {
                this.pendingThreads = HikariPool.this.getThreadsAwaitingConnection();
                this.idleConnections = HikariPool.this.getIdleConnections();
                this.totalConnections = HikariPool.this.getTotalConnections();
                this.activeConnections = HikariPool.this.getActiveConnections();
                this.maxConnections = HikariPool.this.config.getMaximumPoolSize();
                this.minConnections = HikariPool.this.config.getMinimumIdle();
            }
        };
    }

    private SQLException RLHXh(long l) {
        this.RLHXh("Timeout failure ");
        this.RLHXh.recordConnectionTimeout();
        String string = null;
        Exception exception = this.HXvGq();
        if (exception instanceof SQLException) {
            string = ((SQLException)exception).getSQLState();
        }
        SQLTransientConnectionException sQLTransientConnectionException = new SQLTransientConnectionException(this.poolName + " - Connection is not available, request timed out after " + ClockSource.elapsedMillis(l) + "ms.", string, exception);
        if (exception instanceof SQLException) {
            sQLTransientConnectionException.setNextException((SQLException)exception);
        }
        return sQLTransientConnectionException;
    }

    public static class PoolInitializationException
    extends RuntimeException {
        private static final long RLHXh = 929872118275916520L;

        public PoolInitializationException(Throwable throwable) {
            super("Failed to initialize pool: " + throwable.getMessage(), throwable);
        }
    }

    private final class KeepaliveTask
    implements Runnable {
        private final PoolEntry HXvGq;

        KeepaliveTask(PoolEntry poolEntry) {
            this.HXvGq = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.Vjrip.reserve(this.HXvGq)) {
                if (!HikariPool.this.RLHXh(this.HXvGq.RLHXh)) {
                    HikariPool.this.RLHXh(this.HXvGq, HikariPool.DFkJL, true);
                    HikariPool.this.addBagItem(HikariPool.this.Vjrip.getWaitingThreadCount());
                } else {
                    HikariPool.this.Vjrip.unreserve(this.HXvGq);
                    HikariPool.this.JHesM.debug("{} - keepalive: connection {} is alive", (Object)HikariPool.this.poolName, (Object)this.HXvGq.RLHXh);
                }
            }
        }
    }

    private final class MaxLifetimeTask
    implements Runnable {
        private final PoolEntry HXvGq;

        MaxLifetimeTask(PoolEntry poolEntry) {
            this.HXvGq = poolEntry;
        }

        @Override
        public void run() {
            if (HikariPool.this.RLHXh(this.HXvGq, "(connection has passed maxLifetime)", false)) {
                HikariPool.this.addBagItem(HikariPool.this.Vjrip.getWaitingThreadCount());
            }
        }
    }

    private final class HouseKeeper
    implements Runnable {
        private volatile long HXvGq;

        private HouseKeeper() {
            this.HXvGq = ClockSource.plusMillis(ClockSource.currentTime(), -HikariPool.this.SknVT);
        }

        @Override
        public void run() {
            try {
                HikariPool.this.UhzX = HikariPool.this.config.getConnectionTimeout();
                HikariPool.this.Dgduf = HikariPool.this.config.getValidationTimeout();
                HikariPool.this.ygtt.RLHXh(HikariPool.this.config.getLeakDetectionThreshold());
                HikariPool.this.HXvGq = HikariPool.this.config.getCatalog() != null && !HikariPool.this.config.getCatalog().equals(HikariPool.this.HXvGq) ? HikariPool.this.config.getCatalog() : HikariPool.this.HXvGq;
                long l = HikariPool.this.config.getIdleTimeout();
                long l2 = ClockSource.currentTime();
                if (ClockSource.plusMillis(l2, 128L) < ClockSource.plusMillis(this.HXvGq, HikariPool.this.SknVT)) {
                    HikariPool.this.JHesM.warn("{} - Retrograde clock change detected (housekeeper delta={}), soft-evicting connections from pool.", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.HXvGq, l2));
                    this.HXvGq = l2;
                    HikariPool.this.softEvictConnections();
                    return;
                }
                if (l2 > ClockSource.plusMillis(this.HXvGq, 3L * HikariPool.this.SknVT / 2L)) {
                    HikariPool.this.JHesM.warn("{} - Thread starvation or clock leap detected (housekeeper delta={}).", (Object)HikariPool.this.poolName, (Object)ClockSource.elapsedDisplayString(this.HXvGq, l2));
                }
                this.HXvGq = l2;
                String string = "Pool ";
                if (l > 0L && HikariPool.this.config.getMinimumIdle() < HikariPool.this.config.getMaximumPoolSize()) {
                    HikariPool.this.RLHXh("Before cleanup ");
                    string = "After cleanup  ";
                    List list = HikariPool.this.Vjrip.values(0);
                    int n = list.size() - HikariPool.this.config.getMinimumIdle();
                    for (PoolEntry poolEntry : list) {
                        if (n <= 0 || ClockSource.elapsedMillis(poolEntry.HXvGq, l2) <= l || !HikariPool.this.Vjrip.reserve(poolEntry)) continue;
                        HikariPool.this.RLHXh(poolEntry, "(connection has passed idleTimeout)");
                        --n;
                    }
                }
                HikariPool.this.RLHXh(string);
                HikariPool.this.JHesM();
            }
            catch (Exception exception) {
                HikariPool.this.JHesM.error("Unexpected exception in housekeeping task", exception);
            }
        }
    }

    private final class PoolEntryCreator
    implements Callable<Boolean> {
        private final String HXvGq;

        PoolEntryCreator(String string) {
            this.HXvGq = string;
        }

        @Override
        public Boolean call() {
            long l = 250L;
            while (HikariPool.this.poolState == 0 && this.RLHXh()) {
                PoolEntry poolEntry = HikariPool.this.ztTjN();
                if (poolEntry != null) {
                    HikariPool.this.Vjrip.add(poolEntry);
                    HikariPool.this.JHesM.debug("{} - Added connection {}", (Object)HikariPool.this.poolName, (Object)poolEntry.RLHXh);
                    if (this.HXvGq != null) {
                        HikariPool.this.RLHXh(this.HXvGq);
                    }
                    return Boolean.TRUE;
                }
                if (this.HXvGq != null) {
                    HikariPool.this.JHesM.debug("{} - Connection add failed, sleeping with backoff: {}ms", (Object)HikariPool.this.poolName, (Object)l);
                }
                UtilityElf.quietlySleep(l);
                l = Math.min(TimeUnit.SECONDS.toMillis(10L), Math.min(HikariPool.this.UhzX, (long)((double)l * 1.5)));
            }
            return Boolean.FALSE;
        }

        private synchronized boolean RLHXh() {
            return HikariPool.this.getTotalConnections() < HikariPool.this.config.getMaximumPoolSize() && (HikariPool.this.Vjrip.getWaitingThreadCount() > 0 || HikariPool.this.getIdleConnections() < HikariPool.this.config.getMinimumIdle());
        }
    }
}

