/*
 * Decompiled with CFR 0.152.
 */
package me.angeschossen.betterfarming.hikari.pool;

import java.lang.management.ManagementFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.sql.Statement;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import me.angeschossen.betterfarming.hikari.HikariConfig;
import me.angeschossen.betterfarming.hikari.SQLExceptionOverride;
import me.angeschossen.betterfarming.hikari.metrics.IMetricsTracker;
import me.angeschossen.betterfarming.hikari.pool.HikariPool;
import me.angeschossen.betterfarming.hikari.pool.PoolEntry;
import me.angeschossen.betterfarming.hikari.pool.ProxyConnection;
import me.angeschossen.betterfarming.hikari.util.ClockSource;
import me.angeschossen.betterfarming.hikari.util.DriverDataSource;
import me.angeschossen.betterfarming.hikari.util.PropertyElf;
import me.angeschossen.betterfarming.hikari.util.UtilityElf;
import me.angeschossen.betterfarming.slf4j.Logger;
import me.angeschossen.betterfarming.slf4j.LoggerFactory;

abstract class PoolBase {
    private final Logger JHesM = LoggerFactory.getLogger(PoolBase.class);
    public final HikariConfig config;
    IMetricsTrackerDelegate RLHXh;
    protected final String poolName;
    volatile String HXvGq;
    final AtomicReference<Exception> pdjAO;
    long UhzX;
    long Dgduf;
    SQLExceptionOverride ztTjN;
    private static final String[] igzHW = new String[]{"readOnly", "autoCommit", "isolation", "catalog", "netTimeout", "schema"};
    private static final int SknVT = -1;
    private static final int lGdKv = 1;
    private static final int DFkJL = 0;
    private int BdHcv;
    private int OvlG;
    private int AgSRZ;
    private int cKfg;
    private int rndpt;
    private Executor Vjrip;
    private DataSource ygtt;
    private final String VRYJH;
    private final boolean wybtH;
    private final boolean wGVzD;
    private final boolean AEoc;
    private final boolean XOcdi;
    private volatile boolean ePuVM;

    PoolBase(HikariConfig hikariConfig) {
        this.config = hikariConfig;
        this.BdHcv = -1;
        this.HXvGq = hikariConfig.getCatalog();
        this.VRYJH = hikariConfig.getSchema();
        this.wybtH = hikariConfig.isReadOnly();
        this.wGVzD = hikariConfig.isAutoCommit();
        this.ztTjN = UtilityElf.createInstance(hikariConfig.getExceptionOverrideClassName(), SQLExceptionOverride.class, new Object[0]);
        this.rndpt = UtilityElf.getTransactionIsolation(hikariConfig.getTransactionIsolation());
        this.AgSRZ = -1;
        this.OvlG = -1;
        this.AEoc = hikariConfig.getConnectionTestQuery() == null;
        this.XOcdi = hikariConfig.isIsolateInternalQueries();
        this.poolName = hikariConfig.getPoolName();
        this.UhzX = hikariConfig.getConnectionTimeout();
        this.Dgduf = hikariConfig.getValidationTimeout();
        this.pdjAO = new AtomicReference();
        this.RLHXh();
    }

    public String toString() {
        return this.poolName;
    }

    abstract void RLHXh(PoolEntry var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void RLHXh(Connection connection, String string) {
        if (connection != null) {
            try {
                this.JHesM.debug("{} - Closing connection {}: {}", this.poolName, connection, string);
                try {
                    this.HXvGq(connection, TimeUnit.SECONDS.toMillis(15L));
                }
                catch (SQLException sQLException) {
                }
                finally {
                    connection.close();
                }
            }
            catch (Exception exception) {
                this.JHesM.debug("{} - Closing connection {} failed", this.poolName, connection, exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean RLHXh(Connection connection) {
        try {
            try {
                this.HXvGq(connection, this.Dgduf);
                int n = (int)Math.max(1000L, this.Dgduf) / 1000;
                if (this.AEoc) {
                    boolean bl = connection.isValid(n);
                    return bl;
                }
                try (Statement statement = connection.createStatement();){
                    if (this.OvlG != 1) {
                        this.RLHXh(statement, n);
                    }
                    statement.execute(this.config.getConnectionTestQuery());
                    return true;
                }
            }
            finally {
                this.HXvGq(connection, this.BdHcv);
                if (this.XOcdi && !this.wGVzD) {
                    connection.rollback();
                }
            }
        }
        catch (Exception exception) {
            this.pdjAO.set(exception);
            this.JHesM.warn("{} - Failed to validate connection {} ({}). Possibly consider using a shorter maxLifetime value.", this.poolName, connection, exception.getMessage());
            return false;
        }
    }

    Exception HXvGq() {
        return this.pdjAO.get();
    }

    public DataSource getUnwrappedDataSource() {
        return this.ygtt;
    }

    PoolEntry pdjAO() {
        return new PoolEntry(this.ztTjN(), this, this.wybtH, this.wGVzD);
    }

    void RLHXh(Connection connection, ProxyConnection proxyConnection, int n) {
        int n2 = 0;
        if ((n & 1) != 0 && proxyConnection.Dgduf() != this.wybtH) {
            connection.setReadOnly(this.wybtH);
            n2 |= 1;
        }
        if ((n & 2) != 0 && proxyConnection.RLHXh() != this.wGVzD) {
            connection.setAutoCommit(this.wGVzD);
            n2 |= 2;
        }
        if ((n & 4) != 0 && proxyConnection.UhzX() != this.rndpt) {
            connection.setTransactionIsolation(this.rndpt);
            n2 |= 4;
        }
        if ((n & 8) != 0 && this.HXvGq != null && !this.HXvGq.equals(proxyConnection.HXvGq())) {
            connection.setCatalog(this.HXvGq);
            n2 |= 8;
        }
        if ((n & 0x10) != 0 && proxyConnection.ztTjN() != this.BdHcv) {
            this.HXvGq(connection, this.BdHcv);
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0 && this.VRYJH != null && !this.VRYJH.equals(proxyConnection.pdjAO())) {
            connection.setSchema(this.VRYJH);
            n2 |= 0x20;
        }
        if (n2 != 0 && this.JHesM.isDebugEnabled()) {
            this.JHesM.debug("{} - Reset ({}) on connection {}", this.poolName, this.RLHXh(n2), connection);
        }
    }

    void UhzX() {
        if (this.Vjrip instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.Vjrip).shutdownNow();
        }
    }

    long Dgduf() {
        try {
            return this.ygtt != null ? (long)this.ygtt.getLoginTimeout() : TimeUnit.SECONDS.toSeconds(5L);
        }
        catch (SQLException sQLException) {
            return TimeUnit.SECONDS.toSeconds(5L);
        }
    }

    void RLHXh(HikariPool hikariPool, boolean bl) {
        if (!this.config.isRegisterMbeans()) {
            return;
        }
        try {
            ObjectName objectName;
            ObjectName objectName2;
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            if ("true".equals(System.getProperty("hikaricp.jmx.register2.0"))) {
                objectName2 = new ObjectName("me.angeschossen.betterfarming.hikari:type=PoolConfig,name=" + this.poolName);
                objectName = new ObjectName("me.angeschossen.betterfarming.hikari:type=Pool,name=" + this.poolName);
            } else {
                objectName2 = new ObjectName("me.angeschossen.betterfarming.hikari:type=PoolConfig (" + this.poolName + ")");
                objectName = new ObjectName("me.angeschossen.betterfarming.hikari:type=Pool (" + this.poolName + ")");
            }
            if (bl) {
                if (!mBeanServer.isRegistered(objectName2)) {
                    mBeanServer.registerMBean(this.config, objectName2);
                    mBeanServer.registerMBean(hikariPool, objectName);
                } else {
                    this.JHesM.error("{} - JMX name ({}) is already registered.", (Object)this.poolName, (Object)this.poolName);
                }
            } else if (mBeanServer.isRegistered(objectName2)) {
                mBeanServer.unregisterMBean(objectName2);
                mBeanServer.unregisterMBean(objectName);
            }
        }
        catch (Exception exception) {
            this.JHesM.warn("{} - Failed to {} management beans.", this.poolName, bl ? "register" : "unregister", exception);
        }
    }

    private void RLHXh() {
        String string = this.config.getJdbcUrl();
        String string2 = this.config.getUsername();
        String string3 = this.config.getPassword();
        String string4 = this.config.getDataSourceClassName();
        String string5 = this.config.getDriverClassName();
        String string6 = this.config.getDataSourceJNDI();
        Properties properties = this.config.getDataSourceProperties();
        DataSource dataSource = this.config.getDataSource();
        if (string4 != null && dataSource == null) {
            dataSource = UtilityElf.createInstance(string4, DataSource.class, new Object[0]);
            PropertyElf.setTargetFromProperties(dataSource, properties);
        } else if (string != null && dataSource == null) {
            dataSource = new DriverDataSource(string, string5, properties, string2, string3);
        } else if (string6 != null && dataSource == null) {
            try {
                InitialContext initialContext = new InitialContext();
                dataSource = (DataSource)initialContext.lookup(string6);
            }
            catch (NamingException namingException) {
                throw new HikariPool.PoolInitializationException(namingException);
            }
        }
        if (dataSource != null) {
            this.RLHXh(dataSource);
            this.RLHXh(dataSource, string4, string);
        }
        this.ygtt = dataSource;
    }

    private Connection ztTjN() {
        long l = ClockSource.currentTime();
        Connection connection = null;
        try {
            String string = this.config.getUsername();
            String string2 = this.config.getPassword();
            Connection connection2 = connection = string == null ? this.ygtt.getConnection() : this.ygtt.getConnection(string, string2);
            if (connection == null) {
                throw new SQLTransientConnectionException("DataSource returned null unexpectedly");
            }
            this.HXvGq(connection);
            this.pdjAO.set(null);
            Connection connection3 = connection;
            return connection3;
        }
        catch (Exception exception) {
            if (connection != null) {
                this.RLHXh(connection, "(Failed to create/setup connection)");
            } else if (this.HXvGq() == null) {
                this.JHesM.debug("{} - Failed to create/setup connection: {}", (Object)this.poolName, (Object)exception.getMessage());
            }
            this.pdjAO.set(exception);
            throw exception;
        }
        finally {
            if (this.RLHXh != null) {
                this.RLHXh.recordConnectionCreated(ClockSource.elapsedMillis(l));
            }
        }
    }

    private void HXvGq(Connection connection) {
        try {
            if (this.BdHcv == -1) {
                this.BdHcv = this.RLHXh(connection, this.Dgduf);
            } else {
                this.HXvGq(connection, this.Dgduf);
            }
            if (connection.isReadOnly() != this.wybtH) {
                connection.setReadOnly(this.wybtH);
            }
            if (connection.getAutoCommit() != this.wGVzD) {
                connection.setAutoCommit(this.wGVzD);
            }
            this.pdjAO(connection);
            if (this.rndpt != this.cKfg) {
                connection.setTransactionIsolation(this.rndpt);
            }
            if (this.HXvGq != null) {
                connection.setCatalog(this.HXvGq);
            }
            if (this.VRYJH != null) {
                connection.setSchema(this.VRYJH);
            }
            this.RLHXh(connection, this.config.getConnectionInitSql(), true);
            this.HXvGq(connection, this.BdHcv);
        }
        catch (SQLException sQLException) {
            throw new ConnectionSetupException(sQLException);
        }
    }

    private void pdjAO(Connection connection) {
        if (!this.ePuVM) {
            this.UhzX(connection);
            this.Dgduf(connection);
            this.ePuVM = true;
        }
    }

    private void UhzX(Connection connection) {
        try {
            if (this.AEoc) {
                connection.isValid(1);
            } else {
                this.RLHXh(connection, this.config.getConnectionTestQuery(), false);
            }
        }
        catch (AbstractMethodError | Exception throwable) {
            this.JHesM.error("{} - Failed to execute{} connection test query ({}).", this.poolName, this.AEoc ? " isValid() for connection, configure" : "", throwable.getMessage());
            throw throwable;
        }
    }

    private void Dgduf(Connection connection) {
        block3: {
            try {
                this.cKfg = connection.getTransactionIsolation();
                if (this.rndpt == -1) {
                    this.rndpt = this.cKfg;
                }
            }
            catch (SQLException sQLException) {
                this.JHesM.warn("{} - Default transaction isolation level detection failed ({}).", (Object)this.poolName, (Object)sQLException.getMessage());
                if (sQLException.getSQLState() == null || sQLException.getSQLState().startsWith("08")) break block3;
                throw sQLException;
            }
        }
    }

    private void RLHXh(Statement statement, int n) {
        block3: {
            if (this.AgSRZ != 0) {
                try {
                    statement.setQueryTimeout(n);
                    this.AgSRZ = 1;
                }
                catch (Exception exception) {
                    if (this.AgSRZ != -1) break block3;
                    this.AgSRZ = 0;
                    this.JHesM.info("{} - Failed to set query timeout for statement. ({})", (Object)this.poolName, (Object)exception.getMessage());
                }
            }
        }
    }

    private int RLHXh(Connection connection, long l) {
        block4: {
            if (this.OvlG != 0) {
                try {
                    int n = connection.getNetworkTimeout();
                    connection.setNetworkTimeout(this.Vjrip, (int)l);
                    this.OvlG = 1;
                    return n;
                }
                catch (AbstractMethodError | Exception throwable) {
                    if (this.OvlG != -1) break block4;
                    this.OvlG = 0;
                    this.JHesM.info("{} - Driver does not support get/set network timeout for connections. ({})", (Object)this.poolName, (Object)throwable.getMessage());
                    if (this.Dgduf < TimeUnit.SECONDS.toMillis(1L)) {
                        this.JHesM.warn("{} - A validationTimeout of less than 1 second cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                    }
                    if (this.Dgduf % TimeUnit.SECONDS.toMillis(1L) == 0L) break block4;
                    this.JHesM.warn("{} - A validationTimeout with fractional second granularity cannot be honored on drivers without setNetworkTimeout() support.", (Object)this.poolName);
                }
            }
        }
        return 0;
    }

    private void HXvGq(Connection connection, long l) {
        if (this.OvlG == 1) {
            connection.setNetworkTimeout(this.Vjrip, (int)l);
        }
    }

    private void RLHXh(Connection connection, String string, boolean bl) {
        if (string != null) {
            try (Statement statement = connection.createStatement();){
                statement.execute(string);
            }
            if (this.XOcdi && !this.wGVzD) {
                if (bl) {
                    connection.commit();
                } else {
                    connection.rollback();
                }
            }
        }
    }

    private void RLHXh(DataSource dataSource, String string, String string2) {
        if (string != null && string.contains("Mysql") || string2 != null && string2.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.Vjrip = new SynchronousExecutor();
        } else {
            ThreadFactory threadFactory = this.config.getThreadFactory();
            threadFactory = threadFactory != null ? threadFactory : new UtilityElf.DefaultThreadFactory(this.poolName + " network timeout executor", true);
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            threadPoolExecutor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            this.Vjrip = threadPoolExecutor;
        }
    }

    private void RLHXh(DataSource dataSource) {
        if (this.UhzX != Integer.MAX_VALUE) {
            try {
                dataSource.setLoginTimeout(Math.max(1, (int)TimeUnit.MILLISECONDS.toSeconds(500L + this.UhzX)));
            }
            catch (Exception exception) {
                this.JHesM.info("{} - Failed to set login timeout for data source. ({})", (Object)this.poolName, (Object)exception.getMessage());
            }
        }
    }

    private String RLHXh(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < igzHW.length; ++i) {
            if ((n & 1 << i) == 0) continue;
            stringBuilder.append(igzHW[i]).append(", ");
        }
        stringBuilder.setLength(stringBuilder.length() - 2);
        return stringBuilder.toString();
    }

    static final class NopMetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        NopMetricsTrackerDelegate() {
        }
    }

    static class MetricsTrackerDelegate
    implements IMetricsTrackerDelegate {
        final IMetricsTracker RLHXh;

        MetricsTrackerDelegate(IMetricsTracker iMetricsTracker) {
            this.RLHXh = iMetricsTracker;
        }

        @Override
        public void recordConnectionUsage(PoolEntry poolEntry) {
            this.RLHXh.recordConnectionUsageMillis(poolEntry.UhzX());
        }

        @Override
        public void recordConnectionCreated(long l) {
            this.RLHXh.recordConnectionCreatedMillis(l);
        }

        @Override
        public void recordBorrowTimeoutStats(long l) {
            this.RLHXh.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l));
        }

        @Override
        public void recordBorrowStats(PoolEntry poolEntry, long l) {
            long l2;
            poolEntry.pdjAO = l2 = ClockSource.currentTime();
            this.RLHXh.recordConnectionAcquiredNanos(ClockSource.elapsedNanos(l, l2));
        }

        @Override
        public void recordConnectionTimeout() {
            this.RLHXh.recordConnectionTimeout();
        }

        @Override
        public void close() {
            this.RLHXh.close();
        }
    }

    static interface IMetricsTrackerDelegate
    extends AutoCloseable {
        default public void recordConnectionUsage(PoolEntry poolEntry) {
        }

        default public void recordConnectionCreated(long connectionCreatedMillis) {
        }

        default public void recordBorrowTimeoutStats(long startTime) {
        }

        default public void recordBorrowStats(PoolEntry poolEntry, long startTime) {
        }

        default public void recordConnectionTimeout() {
        }

        @Override
        default public void close() {
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable runnable) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LoggerFactory.getLogger(PoolBase.class).debug("Failed to execute: {}", (Object)runnable, (Object)exception);
            }
        }
    }

    static class ConnectionSetupException
    extends Exception {
        private static final long RLHXh = 929872118275916521L;

        ConnectionSetupException(Throwable throwable) {
            super(throwable);
        }
    }
}

