/*
 * Decompiled with CFR 0.152.
 */
package me.SuperRonanCraft.BetterRTPAddons.addons.portals.region;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.wrappers.BlockPosition;
import com.comphenix.protocol.wrappers.WrappedBlockData;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import me.SuperRonanCraft.BetterRTPAddons.Main;
import me.SuperRonanCraft.BetterRTPAddons.addons.portals.AddonPortals;
import me.SuperRonanCraft.BetterRTPAddons.addons.portals.region.PortalsRegionInfo;
import me.SuperRonanCraft.BetterRTPAddons.packets.BlockChangeArray;
import me.SuperRonanCraft.BetterRTPAddons.packets.WrapperPlayServerBlockChange;
import me.SuperRonanCraft.BetterRTPAddons.packets.WrapperPlayServerMultiBlockChange;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PortalsCache {
    AddonPortals addonPortals;
    private List<PortalsRegionInfo> registeredPortals;
    private final HashMap<Player, PortalsRegionInfo> portalsBeingCreated = new HashMap();

    public PortalsCache(AddonPortals addonPortals) {
        this.addonPortals = addonPortals;
    }

    public void load() {
        this.registeredPortals = this.addonPortals.getDatabase().getPortals();
    }

    public void unload() {
        this.portalsBeingCreated.clear();
    }

    void uncache(Player player) {
        this.portalsBeingCreated.remove(player);
    }

    public List<PortalsRegionInfo> getRegisteredPortals() {
        return this.registeredPortals;
    }

    public boolean removeRegisteredPortal(PortalsRegionInfo portalsRegionInfo) {
        this.registeredPortals.remove(portalsRegionInfo);
        return this.addonPortals.getDatabase().removePortal(portalsRegionInfo);
    }

    public boolean addRegisteredPortal(Player player, String string) {
        if (!this.portalsBeingCreated.containsKey(player)) {
            return false;
        }
        PortalsRegionInfo portalsRegionInfo = this.portalsBeingCreated.get(player);
        portalsRegionInfo.name = string;
        this.registeredPortals.add(portalsRegionInfo);
        return this.addonPortals.getDatabase().setPortal(portalsRegionInfo);
    }

    public void cachePortal(Player player, Location location, boolean bl) {
        PortalsRegionInfo portalsRegionInfo;
        if (this.portalsBeingCreated.containsKey(player)) {
            portalsRegionInfo = this.portalsBeingCreated.get(player);
        } else {
            portalsRegionInfo = new PortalsRegionInfo();
            this.portalsBeingCreated.put(player, portalsRegionInfo);
        }
        Location location2 = portalsRegionInfo.loc_1;
        Location location3 = portalsRegionInfo.loc_2;
        if (bl) {
            portalsRegionInfo.loc_2 = location;
        } else {
            portalsRegionInfo.loc_1 = location;
        }
        if (portalsRegionInfo.loc_1 != null && portalsRegionInfo.loc_2 != null && (location2 == null || location3 == null)) {
            this.addonPortals.msgs.getLocation_Ready((CommandSender)player);
        }
        if (Bukkit.getPluginManager().isPluginEnabled("ProtocolLib")) {
            ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
            WrapperPlayServerBlockChange wrapperPlayServerBlockChange = new WrapperPlayServerBlockChange(protocolManager.createPacket(PacketType.Play.Server.BLOCK_CHANGE));
            wrapperPlayServerBlockChange.setBlockData(WrappedBlockData.createData((Material)Material.GLOWSTONE));
            wrapperPlayServerBlockChange.setLocation(new BlockPosition(location.toVector()));
            wrapperPlayServerBlockChange.sendPacket(player);
        } else {
            try {
                if (bl) {
                    player.sendBlockChange(portalsRegionInfo.loc_2, Material.GLOWSTONE.createBlockData());
                } else {
                    player.sendBlockChange(portalsRegionInfo.loc_1, Material.GLOWSTONE.createBlockData());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void preview(Location location, Location location2) {
        ProtocolManager protocolManager = ProtocolLibrary.getProtocolManager();
        Bukkit.getScheduler().runTask((Plugin)Main.getInstance(), () -> {
            PacketContainer packetContainer = protocolManager.createPacket(PacketType.Play.Server.MULTI_BLOCK_CHANGE);
            Chunk chunk = location.getChunk();
            BlockChangeArray blockChangeArray = new BlockChangeArray(256);
            WrapperPlayServerMultiBlockChange wrapperPlayServerMultiBlockChange = new WrapperPlayServerMultiBlockChange(packetContainer);
            wrapperPlayServerMultiBlockChange.setChunkX(chunk.getX());
            wrapperPlayServerMultiBlockChange.setChunkZ(chunk.getZ());
            for (int i = 0; i <= 15; ++i) {
                for (int j = 0; j <= 15; ++j) {
                    int n = 16 * i + j;
                    BlockChangeArray.BlockChange blockChange = blockChangeArray.getBlockChange(n);
                    blockChange.setBlockID(WrappedBlockData.createData((Material)Material.GOLD_BLOCK).getType().getId());
                    Location location2 = location.clone();
                    location2.setX(location2.getX() + (double)i);
                    location2.setZ(location2.getZ() + (double)j);
                    blockChange.setLocation(location2);
                    blockChangeArray.setBlockChange(n, blockChange);
                }
            }
            wrapperPlayServerMultiBlockChange.setRecordData(blockChangeArray);
            for (Player player : Bukkit.getOnlinePlayers()) {
                try {
                    protocolManager.sendServerPacket(player, packetContainer);
                }
                catch (InvocationTargetException invocationTargetException) {
                    invocationTargetException.printStackTrace();
                }
            }
        });
    }

    public PortalsRegionInfo getPortal(Player player) {
        return this.portalsBeingCreated.getOrDefault(player, null);
    }
}

