/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.command;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.List;
import net.coreprotect.command.CommandHandler;
import net.coreprotect.config.Config;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.consumer.Consumer;
import net.coreprotect.database.Database;
import net.coreprotect.language.Phrase;
import net.coreprotect.patch.Patch;
import net.coreprotect.utility.Chat;
import net.coreprotect.utility.ChatMessage;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class PurgeCommand
extends Consumer {
    protected static void runCommand(final CommandSender player, boolean permission, final String[] args) {
        long endTime;
        int resultc = args.length;
        Location location = CommandHandler.parseLocation(player, args);
        Integer[] argRadius = CommandHandler.parseRadius(args, player, location);
        long[] argTime = CommandHandler.parseTime(args);
        final int argWid = CommandHandler.parseWorld(args, false, false);
        List<Integer> argAction = CommandHandler.parseAction(args);
        List<Integer> supportedActions = Arrays.asList(new Integer[0]);
        final long startTime = argTime[1] > 0L ? argTime[0] : 0L;
        long l = endTime = argTime[1] > 0L ? argTime[1] : argTime[0];
        if (ConfigHandler.converterRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.UPGRADE_IN_PROGRESS, new String[0]));
            return;
        }
        if (ConfigHandler.purgeRunning) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_IN_PROGRESS, new String[0]));
            return;
        }
        if (!permission) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_PERMISSION, new String[0]));
            return;
        }
        if (resultc <= 1) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co purge t:<time>"));
            return;
        }
        if (endTime <= 0L) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.MISSING_PARAMETERS, "/co purge t:<time>"));
            return;
        }
        if (argRadius != null) {
            Chat.sendMessage(player, new ChatMessage(Phrase.build(Phrase.INVALID_WORLD, new String[0])).build());
            return;
        }
        if (argWid == -1) {
            String worldName = CommandHandler.parseWorldName(args, false);
            Chat.sendMessage(player, new ChatMessage(Phrase.build(Phrase.WORLD_NOT_FOUND, worldName)).build());
            return;
        }
        for (int action : argAction) {
            if (supportedActions.contains(action)) continue;
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.ACTION_NOT_SUPPORTED, new String[0]));
            return;
        }
        if (player instanceof Player && endTime < 2592000L) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_MINIMUM_TIME, "30", "{1}"));
            return;
        }
        if (endTime < 86400L) {
            Chat.sendMessage(player, Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.PURGE_MINIMUM_TIME, "24", "{2}"));
            return;
        }
        boolean optimizeCheck = false;
        for (String arg : args) {
            if (!arg.trim().equalsIgnoreCase("#optimize")) continue;
            optimizeCheck = true;
            break;
        }
        final boolean optimize = optimizeCheck;
        class BasicThread
        implements Runnable {
            BasicThread() {
            }

            @Override
            public void run() {
                try {
                    Integer[] lastVersion;
                    boolean newVersion;
                    long timestamp = System.currentTimeMillis() / 1000L;
                    long timeStart = startTime > 0L ? timestamp - startTime : 0L;
                    long timeEnd = timestamp - endTime;
                    long removed = 0L;
                    Connection connection = null;
                    for (int i = 0; i <= 5 && (connection = Database.getConnection(false, 500)) == null; ++i) {
                        Thread.sleep(1000L);
                    }
                    if (connection == null) {
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.DATABASE_BUSY, new String[0]));
                        return;
                    }
                    if (argWid > 0) {
                        String worldName = CommandHandler.parseWorldName(args, false);
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_STARTED, worldName));
                    } else {
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_STARTED, "#global"));
                    }
                    Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_NOTICE_1, new String[0]));
                    Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_NOTICE_2, new String[0]));
                    ConfigHandler.purgeRunning = true;
                    while (!pausedSuccess) {
                        Thread.sleep(1L);
                    }
                    Consumer.isPaused = true;
                    Object query = "";
                    PreparedStatement preparedStmt = null;
                    boolean abort = false;
                    String purgePrefix = "tmp_" + ConfigHandler.prefix;
                    if (!Config.getGlobal().MYSQL) {
                        query = "ATTACH DATABASE '" + ConfigHandler.path + ConfigHandler.sqlite + ".tmp' AS tmp_db";
                        preparedStmt = connection.prepareStatement((String)query);
                        preparedStmt.execute();
                        preparedStmt.close();
                        purgePrefix = "tmp_db." + ConfigHandler.prefix;
                    }
                    if ((newVersion = Util.newVersion(lastVersion = Patch.getDatabaseVersion(connection, true), Util.getInternalPluginVersion())) && !ConfigHandler.EDITION_BRANCH.contains("-dev")) {
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_FAILED, new String[0]));
                        Consumer.isPaused = false;
                        ConfigHandler.purgeRunning = false;
                        return;
                    }
                    if (!Config.getGlobal().MYSQL) {
                        for (String table : ConfigHandler.databaseTables) {
                            try {
                                query = "DROP TABLE IF EXISTS " + purgePrefix + table;
                                preparedStmt = connection.prepareStatement((String)query);
                                preparedStmt.execute();
                                preparedStmt.close();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        Database.createDatabaseTables(purgePrefix, true);
                    }
                    List<String> purgeTables = Arrays.asList("sign", "container", "item", "skull", "session", "chat", "command", "entity", "block");
                    List<String> worldTables = Arrays.asList("sign", "container", "item", "session", "chat", "command", "block");
                    List<String> excludeTables = Arrays.asList("database_lock");
                    for (String table : ConfigHandler.databaseTables) {
                        String tableName = table.replaceAll("_", " ");
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_PROCESSING, tableName));
                        if (!Config.getGlobal().MYSQL) {
                            Object columns = "";
                            ResultSet rs = connection.createStatement().executeQuery("SELECT * FROM " + purgePrefix + table);
                            ResultSetMetaData resultSetMetaData = rs.getMetaData();
                            int columnCount = resultSetMetaData.getColumnCount();
                            for (int i = 1; i <= columnCount; ++i) {
                                String name = resultSetMetaData.getColumnName(i);
                                columns = ((String)columns).length() == 0 ? name : (String)columns + "," + name;
                            }
                            rs.close();
                            boolean error = false;
                            if (!excludeTables.contains(table)) {
                                try {
                                    Object timeLimit = "";
                                    if (purgeTables.contains(table)) {
                                        if (argWid > 0 && worldTables.contains(table)) {
                                            timeLimit = " WHERE (wid = '" + argWid + "' AND (time >= '" + timeEnd + "' OR time < '" + timeStart + "')) OR wid != '" + argWid + "'";
                                        } else if (argWid == 0) {
                                            timeLimit = " WHERE (time >= '" + timeEnd + "' OR time < '" + timeStart + "')";
                                        }
                                    }
                                    query = "INSERT INTO " + purgePrefix + table + " SELECT " + (String)columns + " FROM " + ConfigHandler.prefix + table + (String)timeLimit;
                                    preparedStmt = connection.prepareStatement((String)query);
                                    preparedStmt.execute();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    error = true;
                                    e.printStackTrace();
                                }
                            }
                            if (error) {
                                Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_ERROR, tableName));
                                Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_REPAIRING, new String[0]));
                                try {
                                    query = "DELETE FROM " + purgePrefix + table;
                                    preparedStmt = connection.prepareStatement((String)query);
                                    preparedStmt.execute();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                try {
                                    query = "REINDEX " + ConfigHandler.prefix + table;
                                    preparedStmt = connection.prepareStatement((String)query);
                                    preparedStmt.execute();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                try {
                                    String index = " NOT INDEXED";
                                    query = "INSERT INTO " + purgePrefix + table + " SELECT " + (String)columns + " FROM " + ConfigHandler.prefix + table + index;
                                    preparedStmt = connection.prepareStatement((String)query);
                                    preparedStmt.execute();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    abort = true;
                                    break;
                                }
                                try {
                                    boolean purge = purgeTables.contains(table);
                                    Object worldRestriction = "";
                                    if (argWid > 0 && worldTables.contains(table)) {
                                        worldRestriction = " AND wid = '" + argWid + "'";
                                    } else if (argWid > 0) {
                                        purge = false;
                                    }
                                    if (purge) {
                                        query = "DELETE FROM " + purgePrefix + table + " WHERE time < '" + timeEnd + "' AND time >= '" + timeStart + "'" + (String)worldRestriction;
                                        preparedStmt = connection.prepareStatement((String)query);
                                        preparedStmt.execute();
                                        preparedStmt.close();
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (purgeTables.contains(table)) {
                                int oldCount = 0;
                                try {
                                    query = "SELECT COUNT(*) as count FROM " + ConfigHandler.prefix + table + " LIMIT 0, 1";
                                    preparedStmt = connection.prepareStatement((String)query);
                                    ResultSet resultSet = preparedStmt.executeQuery();
                                    while (resultSet.next()) {
                                        oldCount = resultSet.getInt("count");
                                    }
                                    resultSet.close();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                int new_count = 0;
                                try {
                                    query = "SELECT COUNT(*) as count FROM " + purgePrefix + table + " LIMIT 0, 1";
                                    preparedStmt = connection.prepareStatement((String)query);
                                    ResultSet resultSet = preparedStmt.executeQuery();
                                    while (resultSet.next()) {
                                        new_count = resultSet.getInt("count");
                                    }
                                    resultSet.close();
                                    preparedStmt.close();
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                removed += (long)(oldCount - new_count);
                            }
                        }
                        if (!Config.getGlobal().MYSQL) continue;
                        try {
                            boolean purge = purgeTables.contains(table);
                            Object worldRestriction = "";
                            if (argWid > 0 && worldTables.contains(table)) {
                                worldRestriction = " AND wid = '" + argWid + "'";
                            } else if (argWid > 0) {
                                purge = false;
                            }
                            if (!purge) continue;
                            query = "DELETE FROM " + ConfigHandler.prefix + table + " WHERE time < '" + timeEnd + "' AND time >= '" + timeStart + "'" + (String)worldRestriction;
                            preparedStmt = connection.prepareStatement((String)query);
                            preparedStmt.execute();
                            removed += (long)preparedStmt.getUpdateCount();
                            preparedStmt.close();
                        }
                        catch (Exception e) {
                            if (!ConfigHandler.serverRunning) {
                                Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_FAILED, new String[0]));
                                return;
                            }
                            e.printStackTrace();
                        }
                    }
                    if (Config.getGlobal().MYSQL && optimize) {
                        Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_OPTIMIZING, new String[0]));
                        for (String table : ConfigHandler.databaseTables) {
                            query = "OPTIMIZE LOCAL TABLE " + ConfigHandler.prefix + table;
                            preparedStmt = connection.prepareStatement((String)query);
                            preparedStmt.execute();
                            preparedStmt.close();
                        }
                    }
                    connection.close();
                    if (abort) {
                        if (!Config.getGlobal().MYSQL) {
                            new File(ConfigHandler.path + ConfigHandler.sqlite + ".tmp").delete();
                        }
                        ConfigHandler.loadDatabase();
                        Chat.sendGlobalMessage(player, Color.RED + Phrase.build(Phrase.PURGE_ABORTED, new String[0]));
                        Consumer.isPaused = false;
                        ConfigHandler.purgeRunning = false;
                        return;
                    }
                    if (!Config.getGlobal().MYSQL) {
                        new File(ConfigHandler.path + ConfigHandler.sqlite).delete();
                        new File(ConfigHandler.path + ConfigHandler.sqlite + ".tmp").renameTo(new File(ConfigHandler.path + ConfigHandler.sqlite));
                    }
                    ConfigHandler.loadDatabase();
                    Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_SUCCESS, new String[0]));
                    Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_ROWS, NumberFormat.getInstance().format(removed), removed == 1L ? "{1}" : "{2}"));
                }
                catch (Exception e) {
                    Chat.sendGlobalMessage(player, Phrase.build(Phrase.PURGE_FAILED, new String[0]));
                    e.printStackTrace();
                }
                Consumer.isPaused = false;
                ConfigHandler.purgeRunning = false;
            }
        }
        BasicThread runnable = new BasicThread();
        Thread thread = new Thread(runnable);
        thread.start();
    }
}

