/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.database.lookup;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Locale;
import net.coreprotect.config.ConfigHandler;
import net.coreprotect.database.statement.UserStatement;
import net.coreprotect.language.Phrase;
import net.coreprotect.listener.channel.PluginChannelListener;
import net.coreprotect.utility.Color;
import net.coreprotect.utility.Util;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;

public class InteractionLookup {
    public static String performLookup(String command, Statement statement, Block block, CommandSender commandSender, int offset, int page, int limit) {
        Object result = "";
        try {
            if (block == null) {
                return result;
            }
            if (command == null) {
                command = commandSender.hasPermission("coreprotect.co") ? "co" : (commandSender.hasPermission("coreprotect.core") ? "core" : (commandSender.hasPermission("coreprotect.coreprotect") ? "coreprotect" : "co"));
            }
            boolean found = false;
            int x = block.getX();
            int y = block.getY();
            int z = block.getZ();
            int time = (int)(System.currentTimeMillis() / 1000L);
            int worldId = Util.getWorldId(block.getWorld().getName());
            int checkTime = 0;
            int count = 0;
            int rowMax = page * limit;
            int pageStart = rowMax - limit;
            if (offset > 0) {
                checkTime = time - offset;
            }
            String query = "SELECT COUNT(*) as count from " + ConfigHandler.prefix + "block " + Util.getWidIndex("block") + "WHERE wid = '" + worldId + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action='2' AND time >= '" + checkTime + "' LIMIT 0, 1";
            ResultSet results = statement.executeQuery(query);
            while (results.next()) {
                count = results.getInt("count");
            }
            results.close();
            int totalPages = (int)Math.ceil((double)count / ((double)limit + 0.0));
            query = "SELECT time,user,action,type,data,rolled_back FROM " + ConfigHandler.prefix + "block " + Util.getWidIndex("block") + "WHERE wid = '" + worldId + "' AND x = '" + x + "' AND z = '" + z + "' AND y = '" + y + "' AND action='2' AND time >= '" + checkTime + "' ORDER BY rowid DESC LIMIT " + pageStart + ", " + limit;
            results = statement.executeQuery(query);
            StringBuilder resultBuilder = new StringBuilder();
            while (results.next()) {
                Material resultMaterial;
                int resultUserId = results.getInt("user");
                int resultAction = results.getInt("action");
                int resultType = results.getInt("type");
                int resultData = results.getInt("data");
                long resultTime = results.getLong("time");
                int resultRolledBack = results.getInt("rolled_back");
                if (ConfigHandler.playerIdCacheReversed.get(resultUserId) == null) {
                    UserStatement.loadName(statement.getConnection(), resultUserId);
                }
                String resultUser = ConfigHandler.playerIdCacheReversed.get(resultUserId);
                String timeAgo = Util.getTimeSince(resultTime, time, true);
                if (!found) {
                    resultBuilder = new StringBuilder(Color.WHITE + "----- " + Color.DARK_AQUA + Phrase.build(Phrase.INTERACTIONS_HEADER, new String[0]) + Color.WHITE + " ----- " + Util.getCoordinates(command, worldId, x, y, z, false, false) + "\n");
                }
                found = true;
                String rbFormat = "";
                if (resultRolledBack == 1 || resultRolledBack == 3) {
                    rbFormat = "\u00a7m";
                }
                if ((resultMaterial = Util.getType(resultType)) == null) {
                    resultMaterial = Material.AIR;
                }
                Object target = resultMaterial.name().toLowerCase(Locale.ROOT);
                if (((String)(target = Util.nameFilter((String)target, resultData))).length() > 0) {
                    target = "minecraft:" + ((String)target).toLowerCase(Locale.ROOT);
                }
                if (((String)target).startsWith("minecraft:")) {
                    target = ((String)target).split(":")[1];
                }
                resultBuilder.append(timeAgo + " " + Color.WHITE + "- ").append(Phrase.build(Phrase.LOOKUP_INTERACTION, Color.DARK_AQUA + rbFormat + resultUser + Color.WHITE + rbFormat, Color.DARK_AQUA + rbFormat + (String)target + Color.WHITE, "{1}")).append("\n");
                PluginChannelListener.getInstance().sendData(commandSender, resultTime, Phrase.LOOKUP_INTERACTION, "{1}", resultUser, (String)target, -1, x, y, z, worldId, rbFormat, false, false);
            }
            result = resultBuilder.toString();
            results.close();
            if (found) {
                if (count > limit) {
                    String pageInfo = Color.WHITE + "-----\n";
                    pageInfo = pageInfo + Util.getPageNavigation(command, page, totalPages) + "\n";
                    result = (String)result + pageInfo;
                }
            } else {
                result = rowMax > count && count > 0 ? Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_RESULTS_PAGE, "{2}") : Color.DARK_AQUA + "CoreProtect " + Color.WHITE + "- " + Phrase.build(Phrase.NO_DATA_LOCATION, "{3}");
            }
            ConfigHandler.lookupPage.put(commandSender.getName(), page);
            ConfigHandler.lookupType.put(commandSender.getName(), 7);
            ConfigHandler.lookupCommand.put(commandSender.getName(), x + "." + y + "." + z + "." + worldId + ".2." + limit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }
}

