/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener;

import net.coreprotect.consumer.Queue;
import net.coreprotect.listener.entity.EntityPickupItemListener;
import org.bukkit.Material;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPickupArrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;

public final class PlayerPickupArrowListener
extends Queue
implements Listener {
    public static ItemStack getArrowType(AbstractArrow arrow) {
        Arrow arrowEntity;
        PotionData data;
        ItemStack itemStack = null;
        switch (arrow.getType()) {
            case SPECTRAL_ARROW: {
                itemStack = new ItemStack(Material.SPECTRAL_ARROW);
                break;
            }
            default: {
                itemStack = new ItemStack(Material.ARROW);
            }
        }
        if (arrow instanceof Arrow && (data = (arrowEntity = (Arrow)arrow).getBasePotionData()).getType() != PotionType.UNCRAFTABLE) {
            itemStack = new ItemStack(Material.TIPPED_ARROW);
            PotionMeta meta = (PotionMeta)itemStack.getItemMeta();
            meta.setBasePotionData(data);
            for (PotionEffect effect : arrowEntity.getCustomEffects()) {
                meta.addCustomEffect(effect, false);
            }
            itemStack.setItemMeta((ItemMeta)meta);
        }
        return itemStack;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    protected void onPlayerPickupArrowEvent(PlayerPickupArrowEvent event) {
        ItemStack itemStack = PlayerPickupArrowListener.getArrowType(event.getArrow());
        EntityPickupItemListener.onItemPickup(event.getPlayer(), event.getArrow().getLocation(), itemStack);
    }
}

