/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.listener.block;

import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.listener.block.BlockBreakListener;
import net.coreprotect.model.BlockGroup;
import net.coreprotect.thread.CacheHandler;
import net.coreprotect.utility.Util;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class BlockUtil {
    public static final int NONE = 0;
    public static final int TOP = 5;
    public static final int BOTTOM = 6;

    public static boolean verticalBreakScan(Player player, String user, Block block, Block scanBlock, Material scanType, int scanMin) {
        boolean bottom;
        if (!BlockGroup.VERTICAL.contains(scanType)) {
            return false;
        }
        if (scanType != block.getType()) {
            boolean trackBottom;
            boolean trackTop = BlockGroup.TRACK_TOP_BOTTOM.contains(scanType) || BlockGroup.TRACK_TOP.contains(scanType);
            boolean bl = trackBottom = BlockGroup.TRACK_TOP_BOTTOM.contains(scanType) || BlockGroup.TRACK_BOTTOM.contains(scanType);
            if (!trackTop && scanMin == 5 || !trackBottom && scanMin == 6) {
                return false;
            }
        }
        boolean top = BlockGroup.VERTICAL_TOP_BOTTOM.contains(scanType) || BlockGroup.VERTICAL_TOP.contains(scanType);
        boolean bl = bottom = BlockGroup.VERTICAL_TOP_BOTTOM.contains(scanType) || BlockGroup.VERTICAL_BOTTOM.contains(scanType);
        if (top && scanMin == 5 || bottom && scanMin == 6) {
            BlockBreakListener.processBlockBreak(player, user, scanBlock, true, scanMin == 6 ? 5 : 6);
            return true;
        }
        return false;
    }

    public static Block gravityScan(Location location, Material type, String player) {
        Block block = location.getBlock();
        int timestamp = (int)(System.currentTimeMillis() / 1000L);
        if (type.hasGravity() || type == Material.ARMOR_STAND) {
            int x = location.getBlockX();
            int y = location.getBlockY();
            int z = location.getBlockZ();
            World world = location.getWorld();
            int wid = Util.getWorldId(world.getName());
            int yc = y - 1;
            boolean bottomfound = false;
            while (!bottomfound) {
                if (yc < BukkitAdapter.ADAPTER.getMinHeight(world)) {
                    block = world.getBlockAt(x, yc + 1, z);
                    bottomfound = true;
                    continue;
                }
                Block block_down = world.getBlockAt(x, yc, z);
                Material down = block_down.getType();
                if (!(BukkitAdapter.ADAPTER.isInvisible(down) || down.equals((Object)Material.WATER) || down.equals((Object)Material.LAVA) || down.equals((Object)Material.SNOW))) {
                    block = world.getBlockAt(x, yc + 1, z);
                    bottomfound = true;
                } else if (down == Material.WATER && type.name().endsWith("_CONCRETE_POWDER")) {
                    block = world.getBlockAt(x, yc, z);
                    bottomfound = true;
                } else {
                    Material t;
                    String cords = x + "." + yc + "." + z + "." + wid;
                    Object[] data = CacheHandler.lookupCache.get(cords);
                    if (data != null && type.equals((Object)(t = (Material)data[2])) && type != Material.ARMOR_STAND) {
                        block = world.getBlockAt(x, yc + 1, z);
                        bottomfound = true;
                    }
                }
                --yc;
            }
            CacheHandler.lookupCache.put(x + "." + block.getY() + "." + z + "." + wid, new Object[]{timestamp, player, type});
        }
        return block;
    }
}

