/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.thread;

import io.papermc.paper.threadedregions.scheduler.ScheduledTask;
import java.util.concurrent.TimeUnit;
import net.coreprotect.CoreProtect;
import net.coreprotect.config.ConfigHandler;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class Scheduler {
    private Scheduler() {
        throw new IllegalStateException("Scheduler class");
    }

    public static void scheduleSyncDelayedTask(CoreProtect plugin, Runnable task, Object regionData, int delay) {
        if (ConfigHandler.isFolia) {
            if (regionData instanceof Location) {
                Location location = (Location)regionData;
                if (delay == 0) {
                    Bukkit.getServer().getRegionScheduler().run((Plugin)plugin, location, value -> task.run());
                } else {
                    Bukkit.getServer().getRegionScheduler().runDelayed((Plugin)plugin, location, value -> task.run(), (long)delay);
                }
            } else if (regionData instanceof Entity) {
                Entity entity = (Entity)regionData;
                if (delay == 0) {
                    entity.getScheduler().run((Plugin)plugin, value -> task.run(), task);
                } else {
                    entity.getScheduler().runDelayed((Plugin)plugin, value -> task.run(), task, (long)delay);
                }
            } else if (delay == 0) {
                Bukkit.getServer().getGlobalRegionScheduler().run((Plugin)plugin, value -> task.run());
            } else {
                Bukkit.getServer().getGlobalRegionScheduler().runDelayed((Plugin)plugin, value -> task.run(), (long)delay);
            }
        } else if (delay == 0) {
            Bukkit.getServer().getScheduler().runTask((Plugin)plugin, task);
        } else {
            Bukkit.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, task, (long)delay);
        }
    }

    public static Object scheduleSyncRepeatingTask(CoreProtect plugin, Runnable task, Object regionData, int delay, int period) {
        if (ConfigHandler.isFolia) {
            if (regionData instanceof Location) {
                Location location = (Location)regionData;
                return Bukkit.getServer().getRegionScheduler().runAtFixedRate((Plugin)plugin, location, value -> task.run(), (long)delay, (long)period);
            }
            if (regionData instanceof Entity) {
                Entity entity = (Entity)regionData;
                return entity.getScheduler().runAtFixedRate((Plugin)plugin, value -> task.run(), task, (long)delay, (long)period);
            }
            return Bukkit.getServer().getGlobalRegionScheduler().runAtFixedRate((Plugin)plugin, value -> task.run(), (long)delay, (long)period);
        }
        return Bukkit.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)plugin, task, (long)delay, (long)period);
    }

    public static void scheduleAsyncDelayedTask(CoreProtect plugin, Runnable task, int delay) {
        if (ConfigHandler.isFolia) {
            if (delay == 0) {
                Bukkit.getServer().getAsyncScheduler().runNow((Plugin)plugin, value -> task.run());
            } else {
                Bukkit.getServer().getAsyncScheduler().runDelayed((Plugin)plugin, value -> task.run(), (long)delay * 50L, TimeUnit.MILLISECONDS);
            }
        } else if (delay == 0) {
            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)plugin, task);
        } else {
            Bukkit.getServer().getScheduler().runTaskLaterAsynchronously((Plugin)plugin, task, (long)delay);
        }
    }

    public static void scheduleSyncDelayedTask(CoreProtect plugin, Runnable task, int delay) {
        Scheduler.scheduleSyncDelayedTask(plugin, task, null, delay);
    }

    public static void runTask(CoreProtect plugin, Runnable task) {
        Scheduler.scheduleSyncDelayedTask(plugin, task, null, 0);
    }

    public static void runTask(CoreProtect plugin, Runnable task, Object regionData) {
        Scheduler.scheduleSyncDelayedTask(plugin, task, regionData, 0);
    }

    public static void runTaskAsynchronously(CoreProtect plugin, Runnable task) {
        Scheduler.scheduleAsyncDelayedTask(plugin, task, 0);
    }

    public static void runTaskLaterAsynchronously(CoreProtect plugin, Runnable task, int delay) {
        Scheduler.scheduleAsyncDelayedTask(plugin, task, delay);
    }

    public static void cancelTask(Object task) {
        if (ConfigHandler.isFolia) {
            if (task instanceof ScheduledTask) {
                ScheduledTask scheduledTask = (ScheduledTask)task;
                scheduledTask.cancel();
            }
        } else if (task instanceof BukkitTask) {
            BukkitTask bukkitTask = (BukkitTask)task;
            bukkitTask.cancel();
        }
    }
}

