/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.worldedit.WorldEditException;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockType;
import net.coreprotect.config.Config;
import net.coreprotect.utility.Util;
import net.coreprotect.worldedit.CoreProtectEditSessionEvent;
import net.coreprotect.worldedit.WorldEditLogger;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class CoreProtectLogger
extends AbstractDelegateExtent {
    private final Actor eventActor;
    private final World eventWorld;
    private final Extent eventExtent;

    protected CoreProtectLogger(Actor actor, World world, Extent extent) {
        super(extent);
        this.eventActor = actor;
        this.eventWorld = world;
        this.eventExtent = extent;
    }

    public <T extends BlockStateHolder<T>> boolean setBlock(BlockVector3 position, T block) throws WorldEditException {
        ItemStack[] containerData;
        org.bukkit.World world = BukkitAdapter.adapt((World)this.eventWorld);
        if (!Config.getConfig((org.bukkit.World)world).WORLDEDIT) {
            return this.eventExtent.setBlock(position, block);
        }
        BlockState oldBlock = this.eventExtent.getBlock(position);
        Material oldType = BukkitAdapter.adapt((BlockType)oldBlock.getBlockType());
        Location location = new Location(world, (double)position.getBlockX(), (double)position.getBlockY(), (double)position.getBlockZ());
        BaseBlock baseBlock = WorldEditLogger.getBaseBlock(this.eventExtent, position, location, oldType, oldBlock);
        ItemStack[] itemStackArray = containerData = CoreProtectEditSessionEvent.isFAWE() ? null : Util.getContainerContents(oldType, null, location);
        if (this.eventExtent.setBlock(position, block)) {
            WorldEditLogger.postProcess(this.eventExtent, this.eventActor, position, location, block, baseBlock, oldType, oldBlock, containerData);
            return true;
        }
        return false;
    }
}

