/*
 * Decompiled with CFR 0.152.
 */
package net.coreprotect.worldedit;

import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.NBTUtils;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.util.Locale;
import java.util.Map;
import net.coreprotect.bukkit.BukkitAdapter;
import net.coreprotect.config.Config;
import net.coreprotect.consumer.Queue;
import net.coreprotect.utility.Util;
import net.coreprotect.worldedit.WorldEditBlockState;
import org.bukkit.DyeColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class WorldEditLogger
extends Queue {
    public static WorldEditPlugin getWorldEdit(Server server) {
        Plugin plugin = server.getPluginManager().getPlugin("WorldEdit");
        if (plugin == null || !(plugin instanceof WorldEditPlugin)) {
            return null;
        }
        return (WorldEditPlugin)plugin;
    }

    protected static BaseBlock getBaseBlock(Extent extent, BlockVector3 position, Location location, Material oldType, com.sk89q.worldedit.world.block.BlockState oldBlock) {
        if (oldType == Material.SPAWNER || Config.getConfig((World)location.getWorld()).SIGN_TEXT && Tag.SIGNS.isTagged((Keyed)oldType)) {
            return extent.getFullBlock(position);
        }
        return null;
    }

    protected static void postProcess(Extent extent, Actor actor, BlockVector3 position, Location location, BlockStateHolder<?> blockStateHolder, BaseBlock baseBlock, Material oldType, com.sk89q.worldedit.world.block.BlockState oldBlockState, ItemStack[] containerContents) {
        BlockData oldBlockData = com.sk89q.worldedit.bukkit.BukkitAdapter.adapt((BlockStateHolder)oldBlockState);
        BlockData newBlockData = com.sk89q.worldedit.bukkit.BukkitAdapter.adapt((BlockStateHolder)blockStateHolder.toImmutableState());
        Material newType = newBlockData.getMaterial();
        String oldBlockDataString = oldBlockData.getAsString();
        String newBlockDataString = newBlockData.getAsString();
        WorldEditBlockState oldBlock = new WorldEditBlockState(location, oldType, oldBlockData);
        WorldEditBlockState newBlock = new WorldEditBlockState(location, newType, newBlockData);
        int oldBlockExtraData = 0;
        int newBlockExtraData = -1;
        if (!oldType.equals((Object)newType) || !oldBlockDataString.equals(newBlockDataString)) {
            Waterlogged waterlogged;
            try {
                if (baseBlock != null && baseBlock.hasNbtData()) {
                    String mobType;
                    if (Config.getConfig((World)location.getWorld()).SIGN_TEXT && Tag.SIGNS.isTagged((Keyed)oldType)) {
                        CompoundTag compoundTag = baseBlock.getNbtData();
                        String line1 = WorldEditLogger.getSignText(compoundTag.getString("Text1"));
                        String line2 = WorldEditLogger.getSignText(compoundTag.getString("Text2"));
                        String line3 = WorldEditLogger.getSignText(compoundTag.getString("Text3"));
                        String line4 = WorldEditLogger.getSignText(compoundTag.getString("Text4"));
                        int color = DyeColor.valueOf((String)baseBlock.getNbtData().getString("Color").toUpperCase()).getColor().asRGB();
                        boolean isGlowing = compoundTag.getInt("GlowingText") == 1;
                        Queue.queueSignText(actor.getName(), location, 0, color, isGlowing, line1, line2, line3, line4, 5);
                    }
                    if (oldType == Material.SPAWNER && (mobType = WorldEditLogger.getMobType(baseBlock)) != null) {
                        try {
                            EntityType entityType = EntityType.valueOf((String)mobType);
                            oldBlockExtraData = Util.getSpawnerType(entityType);
                        }
                        catch (IllegalArgumentException entityType) {
                            // empty catch block
                        }
                    }
                }
                if (containerContents != null) {
                    Queue.queueContainerBreak(actor.getName(), location, oldType, containerContents);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (newType.equals((Object)Material.SKELETON_SKULL) || newType.equals((Object)Material.SKELETON_WALL_SKULL) || newType.equals((Object)Material.WITHER_SKELETON_SKULL) || newType.equals((Object)Material.WITHER_SKELETON_WALL_SKULL) || newType.equals((Object)Material.ZOMBIE_HEAD) || newType.equals((Object)Material.ZOMBIE_WALL_HEAD) || newType.equals((Object)Material.PLAYER_HEAD) || newType.equals((Object)Material.PLAYER_WALL_HEAD) || newType.equals((Object)Material.CREEPER_HEAD) || newType.equals((Object)Material.CREEPER_WALL_HEAD) || newType.equals((Object)Material.DRAGON_HEAD) || newType.equals((Object)Material.DRAGON_WALL_HEAD)) {
                Queue.queueBlockPlaceDelayed(actor.getName(), location, newType, newBlockDataString, oldBlock, 0);
            } else if ((oldType.equals((Object)Material.AIR) || oldType.equals((Object)Material.CAVE_AIR)) && !newType.equals((Object)Material.AIR) && !newType.equals((Object)Material.CAVE_AIR)) {
                Queue.queueBlockPlace(actor.getName(), newBlock, newType, null, newType, newBlockExtraData, 0, newBlockDataString);
            } else if (!(oldType.equals((Object)Material.AIR) || oldType.equals((Object)Material.CAVE_AIR) || newType.equals((Object)Material.AIR) || newType.equals((Object)Material.CAVE_AIR))) {
                waterlogged = Util.checkWaterlogged(newBlockData, oldBlock);
                if (waterlogged != null) {
                    newBlockDataString = waterlogged.getAsString();
                    oldBlock = null;
                }
                if (oldBlock != null) {
                    Queue.queueBlockBreak(actor.getName(), oldBlock, oldBlock.getType(), oldBlockDataString, null, oldBlockExtraData, 0);
                }
                Queue.queueBlockPlace(actor.getName(), newBlock, newType, null, newType, newBlockExtraData, 0, newBlockDataString);
            } else if (!oldType.equals((Object)Material.AIR) && !oldType.equals((Object)Material.CAVE_AIR) && (newType.equals((Object)Material.AIR) || newType.equals((Object)Material.CAVE_AIR))) {
                Queue.queueBlockBreak(actor.getName(), oldBlock, oldBlock.getType(), oldBlockDataString, null, oldBlockExtraData, 0);
                if (oldBlockData instanceof Waterlogged) {
                    waterlogged = (Waterlogged)oldBlockData;
                    if (waterlogged.isWaterlogged()) {
                        Queue.queueBlockPlace(actor.getName(), newBlock, newType, null, Material.WATER, -1, 0, null);
                    }
                } else if (oldBlockData instanceof Bisected) {
                    Bisected bisected = (Bisected)oldBlockData;
                    Location bisectLocation = location.clone();
                    if (bisected.getHalf() == Bisected.Half.TOP) {
                        bisectLocation.setY(bisectLocation.getY() - 1.0);
                    } else {
                        bisectLocation.setY(bisectLocation.getY() + 1.0);
                    }
                    int worldMaxHeight = location.getWorld().getMaxHeight();
                    int worldMinHeight = BukkitAdapter.ADAPTER.getMinHeight(location.getWorld());
                    if (bisectLocation.getBlockY() >= worldMinHeight && bisectLocation.getBlockY() < worldMaxHeight) {
                        BlockState bisectBlock = location.getWorld().getBlockAt(bisectLocation).getState();
                        Queue.queueBlockBreak(actor.getName(), bisectBlock, bisectBlock.getType(), bisectBlock.getBlockData().getAsString(), null, 0, 0);
                    }
                }
            }
        }
    }

    private static String getMobType(BaseBlock fullBlock) {
        String mobType = null;
        try {
            CompoundTag compoundTag = (CompoundTag)NBTUtils.getChildTag((Map)fullBlock.getNbtData().getValue(), (String)"SpawnData", CompoundTag.class);
            mobType = compoundTag.getString("id").toUpperCase(Locale.ROOT);
            if (mobType.contains("MINECRAFT:")) {
                String[] mobTypeSplit = mobType.split(":");
                mobType = mobTypeSplit[1];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mobType;
    }

    private static String getSignText(String line) {
        String result = "";
        if (!line.startsWith("{\"text\":\"")) {
            return line;
        }
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(line);
            return (String)json.get((Object)"text");
        }
        catch (Exception e) {
            e.printStackTrace();
            return result;
        }
    }
}

