/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.AStand;

import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.AStand.ArmorStandManager;
import com.Zrips.CMI.commands.list.armorstand;
import com.Zrips.CMI.utils.CMIEncoder;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.EulerAngle;
import org.bukkit.util.Vector;

public class ArmorStandSave {
    private Player player;
    private ArmorStand stand;
    private Set<ArmorStandManager.armorStandSaveOptions> save = new HashSet<ArmorStandManager.armorStandSaveOptions>();
    private String name = "ArmorStand_" + new Random().nextInt();
    private String serialized = "";
    static String prefix = "{";
    static String suffix = "}";

    ArmorStandSave(Player player, ArmorStand armorStand, Set<ArmorStandManager.armorStandSaveOptions> set) {
        this.player = player;
        this.stand = armorStand;
        this.save = set;
    }

    ArmorStandSave(String string, String string2) {
        this.name = string;
        this.serialized = string2;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public ArmorStand getStand() {
        return this.stand;
    }

    public void setStand(ArmorStand armorStand) {
        this.stand = armorStand;
    }

    public Set<ArmorStandManager.armorStandSaveOptions> getSaveOptions() {
        return this.save;
    }

    private boolean valid(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        return itemStack.getType() != Material.AIR;
    }

    public String serialize() {
        String string;
        Object object;
        if (this.stand == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        if (this.stand.getCustomName() != null && !this.stand.getCustomName().isEmpty()) {
            stringBuilder.append(";n" + prefix);
            stringBuilder.append(this.stand.getCustomName().replace("_", "__").replace(" ", "_"));
            stringBuilder.append(suffix);
        }
        Object object2 = this.getSaveOptions().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            switch (ArmorStandSave.$SWITCH_TABLE$com$Zrips$CMI$Modules$AStand$ArmorStandManager$armorStandSaveOptions()[((Enum)object).ordinal()]) {
                case 6: {
                    if (!this.valid(this.stand.getEquipment().getBoots())) break;
                    stringBuilder.append(";boots" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getBoots()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 2: {
                    if (!this.valid(this.stand.getEquipment().getChestplate())) break;
                    stringBuilder.append(";chest" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getChestplate()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 1: {
                    if (!this.valid(this.stand.getEquipment().getHelmet())) break;
                    stringBuilder.append(";helmet" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getHelmet()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 5: {
                    if (!this.valid(this.stand.getEquipment().getLeggings())) break;
                    stringBuilder.append(";leggings" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getLeggings()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 4: {
                    if (!this.valid(this.stand.getEquipment().getItemInMainHand())) break;
                    stringBuilder.append(";mainhand" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getItemInMainHand()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 3: {
                    if (!this.valid(this.stand.getEquipment().getItemInOffHand())) break;
                    stringBuilder.append(";offhand" + prefix);
                    stringBuilder.append(CMIItemStack.serialize((ItemStack)this.stand.getEquipment().getItemInOffHand()));
                    stringBuilder.append(suffix);
                    break;
                }
                case 14: {
                    if (!this.stand.isGlowing()) break;
                    stringBuilder3.append(",glowing");
                    break;
                }
                case 7: {
                    if (!this.stand.isCustomNameVisible()) break;
                    stringBuilder3.append(",name");
                    break;
                }
                case 13: {
                    if (this.stand.hasGravity()) break;
                    stringBuilder3.append(",nogravity");
                    break;
                }
                case 16: {
                    if (!this.stand.isMarker()) break;
                    stringBuilder3.append(",noneinteractable");
                    break;
                }
                case 15: {
                    if (!this.stand.isInvulnerable()) break;
                    stringBuilder3.append(",invulnerable");
                    break;
                }
                case 12: {
                    if (!this.stand.hasArms()) break;
                    stringBuilder3.append(",arms");
                    break;
                }
                case 9: {
                    if (this.stand.hasBasePlate()) break;
                    stringBuilder3.append(",nobase");
                    break;
                }
                case 10: {
                    if (!this.stand.isSmall()) break;
                    stringBuilder3.append(",small");
                    break;
                }
                case 11: {
                    if (this.stand.isVisible()) break;
                    stringBuilder3.append(",invisible");
                    break;
                }
                case 8: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    string = ArmorStandSave.getAngle(this.stand, (ArmorStandManager.armorStandSaveOptions)((Object)object));
                    if (string.isEmpty()) break;
                    stringBuilder2.append(";" + ((Enum)object).toString() + "{" + string + "}");
                    break;
                }
            }
        }
        object = stringBuilder2.toString();
        if (((String)object).startsWith(";")) {
            object = ((String)object).substring(1);
        }
        if (!((String)object).isEmpty()) {
            object = ";" + (String)object;
        }
        if (((String)(object2 = stringBuilder3.toString())).startsWith(",")) {
            object2 = ((String)object2).substring(1);
        }
        if (!((String)object2).isEmpty()) {
            object2 = ";extra" + prefix + (String)object2 + suffix;
        }
        if ((string = String.valueOf(stringBuilder.toString()) + (String)object + (String)object2).startsWith(";")) {
            string = string.substring(1);
        }
        return string;
    }

    private static String getAngle(ArmorStand armorStand, ArmorStandManager.armorStandSaveOptions armorStandSaveOptions2) {
        EulerAngle eulerAngle = null;
        switch (armorStandSaveOptions2) {
            case head: {
                eulerAngle = armorStand.getHeadPose();
                break;
            }
            case leftArm: {
                eulerAngle = armorStand.getLeftArmPose();
                break;
            }
            case torso: {
                eulerAngle = armorStand.getBodyPose();
                break;
            }
            case leftLeg: {
                eulerAngle = armorStand.getLeftLegPose();
                break;
            }
            case rightArm: {
                eulerAngle = armorStand.getRightArmPose();
                break;
            }
            case rightLeg: {
                eulerAngle = armorStand.getRightLegPose();
                break;
            }
            case body: {
                return String.valueOf(armorStand.getLocation().getYaw());
            }
        }
        if (eulerAngle != null) {
            int n = (int)Math.toDegrees(eulerAngle.getX());
            int n2 = (int)Math.toDegrees(eulerAngle.getY());
            int n3 = (int)Math.toDegrees(eulerAngle.getZ());
            if (n == armorStandSaveOptions2.getDefault().getBlockX() && n2 == armorStandSaveOptions2.getDefault().getBlockY() && n3 == armorStandSaveOptions2.getDefault().getBlockZ()) {
                return "";
            }
            return String.valueOf(n) + ":" + n2 + ":" + n3;
        }
        return "";
    }

    private static EulerAngle getAngle(ArmorStandManager.armorStandSaveOptions armorStandSaveOptions2, String string) {
        try {
            if (!string.contains(":")) {
                return new EulerAngle(Double.parseDouble(string), 0.0, 0.0);
            }
            String[] stringArray = string.split(":");
            if (stringArray.length == 2 && stringArray[0].equalsIgnoreCase("r")) {
                double d = 5.0;
                int n = Integer.parseInt(stringArray[1]);
                Vector vector = armorStandSaveOptions2.getMin();
                Vector vector2 = armorStandSaveOptions2.getMax();
                int n2 = (int)Math.abs(vector.getX() - vector2.getX());
                int n3 = (int)Math.abs(vector.getY() - vector2.getY());
                int n4 = (int)Math.abs(vector.getZ() - vector2.getZ());
                double d2 = (double)n2 / d;
                double d3 = (double)n3 / d;
                double d4 = (double)n4 / d;
                n2 = (int)(d2 * (double)n);
                n3 = (int)(d3 * (double)n);
                n4 = (int)(d4 * (double)n);
                double d5 = (d - (double)n) * (d2 / 2.0);
                double d6 = (d - (double)n) * (d3 / 2.0);
                double d7 = (d - (double)n) * (d4 / 2.0);
                int n5 = new Random().nextInt(n4);
                double d8 = vector.getX() + d5 + (double)new Random().nextInt(n2);
                double d9 = vector.getZ() + d7 + (double)n5;
                return new EulerAngle(Math.toRadians(d8), Math.toRadians(vector.getY() + d6 + (double)new Random().nextInt(n3)), Math.toRadians(d9));
            }
            return new EulerAngle(Math.toRadians(Double.parseDouble(stringArray[0])), Math.toRadians(Double.parseDouble(stringArray[1])), Math.toRadians(Double.parseDouble(stringArray[2])));
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public boolean apply(final ArmorStand armorStand) {
        armorStand.setArms(false);
        String[] stringArray = this.serialized.split(String.valueOf(suffix) + ";");
        int n = 0;
        while (n < stringArray.length) {
            block66: {
                CMIAsyncHead cMIAsyncHead;
                Location location;
                ArmorStandManager.armorStandSaveOptions armorStandSaveOptions2;
                String string;
                block63: {
                    String string2;
                    block64: {
                        string = stringArray[n];
                        if (n == stringArray.length - 1) {
                            string = string.substring(0, string.length() - 1);
                        }
                        string2 = string.split(Pattern.quote(prefix))[0];
                        string = string.substring(string2.length() + 1, string.length());
                        armorStandSaveOptions2 = ArmorStandManager.armorStandSaveOptions.getByName(string2);
                        if (armorStandSaveOptions2 != null) break block63;
                        if (!string2.equalsIgnoreCase("extra")) break block64;
                        location = string.split(",");
                        int n2 = ((String[])location).length;
                        int n3 = 0;
                        while (n3 < n2) {
                            switch (cMIAsyncHead = location[n3]) {
                                case "glowing": {
                                    armorStand.setGlowing(true);
                                    break;
                                }
                                case "name": {
                                    armorStand.setCustomNameVisible(true);
                                    break;
                                }
                                case "nogravity": {
                                    armorStand.setGravity(false);
                                    break;
                                }
                                case "noneinteractable": {
                                    armorStand.setMarker(true);
                                    break;
                                }
                                case "invulnerable": {
                                    armorStand.setInvulnerable(true);
                                    break;
                                }
                                case "arms": {
                                    armorStand.setArms(true);
                                    break;
                                }
                                case "nobase": {
                                    armorStand.setBasePlate(false);
                                    break;
                                }
                                case "small": {
                                    armorStand.setSmall(true);
                                    break;
                                }
                                case "invisible": {
                                    armorStand.setVisible(false);
                                }
                            }
                            ++n3;
                        }
                        break block66;
                    }
                    if (string2.equalsIgnoreCase("n")) {
                        armorStand.setCustomName(CMIChatColor.translate((String)CMIText.replaceUnderScoreSpace((String)string)));
                    }
                    break block66;
                }
                switch (armorStandSaveOptions2) {
                    case mainhand: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setItemInHand(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setItemInHand(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case boots: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setBoots(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setBoots(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case chest: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setChestplate(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setChestplate(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case helmet: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setHelmet(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setHelmet(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case leggings: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setLeggings(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setLeggings(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case offhand: {
                        cMIAsyncHead = new CMIAsyncHead(){

                            public void afterAsyncUpdate(ItemStack itemStack) {
                                if (!armorStand.isDead()) {
                                    armorStand.getEquipment().setItemInOffHand(itemStack);
                                }
                            }
                        };
                        CMIItemStack cMIItemStack = CMIItemStack.deserialize((String)string, (CMIAsyncHead)cMIAsyncHead);
                        if (cMIItemStack != null && cMIItemStack.getItemStack() != null && !cMIAsyncHead.isAsyncHead()) {
                            armorStand.getEquipment().setItemInOffHand(cMIItemStack.getItemStack());
                        }
                        break;
                    }
                    case body: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            location = armorStand.getLocation();
                            location.setYaw((float)eulerAngle.getX());
                            armorStand.teleport(location);
                        }
                        break;
                    }
                    case head: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setHeadPose(eulerAngle);
                        }
                        break;
                    }
                    case rightArm: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setRightArmPose(eulerAngle);
                        }
                        break;
                    }
                    case rightLeg: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setRightLegPose(eulerAngle);
                        }
                        break;
                    }
                    case torso: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setBodyPose(eulerAngle);
                        }
                        break;
                    }
                    case leftArm: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setLeftArmPose(eulerAngle);
                        }
                        break;
                    }
                    case leftLeg: {
                        EulerAngle eulerAngle = ArmorStandSave.getAngle(armorStandSaveOptions2, string);
                        if (eulerAngle != null) {
                            armorStand.setLeftLegPose(eulerAngle);
                        }
                        break;
                    }
                }
            }
            ++n;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getSerialized() {
        return this.serialized;
    }

    public void setSerialized(String string) {
        this.serialized = string;
    }

    public ItemStack createItem() {
        CMIItemStack cMIItemStack = CMIMaterial.ARMOR_STAND.newCMIItemStack();
        cMIItemStack.setDisplayName(CMILC.getIM(armorstand.class, "armorStandItem", "[name]", this.getName()));
        CMINBT cMINBT = new CMINBT(cMIItemStack.getItemStack());
        return (ItemStack)cMINBT.setString("CMISavedArmorStand", CMIEncoder.encode(this.getName().toLowerCase()));
    }
}

