/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.ChatFilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.Chat.ChatFilterBlockType;

public class ChatFilterRule {
    private String replaceWith;
    private ChatFilterBlockType blockType;
    private String ruleName;
    private List<Pattern> pattern = new ArrayList<Pattern>();
    private String messageToStaff;
    private List<String> commands = new ArrayList<String>();
    private String group;
    private boolean informConsole = false;
    private boolean applyToPrivateMessages = true;

    public ChatFilterRule(String string, String string2, List<String> list2, String string3, ChatFilterBlockType chatFilterBlockType, String string4, List<String> list3) {
        this.group = string2;
        this.ruleName = string;
        this.commands = list3;
        this.setPattern(list2);
        this.messageToStaff = string4;
        this.replaceWith = string3;
        this.blockType = chatFilterBlockType;
    }

    public ChatFilterRule(String string, List<String> list2) {
        this.ruleName = string;
        this.setPattern(list2);
        this.blockType = ChatFilterBlockType.None;
    }

    public ChatFilterRule() {
    }

    public List<Pattern> getPattern() {
        return this.pattern;
    }

    public ChatFilterRule setPattern(String string) {
        this.setPattern(Arrays.asList(string));
        return this;
    }

    public void setPattern(List<String> list2) {
        this.pattern.clear();
        for (String string : list2) {
            this.pattern.add(Pattern.compile(string, 64));
        }
    }

    public String getReplaceWith() {
        return this.replaceWith;
    }

    public void setReplaceWith(String string) {
        this.replaceWith = string;
    }

    public ChatFilterBlockType getBlockType() {
        return this.blockType;
    }

    public void setBlockType(ChatFilterBlockType chatFilterBlockType) {
        this.blockType = chatFilterBlockType;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public void setRuleName(String string) {
        this.ruleName = string;
    }

    public Matcher getMatcher(String string) {
        Matcher matcher = null;
        for (Pattern pattern : this.pattern) {
            if (!pattern.matcher(string).find()) continue;
            matcher = pattern.matcher(string);
            break;
        }
        return matcher;
    }

    public String getMessageToStaff() {
        return this.messageToStaff;
    }

    public void setMessageToStaff(String string) {
        this.messageToStaff = string;
    }

    public List<String> getCommands() {
        return this.commands;
    }

    public void setCommands(List<String> list2) {
        this.commands = list2;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public boolean isInformConsole() {
        return this.informConsole;
    }

    public void setInformConsole(boolean bl) {
        this.informConsole = bl;
    }

    public boolean isApplyToPrivateMessages() {
        return this.applyToPrivateMessages;
    }

    public void setApplyToPrivateMessages(boolean bl) {
        this.applyToPrivateMessages = bl;
    }
}

