/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.CmdWarmUp;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class WarmUpListener
implements Listener {
    private CMI plugin;

    public WarmUpListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onCommand(PlayerCommandPreprocessEvent playerCommandPreprocessEvent) {
        if (playerCommandPreprocessEvent.isCancelled()) {
            return;
        }
        Player player = playerCommandPreprocessEvent.getPlayer();
        String string = playerCommandPreprocessEvent.getMessage();
        if (this.plugin.getWarmUpManager().startCmdUsage((CommandSender)player, string)) {
            playerCommandPreprocessEvent.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        if (playerMoveEvent.isCancelled()) {
            return;
        }
        Player player = playerMoveEvent.getPlayer();
        if (!this.plugin.getWarmUpManager().isOnWarmUp(player)) {
            return;
        }
        Location location = playerMoveEvent.getTo();
        Location location2 = playerMoveEvent.getFrom();
        if (this.plugin.getWarmUpManager().canMove(player)) {
            return;
        }
        if ((!location.getWorld().equals(location2.getWorld()) || location.getBlockX() != location2.getBlockX() || location.getBlockY() != location2.getBlockY() || location.getBlockZ() != location2.getBlockZ()) && this.plugin.getWarmUpManager().cancel(player.getUniqueId())) {
            CMILC.info_WarmUp_canceled.sendMessage(player, new Object[0]);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void PlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (!this.plugin.getWarmUpManager().isOnWarmUp(player.getUniqueId())) {
            return;
        }
        this.plugin.getWarmUpManager().cancel(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerDamage(EntityDamageEvent entityDamageEvent) {
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        Player player = (Player)entityDamageEvent.getEntity();
        if (!this.plugin.getWarmUpManager().isOnWarmUp(player)) {
            return;
        }
        if (this.plugin.getWarmUpManager().canMove(player)) {
            return;
        }
        if (this.plugin.getWarmUpManager().cancel(player.getUniqueId())) {
            CMIScheduler.runTaskLater(() -> CMILC.info_WarmUp_canceled.sendMessage(player, new Object[0]), (long)1L);
        }
    }
}

