/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.SavedInv;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.SavedInv.CMIInventory;
import com.Zrips.CMI.Modules.SavedInv.SavedInventories;
import com.Zrips.CMI.commands.CommandsHandler;
import com.Zrips.CMI.commands.list.invcheck;
import com.Zrips.CMI.utils.DateFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.ActionBar.CMIActionBar;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMIText;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.RawMessages.RawMessage;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.io.BukkitObjectInputStream;
import org.bukkit.util.io.BukkitObjectOutputStream;
import org.yaml.snakeyaml.external.biz.base64Coder.Base64Coder;

public class SavedInventoryManager {
    private ConcurrentHashMap<UUID, SavedInventories> map = new ConcurrentHashMap();
    private CMI plugin;
    private boolean restoreHP = true;
    private boolean restoreXP = true;
    private boolean restoreFood = true;
    private boolean restoreSaturation = true;
    private boolean restorePotions = true;
    private boolean restoreItems = true;
    private boolean SaveOnDeath = false;
    private boolean ignoreEmpty = false;
    private boolean SaveOnDeathRequiresPermission = false;
    private int SavedInventorys = 10;
    List<Material> blackListedMaterials = new ArrayList<Material>();

    public SavedInventoryManager(CMI cMI) {
        this.plugin = cMI;
    }

    private SavedInventories getInventories(UUID uUID) {
        return this.map.get(uUID);
    }

    public void addInventory(CMIUser cMIUser, CMIInventory cMIInventory) {
        this.addInventory(cMIUser, cMIInventory, null);
    }

    public void addInventory(CMIUser cMIUser, CMIInventory cMIInventory, Integer n) {
        SavedInventories savedInventories = this.getInventories(cMIUser.getUniqueId());
        if (savedInventories == null) {
            savedInventories = new SavedInventories(cMIUser);
        }
        cMIInventory.setId(n == null ? (cMIInventory.getId() == 0 ? savedInventories.getNextId() : cMIInventory.getId()) : n);
        savedInventories.addInventory(cMIInventory);
        this.checkInvLimit(savedInventories);
        this.map.put(cMIUser.getUniqueId(), savedInventories);
    }

    private void checkInvLimit(SavedInventories savedInventories) {
        block0: while (savedInventories.getInventories().size() > this.SavedInventorys) {
            CMIInventory cMIInventory = this.getFirstInv(savedInventories);
            CMIInventory cMIInventory2 = (CMIInventory)savedInventories.getInventories().remove(cMIInventory.getId());
            if (cMIInventory2 != null) continue;
            Iterator<CMIInventory> iterator = savedInventories.getInventories().values().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().equals(cMIInventory)) continue;
                iterator.remove();
                break block0;
            }
            break block0;
        }
    }

    public CMIInventory getInvById(CMIUser cMIUser, int n) {
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null) {
            return null;
        }
        if (n == -1) {
            return this.getLastInv(cMIUser);
        }
        return savedInventories.getInventories().get(n);
    }

    public CMIInventory getFirstInv(CMIUser cMIUser) {
        return this.getFirstInv(this.getInventories(cMIUser));
    }

    public CMIInventory getFirstInv(SavedInventories savedInventories) {
        if (savedInventories == null) {
            return null;
        }
        Iterator<Map.Entry<Integer, CMIInventory>> iterator = savedInventories.getInventories().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry<Integer, CMIInventory> entry = iterator.next();
            return entry.getValue();
        }
        return null;
    }

    public CMIInventory getLastInv(CMIUser cMIUser) {
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null) {
            return null;
        }
        int n = 0;
        for (Map.Entry<Integer, CMIInventory> entry : savedInventories.getInventories().entrySet()) {
            if (entry.getKey() <= n) continue;
            n = entry.getKey();
        }
        return savedInventories.getInventories().get(n);
    }

    public CMIInventory getNextInv(CMIUser cMIUser, int n) {
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null) {
            return null;
        }
        int n2 = 0;
        boolean bl = false;
        for (Map.Entry<Integer, CMIInventory> entry : savedInventories.getInventories().entrySet()) {
            if (n2 == 0) {
                n2 = entry.getKey();
            }
            if (bl) {
                n = entry.getKey();
                bl = false;
                break;
            }
            if (entry.getKey() != n) continue;
            bl = true;
        }
        if (bl) {
            return savedInventories.getInventories().get(n2);
        }
        return savedInventories.getInventories().get(n);
    }

    public CMIInventory getPrevInv(CMIUser cMIUser, int n) {
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null) {
            return null;
        }
        int n2 = 0;
        for (Map.Entry<Integer, CMIInventory> entry : savedInventories.getInventories().entrySet()) {
            if (entry.getKey() <= n2) continue;
            n2 = entry.getKey();
        }
        int n3 = 0;
        for (Map.Entry<Integer, CMIInventory> entry : savedInventories.getInventories().entrySet()) {
            if ((Integer)entry.getKey() == n) break;
            n3 = (Integer)entry.getKey();
        }
        if (n3 == 0) {
            return savedInventories.getInventories().get(n2);
        }
        return savedInventories.getInventories().get(n3);
    }

    public SavedInventories getInventories(CMIUser cMIUser) {
        SavedInventories savedInventories = this.getInventories(cMIUser.getUniqueId());
        if (savedInventories == null) {
            this.loadInventories(cMIUser);
        }
        return this.getInventories(cMIUser.getUniqueId());
    }

    public void loadInventories(CMIUser cMIUser) {
        if (cMIUser == null) {
            return;
        }
        String string = this.plugin.getDbManager().getDB().getInv(cMIUser);
        if (string == null) {
            return;
        }
        this.loadInventories(cMIUser, string);
    }

    public void loadInventories(CMIUser cMIUser, String string) {
        if (cMIUser == null) {
            return;
        }
        if (string == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.contains(";")) {
            arrayList.addAll(Arrays.asList(string.split(";")));
        } else {
            arrayList.add(string);
        }
        for (String string2 : arrayList) {
            if (string2 == null) continue;
            try {
                HashMap<String, Object> hashMap = SavedInventoryManager.deserialize(string2);
                if (hashMap.isEmpty()) {
                    return;
                }
                CMIInventory cMIInventory = this.generateInvFromMap(hashMap);
                cMIInventory.setOwner(cMIUser.getName());
                cMIInventory.setUuid(cMIUser.getUuid());
                this.addInventory(cMIUser, cMIInventory);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean saveAllInventories(UUID uUID) {
        String string = "";
        SavedInventories savedInventories = this.getInventories(uUID);
        if (savedInventories == null) {
            return false;
        }
        for (Map.Entry<Integer, CMIInventory> object2 : savedInventories.getInventories().entrySet()) {
            if (!string.isEmpty()) {
                string = String.valueOf(string) + ";";
            }
            HashMap<String, Object> hashMap = this.generateMapFromPlayerInv(object2.getValue());
            string = String.valueOf(string) + SavedInventoryManager.serialize(hashMap);
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(uUID);
        this.plugin.getDbManager().addForSave(cMIUser, string);
        return true;
    }

    public CMIInventory saveInv(Player player, Entity entity, EntityDamageEvent.DamageCause damageCause) {
        return this.saveInv(player, entity, damageCause, null);
    }

    public CMIInventory saveInv(Player player, Entity entity, EntityDamageEvent.DamageCause damageCause, Integer n) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return null;
        }
        return this.saveInv(this.generateCMIInventory(player, entity, damageCause), n);
    }

    public CMIInventory saveInv(CMIInventory cMIInventory, Integer n) {
        if (cMIInventory == null) {
            return null;
        }
        if (this.ignoreEmpty && (cMIInventory.getDeathReason() != null || cMIInventory.getKiller() != null) && cMIInventory.getItems().isEmpty()) {
            return null;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(cMIInventory.getUniqueId());
        if (cMIUser == null) {
            return null;
        }
        if (n != null) {
            this.removeInventory(this.plugin.getPlayerManager().getUser(cMIInventory.getUniqueId()), n);
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            this.getInventories(cMIUser);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.addInventory(cMIUser, cMIInventory, n);
                this.saveAllInventories(cMIInventory.getUniqueId());
                cMIInventory.afterSave();
            });
        });
        return cMIInventory;
    }

    public CMIInventory generateCMIInventory(Player player, Entity entity, EntityDamageEvent.DamageCause damageCause) {
        return this.generateCMIInventory(new CMIInventory(player.getName(), player.getUniqueId()), entity, damageCause);
    }

    public CMIInventory generateCMIInventory(CMIInventory cMIInventory, Entity entity, EntityDamageEvent.DamageCause damageCause) {
        CMIUser cMIUser = CMIUser.getUser(cMIInventory.getUniqueId());
        if (cMIUser == null) {
            return null;
        }
        Player player = cMIUser.getPlayer();
        if (player == null) {
            return null;
        }
        long l = System.currentTimeMillis();
        cMIInventory.setTime(l);
        if (entity != null) {
            cMIInventory.setKiller(entity.getName());
        }
        if (damageCause != null) {
            cMIInventory.setDeathReason(this.plugin.getUtilManager().translateDamageCause(damageCause.name()));
        }
        cMIInventory.setExp(cMIUser.getExp());
        cMIInventory.setHealth(player.getHealth());
        cMIInventory.setMaxHealth(player.getMaxHealth());
        cMIInventory.setSaturation(player.getSaturation());
        cMIInventory.setHunger(player.getFoodLevel());
        cMIInventory.setGameMode(player.getGameMode());
        cMIInventory.setFly(player.getAllowFlight());
        cMIInventory.setPotions(player.getActivePotionEffects());
        cMIInventory.setLoc(player.getLocation());
        ItemStack[] itemStackArray = player.getInventory().getContents();
        HashMap<Integer, ItemStack> hashMap = new HashMap<Integer, ItemStack>();
        int n = 0;
        while (n < itemStackArray.length) {
            if (itemStackArray[n] != null && !this.blackListedMaterials.contains(itemStackArray[n].getType())) {
                hashMap.put(n, itemStackArray[n].clone());
            }
            ++n;
        }
        if (Version.isCurrentEqualOrLower((Version)Version.v1_8_R3)) {
            itemStackArray = player.getInventory().getArmorContents();
            n = 0;
            while (n < itemStackArray.length) {
                if (itemStackArray[n] != null && itemStackArray[n].clone().getType() != Material.AIR && !this.blackListedMaterials.contains(itemStackArray[n].getType())) {
                    hashMap.put(n + 36, itemStackArray[n].clone());
                }
                ++n;
            }
        }
        cMIInventory.setItems(hashMap);
        return cMIInventory;
    }

    public CMIInventory generateInvFromMap(HashMap<String, Object> hashMap) {
        Object object;
        CMIInventory cMIInventory = new CMIInventory();
        cMIInventory.setId((Integer)hashMap.get("Id"));
        cMIInventory.setTime((long)((Long)hashMap.get("Time")));
        if (hashMap.containsKey("Killer")) {
            cMIInventory.setKiller((String)hashMap.get("Killer"));
        }
        if (hashMap.containsKey("DeathReason")) {
            cMIInventory.setDeathReason((String)hashMap.get("DeathReason"));
        }
        cMIInventory.setExp((Double)hashMap.get("Exp"));
        cMIInventory.setHealth((Double)hashMap.get("Health"));
        cMIInventory.setMaxHealth((Double)hashMap.get("MaxHealth"));
        cMIInventory.setSaturation(((Float)hashMap.get("Saturation")).floatValue());
        cMIInventory.setHunger((Integer)hashMap.get("Hunger"));
        cMIInventory.setGameMode((GameMode)hashMap.get("GameMode"));
        cMIInventory.setFly((Boolean)hashMap.get("FlyModeOn"));
        ArrayList arrayList = (ArrayList)hashMap.get("Potions");
        cMIInventory.setPotions(arrayList);
        try {
            if (hashMap.containsKey("Location")) {
                object = hashMap.get("Location");
                Location location = null;
                if (object instanceof Location) {
                    location = (Location)hashMap.get("Location");
                } else if (object instanceof String) {
                    CMILocation cMILocation = this.plugin.getPlayerManager().convertStringToLocation((String)object);
                    if (cMILocation.getWorld() == null) {
                        cMILocation.setWorld((World)Bukkit.getWorlds().get(0));
                    }
                    location = cMILocation.clone();
                }
                if (location == null || location.getWorld() == null) {
                    location = new Location((World)Bukkit.getWorlds().get(0), 0.0, 0.0, 0.0, 0.0f, 0.0f);
                }
                cMIInventory.setLoc(location);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = (HashMap)hashMap.get("Items");
        cMIInventory.setItems((HashMap<Integer, ItemStack>)object);
        return cMIInventory;
    }

    public HashMap<String, Object> generateMapFromPlayerInv(CMIInventory cMIInventory) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Id", cMIInventory.getId());
        hashMap.put("Time", cMIInventory.getTime());
        if (cMIInventory.getKiller() != null) {
            hashMap.put("Killer", cMIInventory.getKiller());
        }
        if (cMIInventory.getDeathReason() != null) {
            hashMap.put("DeathReason", cMIInventory.getDeathReason());
        }
        hashMap.put("Exp", cMIInventory.getExp());
        hashMap.put("Health", cMIInventory.getHealth());
        hashMap.put("MaxHealth", cMIInventory.getMaxHealth());
        hashMap.put("Saturation", Float.valueOf(cMIInventory.getSaturation()));
        hashMap.put("Hunger", cMIInventory.getHunger());
        hashMap.put("GameMode", cMIInventory.getGameMode());
        hashMap.put("FlyModeOn", cMIInventory.isFly());
        hashMap.put("Potions", cMIInventory.getPotions());
        hashMap.put("Location", this.plugin.getPlayerManager().convertLocToString(cMIInventory.getLocation()));
        hashMap.put("Items", cMIInventory.getItems());
        return hashMap;
    }

    private static String serialize(HashMap<String, Object> hashMap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            BukkitObjectOutputStream bukkitObjectOutputStream = new BukkitObjectOutputStream((OutputStream)byteArrayOutputStream);
            bukkitObjectOutputStream.writeObject(hashMap);
            bukkitObjectOutputStream.close();
            return Base64Coder.encodeLines((byte[])byteArrayOutputStream.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static HashMap<String, Object> deserialize(String string) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (string == null) {
            return hashMap;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Base64Coder.decodeLines((String)string));
        BukkitObjectInputStream bukkitObjectInputStream = null;
        try {
            try {
                bukkitObjectInputStream = new BukkitObjectInputStream((InputStream)byteArrayInputStream);
                hashMap.putAll((Map)bukkitObjectInputStream.readObject());
            }
            catch (Throwable throwable) {
                try {
                    if (bukkitObjectInputStream != null) {
                        bukkitObjectInputStream.close();
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (bukkitObjectInputStream != null) {
                    bukkitObjectInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return hashMap;
    }

    private void fillFields(CMIGui cMIGui, CMIInventory cMIInventory) {
        Object object;
        Serializable serializable;
        String string;
        int itemStack3;
        long l = cMIInventory.getTime();
        cMIGui.setTitle(ChatColor.DARK_GREEN + DateFormat.MiliToDate(l) + " #" + cMIInventory.getId());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (!cMIInventory.getPotions().isEmpty()) {
            for (PotionEffect itemStack2 : cMIInventory.getPotions()) {
                String n2 = CMIText.firstToUpperCase((String)itemStack2.getType().getName());
                itemStack3 = itemStack2.getAmplifier();
                string = null;
                switch (itemStack2.getAmplifier()) {
                    case 0: {
                        string = "";
                        break;
                    }
                    case 1: {
                        string = " II";
                        break;
                    }
                    default: {
                        string = " " + String.valueOf(itemStack3);
                    }
                }
                serializable = Double.valueOf((double)itemStack2.getDuration() / 20.0);
                object = ChatColor.DARK_GREEN + n2 + string + ChatColor.DARK_AQUA + " Duration: " + serializable + " sec";
                arrayList.add(object);
            }
        } else {
            arrayList.add(CMILC.Potion_NoPotions.getLocale(new Object[0]));
        }
        ItemStack itemStack = CMIMaterial.BLACK_STAINED_GLASS_PANE.newItemStack();
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemMeta.setDisplayName(" ");
        itemStack.setItemMeta(itemMeta);
        object = this.plugin.getPlayerManager().getUser(cMIInventory.getOwner());
        cMIGui.addEmptyButton(6);
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(7), Material.HAY_BLOCK, CMILC.info_InventorySave_LoadForSelf.getLocale(new Object[0])).addCommand("cmi invload " + cMIInventory.getOwner() + " " + cMIInventory.getId()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(8), CMIMaterial.BLUE_WOOL, CMILC.info_InventorySave_LoadForOwner.getLocale(new Object[0])).addCommand("cmi invload " + cMIInventory.getOwner() + " " + cMIInventory.getOwner() + " " + cMIInventory.getId()));
        cMIGui.addEmptyButton(11);
        cMIGui.addEmptyButton(12);
        cMIGui.addEmptyButton(13);
        if (PermissionsManager.CMIPerm.command_invcheck_edit.hasPermission((CommandSender)cMIGui.getPlayer())) {
            if (!cMIInventory.isEditable()) {
                cMIGui.addButton(new CMIGuiButton(Integer.valueOf(14), CMIMaterial.RED_WOOL, CMILC.info_InventorySave_NonEditable.getLocale(new Object[0])).addCommand("cmi invcheck " + cMIInventory.getOwner() + " " + cMIInventory.getId() + " -e"));
            } else {
                cMIGui.addButton(new CMIGuiButton(Integer.valueOf(14), CMIMaterial.BLUE_WOOL, CMILC.info_InventorySave_Editable.getLocale(new Object[0])).addCommand("cmi invcheck " + cMIInventory.getOwner() + " " + cMIInventory.getId()));
            }
        } else {
            cMIGui.addEmptyButton(14);
        }
        cMIGui.addEmptyButton(15);
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(16), CMILib.getInstance().getConfigManager().getGUIPreviousPage()).setName(CMILC.info_InventorySave_PreviousInventory.getLocale(new Object[0])).addCommand("cmi invcheck " + cMIInventory.getOwner() + " " + this.getPrevInv((CMIUser)object, cMIInventory.getId()).getId()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(17), CMILib.getInstance().getConfigManager().getGUINextPage()).setName(CMILC.info_InventorySave_NextInventory.getLocale(new Object[0])).addCommand("cmi invcheck " + cMIInventory.getOwner() + " " + this.getNextInv((CMIUser)object, cMIInventory.getId()).getId()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(10), GUIManager.GUIFieldType.Free, cMIInventory.getBoots()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(9), GUIManager.GUIFieldType.Free, cMIInventory.getChest()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(0), GUIManager.GUIFieldType.Free, cMIInventory.getHelmet()));
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(1), GUIManager.GUIFieldType.Free, cMIInventory.getPants()));
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_9_R1)) {
            cMIGui.addButton(new CMIGuiButton(Integer.valueOf(2), GUIManager.GUIFieldType.Free, cMIInventory.getOffHand()));
        } else {
            cMIGui.addEmptyButton(2);
        }
        int n = 0;
        itemStack3 = 45;
        while (itemStack3 <= 53) {
            cMIGui.addButton(new CMIGuiButton(Integer.valueOf(itemStack3), GUIManager.GUIFieldType.Free, cMIInventory.getItems().get(n)));
            ++n;
            ++itemStack3;
        }
        itemStack3 = 18;
        while (itemStack3 <= 44) {
            cMIGui.addButton(new CMIGuiButton(Integer.valueOf(itemStack3), GUIManager.GUIFieldType.Free, cMIInventory.getItems().get(n)));
            ++n;
            ++itemStack3;
        }
        ItemStack itemStack2 = CMIMaterial.GLASS_BOTTLE.newItemStack();
        string = itemStack2.getItemMeta();
        string.setLore(arrayList);
        string.setDisplayName(ChatColor.GRAY + "Potion effects");
        itemStack2.setItemMeta((ItemMeta)string);
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(3), itemStack2));
        serializable = new ArrayList();
        ItemStack itemStack4 = CMIMaterial.MAP.newItemStack();
        ItemMeta itemMeta2 = itemStack4.getItemMeta();
        if (cMIInventory.getKiller() != null) {
            serializable.add(LC.Location_Killer.getLocale(new Object[]{"[killer]", cMIInventory.getKiller()}));
        }
        if (cMIInventory.getDeathReason() != null) {
            serializable.add(LC.Location_DeathReason.getLocale(new Object[]{"[reason]", cMIInventory.getDeathReason(), "[reasson]", cMIInventory.getDeathReason()}));
        }
        if (cMIInventory.getLocation() != null && cMIInventory.getLocation().getWorld() != null) {
            serializable.add(LC.Location_World.getLocale(new Object[]{"[world]", cMIInventory.getLocation().getWorld().getName()}));
            serializable.add(LC.Location_X.getLocale(new Object[]{"[x]", cMIInventory.getLocation().getBlockX()}));
            serializable.add(LC.Location_Y.getLocale(new Object[]{"[y]", cMIInventory.getLocation().getBlockY()}));
            serializable.add(LC.Location_Z.getLocale(new Object[]{"[z]", cMIInventory.getLocation().getBlockZ()}));
            serializable.add(LC.Location_Pitch.getLocale(new Object[]{"[pitch]", Float.valueOf(cMIInventory.getLocation().getPitch())}));
            serializable.add(LC.Location_Yaw.getLocale(new Object[]{"[yaw]", Float.valueOf(cMIInventory.getLocation().getYaw())}));
        }
        itemMeta2.setLore((List)((Object)serializable));
        itemMeta2.setDisplayName(LC.Location_Title.getLocale(new Object[0]));
        itemStack4.setItemMeta(itemMeta2);
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(4), itemStack4).addCommand(cMIInventory.getLocation()).addPermission("cmi.buttonteleport"));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ItemStack itemStack5 = new ItemStack(Material.BOOK);
        ItemMeta itemMeta3 = itemStack5.getItemMeta();
        arrayList2.add(CMILC.Information_Health.getLocale("[Health]", cMIInventory.getHealth(), "[maxHealth]", cMIInventory.getMaxHealth()));
        arrayList2.add(CMILC.Information_Hunger.getLocale("[Hunger]", cMIInventory.getHunger()));
        arrayList2.add(CMILC.Information_Saturation.getLocale("[Saturation]", Float.valueOf(cMIInventory.getSaturation())));
        arrayList2.add(CMILC.Information_Exp.getLocale("[Exp]", cMIInventory.getExp()));
        arrayList2.add(CMILC.Information_GameMode.getLocale("[GameMode]", cMIInventory.getGameMode()));
        arrayList2.add(CMILC.Information_Flying.getLocale("[Flying]", cMIInventory.isFly()));
        itemMeta3.setLore(arrayList2);
        itemMeta3.setDisplayName(CMILC.Information_Title.getLocale(new Object[0]));
        itemStack5.setItemMeta(itemMeta3);
        cMIGui.addButton(new CMIGuiButton(Integer.valueOf(5), itemStack5));
    }

    public void updateCMIInventoryItems(Inventory inventory, CMIInventory cMIInventory) {
        if (cMIInventory == null) {
            return;
        }
        if (!cMIInventory.isEditable()) {
            return;
        }
        HashMap<Integer, ItemStack> hashMap = cMIInventory.getItems();
        if (inventory == null) {
            return;
        }
        hashMap.put(36, inventory.getItem(10));
        hashMap.put(39, inventory.getItem(0));
        hashMap.put(38, inventory.getItem(9));
        hashMap.put(37, inventory.getItem(1));
        hashMap.put(40, inventory.getItem(2));
        int n = 0;
        int n2 = 45;
        while (n2 <= 53) {
            hashMap.put(n, inventory.getItem(n2));
            ++n;
            ++n2;
        }
        n2 = 18;
        while (n2 <= 44) {
            hashMap.put(n, inventory.getItem(n2));
            ++n;
            ++n2;
        }
        cMIInventory.setItems(hashMap);
    }

    public void openSavedInv(Player player, CMIInventory cMIInventory, boolean bl) {
        if (cMIInventory == null) {
            return;
        }
        CMIGui cMIGui = new CMIGui(player);
        cMIGui.setInvSize(GUIManager.GUIRows.r6);
        cMIGui.setWhatShows((Object)cMIInventory);
        if (bl) {
            cMIGui.addLock(GUIManager.InvType.Gui, GUIManager.GUIFieldType.Locked);
            cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.SavedInv);
            cMIInventory.setEditable(false);
        } else {
            cMIGui.addLock(GUIManager.InvType.Gui, GUIManager.GUIFieldType.Free);
            cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.EditableInv);
            cMIInventory.setEditable(true);
        }
        this.fillFields(cMIGui, cMIInventory);
        CMILib.getInstance().getGUIManager().openGui(cMIGui);
    }

    public void InvList(CommandSender commandSender, Player player) {
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        this.InvList(commandSender, cMIUser);
    }

    public void InvList(CommandSender commandSender, CMIUser cMIUser) {
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null || savedInventories.getInventories().isEmpty()) {
            CMILC.info_InventorySave_NoSavedInv.sendMessage(commandSender, new Object[0]);
            return;
        }
        Snd snd = new Snd().setSender(commandSender).setTarget(cMIUser);
        CMILC.info_InventorySave_TopLine.sendMessage(commandSender, "[name]", cMIUser.getName(), "[playerDisplayName]", cMIUser.getName(), snd);
        for (Map.Entry<Integer, CMIInventory> entry : savedInventories.getInventories().entrySet()) {
            boolean bl = entry.getValue().getKiller() != null || entry.getValue().getDeathReason() != null;
            String string = String.valueOf(CMILC.info_InventorySave_List.getLocale("[id]", entry.getKey(), "[time]", DateFormat.MiliToDate(entry.getValue().getTime()))) + (bl ? CMILC.info_InventorySave_KillerSymbol.getLocale(new Object[0]) : "");
            RawMessage rawMessage = new RawMessage();
            rawMessage.addText(string).addHover(CMILC.info_InventorySave_Click.getLocale("[id]", entry.getKey())).addCommand("/" + CommandsHandler.getLabel() + " " + invcheck.class.getSimpleName() + " " + cMIUser.getName() + " " + entry.getKey());
            rawMessage.show(commandSender);
        }
        LC.info_Spliter.sendMessage((Object)commandSender, new Object[0]);
    }

    public boolean loadInv(CommandSender commandSender, CMIUser cMIUser, CMIInventory cMIInventory) {
        if (cMIInventory == null) {
            CMILC.info_InventorySave_CantFind.sendMessage(commandSender, new Object[0]);
            return false;
        }
        Player player = cMIUser.getPlayer();
        if (this.restorePotions && player.isOnline()) {
            for (PotionEffect object : player.getActivePotionEffects()) {
                if (object == null || object.getType() == null) continue;
                player.removePotionEffect(object.getType());
            }
            for (PotionEffect potionEffect : cMIInventory.getPotions()) {
                if (potionEffect == null) continue;
                player.addPotionEffect(potionEffect);
            }
        }
        if (this.restoreItems) {
            player.getInventory().clear();
            for (Map.Entry entry : cMIInventory.getItems().entrySet()) {
                try {
                    player.getInventory().setItem(((Integer)entry.getKey()).intValue(), (ItemStack)entry.getValue());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (this.restoreXP) {
            player.setTotalExperience(0);
            player.setLevel(0);
            player.setExp(0.0f);
            player.giveExp((int)cMIInventory.getExp());
        }
        if (this.restoreHP) {
            player.setMaxHealth(cMIInventory.getMaxHealth());
            if (cMIInventory.getHealth() > 0.0) {
                player.setHealth(cMIInventory.getHealth());
            } else {
                player.setHealth(1.0);
            }
        }
        if (this.restoreSaturation) {
            player.setSaturation(cMIInventory.getSaturation());
        }
        if (this.restoreFood) {
            player.setFoodLevel(cMIInventory.getHunger());
        }
        if (commandSender != player) {
            CMILC.info_InventorySave_Restored.sendMessage(commandSender, "[sourcename]", cMIInventory.getOwner(), "[targetname]", player.getName());
        }
        this.plugin.save(player);
        if (player.isOnline()) {
            player.updateInventory();
            CMILC.info_InventorySave_GotRestored.sendMessage(player, "[sourcename]", cMIInventory.getOwner(), "[time]", DateFormat.MiliToDate(cMIInventory.getTime()));
        }
        return true;
    }

    public boolean removeInventory(CMIUser cMIUser, int n) {
        if (cMIUser == null) {
            return false;
        }
        SavedInventories savedInventories = this.getInventories(cMIUser);
        if (savedInventories == null) {
            return false;
        }
        if (n == -2) {
            savedInventories.getInventories().clear();
        }
        if (n == -1) {
            CMIInventory cMIInventory = this.getLastInv(cMIUser);
            if (cMIInventory == null) {
                return false;
            }
            this.removeInventory(cMIUser, cMIInventory.getId());
            this.saveAllInventories(cMIUser.getUniqueId());
        } else {
            CMIInventory cMIInventory = (CMIInventory)savedInventories.getInventories().remove(n);
            if (cMIInventory == null) {
                return false;
            }
            this.saveAllInventories(cMIUser.getUniqueId());
        }
        return true;
    }

    public int showTimer(Player player, int n, int n2, int n3, int n4, int n5) {
        String string = "";
        switch (n) {
            case 1: {
                string = "&4-&2----";
                n = 2;
                break;
            }
            case 2: {
                string = "&2-&4-&2---";
                n = 3;
                break;
            }
            case 3: {
                string = "&2--&4-&2--";
                n = 4;
                break;
            }
            case 4: {
                string = "&2---&4-&2-";
                n = 5;
                break;
            }
            case 5: {
                string = "&2----&4-&2";
                n = 1;
            }
        }
        if (player != null) {
            CMIActionBar.send((Player)player, (String)this.plugin.getLM().getMessage("command.saveall.info.saving", "[simbol]", string, "[symbol]", string, "[checked]", n5, "[total]", n3, "[saved]", n2, "[skipped]", n4));
        }
        return n;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("inv.SaveOnDeath", new String[]{"Do you want to save the player's inventory on his death"});
        this.SaveOnDeath = configReader.get("inv.SaveOnDeath", Boolean.valueOf(false));
        configReader.addComment("inv.IgnoreEmpty", new String[]{"When set to true, empty inventories (no items in inventory) will not be saved on players death"});
        this.ignoreEmpty = configReader.get("inv.IgnoreEmpty", Boolean.valueOf(false));
        configReader.addComment("inv.RequiresPermission", new String[]{"If set to true then player should have cmi.saveinv permission node for inventory to be saved on death"});
        this.SaveOnDeathRequiresPermission = configReader.get("inv.RequiresPermission", Boolean.valueOf(false));
        configReader.addComment("inv.SavedInventories", new String[]{"How many inventories, we will keep for each player"});
        this.SavedInventorys = configReader.get("inv.SavedInventories", 5);
        configReader.addComment("inv.restore.HP", new String[]{"Set to false if you don't want to restore hp state on inventory load with /cmi invload command"});
        this.restoreHP = configReader.get("inv.restore.HP", Boolean.valueOf(true));
        configReader.addComment("inv.restore.XP", new String[]{"Set to false if you don't want to restore players experience points"});
        this.restoreXP = configReader.get("inv.restore.XP", Boolean.valueOf(true));
        configReader.addComment("inv.restore.Food", new String[]{"Set to false if you don't want to restore food state"});
        this.restoreFood = configReader.get("inv.restore.Food", Boolean.valueOf(true));
        configReader.addComment("inv.restore.Saturation", new String[]{"Set to false if you don't want to restore saturation level"});
        this.restoreSaturation = configReader.get("inv.restore.Saturation", Boolean.valueOf(true));
        configReader.addComment("inv.restore.Potions", new String[]{"Set to false if you don't want to restore potion effects"});
        this.restorePotions = configReader.get("inv.restore.Potions", Boolean.valueOf(true));
        configReader.addComment("inv.restore.Items", new String[]{"Set to false if you don't want to restore items"});
        this.restoreItems = configReader.get("inv.restore.Items", Boolean.valueOf(true));
        configReader.addComment("inv.restore.BlackListedItems", new String[]{"List of materials we should not save", "Keep in mind that you might need to include all materials for colored items, like wool or shulker boxes"});
        List list2 = configReader.get("inv.restore.BlackListedItems", Arrays.asList(""));
        this.blackListedMaterials.clear();
        for (String string : list2) {
            CMIMaterial cMIMaterial = CMIMaterial.get((String)string);
            if (!cMIMaterial.isValidItem()) continue;
            this.blackListedMaterials.add(cMIMaterial.getMaterial());
        }
    }

    public Boolean isSaveOnDeath() {
        return this.SaveOnDeath;
    }

    public Boolean isSaveOnDeathRequiresPermission() {
        return this.SaveOnDeathRequiresPermission;
    }

    public int getMaxSavedInventorys() {
        return this.SavedInventorys;
    }

    public ConcurrentHashMap<UUID, SavedInventories> getMap() {
        return this.map;
    }

    public void clearAll() {
        this.map.clear();
    }
}

