/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.tp;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.tp.TpInfo;
import com.Zrips.CMI.events.CMIPlayerTeleportRequestEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TpManager {
    private CMI plugin;
    private TreeMap<UUID, Set<TpInfo>> tpRequests = new TreeMap();
    private TreeMap<UUID, Set<TpInfo>> blockedRequests = new TreeMap();
    private boolean SafeLocationDownThenUp;
    private int TeleportInvulnerability = 2;
    private boolean TeleportToSpawnBefore;
    private boolean TeleportSwitchPlaces;
    private boolean TpaCurrentLoc;
    private boolean TpahereCurrentLoc;
    private int TeleportJumpDefault;
    private int TeleportTpaTime;
    private int TeleportTpaWarmup;
    private boolean TeleportTpaMove;
    private int TeleportTpaBlock;
    private boolean TeleportDenyConfirm;
    private int TeleportTpaMaxDistance;
    private int TeleportTpaHereMaxDistance;
    private int TeleportTpBypass;
    private int BackMinDistance = 5;
    private boolean BackWithWE = true;
    private List<String> BackBlackList = new ArrayList<String>();
    private HashMap<TpAction, Boolean> BlackListedItemsEnabledFor = new HashMap();
    private HashMap<Material, Integer> blockedItems = new HashMap();

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Optimizations.Teleport.SafeLocationDownThenUp", new String[]{"Players need to have " + PermissionsManager.CMIPerm.safeteleport.getPermission() + " permision node to be placed in a safe location when teleporting to target location", "When true then while checking for safe location, we will try to determin it going down and if it fails, then up from target location", "When set to false, then first of all location above target location will be checked, then down"});
        this.SafeLocationDownThenUp = configReader.get("Optimizations.Teleport.SafeLocationDownThenUp", Boolean.valueOf(false));
        configReader.addComment("Optimizations.Teleport.Invulnerability", new String[]{"Time in seconds player should be invulnerable after teleporting", "This will prevent player who teleported to damage others for defined time", "Set this to 0 if you want to disable it", "Max 60 seconds"});
        this.TeleportInvulnerability = configReader.get("Optimizations.Teleport.Invulnerability", 5);
        if (this.TeleportInvulnerability > 60) {
            this.TeleportInvulnerability = 60;
        }
        configReader.addComment("Optimizations.Teleport.ToSpawnBefore", new String[]{"When this set to true each time player teleports to any destination he will be teleported to spawn point", "This is to prevent from people knowing to which direction you have teleported too", "As everyone noticed, teleportation doesnt actually teleport you, but moves to targetdestination in short time"});
        this.TeleportToSpawnBefore = configReader.get("Optimizations.Teleport.ToSpawnBefore", Boolean.valueOf(false));
        configReader.addComment("Optimizations.Teleport.SwitchPlaces", new String[]{"Set to true if you want to use tp commands as /cmi tp [WhoYouWantToTeleport] [WhereToTeleport] when its false, its /cmi tp [whereToTeleport] [WhoYouWantToTeleport]"});
        this.TeleportSwitchPlaces = configReader.get("Optimizations.Teleport.SwitchPlaces", Boolean.valueOf(true));
        configReader.addComment("Optimizations.Teleport.CurrentLoc.tpa", new String[]{"Applies for tpa, tpahere and tpaall only", "If set to true then player will be teleported to current player position after accepting teleport request", "If set to false then player will be teleported to player at which teleport request was issued"});
        this.TpaCurrentLoc = configReader.get("Optimizations.Teleport.CurrentLoc.tpa", Boolean.valueOf(true));
        configReader.addComment("Optimizations.Teleport.CurrentLoc.tpahere", new String[]{"Applies for tpahere only"});
        this.TpahereCurrentLoc = configReader.get("Optimizations.Teleport.CurrentLoc.tpahere", Boolean.valueOf(configReader.getC().getBoolean("Optimizations.Teleport.CurrentLoc", true)));
        configReader.addComment("Optimizations.Teleport.JumpDefault", new String[]{"Default distance for jump command. Can be overriden with cmi.command.jump.[amount] permission node"});
        this.TeleportJumpDefault = configReader.get("Optimizations.Teleport.JumpDefault", 50);
        configReader.addComment("Optimizations.Teleport.Tpa.Time", new String[]{"Defines time in seconds for accepting tpa or tpahere requests"});
        this.TeleportTpaTime = configReader.get("Optimizations.Teleport.Tpa.Time", configReader.getC().getInt("Optimizations.Teleport.TpaTime", 60));
        configReader.addComment("Optimizations.Teleport.Tpa.Warmup", new String[]{"Defines time in seconds for player being teleported after tpa or tpahere is being accepted"});
        this.TeleportTpaWarmup = configReader.get("Optimizations.Teleport.Tpa.Warmup", configReader.getC().getInt("Optimizations.Teleport.TpaWarmup", 3));
        configReader.addComment("Optimizations.Teleport.Tpa.Move", new String[]{"Defines if player can move when tpa or tpahere is being accepted"});
        this.TeleportTpaMove = configReader.get("Optimizations.Teleport.Tpa.Move", Boolean.valueOf(configReader.getC().getBoolean("Optimizations.Teleport.TpaMove", false)));
        configReader.addComment("Optimizations.Teleport.Tpa.Block", new String[]{"Defines time in seconds for blocking player teleport offers after denying their request"});
        this.TeleportTpaBlock = configReader.get("Optimizations.Teleport.Tpa.Block", configReader.getC().getInt("Optimizations.Teleport.TpaBlock", 120));
        configReader.addComment("Optimizations.Teleport.Tpa.MaxDistance", new String[]{"Distance in blocks for max teleportation range", "Set to 0 if you want to disable it", "Having it at any positive number will prevent players requesting teleportations to player in other wolds in adition to limiting it by range between players", "Can be bypassed by player having " + PermissionsManager.CMIPerm.command_tpa_max_$1.getPermission("[blockCount]") + " permission node"});
        this.TeleportTpaMaxDistance = configReader.get("Optimizations.Teleport.Tpa.MaxDistance", 0);
        configReader.addComment("Optimizations.Teleport.TpaHere.MaxDistance", new String[]{"Distance in blocks for max teleportation range", "Set to 0 if you want to disable it", "Can be bypassed by player having " + PermissionsManager.CMIPerm.command_tpahere_max_$1.getPermission("[blockCount]") + " permission node"});
        this.TeleportTpaHereMaxDistance = configReader.get("Optimizations.Teleport.TpaHere.MaxDistance", 0);
        configReader.addComment("Optimizations.Teleport.Tp.Bypass", new String[]{"Defines time in seconds for bypassing prevented teleportation to unsafe location"});
        this.TeleportTpBypass = configReader.get("Optimizations.Teleport.Tp.Bypass", configReader.getC().getInt("Optimizations.Teleport.TpBypass", 15));
        configReader.addComment("Optimizations.Teleport.DenyConfirm", new String[]{"When set to true adds accept and deny buttons when sending tpa or tpahere requests"});
        this.TeleportDenyConfirm = configReader.get("Optimizations.Teleport.DenyConfirm", Boolean.valueOf(true));
        configReader.addComment("Optimizations.Teleport.BlackListedItems.Enabled", new String[]{"Option to prevent player teleportation when he has blacklisted items in his inventory. Can be bypassed with cmi.teleport.bypassblacklist"});
        Boolean bl = configReader.get("Optimizations.Teleport.BlackListedItems.Enabled", Boolean.valueOf(false));
        this.BlackListedItemsEnabledFor.put(TpAction.tp, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.tp", Boolean.valueOf(true)));
        this.BlackListedItemsEnabledFor.put(TpAction.tpa, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.tpa", Boolean.valueOf(true)));
        this.BlackListedItemsEnabledFor.put(TpAction.tpahere, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.tpahere", Boolean.valueOf(true)));
        this.BlackListedItemsEnabledFor.put(TpAction.warp, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.warp", Boolean.valueOf(true)));
        this.BlackListedItemsEnabledFor.put(TpAction.home, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.home", Boolean.valueOf(true)));
        this.BlackListedItemsEnabledFor.put(TpAction.spawn, configReader.get("Optimizations.Teleport.BlackListedItems.EnabledFor.spawn", Boolean.valueOf(true)));
        configReader.addComment("Optimizations.Teleport.BlackListedItems.List", new String[]{"Item and amount (if not defined, defaults to 0) we want to protect", "Separate amount with : in example IronOre:5 what will limit ironOre block in players inventory up to 5, more than that and player cant teleport"});
        List list2 = configReader.get("Optimizations.Teleport.BlackListedItems.List", Arrays.asList("Diamond", "DiamondBlock", "DiamondOre", "ironore:5"));
        if (bl.booleanValue()) {
            for (String string : list2) {
                int n;
                Material material;
                block6: {
                    material = CMILib.getInstance().getItemManager().getMaterial(string);
                    if (material == null) continue;
                    n = 0;
                    try {
                        if (!string.contains(":")) break block6;
                        n = Integer.parseInt(string.split(":")[1]);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                this.blockedItems.put(material, n);
            }
        }
        configReader.addComment("Optimizations.Teleport.BackMinDistance", new String[]{"Back location will not be triggered if player teleports closer than defined amount of blocks"});
        this.BackMinDistance = configReader.get("Optimizations.Teleport.BackMinDistance", 5);
        configReader.addComment("Optimizations.Teleport.BackWithWE", new String[]{"When set to false we will not include teleport location when teleporting around with worldedit compass", "When set to true we will include each teleport action, even if you simply jumped around with compass"});
        this.BackWithWE = configReader.get("Optimizations.Teleport.BackWithWE", Boolean.valueOf(true));
        this.BackBlackList.clear();
        configReader.addComment("Optimizations.Teleport.BackBlackList", new String[]{"List of worlds to which players can't return using the /back command"});
        this.BackBlackList = configReader.get("Optimizations.Teleport.BackBlackList", Arrays.asList("TeztWorldz"));
        int n = 0;
        while (n < this.BackBlackList.size()) {
            this.BackBlackList.set(n, this.BackBlackList.get(n).toLowerCase());
            ++n;
        }
    }

    public TpManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void clearRequests(Player player) {
        this.tpRequests.remove(player.getUniqueId());
    }

    private void clearRequests() {
        TreeMap<UUID, Set<TpInfo>> treeMap = new TreeMap<UUID, Set<TpInfo>>((SortedMap<UUID, Set<TpInfo>>)this.tpRequests);
        for (Map.Entry<UUID, Set<TpInfo>> entry : treeMap.entrySet()) {
            HashSet<TpInfo> hashSet = new HashSet<TpInfo>();
            for (TpInfo tpInfo : entry.getValue()) {
                if (tpInfo.getWhen() + (long)(this.TeleportTpaTime * 1000) <= System.currentTimeMillis()) continue;
                hashSet.add(tpInfo);
            }
            this.tpRequests.put(entry.getKey(), hashSet);
        }
    }

    private void clearBlocks() {
        TreeMap<UUID, Set<TpInfo>> treeMap = new TreeMap<UUID, Set<TpInfo>>((SortedMap<UUID, Set<TpInfo>>)this.blockedRequests);
        for (Map.Entry<UUID, Set<TpInfo>> entry : treeMap.entrySet()) {
            HashSet<TpInfo> hashSet = new HashSet<TpInfo>();
            for (TpInfo tpInfo : entry.getValue()) {
                if (tpInfo.getWhen() + (long)(this.TeleportTpaBlock * 1000) <= System.currentTimeMillis()) continue;
                hashSet.add(tpInfo);
            }
            this.blockedRequests.put(entry.getKey(), hashSet);
        }
    }

    public void addTpBlock(Player player, TpInfo tpInfo) {
        Set<TpInfo> set = this.blockedRequests.get(player.getUniqueId());
        if (set == null) {
            set = new HashSet<TpInfo>();
        }
        set.add(tpInfo);
        this.blockedRequests.put(player.getUniqueId(), set);
    }

    public boolean isBlockedRequest(Player player, Player player2, TpAction tpAction) {
        this.clearBlocks();
        Set<TpInfo> set = this.blockedRequests.get(player2.getUniqueId());
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (TpInfo tpInfo : set) {
            if (tpInfo.getAction() != tpAction || !tpInfo.getWhoAccepts().getUniqueId().equals(player2.getUniqueId()) || !tpInfo.getWhoOffers().getUniqueId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    public long getBlockTime(Player player, Player player2, TpAction tpAction) {
        this.clearRequests();
        Set<TpInfo> set = this.blockedRequests.get(player2.getUniqueId());
        if (set == null || set.isEmpty()) {
            return 0L;
        }
        for (TpInfo tpInfo : set) {
            if (tpInfo.getAction() != tpAction || !tpInfo.getWhoAccepts().getUniqueId().equals(player2.getUniqueId()) || !tpInfo.getWhoOffers().getUniqueId().equals(player.getUniqueId())) continue;
            long l = tpInfo.getWhen() + (long)(this.TeleportTpaBlock * 1000) + 1500L;
            return l - System.currentTimeMillis();
        }
        return 0L;
    }

    public boolean addTpRequest(Player player, Player player2, TpAction tpAction) {
        return this.addTpRequest(player, player2, tpAction, true);
    }

    public boolean addTpRequest(Player player, Player player2, TpAction tpAction, boolean bl) {
        CMIPlayerTeleportRequestEvent cMIPlayerTeleportRequestEvent = new CMIPlayerTeleportRequestEvent(player, player2, tpAction);
        Bukkit.getServer().getPluginManager().callEvent((Event)cMIPlayerTeleportRequestEvent);
        if (cMIPlayerTeleportRequestEvent.isCancelled()) {
            return false;
        }
        Set<TpInfo> set = this.tpRequests.get(player.getUniqueId());
        TpInfo tpInfo = new TpInfo(player, player2, tpAction);
        if (set == null) {
            set = new HashSet<TpInfo>();
        }
        if (!bl) {
            switch (tpAction) {
                case home: {
                    break;
                }
                case spawn: {
                    break;
                }
                case tp: {
                    break;
                }
                case tpa: {
                    if (this.isTpaCurrentLoc()) break;
                    tpInfo.setLoc(player2.getLocation());
                    break;
                }
                case tpaall: {
                    if (this.isTpaCurrentLoc()) break;
                    tpInfo.setLoc(player2.getLocation());
                    break;
                }
                case tpahere: {
                    if (this.isTpahereCurrentLoc()) break;
                    tpInfo.setLoc(player.getLocation());
                    break;
                }
                case warp: {
                    break;
                }
            }
        }
        set.add(tpInfo);
        this.tpRequests.put(player.getUniqueId(), set);
        return true;
    }

    public boolean removeTpRequest(Player player, Player player2) {
        Set<TpInfo> set = this.tpRequests.get(player.getUniqueId());
        if (set == null) {
            return true;
        }
        for (TpInfo tpInfo : new HashSet<TpInfo>(set)) {
            if (!tpInfo.getWhoAccepts().equals(player2)) continue;
            set.remove(tpInfo);
            return true;
        }
        return false;
    }

    public boolean isAlreadyInRequest(Player player, Player player2, TpAction tpAction) {
        this.clearRequests();
        Set<TpInfo> set = this.tpRequests.get(player.getUniqueId());
        if (set == null || set.isEmpty()) {
            return false;
        }
        for (TpInfo tpInfo : set) {
            if (tpInfo.getAction() != tpAction || !tpInfo.getWhoAccepts().getUniqueId().equals(player2.getUniqueId()) || !tpInfo.getWhoOffers().getUniqueId().equals(player.getUniqueId())) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public TpInfo getTeleportInfo(Player player, Player player2) {
        return this.getTeleportInfo(player, player2, null);
    }

    public TpInfo getTeleportInfo(Player player, Player player2, TpAction tpAction) {
        this.clearRequests();
        TpInfo tpInfo = null;
        if (player2 != null) {
            if (!player2.isOnline()) {
                return null;
            }
            Set<TpInfo> set = this.tpRequests.get(player2.getUniqueId());
            if (set == null) {
                return null;
            }
            for (TpInfo tpInfo2 : set) {
                if (tpInfo2 == null || tpAction != null && !tpInfo2.getAction().equals((Object)tpAction) || !tpInfo2.getWhoAccepts().getUniqueId().equals(player.getUniqueId()) || !tpInfo2.getWhoOffers().getUniqueId().equals(player2.getUniqueId())) continue;
                set.remove(tpInfo2);
                this.tpRequests.put(player2.getUniqueId(), set);
                return tpInfo2;
            }
        }
        long l = 0L;
        for (Map.Entry<UUID, Set<TpInfo>> entry : this.tpRequests.entrySet()) {
            Set<TpInfo> set = entry.getValue();
            for (TpInfo tpInfo3 : set) {
                if (!tpInfo3.getWhoAccepts().getUniqueId().equals(player.getUniqueId()) || tpInfo3.getWhen() < l || tpAction != null && !tpAction.equals((Object)tpInfo3.getAction())) continue;
                l = tpInfo3.getWhen();
                tpInfo = tpInfo3;
            }
        }
        if (tpInfo != null) {
            this.tpRequests.remove(tpInfo.getWhoOffers().getUniqueId());
        }
        return tpInfo;
    }

    public TreeMap<UUID, Set<TpInfo>> getTeleportRequests() {
        return this.tpRequests;
    }

    public Set<TpInfo> getTeleportRequests(UUID uUID) {
        return this.tpRequests.get(uUID);
    }

    public TreeMap<UUID, Set<TpInfo>> getBlockedRequests() {
        return this.blockedRequests;
    }

    public Set<TpInfo> getBlockedRequests(UUID uUID) {
        return this.blockedRequests.get(uUID);
    }

    public HashMap<Material, Integer> getBlockedItems() {
        return this.blockedItems;
    }

    public Boolean isBlackListedItemsEnabledFor(TpAction tpAction) {
        if (!this.BlackListedItemsEnabledFor.containsKey((Object)tpAction)) {
            return false;
        }
        return this.BlackListedItemsEnabledFor.get((Object)tpAction);
    }

    public boolean isSwitchTeleportPlaces() {
        return this.TeleportSwitchPlaces;
    }

    public int getTpaWarmupTime() {
        return this.TeleportTpaWarmup;
    }

    public boolean isTpaMove() {
        return this.TeleportTpaMove;
    }

    public boolean isTpaCurrentLoc() {
        return this.TpaCurrentLoc;
    }

    public boolean isTpahereCurrentLoc() {
        return this.TpahereCurrentLoc;
    }

    public int getJumpDefaultDistance() {
        return this.TeleportJumpDefault;
    }

    public int getBackMinDistance() {
        return this.BackMinDistance;
    }

    public boolean isSafeLocationDownThenUp() {
        return this.SafeLocationDownThenUp;
    }

    public void setSafeLocationDownThenUp(boolean bl) {
        this.SafeLocationDownThenUp = bl;
    }

    public List<String> getBackBlackList() {
        return this.BackBlackList;
    }

    public int getTpaMaxDistance() {
        return this.TeleportTpaMaxDistance;
    }

    public int getTpaHereMaxDistance() {
        return this.TeleportTpaHereMaxDistance;
    }

    public int getInvulnerabilityTime() {
        return this.TeleportInvulnerability;
    }

    public boolean isToSpawnBeforeTeleporting() {
        return this.TeleportToSpawnBefore;
    }

    public boolean isDenyConfirm() {
        return this.TeleportDenyConfirm;
    }

    public int getTpBypassTime() {
        return this.TeleportTpBypass;
    }

    public boolean isBackWithWE() {
        return this.BackWithWE;
    }

    public int getTpaTime() {
        return this.TeleportTpaTime;
    }

    public static enum TpAction {
        tpa,
        tpahere,
        tpaall,
        tp,
        warp,
        home,
        spawn;


        public static TpAction get(String string) {
            TpAction[] tpActionArray = TpAction.values();
            int n = tpActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                TpAction tpAction = tpActionArray[n2];
                if (tpAction.toString().equalsIgnoreCase(string)) {
                    return tpAction;
                }
                ++n2;
            }
            return null;
        }
    }
}

