/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.NBT;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIHitBox;
import com.Zrips.CMI.Containers.CMIPlayerInventory;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Holograms.CMIDataWatcher;
import com.Zrips.CMI.Modules.Holograms.CMIHoloLineType;
import com.Zrips.CMI.Modules.Holograms.CMIHologram;
import com.Zrips.CMI.Modules.Packets.FakeInfo;
import com.Zrips.CMI.Modules.Packets.PacketHandler;
import com.Zrips.CMI.NBT.NMS;
import com.Zrips.CMI.utils.Util;
import com.mojang.authlib.GameProfile;
import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.minecraft.server.v1_9_R2.AxisAlignedBB;
import net.minecraft.server.v1_9_R2.Block;
import net.minecraft.server.v1_9_R2.BlockPosition;
import net.minecraft.server.v1_9_R2.EntityArmorStand;
import net.minecraft.server.v1_9_R2.EntityHuman;
import net.minecraft.server.v1_9_R2.EntityLiving;
import net.minecraft.server.v1_9_R2.EntityPlayer;
import net.minecraft.server.v1_9_R2.EnumItemSlot;
import net.minecraft.server.v1_9_R2.EnumParticle;
import net.minecraft.server.v1_9_R2.EnumProtocolDirection;
import net.minecraft.server.v1_9_R2.IBlockData;
import net.minecraft.server.v1_9_R2.ItemStack;
import net.minecraft.server.v1_9_R2.MinecraftServer;
import net.minecraft.server.v1_9_R2.MovingObjectPosition;
import net.minecraft.server.v1_9_R2.NBTBase;
import net.minecraft.server.v1_9_R2.NBTCompressedStreamTools;
import net.minecraft.server.v1_9_R2.NBTTagCompound;
import net.minecraft.server.v1_9_R2.NBTTagDouble;
import net.minecraft.server.v1_9_R2.NBTTagFloat;
import net.minecraft.server.v1_9_R2.NBTTagList;
import net.minecraft.server.v1_9_R2.NBTTagString;
import net.minecraft.server.v1_9_R2.NetworkManager;
import net.minecraft.server.v1_9_R2.Packet;
import net.minecraft.server.v1_9_R2.PacketPlayOutAbilities;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_9_R2.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_9_R2.PacketPlayOutMapChunk;
import net.minecraft.server.v1_9_R2.PacketPlayOutMount;
import net.minecraft.server.v1_9_R2.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_9_R2.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_9_R2.PacketPlayOutPosition;
import net.minecraft.server.v1_9_R2.PacketPlayOutRespawn;
import net.minecraft.server.v1_9_R2.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_9_R2.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_9_R2.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_9_R2.PacketPlayOutWorldParticles;
import net.minecraft.server.v1_9_R2.PlayerAbilities;
import net.minecraft.server.v1_9_R2.PlayerConnection;
import net.minecraft.server.v1_9_R2.PlayerInteractManager;
import net.minecraft.server.v1_9_R2.Vec3D;
import net.minecraft.server.v1_9_R2.Vector3f;
import net.minecraft.server.v1_9_R2.World;
import net.minecraft.server.v1_9_R2.WorldServer;
import net.minecraft.server.v1_9_R2.WorldSettings;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_9_R2.CraftChunk;
import org.bukkit.craftbukkit.v1_9_R2.CraftServer;
import org.bukkit.craftbukkit.v1_9_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_9_R2.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_9_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_9_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class v1_9_R2
implements NMS {
    @Override
    public synchronized Player getPlayer(CMIUser cMIUser) {
        try {
            GameProfile gameProfile = new GameProfile(cMIUser.getUniqueId(), cMIUser.getName());
            MinecraftServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            EntityPlayer entityPlayer = new EntityPlayer(minecraftServer, minecraftServer.getWorldServer(0), gameProfile, new PlayerInteractManager((World)minecraftServer.getWorldServer(0)));
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            if (craftPlayer != null) {
                craftPlayer.loadData();
                return craftPlayer;
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized Player createFakeOperator() {
        try {
            GameProfile gameProfile = new GameProfile(CMI.getInstance().getPlayerManager().getFakeUserUUID(), CMI.getInstance().getPlayerManager().getFakeUserName());
            MinecraftServer minecraftServer = ((CraftServer)Bukkit.getServer()).getServer();
            EntityPlayer entityPlayer = new EntityPlayer(minecraftServer, minecraftServer.getWorldServer(0), gameProfile, new PlayerInteractManager((World)minecraftServer.getWorldServer(0)));
            entityPlayer.playerConnection = new PlayerConnection(minecraftServer, new NetworkManager(EnumProtocolDirection.SERVERBOUND), entityPlayer);
            entityPlayer.playerConnection.networkManager.l = new InetSocketAddress("127.0.0.1", 25566);
            CraftPlayer craftPlayer = entityPlayer.getBukkitEntity();
            craftPlayer.setOp(true);
            return craftPlayer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void unloadData(Player player) {
    }

    public NBTTagCompound getNBTTagC(File file) {
        NBTTagCompound nBTTagCompound;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return nBTTagCompound;
    }

    public NBTTagCompound getNBTTagC(Player player) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(player);
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public String getWorldName(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return null;
        }
        UUID uUID = new UUID(v1_9_R2.getUUIDWorldMost(nBTTagCompound), v1_9_R2.getUUIDWorldLeast(nBTTagCompound));
        return CMI.getInstance().getUtilManager().getWorldName(uUID);
    }

    public Location getMiscLocation(NBTTagCompound nBTTagCompound) {
        org.bukkit.World world2 = v1_9_R2.getLocationWorld(nBTTagCompound);
        double[] dArray = this.getLocationPosition(nBTTagCompound);
        Float[] floatArray = this.getLocationView(nBTTagCompound);
        Location location = new Location(world2, dArray[0], dArray[1], dArray[2]);
        location.setPitch(floatArray[0].floatValue());
        location.setYaw(floatArray[1].floatValue());
        return location;
    }

    public double[] getLocationPosition(NBTTagCompound nBTTagCompound) {
        double[] dArray = new double[3];
        NBTTagList nBTTagList = nBTTagCompound.getList("Pos", 6);
        dArray[0] = nBTTagList.e(0);
        dArray[1] = nBTTagList.e(1);
        dArray[2] = nBTTagList.e(2);
        return dArray;
    }

    public Float[] getLocationView(NBTTagCompound nBTTagCompound) {
        Float[] floatArray = new Float[2];
        NBTTagList nBTTagList = nBTTagCompound.getList("Rotation", 5);
        floatArray[0] = Float.valueOf(nBTTagList.f(0));
        floatArray[1] = Float.valueOf(nBTTagList.f(1));
        return floatArray;
    }

    @Override
    public void setMiscLocation(File file, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        v1_9_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setMiscLocation(Player player, Location location) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(player);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound = this.setMiscLocation(location, nBTTagCompound);
        this.saveData(nBTTagCompound, player);
    }

    private static NBTTagCompound setDimension(NBTTagCompound nBTTagCompound, int n) {
        nBTTagCompound.setInt("Dimension", n);
        return nBTTagCompound;
    }

    private static NBTTagCompound setLocationWorld(NBTTagCompound nBTTagCompound, long l, long l2) {
        nBTTagCompound = v1_9_R2.setUUIDWorldLeast(nBTTagCompound, l);
        nBTTagCompound = v1_9_R2.setUUIDWorldMost(nBTTagCompound, l2);
        return nBTTagCompound;
    }

    private static NBTTagCompound setUUIDWorldLeast(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDLeast", l);
        return nBTTagCompound;
    }

    public static String getName(NBTTagCompound nBTTagCompound) {
        NBTTagCompound nBTTagCompound2 = nBTTagCompound.getCompound("bukkit");
        String string = nBTTagCompound2.getString("lastKnownName");
        return string;
    }

    private static NBTTagCompound setUUIDWorldMost(NBTTagCompound nBTTagCompound, long l) {
        nBTTagCompound.setLong("WorldUUIDMost", l);
        return nBTTagCompound;
    }

    public static org.bukkit.World getLocationWorld(NBTTagCompound nBTTagCompound) {
        return Bukkit.getWorld((UUID)new UUID(v1_9_R2.getUUIDWorldMost(nBTTagCompound), v1_9_R2.getUUIDWorldLeast(nBTTagCompound)));
    }

    private static long getUUIDWorldMost(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDMost");
    }

    private static long getUUIDWorldLeast(NBTTagCompound nBTTagCompound) {
        return nBTTagCompound.getLong("WorldUUIDLeast");
    }

    public NBTTagCompound setMiscLocation(Location location, NBTTagCompound nBTTagCompound) {
        nBTTagCompound = v1_9_R2.setLocationWorld(nBTTagCompound, location.getWorld().getUID().getLeastSignificantBits(), location.getWorld().getUID().getMostSignificantBits());
        nBTTagCompound = v1_9_R2.setDimension(nBTTagCompound, location.getWorld().getEnvironment().getId());
        nBTTagCompound = v1_9_R2.setLocationPosition(nBTTagCompound, location.getX(), location.getY(), location.getZ());
        nBTTagCompound = v1_9_R2.setLocationView(nBTTagCompound, location.getYaw(), location.getPitch());
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationPosition(NBTTagCompound nBTTagCompound, double d, double d2, double d3) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((NBTBase)new NBTTagDouble(d));
        nBTTagList.add((NBTBase)new NBTTagDouble(d2));
        nBTTagList.add((NBTBase)new NBTTagDouble(d3));
        nBTTagCompound.set("Pos", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static NBTTagCompound setLocationView(NBTTagCompound nBTTagCompound, float f, float f2) {
        NBTTagList nBTTagList = new NBTTagList();
        nBTTagList.add((NBTBase)new NBTTagFloat(f));
        nBTTagList.add((NBTBase)new NBTTagFloat(f2));
        nBTTagCompound.set("Rotation", (NBTBase)nBTTagList);
        return nBTTagCompound;
    }

    public static void saveData(NBTTagCompound nBTTagCompound, File file) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveData(NBTTagCompound nBTTagCompound, Player player) {
        if (nBTTagCompound != null) {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(Util.getFile(player));
                NBTCompressedStreamTools.a((NBTTagCompound)nBTTagCompound, (OutputStream)fileOutputStream);
                fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public NBTTagCompound resetMaxHp(NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound == null) {
            return null;
        }
        NBTTagList nBTTagList = nBTTagCompound.getList("Attributes", 10);
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.get(n);
            if (nBTTagCompound2.hasKey("Modifiers") && nBTTagCompound2.getString("Name").equalsIgnoreCase("generic.maxHealth")) {
                nBTTagCompound2.remove("Modifiers");
            }
            ++n;
        }
        return nBTTagCompound;
    }

    @Override
    public void clearPotionEffects(Player player) {
        File file = Util.getFile(player);
        this.clearPotionEffects(file);
    }

    public void clearPotionEffects(File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        nBTTagCompound.remove("ActiveEffects");
        v1_9_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public void setPotionEffects(Player player, PotionEffect potionEffect) {
        File file = Util.getFile(player);
        this.setPotionEffects(potionEffect, file);
    }

    public void setPotionEffects(PotionEffect potionEffect, File file) {
        NBTTagCompound nBTTagCompound = this.getNBTTagC(file);
        if (nBTTagCompound == null) {
            return;
        }
        NBTTagList nBTTagList = nBTTagCompound.getList("ActiveEffects", 10);
        boolean bl = false;
        int n = 0;
        while (n < nBTTagList.size()) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.get(n);
            if (nBTTagCompound2.getByte("Id") == potionEffect.getType().getId()) {
                bl = true;
                nBTTagCompound2.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
                nBTTagCompound2.setByte("Amplifier", (byte)potionEffect.getAmplifier());
                nBTTagCompound2.setInt("Duration", potionEffect.getDuration());
                nBTTagCompound2.setByte("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
                nBTTagList.a(n, (NBTBase)nBTTagCompound2);
                break;
            }
            ++n;
        }
        if (!bl) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            nBTTagCompound3.setByte("Ambient", (byte)(potionEffect.isAmbient() ? 1 : 0));
            nBTTagCompound3.setByte("Amplifier", (byte)potionEffect.getAmplifier());
            nBTTagCompound3.setInt("Duration", potionEffect.getDuration());
            nBTTagCompound3.setByte("Id", (byte)potionEffect.getType().getId());
            nBTTagCompound3.setByte("ShowParticles", (byte)(potionEffect.hasParticles() ? 1 : 0));
            nBTTagList.add((NBTBase)nBTTagCompound3);
        }
        v1_9_R2.saveData(nBTTagCompound, file);
    }

    @Override
    public boolean changeGodMode(Player player, boolean bl) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        try {
            PlayerAbilities playerAbilities = entityPlayer.abilities;
            Field field = playerAbilities.getClass().getDeclaredField("isInvulnerable");
            field.setAccessible(true);
            field.setBoolean(playerAbilities, bl);
            return true;
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException exception) {
            return false;
        }
    }

    @Override
    public boolean getGodMode(Player player) {
        return player.isInvulnerable();
    }

    @Override
    public void relightChunk(Chunk chunk) {
        ((CraftChunk)chunk).getHandle().initLighting();
        org.bukkit.World world2 = chunk.getWorld();
        CraftWorld craftWorld = (CraftWorld)world2;
        WorldServer worldServer = craftWorld.getHandle();
        int n = chunk.getX() * 16;
        int n2 = chunk.getZ() * 16;
        int n3 = n;
        while (n3 <= n + 16) {
            int n4 = n2;
            while (n4 <= n2 + 16) {
                int n5 = world2.getHighestBlockYAt(n3, n4);
                int n6 = 0;
                while (n6 <= n5) {
                    worldServer.w(new BlockPosition(n3, n6, n4));
                    ++n6;
                }
                ++n4;
            }
            ++n3;
        }
    }

    @Override
    public void resendChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 65535));
    }

    @Override
    public void unloadChunk(Chunk chunk, Player player) {
        ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutMapChunk(((CraftChunk)chunk).getHandle(), 0));
    }

    @Override
    public void updateCollisions(Player player, boolean bl, boolean bl2) {
    }

    @Override
    public Inventory getShulkerInv(org.bukkit.inventory.ItemStack itemStack) {
        return null;
    }

    @Override
    public Inventory getShulkerInv(org.bukkit.block.Block block) {
        return null;
    }

    @Override
    public int getTickLived(UUID uUID) {
        if (uUID == null) {
            return 0;
        }
        NBTTagCompound nBTTagCompound = this.getNBTTagC(uUID);
        if (nBTTagCompound == null) {
            return 0;
        }
        if (!nBTTagCompound.hasKey("Spigot.ticksLived")) {
            return 0;
        }
        return nBTTagCompound.getInt("Spigot.ticksLived");
    }

    public NBTTagCompound getNBTTagC(UUID uUID) {
        NBTTagCompound nBTTagCompound;
        File file = Util.getFile(uUID);
        if (!file.exists()) {
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            nBTTagCompound = NBTCompressedStreamTools.a((InputStream)fileInputStream);
            fileInputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return nBTTagCompound;
    }

    @Override
    public void showResurection(Player player) {
    }

    @Override
    public void setEntityTag(Entity entity, String string, Object object) {
    }

    @Override
    public org.bukkit.inventory.ItemStack removeEnchantNbt(org.bukkit.inventory.ItemStack itemStack, Enchantment enchantment) {
        ItemStack itemStack2 = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (itemStack2 == null) {
            return null;
        }
        try {
            int n = (Integer)enchantment.getClass().getMethod("getId", new Class[0]).invoke((Object)enchantment, new Object[0]);
            NBTTagCompound nBTTagCompound = itemStack2.getTag();
            boolean bl = false;
            if (nBTTagCompound != null && nBTTagCompound.hasKey("ench")) {
                NBTTagList nBTTagList = nBTTagCompound.getList("ench", 10);
                int n2 = 0;
                while (n2 < nBTTagList.size()) {
                    if (nBTTagList.get(n2).getShort("id") == n) {
                        nBTTagList.remove(n2);
                        bl = true;
                        break;
                    }
                    ++n2;
                }
                if (bl) {
                    nBTTagCompound.set("ench", (NBTBase)nBTTagList);
                }
                itemStack2.setTag(nBTTagCompound);
            }
            if (bl) {
                return CraftItemStack.asBukkitCopy((ItemStack)itemStack2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public org.bukkit.inventory.ItemStack setNBTList(org.bukkit.inventory.ItemStack itemStack, String string, List<String> list2) {
        ItemStack itemStack2 = CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack);
        if (itemStack2 == null) {
            return itemStack;
        }
        try {
            NBTTagCompound nBTTagCompound = itemStack2.getTag();
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            NBTTagList nBTTagList = new NBTTagList();
            if (list2 != null) {
                for (String string2 : list2) {
                    nBTTagList.add((NBTBase)new NBTTagString(string2));
                }
            }
            if (list2 == null) {
                nBTTagCompound.remove(string);
            } else {
                nBTTagCompound.set(string, (NBTBase)nBTTagList);
            }
            itemStack2.setTag(nBTTagCompound);
            return CraftItemStack.asBukkitCopy((ItemStack)itemStack2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return itemStack;
        }
    }

    @Override
    public void updateExpBar(Player player) {
        CraftPlayer craftPlayer = (CraftPlayer)player;
        craftPlayer.getHandle().lastSentExp = -1;
    }

    @Override
    public Command getCommand(String string) {
        return ((CraftServer)Bukkit.getServer()).getCommandMap().getCommand(string);
    }

    private static EntityArmorStand createStand(Location location, String string, boolean bl) {
        double d = location.getX();
        double d2 = location.getZ();
        if (bl) {
            d += 0.35;
            d2 -= 0.1;
        }
        EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), d, location.getY() - 0.45, d2);
        entityArmorStand.setInvisible(true);
        entityArmorStand.setArms(false);
        entityArmorStand.setMarker(true);
        entityArmorStand.setBasePlate(false);
        entityArmorStand.setSmall(bl);
        entityArmorStand.setGravity(false);
        if (bl) {
            entityArmorStand.setRightArmPose(new Vector3f(-15.0f, 45.0f, 0.0f));
        }
        if (string != null && !string.isEmpty()) {
            entityArmorStand.setCustomName(CMIChatColor.translate((String)string));
            if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
                entityArmorStand.setCustomNameVisible(false);
            } else {
                entityArmorStand.setCustomNameVisible(true);
            }
        } else {
            entityArmorStand.setCustomNameVisible(false);
        }
        return entityArmorStand;
    }

    @Override
    public CMIDataWatcher spawnHologram(Player player, Location location, String string, org.bukkit.inventory.ItemStack itemStack) {
        EntityArmorStand entityArmorStand = v1_9_R2.createStand(location, string, itemStack != null);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutSpawnEntity((net.minecraft.server.v1_9_R2.Entity)entityArmorStand, 78));
            try {
                craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityMetadata(entityArmorStand.getId(), entityArmorStand.getDataWatcher(), false));
                if (itemStack != null) {
                    PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(entityArmorStand.getId(), EnumItemSlot.MAINHAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack));
                    craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment);
                }
                return new CMIDataWatcher(entityArmorStand.getId(), entityArmorStand, itemStack != null ? CMIHoloLineType.staticIcon : CMIHoloLineType.plainText);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public void removeHologram(Player player, Integer n) {
        if (n == null) {
            return;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)new PacketPlayOutEntityDestroy(new int[]{n}));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void updateHologram(Player player, CMIDataWatcher cMIDataWatcher, String string, org.bukkit.inventory.ItemStack itemStack) {
        if (cMIDataWatcher == null) {
            return;
        }
        EntityArmorStand entityArmorStand = (EntityArmorStand)cMIDataWatcher.getStand();
        if (string == null || string.isEmpty()) {
            entityArmorStand.setCustomNameVisible(false);
        } else if (CMIChatColor.stripColor((String)string).isEmpty() || string.replace(" ", "").isEmpty()) {
            entityArmorStand.setCustomNameVisible(false);
        } else {
            entityArmorStand.setCustomNameVisible(true);
        }
        entityArmorStand.setCustomName(string);
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(cMIDataWatcher.getId().intValue(), entityArmorStand.getDataWatcher(), true);
        CraftPlayer craftPlayer = (CraftPlayer)player;
        try {
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
            PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(cMIDataWatcher.getId().intValue(), EnumItemSlot.MAINHAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)itemStack));
            craftPlayer.getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, org.bukkit.inventory.ItemStack itemStack) {
        return this.makeFloatingIcon(player, location, itemStack, false);
    }

    @Override
    public CMIDataWatcher makeFloatingIcon(Player player, Location location, org.bukkit.inventory.ItemStack itemStack, boolean bl) {
        return null;
    }

    @Override
    public FakeInfo spawnClickable(Player player, Location location, Object object, boolean bl) {
        try {
            EntityArmorStand entityArmorStand = new EntityArmorStand((World)((CraftWorld)location.getWorld()).getHandle(), location.getX(), location.getY() - 0.35, location.getZ());
            entityArmorStand.setInvisible(true);
            entityArmorStand.setArms(false);
            entityArmorStand.setGravity(false);
            entityArmorStand.setBasePlate(false);
            if (object instanceof CMIHologram) {
                if (((CMIHologram)object).getHeight() > 1.7) {
                    entityArmorStand.setSmall(false);
                    entityArmorStand.setLocation(location.getX(), location.getY() - 0.75, location.getZ(), 0.0f, 0.0f);
                } else {
                    entityArmorStand.setSmall(true);
                }
            } else {
                entityArmorStand.setSmall(true);
            }
            entityArmorStand.setCustomNameVisible(false);
            PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)entityArmorStand);
            ((CraftPlayer)player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutSpawnEntityLiving);
            FakeInfo fakeInfo = new FakeInfo().setObj(object).setPlayer(player).setId(entityArmorStand.getId());
            fakeInfo.setEntity(entityArmorStand);
            PacketHandler.fakeEntities.put(entityArmorStand.getId(), fakeInfo);
            return fakeInfo;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean clearSkin(Player player) {
        if (player == null) {
            return false;
        }
        CraftPlayer craftPlayer = (CraftPlayer)player;
        GameProfile gameProfile = craftPlayer.getProfile();
        gameProfile.getProperties().removeAll((Object)"textures");
        this.updatePlayerViaPackets(player);
        return true;
    }

    @Override
    public void updatePlayerViaPackets(final Player player) {
        final CraftPlayer craftPlayer = (CraftPlayer)player;
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        EntityPlayer entityPlayer = craftPlayer.getHandle();
        int n = player.getEntityId();
        PacketPlayOutPlayerInfo packetPlayOutPlayerInfo = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.REMOVE_PLAYER, new EntityPlayer[]{craftPlayer.getHandle()});
        PacketPlayOutPlayerInfo packetPlayOutPlayerInfo2 = new PacketPlayOutPlayerInfo(PacketPlayOutPlayerInfo.EnumPlayerInfoAction.ADD_PLAYER, new EntityPlayer[]{craftPlayer.getHandle()});
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{n});
        PacketPlayOutNamedEntitySpawn packetPlayOutNamedEntitySpawn = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment = new PacketPlayOutEntityEquipment(n, EnumItemSlot.HEAD, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Helmet)));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment2 = new PacketPlayOutEntityEquipment(n, EnumItemSlot.CHEST, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.ChestPlate)));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment3 = new PacketPlayOutEntityEquipment(n, EnumItemSlot.LEGS, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Pants)));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment4 = new PacketPlayOutEntityEquipment(n, EnumItemSlot.FEET, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getInventory().getItem(CMIPlayerInventory.CMIInventorySlot.Boots)));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment5 = new PacketPlayOutEntityEquipment(n, EnumItemSlot.MAINHAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getItemInHand()));
        PacketPlayOutEntityEquipment packetPlayOutEntityEquipment6 = new PacketPlayOutEntityEquipment(n, EnumItemSlot.OFFHAND, CraftItemStack.asNMSCopy((org.bukkit.inventory.ItemStack)cMIUser.getItemInOffHand()));
        PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(n, craftPlayer.getHandle().getDataWatcher(), true);
        PacketPlayOutAbilities packetPlayOutAbilities = new PacketPlayOutAbilities(craftPlayer.getHandle().abilities);
        PacketPlayOutMount packetPlayOutMount = null;
        if (player.getVehicle() != null) {
            packetPlayOutMount = new PacketPlayOutMount(((CraftEntity)player.getVehicle()).getHandle());
        }
        for (Player player2 : Bukkit.getOnlinePlayers()) {
            PlayerConnection playerConnection = ((CraftPlayer)player2).getHandle().playerConnection;
            if (player2 == player) {
                final boolean bl = player.isFlying();
                playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo);
                playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo2);
                Location location = player.getLocation();
                HashSet hashSet = new HashSet();
                PacketPlayOutPosition packetPlayOutPosition = new PacketPlayOutPosition(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch(), hashSet, 0);
                PacketPlayOutRespawn packetPlayOutRespawn = new PacketPlayOutRespawn(player.getWorld().getEnvironment().getId(), entityPlayer.getWorld().getDifficulty(), entityPlayer.getWorld().worldData.getType(), WorldSettings.EnumGamemode.getById((int)player.getGameMode().getValue()));
                playerConnection.sendPacket((Packet)packetPlayOutRespawn);
                playerConnection.sendPacket((Packet)packetPlayOutPosition);
                PacketPlayOutUpdateHealth packetPlayOutUpdateHealth = new PacketPlayOutUpdateHealth((float)player.getHealth(), player.getFoodLevel(), player.getSaturation());
                playerConnection.sendPacket((Packet)packetPlayOutUpdateHealth);
                if (packetPlayOutMount != null) {
                    playerConnection.sendPacket((Packet)packetPlayOutMount);
                }
                playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
                playerConnection.sendPacket((Packet)packetPlayOutAbilities);
                Bukkit.getScheduler().runTask((Plugin)CMI.getInstance(), new Runnable(){

                    @Override
                    public void run() {
                        if (bl) {
                            player.setAllowFlight(true);
                            player.setFlying(true);
                        }
                        v1_9_R2.this.updateExpBar(player);
                        if (player.isOp()) {
                            ((CraftServer)Bukkit.getServer()).getHandle().addOp(craftPlayer.getProfile());
                            craftPlayer.recalculatePermissions();
                        }
                    }
                });
                continue;
            }
            if (!player2.canSee(player)) continue;
            playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo);
            playerConnection.sendPacket((Packet)packetPlayOutPlayerInfo2);
            if (CMI.getInstance().getUtilManager().getDistance(player2.getLocation(), player.getLocation()) < (double)CMI.getInstance().getUtilManager().getPlayerTrackingRange(player.getWorld())) {
                playerConnection.sendPacket((Packet)packetPlayOutEntityDestroy);
                playerConnection.sendPacket((Packet)packetPlayOutNamedEntitySpawn);
            }
            if (packetPlayOutMount != null) {
                playerConnection.sendPacket((Packet)packetPlayOutMount);
            }
            playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment2);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment3);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment4);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment5);
            playerConnection.sendPacket((Packet)packetPlayOutEntityEquipment6);
        }
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, Color color) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(0);
        cMIEffect.setSpeed(1.0f);
        cMIEffect.setColor(org.bukkit.Color.fromBGR((int)color.getBlue(), (int)color.getGreen(), (int)color.getRed()));
        this.playEffect(player, location, cMIEffect);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, Effect effect2, float f, float f2, float f3, float f4, int n) {
        CMIEffectManager.CMIParticle cMIParticle = CMIEffectManager.CMIParticle.getCMIParticle((String)effect2.name());
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffectManager.CMIParticle cMIParticle, float f, float f2, float f3, float f4, int n) {
        CMIEffect cMIEffect = new CMIEffect(cMIParticle);
        cMIEffect.setAmount(n);
        cMIEffect.setOffset(new Vector(f, f2, f3));
        cMIEffect.setSpeed(f4);
        this.playEffect(player, location, cMIEffect);
    }

    @Override
    public void playEffect(Player player, Location location, CMIEffect cMIEffect) {
        CraftPlayer craftPlayer;
        if (location == null || cMIEffect == null || location.getWorld() == null) {
            return;
        }
        PacketPlayOutWorldParticles packetPlayOutWorldParticles = null;
        if (cMIEffect.getParticle().getEffect() == null) {
            return;
        }
        if (cMIEffect.getParticle().isParticle()) {
            craftPlayer = cMIEffect.getParticle().getParticle();
            EnumParticle enumParticle = cMIEffect.getParticle().getEnumParticle() == null ? null : (EnumParticle)cMIEffect.getParticle().getEnumParticle();
            int[] nArray = cMIEffect.getParticle().getExtra();
            if (enumParticle == null) {
                EnumParticle[] enumParticleArray = EnumParticle.values();
                int n = enumParticleArray.length;
                int n2 = 0;
                while (n2 < n) {
                    EnumParticle enumParticle2 = enumParticleArray[n2];
                    if (craftPlayer.name().replace("_", "").equalsIgnoreCase(enumParticle2.toString().replace("_", ""))) {
                        enumParticle = enumParticle2;
                        if (cMIEffect.getParticle().getEffect().getData() == null) break;
                        if (cMIEffect.getParticle().getEffect().equals(Material.class)) {
                            nArray = new int[1];
                            break;
                        }
                        nArray = new int[1];
                        break;
                    }
                    if (cMIEffect.getParticle().getName().replace("_", "").equalsIgnoreCase(enumParticle2.toString().replace("_", ""))) {
                        enumParticle = enumParticle2;
                        if (cMIEffect.getParticle().getEffect().getData() == null) break;
                        if (cMIEffect.getParticle().getEffect().equals(Material.class)) {
                            nArray = new int[1];
                            break;
                        }
                        nArray = new int[1];
                        break;
                    }
                    if (cMIEffect.getParticle().getSecondaryName().replace("_", "").equalsIgnoreCase(enumParticle2.toString().replace("_", ""))) {
                        enumParticle = enumParticle2;
                        if (cMIEffect.getParticle().getEffect().getData() == null) break;
                        if (cMIEffect.getParticle().getEffect().equals(Material.class)) {
                            nArray = new int[1];
                            break;
                        }
                        nArray = new int[1];
                        break;
                    }
                    ++n2;
                }
                if (nArray == null) {
                    nArray = new int[]{};
                }
            }
            if (enumParticle == null) {
                return;
            }
            if (cMIEffect.getParticle().getEnumParticle() == null) {
                cMIEffect.getParticle().setEnumParticle((Object)enumParticle);
                cMIEffect.getParticle().setExtra(nArray);
            }
            packetPlayOutWorldParticles = new PacketPlayOutWorldParticles(enumParticle, true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), (float)cMIEffect.getOffset().getX(), (float)cMIEffect.getOffset().getY(), (float)cMIEffect.getOffset().getZ(), cMIEffect.getSpeed(), cMIEffect.getAmount(), nArray);
        }
        craftPlayer = (CraftPlayer)player;
        if (craftPlayer.getHandle().playerConnection == null) {
            return;
        }
        if (!location.getWorld().equals(craftPlayer.getWorld())) {
            return;
        }
        if (packetPlayOutWorldParticles == null) {
            return;
        }
        craftPlayer.getHandle().playerConnection.sendPacket(packetPlayOutWorldParticles);
    }

    @Override
    public boolean forceTeleport(Player player, Location location) {
        EntityPlayer entityPlayer = ((CraftPlayer)player).getHandle();
        if (entityPlayer.getHealth() == 0.0f || entityPlayer.dead) {
            return false;
        }
        if (entityPlayer.playerConnection == null) {
            return false;
        }
        if (entityPlayer.isVehicle()) {
            return false;
        }
        Location location2 = player.getLocation();
        Location location3 = location;
        entityPlayer.stopRiding();
        WorldServer worldServer = ((CraftWorld)location2.getWorld()).getHandle();
        WorldServer worldServer2 = ((CraftWorld)location3.getWorld()).getHandle();
        if (((CraftPlayer)player).getHandle().activeContainer != ((CraftPlayer)player).getHandle().defaultContainer) {
            ((CraftPlayer)player).getHandle().closeInventory();
        }
        if (worldServer == worldServer2) {
            entityPlayer.playerConnection.teleport(location3);
        } else {
            ((CraftServer)Bukkit.getServer()).getHandle().moveToWorld(entityPlayer, worldServer2.dimension, true, location3, true);
        }
        return true;
    }

    @Override
    public CMIHitBox getBlockHitBox(CMIHitBox cMIHitBox) {
        try {
            org.bukkit.block.Block block = cMIHitBox.getBlock();
            if (CMIMaterial.isAir((Material)block.getType())) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
            } else {
                BlockPosition blockPosition = new BlockPosition(block.getX(), block.getY(), block.getZ());
                WorldServer worldServer = ((CraftWorld)block.getWorld()).getHandle();
                IBlockData iBlockData = worldServer.getType(blockPosition);
                Block block2 = iBlockData.getBlock();
                AxisAlignedBB axisAlignedBB = block2.a(iBlockData, (World)worldServer, blockPosition);
                if (axisAlignedBB != null) {
                    cMIHitBox.setMin(new Vector(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c));
                    cMIHitBox.setMax(new Vector(axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f));
                }
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public CMIHitBox getEntityHitBox(CMIHitBox cMIHitBox) {
        try {
            Entity entity = cMIHitBox.getEntity();
            if (entity == null) {
                cMIHitBox.setMin(new Vector(1, 1, 1));
                cMIHitBox.setMax(new Vector(0, 0, 0));
                return cMIHitBox;
            }
            AxisAlignedBB axisAlignedBB = ((CraftEntity)entity).getHandle().getBoundingBox();
            cMIHitBox.setMin(new Vector(axisAlignedBB.a, axisAlignedBB.b, axisAlignedBB.c));
            cMIHitBox.setMax(new Vector(axisAlignedBB.d, axisAlignedBB.e, axisAlignedBB.f));
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return cMIHitBox;
    }

    @Override
    public org.bukkit.block.Block getBlockLookingAt(Player player, int n, boolean bl) {
        if (player == null) {
            return null;
        }
        if (n < 1) {
            n = 1;
        }
        if (n > 120) {
            n = 120;
        }
        Location location = player.getLocation().clone().add(0.0, player.getEyeHeight(), 0.0);
        Vector vector = location.toVector();
        Vector vector2 = location.getDirection().normalize().multiply(n);
        Vector vector3 = vector.clone().add(vector2);
        return this.getBlockLookingAt(player.getWorld(), vector, vector3, bl);
    }

    @Override
    public org.bukkit.block.Block getBlockLookingAt(org.bukkit.World world2, Vector vector, Vector vector2, boolean bl) {
        WorldServer worldServer = ((CraftWorld)world2).getHandle();
        MovingObjectPosition movingObjectPosition = worldServer.rayTrace(new Vec3D(vector.getX(), vector.getY(), vector.getZ()), new Vec3D(vector2.getX(), vector2.getY(), vector2.getZ()), bl);
        return movingObjectPosition == null ? null : world2.getBlockAt(movingObjectPosition.a().getX(), movingObjectPosition.a().getY(), movingObjectPosition.a().getZ());
    }
}

