/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import java.util.ArrayList;
import java.util.List;
import net.Zrips.CMILib.BossBar.BossBarInfo;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class Speed {
    private BossBarInfo bb;
    private Player player;
    private boolean allowBoost = false;
    private boolean allowSuperBoost = false;
    private boolean speedometer = false;
    private List<Long> time = new ArrayList<Long>();
    private List<Location> loc = new ArrayList<Location>();
    private Long boost = 0L;
    private Long superBoost = 0L;
    private boolean free = false;
    private boolean dura = false;
    private static int amount = 5;
    private static int timeRange = 1000 / amount;

    public Speed(Player player) {
        this.player = player;
        if (PermissionsManager.CMIPerm.elytra_boost.hasPermission((CommandSender)player)) {
            this.allowBoost = true;
        }
        if (PermissionsManager.CMIPerm.elytra_superboost.hasPermission((CommandSender)player)) {
            this.allowSuperBoost = true;
        }
        if (!PermissionsManager.CMIPerm.elytra.hasPermission((CommandSender)player)) {
            ItemStack itemStack = player.getInventory().getChestplate();
            if (itemStack != null && itemStack.getType() == Material.ELYTRA) {
                player.getInventory().setChestplate(null);
                if (player.getInventory().firstEmpty() == -1) {
                    player.getWorld().dropItem(player.getLocation(), itemStack);
                } else {
                    player.getInventory().addItem(new ItemStack[]{itemStack});
                }
                player.updateInventory();
            }
            player.setGliding(false);
        }
        if (PermissionsManager.CMIPerm.elytra_speedometer.hasPermission((CommandSender)player)) {
            this.speedometer = true;
        }
        if (PermissionsManager.CMIPerm.elytra_freeflight.hasPermission((CommandSender)player)) {
            this.free = true;
        }
        if (PermissionsManager.CMIPerm.informDurability.hasPermission((CommandSender)player)) {
            this.dura = true;
        }
        this.loc.add(player.getLocation());
        this.time.add(System.currentTimeMillis());
    }

    private long getTime() {
        while (this.time.size() > amount) {
            this.time.remove(0);
        }
        if (this.time.isEmpty()) {
            return System.currentTimeMillis();
        }
        return this.time.get(0);
    }

    private Location getLocation() {
        while (this.loc.size() > amount) {
            this.loc.remove(0);
        }
        if (this.loc.isEmpty()) {
            return null;
        }
        return this.loc.get(0);
    }

    public double getSpeed() {
        Location location = this.getLocation();
        if (location == null) {
            return 0.0;
        }
        if (!this.player.getWorld().equals(location.getWorld())) {
            return 0.0;
        }
        double d = this.player.getLocation().distance(location);
        long l = System.currentTimeMillis() - this.getTime();
        return (double)((int)(d / (double)l * 100.0 * 6.0 * 6.0 * 100.0)) / 100.0;
    }

    public void setLoc(Location location) {
        this.loc.add(location);
        while (this.loc.size() > amount) {
            this.loc.remove(0);
        }
    }

    public boolean isGoodTime() {
        if (this.time.isEmpty()) {
            return true;
        }
        return System.currentTimeMillis() - this.time.get(this.time.size() - 1) > (long)timeRange;
    }

    public void setTime(Long l) {
        this.time.add(l);
        while (this.time.size() > amount) {
            this.time.remove(0);
        }
    }

    public Long getBoost() {
        return this.boost;
    }

    public void setBoost(Long l) {
        this.boost = l;
    }

    public boolean isBoosting() {
        return System.currentTimeMillis() - this.boost < 250L;
    }

    public Long getSuperBoost() {
        return this.superBoost;
    }

    public void setSuperBoost(Long l) {
        this.superBoost = l;
    }

    public boolean isSuperBoosting() {
        return System.currentTimeMillis() - this.superBoost < 1000L;
    }

    public boolean isAllowBoost() {
        return this.allowBoost;
    }

    public boolean isAllowSuperBoost() {
        return this.allowSuperBoost;
    }

    public boolean isSpeedometer() {
        return this.speedometer;
    }

    public boolean isFree() {
        return this.free;
    }

    public void setFree(boolean bl) {
        this.free = bl;
    }

    public BossBarInfo getBb() {
        return this.bb;
    }

    public void setBb(BossBarInfo bossBarInfo) {
        this.bb = bossBarInfo;
    }

    public boolean isShowDurability() {
        return this.dura;
    }
}

