/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Animations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.spigotmc.event.entity.EntityDismountEvent;

public class AnimationListener
implements Listener {
    private CMI plugin;

    public AnimationListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.LOW, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (!this.plugin.getAnimationManager().isRiding(player.getUniqueId())) {
            return;
        }
        player.leaveVehicle();
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void VehicleExitEvent(EntityDismountEvent entityDismountEvent) {
        Entity entity = entityDismountEvent.getEntity();
        if (!(entity instanceof Player)) {
            if (entity instanceof Slime && (entity.hasMetadata("CMIFakeSlime") || entity.getCustomName() != null && entity.getCustomName().equalsIgnoreCase("CMIFakeSlime"))) {
                this.plugin.getTeleportations().shakePassengers(entityDismountEvent.getEntity());
                entityDismountEvent.getEntity().remove();
            }
            return;
        }
        Player player = (Player)entity;
        CMIUser cMIUser = CMIUser.getUser(player);
        if (cMIUser == null || cMIUser.isFakeAccount().booleanValue()) {
            return;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_19_R3) && cMIUser.isSitting()) {
            this.plugin.getAnimationManager().removePlayerFromChair(player);
        }
        if (!this.plugin.getAnimationManager().isRiding(player.getUniqueId())) {
            return;
        }
        if (entityDismountEvent.getDismounted() instanceof Slime && (entityDismountEvent.getDismounted().hasMetadata("CMIFakeSlime") || entityDismountEvent.getDismounted().getCustomName() != null && entityDismountEvent.getDismounted().getCustomName().equalsIgnoreCase("CMIFakeSlime"))) {
            entityDismountEvent.getDismounted().leaveVehicle();
            entityDismountEvent.getDismounted().remove();
        }
        this.plugin.getAnimationManager().removeRiding(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void PlayerMoveEvent(VehicleMoveEvent vehicleMoveEvent) {
    }
}

