/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Particl;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Particl.CMIPEAnimationInterface;
import com.Zrips.CMI.Modules.Particl.CMIPECircle;
import com.Zrips.CMI.Modules.Particl.CMIPEFireWork;
import com.Zrips.CMI.Modules.Particl.CMIVisualEffect;
import com.Zrips.CMI.Modules.Particl.Vectors;
import com.Zrips.CMI.Modules.tp.Teleportations;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Effects.CMIEffect;
import net.Zrips.CMILib.Effects.CMIEffectManager;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ParticleManager {
    private CMI plugin;
    Map<UUID, Set<CMIVisualEffect>> playerEffects = Collections.synchronizedMap(new ConcurrentHashMap());
    private static final String fileName = "ParticleEffects.yml";
    private static final String customPreset = "circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4";

    public ParticleManager(CMI cMI) {
        this.plugin = cMI;
    }

    public synchronized boolean addPlayerEffect(CMIVisualEffect cMIVisualEffect) {
        Player player = cMIVisualEffect.getTargetPlayer();
        if (player == null) {
            return false;
        }
        Set<CMIVisualEffect> set = this.playerEffects.get(player.getUniqueId());
        if (set == null) {
            set = Collections.synchronizedSet(new HashSet());
            this.playerEffects.put(player.getUniqueId(), set);
        }
        set.add(cMIVisualEffect);
        return true;
    }

    public synchronized boolean removePlayerEffects(CMIVisualEffect cMIVisualEffect) {
        Player player = cMIVisualEffect.getTargetPlayer();
        if (player == null) {
            return false;
        }
        Set<CMIVisualEffect> set = this.playerEffects.get(player.getUniqueId());
        if (set == null) {
            return false;
        }
        set.remove(cMIVisualEffect);
        if (set.isEmpty()) {
            this.playerEffects.remove(player.getUniqueId());
        }
        cMIVisualEffect.stop();
        return true;
    }

    public synchronized boolean removePlayerEffects(UUID uUID) {
        if (uUID == null) {
            return false;
        }
        Set<CMIVisualEffect> set = this.playerEffects.remove(uUID);
        if (set != null) {
            for (CMIVisualEffect cMIVisualEffect : set) {
                cMIVisualEffect.stop();
            }
        }
        return true;
    }

    public synchronized boolean removeAllPlayerEffects() {
        Iterator<Map.Entry<UUID, Set<CMIVisualEffect>>> iterator = this.playerEffects.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Set<CMIVisualEffect>> entry = iterator.next();
            HashSet hashSet = new HashSet(entry.getValue());
            for (CMIVisualEffect cMIVisualEffect : hashSet) {
                cMIVisualEffect.stop();
            }
            iterator.remove();
        }
        return true;
    }

    @Deprecated
    public void drawLine(Player player, Location location, Location location2, CMIEffectManager.CMIParticle cMIParticle, boolean bl) {
        this.drawLine(location, location2, cMIParticle, bl, Arrays.asList(player));
    }

    @Deprecated
    public void drawLine(Location location, Location location2, CMIEffectManager.CMIParticle cMIParticle, boolean bl, Player player) {
        ArrayList<Player> arrayList = new ArrayList<Player>();
        arrayList.add(player);
        this.drawLine(location, location2, cMIParticle, bl, arrayList);
    }

    @Deprecated
    public void drawLine(Location location, Location location2, CMIEffectManager.CMIParticle cMIParticle, boolean bl, List<Player> list2) {
        this.drawLine(location, location2, cMIParticle, bl, list2, 5000L);
    }

    @Deprecated
    public void drawLine(Location location, Location location2, CMIEffectManager.CMIParticle cMIParticle, boolean bl, List<Player> list2, Long l) {
        this.drawLine(location, location2, new CMIEffect(cMIParticle), bl, list2, l, 0.3);
    }

    public void drawLine(Location location, Location location2, CMIEffect cMIEffect, boolean bl, List<Player> list2, Long l, Double d) {
        ArrayList<Location> arrayList = ParticleManager.getLineLocations(location, location2, bl, d);
        this.drawShed(arrayList, cMIEffect, list2, l);
    }

    private static ArrayList<Location> getLineLocations(Location location, Location location2, boolean bl, Double d) {
        if (d == null) {
            d = 0.3;
        }
        Vector vector = location.toVector();
        Vector vector2 = location2.toVector();
        if (bl) {
            vector = new Vector((double)location.getBlockX() + 0.5, (double)location.getBlockY() + 0.5, (double)location.getBlockZ() + 0.5);
            vector2 = new Vector((double)location2.getBlockX() + 0.5, (double)location2.getBlockY() + 0.5, (double)location2.getBlockZ() + 0.5);
        }
        Vectors vectors = ParticleManager.shortenVectors(0.5, 32, vector, vector2, location);
        ArrayList<Location> arrayList = new ArrayList<Location>();
        if (vectors.getp1() == null || vectors.getp2() == null) {
            return arrayList;
        }
        vector = vectors.getp1();
        vector2 = vectors.getp2();
        List<Vector> list2 = ParticleManager.remakePlotLineInRange(d, 32, vector, vector2, location);
        for (Vector vector3 : list2) {
            arrayList.add(new Location(location.getWorld(), vector3.getX(), vector3.getY(), vector3.getZ()));
        }
        return arrayList;
    }

    private void drawShed(final ArrayList<Location> arrayList, final CMIEffect cMIEffect, final List<Player> list2, final Long l) {
        final taskCancel taskCancel2 = new taskCancel(-1);
        taskCancel2.setId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                int n = 0;
                while (n < 5) {
                    if (arrayList.isEmpty()) break;
                    Location location = (Location)arrayList.remove(0);
                    for (Player player : list2) {
                        CMI.getInstance().getNMS().playEffect(player, location, cMIEffect);
                    }
                    if (arrayList.isEmpty()) {
                        ParticleManager.this.markBlockShed(location, cMIEffect, System.currentTimeMillis() + l, list2);
                        break;
                    }
                    ++n;
                }
                if (arrayList.isEmpty()) {
                    taskCancel2.cancel();
                    return;
                }
            }
        }, 0L, 1L));
    }

    private void markBlockShed(final Location location, final CMIEffect cMIEffect, final Long l, final List<Player> list2) {
        final taskCancel taskCancel2 = new taskCancel(-1);
        taskCancel2.setId(Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                if (l < System.currentTimeMillis()) {
                    taskCancel2.cancel();
                    return;
                }
                ParticleManager.markBlock(location, cMIEffect, list2);
            }
        }, 0L, 10L));
    }

    private static void markBlock(Location location, CMIEffect cMIEffect, List<Player> list2) {
        if (location == null) {
            return;
        }
        Location location2 = location.clone().add(-0.5, -0.5, -0.5);
        for (Player player : list2) {
            CMI.getInstance().getNMS().playEffect(player, location2, cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(1.0, 0.0, 0.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.0, 1.0, 0.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.0, 0.0, 1.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(1.0, 1.0, 0.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(1.0, 0.0, 1.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.0, 1.0, 1.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(1.0, 1.0, 1.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.5, 0.5, 0.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.5, 0.0, 0.5), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.0, 0.5, 0.5), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(1.0, 0.5, 0.5), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.5, 0.5, 1.0), cMIEffect);
            CMI.getInstance().getNMS().playEffect(player, location2.clone().add(0.5, 1.0, 0.5), cMIEffect);
        }
    }

    private static List<Vector> remakePlotLineInRange(Double d, int n, Vector vector, Vector vector2, Location location) {
        ArrayList<Vector> arrayList = new ArrayList<Vector>();
        int n2 = (int)(vector.distance(vector2) / d) + 1;
        double d2 = vector.distance(vector2);
        double d3 = d2 / (double)(n2 - 1);
        Vector vector3 = vector2.subtract(vector).normalize().multiply(d3);
        int n3 = 1;
        int n4 = 0;
        while (n4 < n2) {
            Vector vector4 = vector.clone().add(vector3.clone().multiply(n4));
            double d4 = vector4.getY() - location.getY();
            if (d4 < 0.0) {
                d4 = -d4;
            }
            if (!(d4 > (double)n)) {
                if (!ParticleManager.inRange(location, new Location(location.getWorld(), vector4.getX(), vector4.getY(), vector4.getZ()), n)) {
                    if (n3 < 15) {
                        ++n3;
                    }
                    n4 += n3;
                } else {
                    n3 = 1;
                    arrayList.add(vector4);
                }
            }
            ++n4;
        }
        return arrayList;
    }

    private static boolean inRange(Location location, Location location2, Integer n) {
        double d;
        double d2;
        double d3 = location2.getBlockX() - location.getBlockX();
        if (d3 < 0.0) {
            d3 = -d3;
        }
        if ((d2 = (double)(location2.getBlockZ() - location.getBlockZ())) < 0.0) {
            d2 = -d2;
        }
        if ((d = (double)(location2.getBlockY() - location.getBlockY())) < 0.0) {
            d = -d;
        }
        return !(d3 > (double)n.intValue()) && !(d > (double)n.intValue()) && !(d2 > (double)n.intValue());
    }

    private static Vectors shortenVectors(Double d, Integer n, Vector vector, Vector vector2, Location location) {
        int n2 = (int)(vector.distance(vector2) / d) + 1;
        double d2 = vector.distance(vector2);
        double d3 = d2 / (double)(n2 - 1);
        Vector vector3 = vector2.clone().subtract(vector).normalize().multiply(d3);
        boolean bl = false;
        boolean bl2 = false;
        Vectors vectors = new Vectors();
        vectors.setp1(vector);
        vectors.setp2(vector2);
        int n3 = 0;
        while (n3 < n2) {
            Vector vector4 = vector.clone().add(vector3.clone().multiply(n3));
            if (n3 == 0 && vector4.getBlockX() < location.getBlockX() + n && vector4.getBlockZ() < location.getBlockZ() + n && vector4.getBlockX() > location.getBlockX() - n && vector4.getBlockZ() > location.getBlockZ() - n) {
                bl = true;
            }
            if (n3 + 1 >= n2 && !bl2 && vector4.getBlockX() < location.getBlockX() + n && vector4.getBlockZ() < location.getBlockZ() + n && vector4.getBlockX() > location.getBlockX() - n && vector4.getBlockZ() > location.getBlockZ() - n) {
                bl2 = true;
            }
            if (!bl && vector4.getBlockX() < location.getBlockX() + n && vector4.getBlockZ() < location.getBlockZ() + n && vector4.getBlockX() > location.getBlockX() - n && vector4.getBlockZ() > location.getBlockZ() - n) {
                vectors.setp1(vector4);
                bl2 = true;
                break;
            }
            if (bl && (vector4.getBlockX() > location.getBlockX() + n || vector4.getBlockZ() > location.getBlockZ() + n || vector4.getBlockX() < location.getBlockX() - n || vector4.getBlockZ() < location.getBlockZ() - n)) {
                vectors.setp2(vector4);
                bl2 = true;
                break;
            }
            ++n3;
        }
        if (!bl2) {
            vectors.setp1(null);
        }
        return vectors;
    }

    public void loadConfig() {
        String string;
        Enum enum_;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            CMI.getInstance().consoleMessage("&cFailed to load Settings" + File.separator + fileName + " file");
            return;
        }
        ConfigReader configReader2 = CMI.getInstance().getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("Particles")) {
            configReader.getC().set("Particles", configReader2.getC().get("Particles"));
        }
        if (configReader2.getC().isConfigurationSection("TeleportEffects")) {
            configReader.getC().set("TeleportEffects", configReader2.getC().get("TeleportEffects"));
        }
        configReader.addComment("Particles", new String[]{"If you want to disable particular particle entirely, set it to \"\" ", "More information how to set up this one can be found at https://www.zrips.net/cmi/extra/particles/"});
        configReader.addComment("Particles.custom1", new String[]{"From custom1 to custom30 are free to use particle presets which can be utilized for things like command warmups"});
        Boolean bl = configReader.get("Particles.Enabled", Boolean.valueOf(true));
        Enum[] enumArray = CMIPresetAnimations.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            string = configReader.get("Particles." + enum_.toString(), ((CMIPresetAnimations)enum_).getAnimString());
            if (string == null || string.isEmpty()) {
                ((CMIPresetAnimations)enum_).setEnabled(false);
            } else {
                ((CMIPresetAnimations)enum_).setAnimString(string);
                ((CMIPresetAnimations)enum_).setEnabled(bl);
            }
            ++n2;
        }
        configReader.addComment("TeleportEffects", new String[]{"Defined animated particles will be shown on player teleportation on particular action from place and to destination", "if you don't want it to be shown then set it to empty field", "Animation names should be used from Particles section from above like TpUp"});
        enumArray = Teleportations.TeleportType.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            enum_ = enumArray[n2];
            string = configReader.get("TeleportEffects." + enum_.toString() + ".From", "");
            String string2 = configReader.get("TeleportEffects." + enum_.toString() + ".To", "");
            if (string != null && !string.isEmpty()) {
                ((Teleportations.TeleportType)enum_).setFrom(CMIPresetAnimations.getByName(string));
            } else {
                ((Teleportations.TeleportType)enum_).setFrom(null);
            }
            if (string2 != null && !string2.isEmpty()) {
                ((Teleportations.TeleportType)enum_).setTo(CMIPresetAnimations.getByName(string2));
            } else {
                ((Teleportations.TeleportType)enum_).setTo(null);
            }
            ++n2;
        }
        configReader.save();
    }

    public void show(String string, Player player) {
        CMIPEAnimationInterface cMIPEAnimationInterface = this.getParticleAnimation(string);
        this.show(cMIPEAnimationInterface, player);
    }

    public void show(final CMIPEAnimationInterface cMIPEAnimationInterface, final Location location) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (cMIPEAnimationInterface == null) {
                    return;
                }
                CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(location, cMIPEAnimationInterface);
                cMIVisualEffect.setUntil((long)((double)System.currentTimeMillis() + cMIPEAnimationInterface.getDuration() * 1000.0));
                cMIVisualEffect.show();
            }
        });
    }

    public void show(final CMIPEAnimationInterface cMIPEAnimationInterface, final Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)CMI.getInstance(), new Runnable(){

            @Override
            public void run() {
                if (cMIPEAnimationInterface == null) {
                    return;
                }
                CMIVisualEffect cMIVisualEffect = new CMIVisualEffect(cMIPEAnimationInterface.getPlayerMove() == null ? player : cMIPEAnimationInterface.getPlayerMove(), cMIPEAnimationInterface);
                cMIVisualEffect.setUntil((long)((double)System.currentTimeMillis() + cMIPEAnimationInterface.getDuration() * 1000.0));
                cMIVisualEffect.show();
            }
        });
    }

    public CMIPEAnimationInterface getParticleAnimation(String string) {
        Object object2;
        Object object3;
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.startsWith("preset:") && (object3 = CMIPresetAnimations.getByName((String)(object2 = string.substring("preset:".length()).split(";")[0]))) != null) {
            string = (string = string.substring("preset:".length() + ((String)object2).length())).endsWith(";") ? string.substring(0, string.length() - 1) : string;
            string = String.valueOf(((CMIPresetAnimations)((Object)object3)).getAnimString()) + ";" + string;
        }
        string = string.toLowerCase();
        object2 = new ArrayList();
        if (string.contains(";")) {
            object2.addAll(Arrays.asList(string.split(";")));
        } else {
            object2.add(string);
        }
        if (object2.isEmpty()) {
            return null;
        }
        object3 = ((String)object2.get(0)).toLowerCase();
        List list2 = object2.subList(1, object2.size());
        HashMap<Object, String> hashMap = new HashMap<Object, String>();
        for (Object object4 : list2) {
            if (((String)object4).contains(":")) {
                String[] object5 = ((String)object4).split(":", 2);
                hashMap.put(object5[0], object5[1]);
                continue;
            }
            hashMap.put(object4, "true");
        }
        switch (object3) {
            case "firework": {
                CMIPEFireWork cMIPEFireWork = new CMIPEFireWork();
                block155: for (Map.Entry entry : hashMap.entrySet()) {
                    block39 : switch ((String)entry.getKey()) {
                        case "c1": {
                            CMIChatColor cMIChatColor = CMIChatColor.getColor((String)((String)entry.getValue()));
                            if (cMIChatColor == null) break;
                            cMIPEFireWork.setFadeFrom(cMIChatColor.getRGBColor());
                            break;
                        }
                        case "c2": {
                            CMIChatColor cMIChatColor = CMIChatColor.getColor((String)((String)entry.getValue()));
                            if (cMIChatColor == null) break;
                            cMIPEFireWork.setFadeTo(cMIChatColor.getRGBColor());
                            break;
                        }
                        case "flicker": {
                            cMIPEFireWork.setFlicker(true);
                            break;
                        }
                        case "trail": {
                            cMIPEFireWork.setTrail(true);
                            break;
                        }
                        case "t": 
                        case "type": {
                            FireworkEffect.Type type2;
                            FireworkEffect.Type[] world3 = FireworkEffect.Type.values();
                            int n = world3.length;
                            int exception = 0;
                            while (exception < n) {
                                type2 = world3[exception];
                                if (type2.toString().replace("_", "").equalsIgnoreCase((String)entry.getValue())) {
                                    cMIPEFireWork.setType(type2);
                                    break block39;
                                }
                                ++exception;
                            }
                            continue block155;
                        }
                        case "center": {
                            FireworkEffect.Type type2 = ((String)entry.getValue()).split(",");
                            if (((String[])type2).length != 4) {
                                Player d = CMIUser.getOnlinePlayer((String)entry.getValue());
                                if (d == null) break;
                                cMIPEFireWork.setCenter(d.getLocation());
                                break;
                            }
                            try {
                                World exception = this.plugin.getUtilManager().getWorld((String)type2[0]);
                                double d = Double.parseDouble((String)type2[1]);
                                double d2 = Double.parseDouble((String)type2[2]);
                                double d3 = Double.parseDouble((String)type2[3]);
                                if (exception == null) continue block155;
                                cMIPEFireWork.setCenter(new Location(exception, d, d2, d3));
                            }
                            catch (Exception player) {}
                            continue block155;
                        }
                        case "offset": 
                        case "off": {
                            FireworkEffect.Type type2 = ((String)entry.getValue()).split(",");
                            if (((String[])type2).length != 3) continue block155;
                            try {
                                double d = Double.parseDouble(type2[0]);
                                double exception = Double.parseDouble((String)type2[1]);
                                exception = Double.parseDouble((String)type2[2]);
                                cMIPEFireWork.setOffset(new Vector(d, exception, exception));
                                break;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                return cMIPEFireWork;
            }
            case "circle": {
                CMIPECircle cMIPECircle = new CMIPECircle();
                block157: for (Map.Entry entry : hashMap.entrySet()) {
                    block97 : switch ((String)entry.getKey()) {
                        case "effect": 
                        case "ef": {
                            CMIEffect cMIEffect = CMIEffectManager.CMIParticle.getCMIEffect((String)((String)entry.getValue()));
                            if (cMIEffect == null) break;
                            cMIPECircle.setCMIEffect(cMIEffect);
                            break;
                        }
                        case "target": 
                        case "tr": {
                            Player player = CMIUser.getOnlinePlayer((String)entry.getValue());
                            if (player == null) break;
                            cMIPECircle.setPlayerMove(player);
                            break;
                        }
                        case "center": 
                        case "ct": {
                            String[] stringArray = ((String)entry.getValue()).split(",");
                            if (stringArray.length != 4) {
                                Player d = CMIUser.getOnlinePlayer((String)entry.getValue());
                                if (d == null) break;
                                cMIPECircle.setCenter(d.getLocation());
                                break;
                            }
                            try {
                                World exception = this.plugin.getUtilManager().getWorld(stringArray[0]);
                                double d = Double.parseDouble(stringArray[1]);
                                double d4 = Double.parseDouble(stringArray[2]);
                                double d5 = Double.parseDouble(stringArray[3]);
                                if (exception == null) continue block157;
                                cMIPECircle.setCenter(new Location(exception, d, d4, d5));
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "radius": 
                        case "r": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setRadius(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "a": 
                        case "angle": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setStartingAngle((short)exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "locked": 
                        case "static": 
                        case "fixed": {
                            cMIPECircle.setFixedLocation(true);
                            break;
                        }
                        case "rc": 
                        case "radiuschange": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setRadiusChange(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "duration": 
                        case "dur": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setDuration(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "mr": 
                        case "maxradius": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setMaxRadius(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "offset": 
                        case "off": {
                            String[] stringArray = ((String)entry.getValue()).split(",");
                            if (stringArray.length != 3) continue block157;
                            try {
                                double exception = Double.parseDouble(stringArray[0]);
                                double vector = Double.parseDouble(stringArray[1]);
                                double d = Double.parseDouble(stringArray[2]);
                                cMIPECircle.setOffset(new Vector(exception, vector, d));
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "move": {
                            Player player;
                            String[] stringArray = ((String)entry.getValue()).split(",");
                            if (stringArray.length == 3) {
                                try {
                                    double d = Double.parseDouble(stringArray[0]);
                                    double d6 = Double.parseDouble(stringArray[1]);
                                    double d7 = Double.parseDouble(stringArray[2]);
                                    cMIPECircle.setMove(new Vector(d, d6, d7));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            Double d = null;
                            String string2 = (String)entry.getValue();
                            if (((String)entry.getValue()).contains(",")) {
                                try {
                                    d = Double.parseDouble(((String)entry.getValue()).split(",")[1]);
                                    string2 = ((String)entry.getValue()).split(",")[0];
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if ((player = CMIUser.getOnlinePlayer(string2)) == null) break;
                            Vector exception = player.getLocation().getDirection();
                            if (d != null) {
                                exception = exception.multiply(d.doubleValue());
                            }
                            cMIPECircle.setMove(exception);
                            break;
                        }
                        case "maxmovedistance": 
                        case "mmdist": 
                        case "maxd": {
                            try {
                                double n = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setMaxMoveDistance(n);
                            }
                            catch (Exception exception) {}
                            continue block157;
                        }
                        case "rotate": 
                        case "rotating": 
                        case "rot": 
                        case "twist": {
                            try {
                                cMIPECircle.setRotating(true);
                            }
                            catch (Exception n) {}
                            continue block157;
                        }
                        case "particles": 
                        case "part": {
                            try {
                                int exception = Integer.parseInt((String)entry.getValue());
                                cMIPECircle.setTimes(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "tickinter": 
                        case "tickinterval": 
                        case "interval": 
                        case "tinterval": {
                            try {
                                int exception = Integer.parseInt((String)entry.getValue());
                                if (exception < 1) {
                                    exception = 1;
                                }
                                cMIPECircle.setInterval(exception);
                            }
                            catch (Exception d) {}
                            continue block157;
                        }
                        case "pitch": {
                            Player player;
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setPitch(exception);
                            }
                            catch (Exception d) {
                                player = CMIUser.getOnlinePlayer((String)entry.getValue());
                                if (player == null) break;
                                cMIPECircle.setPitch(player.getLocation().getPitch());
                                cMIPECircle.setFollowPitch(true);
                            }
                            continue block157;
                        }
                        case "yaw": {
                            Player player;
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setYaw(exception);
                            }
                            catch (Exception d) {
                                player = CMIUser.getOnlinePlayer((String)entry.getValue());
                                if (player == null) break;
                                cMIPECircle.setYaw(player.getLocation().getYaw());
                                cMIPECircle.setFollowYaw(true);
                            }
                            continue block157;
                        }
                        case "pitchc": 
                        case "pitchchange": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setPitchAdjust(exception);
                            }
                            catch (Exception n) {}
                            continue block157;
                        }
                        case "yawchange": 
                        case "yawc": {
                            try {
                                double exception = Double.parseDouble((String)entry.getValue());
                                cMIPECircle.setYawAdjust(exception);
                            }
                            catch (Exception cMIChatColor) {}
                            continue block157;
                        }
                        case "fdir": 
                        case "followdirection": {
                            cMIPECircle.setFollowDirection(true);
                            break;
                        }
                        case "hidewhenvanished": 
                        case "hwv": {
                            cMIPECircle.setHideWithVanish(true);
                            break;
                        }
                        case "c": 
                        case "color": {
                            CMIChatColor cMIChatColor;
                            String[] stringArray;
                            if (((String)entry.getValue()).contains(",") && (stringArray = ((String)entry.getValue()).split(",")).length == 3) {
                                try {
                                    int cMIChatColor2 = Integer.parseInt(stringArray[0]);
                                    int n = Integer.parseInt(stringArray[1]);
                                    int n2 = Integer.parseInt(stringArray[2]);
                                    cMIPECircle.setColor(Color.fromRGB((int)cMIChatColor2, (int)n, (int)n2));
                                    break;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (((String)entry.getValue()).contains("{#") && ((String)entry.getValue()).contains("}") && (cMIChatColor = CMIChatColor.getColor((String)((String)entry.getValue()))) != null) {
                                cMIPECircle.setColor(cMIChatColor);
                                break;
                            }
                            CMIChatColor cMIChatColor2 = CMIChatColor.getByCustomName((String)((String)entry.getValue()));
                            if (cMIChatColor2 != null) {
                                cMIPECircle.setColor(cMIChatColor2);
                                break;
                            }
                            switch ((String)entry.getValue()) {
                                case "r": 
                                case "raindbow": {
                                    cMIPECircle.setRaindbowColor(true);
                                    break block97;
                                }
                                case "raindbowstatic": 
                                case "rs": {
                                    cMIPECircle.setRaindbowColorStatic(true);
                                    break block97;
                                }
                                case "raindbowfromstart": 
                                case "rfs": {
                                    cMIPECircle.setRaindbowColorFromStart(true);
                                }
                            }
                        }
                    }
                }
                return cMIPECircle;
            }
        }
        return null;
    }

    public static enum CMIPresetAnimations {
        TotemHalo("circle;effect:reddust;c:255,255,10;twist;part:3;offset:0,2,0;pitch:90;radius:0.3;interval:2"),
        Healing("circle;effect:heart;dur:0.1;part:1;offset:0,1.7,0;radius:0.3"),
        GlyphHead("circle;effect:flying_glyph;dur:5;pitchc:15;part:10;offset:0,1.7,0;radius:0.5;yawc:12;color:rs;pitch:90"),
        tpaWarmup("circle;effect:flying_glyph;dur:5;pitchc:15;part:10;offset:0,1.7,0;radius:0.5;yawc:12;color:rs;pitch:90"),
        GColumn("circle;c:0,255,0;twist;part:5;r:0.75;pitch:90;move:0,0.1,0;rc:-0.02"),
        SmallBoop("circle;effect:flying_glyph;yaw:[playerName];pitch:[playerName];r:0.1;part:3;rc:0.03;mr:0.3;twist"),
        HologramInteraction("circle;effect:flying_glyph;yaw:[playerName];pitch:[playerName];r:0.1;part:3;rc:0.03;mr:0.3;twist"),
        HologramNewInteraction("circle;effect:reddust;r:0;part:2;rc:0.2;mr:1;color:rs;yaw:[playerName];a:90"),
        HologramHover("circle;effect:crit;r:0;part:1;"),
        TpUp("circle;c:200,50,210;twist;part:5;r:0.5;pitch:90;move:0,0.33,0;offset:0,-0.2,0"),
        TpDown("circle;c:150,50,10;part:5;r:0.5;pitch:90;move:0,-0.33,0;offset:0,2.2,0"),
        custom1("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom2("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom3("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom4("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom5("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom6("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom7("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom8("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom9("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom10("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom11("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom12("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom13("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom14("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom15("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom16("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom17("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom18("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom19("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom20("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom21("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom22("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom23("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom24("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom25("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom26("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom27("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom28("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom29("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4"),
        custom30("circle;effect:reddust;dur:5;pitchc:5;part:10;offset:0,1,0;radius:1;yawc:4");

        private String string = "";
        private boolean enabled = true;

        private CMIPresetAnimations(String string2) {
            this.string = string2;
        }

        public CMIPEAnimationInterface getInter() {
            return CMI.getInstance().getParticleManager().getParticleAnimation(this.string);
        }

        public CMIPEAnimationInterface getInter(Player player) {
            Snd snd = new Snd(player, player);
            String string = CMI.getInstance().getLM().updateSnd(snd, this.string);
            return CMI.getInstance().getParticleManager().getParticleAnimation(this.isEnabled() ? string : "");
        }

        public void show(Location location) {
            CMI.getInstance().getParticleManager().show(CMI.getInstance().getParticleManager().getParticleAnimation(this.string), location);
        }

        public void show(Player player) {
            if (player == null || !player.isOnline()) {
                return;
            }
            CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
            if (cMIUser == null) {
                return;
            }
            if (cMIUser.isVanished()) {
                return;
            }
            CMI.getInstance().getParticleManager().show(CMI.getInstance().getParticleManager().getParticleAnimation(this.string), player);
        }

        public static CMIPresetAnimations getByName(String string) {
            CMIPresetAnimations[] cMIPresetAnimationsArray = CMIPresetAnimations.values();
            int n = cMIPresetAnimationsArray.length;
            int n2 = 0;
            while (n2 < n) {
                CMIPresetAnimations cMIPresetAnimations = cMIPresetAnimationsArray[n2];
                if (cMIPresetAnimations.toString().equalsIgnoreCase(string)) {
                    return cMIPresetAnimations;
                }
                ++n2;
            }
            return null;
        }

        public void setAnimString(String string) {
            this.string = string;
        }

        public String getAnimString() {
            return this.string;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }

    private class taskCancel {
        private int id = -1;

        taskCancel(int n) {
            this.id = n;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int n) {
            this.id = n;
        }

        public void cancel() {
            if (this.id > 0) {
                Bukkit.getScheduler().cancelTask(this.id);
            }
        }
    }
}

