/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.tp;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.RandomTeleport;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import net.Zrips.CMILib.Container.CMIBlock;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Container.CuboidArea;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class RandomTeleportationManager {
    private CMI plugin;
    ConcurrentHashMap<String, List<CMILocation>> randomLocCache = new ConcurrentHashMap();
    Set<String> cacheFilling = new HashSet<String>();
    private HashMap<String, RandomTeleport> randomTeleports = new HashMap();
    private int randomTeleportCooldown = 3;
    private int randomTeleportMaxTries = 10;
    private List<Biome> randomTeleportExcludedBiomes = new ArrayList<Biome>();
    private static final String fileName = "RandomTeleportations.yml";
    Random random = new Random(System.nanoTime());
    Random random2 = new Random(System.nanoTime() - System.currentTimeMillis());

    public RandomTeleportationManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        Iterator iterator;
        RandomTeleport randomTeleport;
        int n;
        int n2;
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string;
        Object object3;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            CMI.getInstance().consoleMessage("&cFailed to load Settings" + File.separator + fileName + " file");
            return;
        }
        ConfigReader configReader2 = CMI.getInstance().getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("RandomTeleportation")) {
            configReader.getC().set("RandomTeleportation", configReader2.getC().get("RandomTeleportation"));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (World world2 : Bukkit.getWorlds()) {
            hashSet.add(world2.getName());
        }
        boolean bl6 = false;
        this.randomTeleports.clear();
        configReader.addComment("RandomTeleportation.AutoGenerateWorlds", new String[]{"If this set to true we will generate random teleport default settings for all detected worlds", "Setting to false will not longer generate world setups, but you can add them manually if needed"});
        Boolean bl7 = configReader.get("RandomTeleportation.AutoGenerateWorlds", Boolean.valueOf(true));
        if (configReader.getC().isConfigurationSection("RandomTeleportation.Worlds") && (object3 = configReader.getC().getConfigurationSection("RandomTeleportation.Worlds")) != null) {
            for (Object object2 : object3.getKeys(false)) {
                string = "RandomTeleportation.Worlds." + (String)object2 + ".";
                n7 = configReader.get(String.valueOf(string) + "Enabled", Boolean.valueOf(true)).booleanValue();
                if (!bl6) {
                    configReader.addComment("RandomTeleportation.Worlds." + (String)object2, new String[]{"World name to use this feature. Add annother one with appropriate name to enable random teleportation"});
                }
                if (!bl6) {
                    configReader.addComment(String.valueOf(string) + "MaxRange", new String[]{"Max coordinate to teleport, setting to 1000, player can be teleported between -1000 and 1000 blocks between defined center location", "For example having centerX at 2000 and centerZ at 3000 while MaxRange is set to 1500 we will teleport player between x:500;z:1500 and x:3500;z:4500 coordinates"});
                }
                n6 = configReader.get(String.valueOf(string) + "MaxRange", configReader.getC().getInt(String.valueOf(string) + "MaxCoord", 1000));
                if (!bl6) {
                    configReader.addComment(String.valueOf(string) + "MinRange", new String[]{"If maxcord set to 1000 and mincord to 500, then player can be teleported between -1000 to -500 and 1000 to 500 coordinates"});
                }
                n5 = configReader.get(String.valueOf(string) + "MinRange", configReader.getC().getInt(String.valueOf(string) + "MinCoord", 500));
                n4 = configReader.get(String.valueOf(string) + "CenterX", 0);
                n3 = configReader.get(String.valueOf(string) + "CenterZ", 0);
                bl5 = configReader.get(String.valueOf(string) + "Circle", Boolean.valueOf(false));
                bl4 = configReader.get(String.valueOf(string) + "IgnoreWater", Boolean.valueOf(true));
                bl3 = configReader.get(String.valueOf(string) + "IgnoreLava", Boolean.valueOf(true));
                bl2 = configReader.get(String.valueOf(string) + "ignorePowderSnow", Boolean.valueOf(false));
                if (!bl6) {
                    configReader.addComment(String.valueOf(string) + "surfaceOnly", new String[]{"With this option we will only attempt to teleport player on highest block and ignore any cave teleportations"});
                }
                bl = configReader.get(String.valueOf(string) + "surfaceOnly", Boolean.valueOf(false));
                n2 = configReader.get(String.valueOf(string) + "minY", 0);
                n = configReader.get(String.valueOf(string) + "maxY", 256);
                randomTeleport = this.plugin.getUtilManager().getWorld((String)object2);
                if (randomTeleport == null) {
                    this.plugin.consoleMessage("&e(RandomTeleportation) Can't find world with (" + (String)object2 + ") name");
                }
                bl6 = true;
                hashSet.remove(object2);
                RandomTeleport randomTeleport2 = new RandomTeleport(n7 != 0, n6, n5, new CMILocation((String)object2, (double)n4, 63.0, (double)n3)).setCircle(bl5).setIgnoreLava(bl3).setIgnoreWater(bl4).setIgnorePowderSnow(bl2).setMinY(n2).setMaxY(n).setSurfaceOnly(bl);
                if (!bl5 && randomTeleport != null) {
                    try {
                        Location location = randomTeleport.getWorldBorder().getCenter();
                        double d = randomTeleport.getWorldBorder().getSize() / 2.0;
                        double d2 = location.getX() - d;
                        double d3 = location.getX() + d;
                        double d4 = location.getZ() - d;
                        double d5 = location.getZ() + d;
                        double d6 = randomTeleport2.getCenter().getX() - (double)randomTeleport2.getMaxDistance();
                        double d7 = randomTeleport2.getCenter().getX() + (double)randomTeleport2.getMaxDistance();
                        double d8 = randomTeleport2.getCenter().getZ() - (double)randomTeleport2.getMaxDistance();
                        double d9 = randomTeleport2.getCenter().getZ() + (double)randomTeleport2.getMaxDistance();
                        if (d2 > d6) {
                            this.plugin.consoleMessage("&5Random teleport location is out of minimal world border X coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d3 < d7) {
                            this.plugin.consoleMessage("&5Random teleport location is out of maximal world border X coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d4 > d8) {
                            this.plugin.consoleMessage("&5Random teleport location is out of minimal world border Z coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d5 < d9) {
                            this.plugin.consoleMessage("&5Random teleport location is out of maximal world border Z coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                this.randomTeleports.put((String)object2, randomTeleport2);
            }
        }
        if (bl7.booleanValue()) {
            for (Object object3 : Bukkit.getWorlds()) {
                if (!hashSet.contains(object3.getName())) continue;
                iterator = object3.getName();
                iterator = ((String)((Object)iterator)).replace(".", "_");
                string = "RandomTeleportation.Worlds." + (String)((Object)iterator) + ".";
                n7 = configReader.get(String.valueOf(string) + "Enabled", Boolean.valueOf(true)).booleanValue();
                n6 = configReader.get(String.valueOf(string) + "MaxRange", 1000);
                n5 = configReader.get(String.valueOf(string) + "MinRange", 500);
                n4 = configReader.get(String.valueOf(string) + "CenterX", 0);
                n3 = configReader.get(String.valueOf(string) + "CenterZ", 0);
                bl5 = configReader.get(String.valueOf(string) + "Circle", Boolean.valueOf(false));
                bl4 = configReader.get(String.valueOf(string) + "IgnoreWater", Boolean.valueOf(true));
                bl3 = configReader.get(String.valueOf(string) + "IgnoreLava", Boolean.valueOf(true));
                bl2 = configReader.get(String.valueOf(string) + "ignorePowderSnow", Boolean.valueOf(false));
                bl = configReader.get(String.valueOf(string) + "surfaceOnly", Boolean.valueOf(false));
                n2 = configReader.get(String.valueOf(string) + "minY", CMIWorld.getMinHeight((World)object3));
                n = configReader.get(String.valueOf(string) + "maxY", CMIWorld.getMaxHeight((World)object3));
                randomTeleport = new RandomTeleport(n7 != 0, n6, n5, new CMILocation((World)object3, (double)n4, (double)(CMIWorld.getMaxHeight((World)object3) / 2), (double)n3));
                randomTeleport.setCircle(bl5);
                randomTeleport.setCircle(bl5).setIgnoreLava(bl3).setIgnoreWater(bl4).setIgnorePowderSnow(bl2).setMinY(n2).setMaxY(n).setSurfaceOnly(bl);
                this.randomTeleports.put(object3.getName(), randomTeleport);
            }
        }
        configReader.addComment("RandomTeleportation.Cooldown", new String[]{"How long force player to wait before using command again."});
        this.randomTeleportCooldown = configReader.get("RandomTeleportation.Cooldown", 5);
        configReader.addComment("RandomTeleportation.MaxTries", new String[]{"How many times to try find correct location for teleportation.", "Keep it at low number, as player always can try again after delay"});
        this.randomTeleportMaxTries = configReader.get("RandomTeleportation.MaxTries", 20);
        configReader.addComment("RandomTeleportation.ExcludedBiomes", new String[]{"List of biomes to exclude from random teleportation"});
        object3 = configReader.get("RandomTeleportation.ExcludedBiomes", Arrays.asList("Ocean", "Deep ocean"));
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = (String)iterator.next();
            object2 = ((String)object2).replace(" ", "").replace("_", "");
            Biome[] biomeArray = Biome.values();
            n6 = biomeArray.length;
            n7 = 0;
            while (n7 < n6) {
                string = biomeArray[n7];
                if (string.name().replace("_", "").equalsIgnoreCase((String)object2)) {
                    this.randomTeleportExcludedBiomes.add((Biome)string);
                }
                n7 += 1;
            }
        }
        configReader.save();
    }

    public RandomTeleport getRandomTeleport(World world2) {
        return this.getRandomTeleport(world2, false);
    }

    public RandomTeleport getRandomTeleport(World world2, boolean bl) {
        RandomTeleport randomTeleport = this.randomTeleports.get(world2.getName());
        return randomTeleport == null ? null : (randomTeleport.isEnabled() && randomTeleport.getCenter().getWorld() != null ? randomTeleport : (bl ? randomTeleport : null));
    }

    public HashMap<String, RandomTeleport> getRandomTeleports() {
        return this.randomTeleports;
    }

    public int getRandomTeleportMaxTries() {
        return this.randomTeleportMaxTries;
    }

    public int getRandomTeleportCooldown() {
        return this.randomTeleportCooldown;
    }

    public List<Biome> getRandomTeleportExcludedBiomes() {
        return this.randomTeleportExcludedBiomes;
    }

    public void clearRLCache() {
        this.randomLocCache.clear();
    }

    public void fillRLCache() {
        for (World world2 : Bukkit.getWorlds()) {
            RandomTeleport randomTeleport = this.getRandomTeleport(world2);
            if (randomTeleport == null) continue;
            this.fillRLCache(world2);
        }
    }

    private void fillRLCache(World world2) {
        this.fillRLCache(world2.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CMILocation fillRLCache(String string) {
        if (this.cacheFilling.contains(string)) {
            return null;
        }
        try {
            List<Object> list2 = this.randomLocCache.get(string);
            if (list2 == null) {
                list2 = Collections.synchronizedList(new ArrayList());
                this.randomLocCache.put(string, list2);
            }
            Random random = new Random(System.nanoTime());
            World world2 = Bukkit.getWorld((String)string);
            int n = 0;
            RandomTeleport randomTeleport = this.getRandomTeleport(world2);
            if (randomTeleport == null) {
                return null;
            }
            block4: while (list2.size() < 5 && n <= 20) {
                ++n;
                boolean bl = false;
                double d = 0.0;
                Location location = null;
                double d2 = 0.0;
                double d3 = 0.0;
                int n2 = randomTeleport.getMinDistance();
                int n3 = randomTeleport.getMaxDistance();
                if (n3 < 1) {
                    n3 = 1;
                }
                if (n3 <= n2) {
                    n3 = n2 + 1;
                }
                int n4 = this.getRandomTeleportMaxTries();
                int n5 = this.plugin.getUtilManager().getMaxWorldHeight(world2);
                while (!bl && !((d += 1.0) > (double)n4)) {
                    try {
                        if (randomTeleport.isCircle()) {
                            double d4 = Math.random() * 2.0 * Math.PI;
                            double d5 = (double)(n3 - n2) * Math.sqrt(Math.random()) + (double)n2;
                            d2 = d5 * Math.cos(d4);
                            d3 = d5 * Math.sin(d4);
                            d2 = (double)((int)d2) + 0.5 + randomTeleport.getCenter().getX();
                            d3 = (double)((int)d3) + 0.5 + randomTeleport.getCenter().getZ();
                        } else {
                            int n6 = (n3 - n2) * 2;
                            d2 = random.nextInt(n6);
                            d2 = d2 > (double)n6 / 2.0 ? d2 - (double)n6 / 2.0 : -d2;
                            d2 = d2 > 0.0 ? d2 + (double)n2 : d2 - (double)n2;
                            d2 += (double)randomTeleport.getCenter().getBlockX();
                            d3 = random.nextInt(n6);
                            d3 = d3 > (double)n6 / 2.0 ? d3 - (double)n6 / 2.0 : -d3;
                            d3 = d3 > 0.0 ? d3 + (double)n2 : d3 - (double)n2;
                            d3 += (double)randomTeleport.getCenter().getBlockZ();
                        }
                        location = new Location(world2, d2, (double)(world2.getEnvironment().equals((Object)World.Environment.NETHER) ? n5 - 10 : n5 / 2), d3);
                        CompletableFuture completableFuture = PaperLib.getChunkAtAsync((Location)location, (boolean)true);
                        Chunk chunk = (Chunk)completableFuture.get();
                        Block block = chunk.getBlock(location.getBlockX() & 0xF, location.getBlockY(), location.getBlockZ() & 0xF);
                        if (this.getRandomTeleportExcludedBiomes().contains(block.getBiome())) continue;
                        int n7 = random.nextInt(359);
                        location.setYaw((float)n7);
                        Location location2 = location.clone();
                        if (location2 == null || (location2 = this.plugin.getTeleportations().getDownLocationSimple(location2)) == null) continue;
                        if (location2.getY() < 2.0) {
                            if (location2.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                                location2.setY((double)(CMI.getInstance().getUtilManager().getMaxWorldHeight(location2.getWorld()) / 2));
                            } else {
                                location2.setY((double)location2.getWorld().getHighestBlockYAt(location));
                            }
                        }
                        if (location2.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && location2.getY() > 128.0 || (double)randomTeleport.getMinY() > location2.getY() || (double)randomTeleport.getMaxY() < location2.getY()) continue;
                        CMIBlock cMIBlock = new CMIBlock(location2.clone().add(0.0, -2.0, 0.0).getBlock());
                        if (randomTeleport.isIgnoreWater() && cMIBlock.isWaterlogged() || randomTeleport.isIgnoreLava() && (new CMILocation(location2.clone()).getBlockCMIType().isLava() || new CMILocation(location2.clone().add(0.0, -1.0, 0.0)).getBlockCMIType().isLava())) continue;
                        CMILocation cMILocation = new CMILocation(location2.add(0.5, 0.1, 0.5));
                        list2.add(cMILocation.clone());
                        this.randomLocCache.put(string, list2);
                        continue block4;
                    }
                    catch (Error | Exception throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        this.cacheFilling.remove(string);
        return this.getRandomCachedLocation(Bukkit.getWorld((String)string));
    }

    public CMILocation getRandomCachedLocation(World world2) {
        List<CMILocation> list2;
        RandomTeleport randomTeleport = this.getRandomTeleport(world2);
        if (randomTeleport == null) {
            return null;
        }
        if (Version.isPaper() && (list2 = this.randomLocCache.get(world2.getName())) != null && !list2.isEmpty()) {
            return list2.remove(0).clone();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Location getRandomLocation(World var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = false;
        var3_3 = 0.0;
        var5_4 = this.getRandomTeleport(var1_1);
        if (var5_4 == null) {
            return null;
        }
        var6_5 = null;
        var7_6 = 0.0;
        var9_7 = 0.0;
        var11_8 = var5_4.getMinDistance();
        var12_9 = var5_4.getMaxDistance();
        if (var12_9 < 1) {
            var12_9 = 1;
        }
        if (var12_9 <= var11_8) {
            var12_9 = var11_8 + 1;
        }
        var13_10 = this.getRandomTeleportMaxTries();
        var14_11 = this.plugin.getUtilManager().getMaxWorldHeight(var1_1);
        var15_12 = null;
        try {
            var16_13 = var1_1.getWorldBorder().getCenter();
            var17_20 = var1_1.getWorldBorder().getSize();
            var19_22 = var16_13.toVector();
            var15_12 = new CuboidArea(var1_1);
            var15_12.setHighPoint(var19_22.clone().setY(600).setX(var19_22.getX() + var17_20).setZ(var19_22.getZ() + var17_20));
            var15_12.setLowPoint(var19_22.clone().setY(-600).setX(var19_22.getX() - var17_20).setZ(var19_22.getZ() - var17_20));
        }
        catch (Throwable var16_14) {
            // empty catch block
        }
        var13_10 = CMINumber.clamp((int)var13_10, (int)1, (int)50);
        while (!var2_2) {
            if ((var3_3 += 1.0) > (double)var13_10) {
                return null;
            }
            if (var5_4.isCircle()) {
                var16_15 = Math.random() * 2.0 * 3.141592653589793;
                var18_23 = (double)(var12_9 - var11_8) * Math.sqrt(Math.random()) + (double)var11_8;
                var7_6 = var18_23 * Math.cos(var16_15);
                var9_7 = var18_23 * Math.sin(var16_15);
                var7_6 = (double)((int)var7_6) + var5_4.getCenter().getX();
                var9_7 = (double)((int)var9_7) + var5_4.getCenter().getZ();
            } else {
                var16_16 = (var12_9 - var11_8) * 2;
                var7_6 = this.random.nextInt(var16_16);
                var7_6 = var7_6 > (double)var16_16 / 2.0 ? var7_6 - (double)var16_16 / 2.0 : -var7_6;
                var7_6 = var7_6 > 0.0 ? var7_6 + (double)var11_8 : var7_6 - (double)var11_8;
                var7_6 += (double)var5_4.getCenter().getBlockX();
                var9_7 = this.random2.nextInt(var16_16);
                var9_7 = var9_7 > (double)var16_16 / 2.0 ? var9_7 - (double)var16_16 / 2.0 : -var9_7;
                var9_7 = var9_7 > 0.0 ? var9_7 + (double)var11_8 : var9_7 - (double)var11_8;
                var9_7 += (double)var5_4.getCenter().getBlockZ();
            }
            var6_5 = new Location(var1_1, var7_6, (double)(var1_1.getEnvironment().equals((Object)World.Environment.NETHER) != false ? var14_11 - 10 : var14_11 / 2), var9_7);
            if (var6_5.getBlockY() > var5_4.getMaxY()) {
                var6_5.setY((double)var5_4.getMaxY());
            }
            if (var15_12 != null && !var15_12.containsLoc(var6_5)) continue;
            try {
                if (this.getRandomTeleportExcludedBiomes().contains(var6_5.getBlock().getBiome())) {
                    continue;
                }
                ** GOTO lbl-1000
            }
            catch (Throwable var16_17) {
                try lbl-1000:
                // 2 sources

                {
                    var16_18 = this.random.nextInt(359);
                    var6_5.setYaw((float)var16_18);
                    var17_21 = var6_5.clone();
                    if (var17_21 == null || (var17_21 = this.plugin.getTeleportations().getDownLocationSimple(var17_21, var5_4.isSurfaceOnly())) == null) continue;
                    if (var17_21.getY() < (double)(CMIWorld.getMinHeight((World)var17_21.getWorld()) + 4)) {
                        if (var17_21.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                            var17_21.setY((double)(CMI.getInstance().getUtilManager().getMaxWorldHeight(var17_21.getWorld()) / 2));
                        } else if (Version.isPaper()) {
                            var18_24 = PaperLib.getChunkAtAsync((Location)var6_5, (boolean)true);
                            var19_22 = (Chunk)var18_24.get();
                            var20_26 = var19_22.getChunkSnapshot().getHighestBlockYAt(var6_5.getBlockX() & 15, var6_5.getBlockZ() & 15) - 1;
                            var17_21.setY((double)var20_26);
                        } else {
                            var17_21.setY((double)var6_5.getWorld().getHighestBlockYAt(var6_5));
                        }
                    }
                    if (var17_21.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) && var17_21.getY() > 128.0 || (double)var5_4.getMinY() > var17_21.getY() || (double)var5_4.getMaxY() < var17_21.getY()) continue;
                    var18_25 = null;
                    if (Version.isPaper()) {
                        var19_22 = PaperLib.getChunkAtAsync((Location)var6_5, (boolean)true);
                        var20_27 = (Chunk)var19_22.get();
                        var21_28 = var17_21.clone().add(0.0, -1.0, 0.0);
                        var22_29 = var20_27.getBlock(var21_28.getBlockX() - var20_27.getX() * 16, var21_28.getBlockY(), var21_28.getBlockZ() - var20_27.getZ() * 16);
                        var18_25 = new CMIBlock(var22_29);
                    } else {
                        var18_25 = new CMIBlock(var17_21.clone().add(0.0, -1.0, 0.0).getBlock());
                    }
                    if (var5_4.isIgnoreWater() && var18_25.isWaterlogged() || var5_4.isIgnoreLava() && new CMILocation(var17_21.clone().add(0.0, -1.0, 0.0)).getBlockCMIType().isLava() || var5_4.isIgnorePowderedSnow() && CMIMaterial.get((Block)var17_21.getBlock()).equals((Object)CMIMaterial.POWDER_SNOW)) continue;
                    return var17_21.add(0.5, 0.1, 0.5);
                }
                catch (Throwable var16_19) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

