/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Chat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Modules.Chat.CMIChatBubble;
import java.util.HashMap;
import java.util.Set;
import java.util.UUID;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ChatBubbleManager {
    private HashMap<UUID, CMIChatBubble> bubbles = new HashMap();
    private CMI plugin;
    private boolean publicMessages = true;
    private double offset = 2.5;
    private double baseShowFor = 5.0;
    private double maxShowFor = 8.0;
    private double extraTime = 0.02;
    private double scale = 0.5;
    private boolean shadow = true;
    private int range = 32;
    private Color backgroundColor;
    private int LineWidth = 255;

    public ChatBubbleManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig(ConfigReader configReader) {
        if (Version.isCurrentEqualOrLower((Version)Version.v1_19_R2)) {
            configReader.addComment("ChatBubble", new String[]{" ", "ONLY works for servers 1.19.4 and above!", " "});
        }
        configReader.addComment("ChatBubble.PublicMessages", new String[]{"Do you want to enable chat bubbles for public messages", "Each player can disable this with /options command personally"});
        this.publicMessages = configReader.get("ChatBubble.PublicMessages", Boolean.valueOf(true));
        configReader.addComment("ChatBubble.Offset", new String[]{"How high we should show chat bubble"});
        this.offset = configReader.get("ChatBubble.Offset", Double.valueOf(2.5));
        configReader.addComment("ChatBubble.ShowFor", new String[]{"Base time in seconds for chat bubble to be visible"});
        this.baseShowFor = configReader.get("ChatBubble.ShowFor", 4);
        configReader.addComment("ChatBubble.MaxShowFor", new String[]{"Maximum time bubble will be shown for"});
        this.maxShowFor = configReader.get("ChatBubble.MaxShowFor", 8);
        configReader.addComment("ChatBubble.ExtraTime", new String[]{"Extra seconds to be added for each letter in a message", "This will allow to have shorter times for short messages and increase it for longer ones"});
        this.extraTime = configReader.get("ChatBubble.ExtraTime", Double.valueOf(0.02));
        configReader.addComment("ChatBubble.Scale", new String[]{"Scale of chat bubble, default 0.5"});
        this.scale = configReader.get("ChatBubble.Scale", Double.valueOf(0.5));
        configReader.addComment("ChatBubble.LineWidth", new String[]{"Line width before warping text to new line"});
        this.LineWidth = configReader.get("ChatBubble.LineWidth", 255);
        configReader.addComment("ChatBubble.BackgroundColor", new String[]{"Default Color code, this could be overriden if text itself was colorized", "Leave it empty for default transparent color", "Example of color code: {#gray}"});
        CMIChatColor cMIChatColor = CMIChatColor.getColor((String)configReader.get("ChatBubble.BackgroundColor", "{#gray}"));
        if (cMIChatColor != null) {
            this.backgroundColor = cMIChatColor.getRGBColor();
        }
        configReader.addComment("ChatBubble.Shadow", new String[]{"Do you want to add text shadow"});
        this.shadow = configReader.get("ChatBubble.Shadow", Boolean.valueOf(true));
    }

    public void showBubble(Player player, String string, Set<Player> set) {
        if (!this.publicMessages) {
            return;
        }
        if (Version.isCurrentEqualOrLower((Version)Version.v1_19_R2)) {
            return;
        }
        CMIChatBubble cMIChatBubble = this.bubbles.get(player.getUniqueId());
        if (!set.isEmpty()) {
            if (cMIChatBubble != null) {
                cMIChatBubble.delete();
            }
            try {
                CMIChatBubble cMIChatBubble2 = new CMIChatBubble(player, string, set);
                cMIChatBubble2.show();
                this.bubbles.put(player.getUniqueId(), cMIChatBubble2);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public double getOffset() {
        return this.offset;
    }

    public double getShowFor(String string) {
        double d = this.baseShowFor + (double)string.length() * this.extraTime;
        return CMINumber.clamp((double)d, (double)d, (int)((int)this.maxShowFor));
    }

    public boolean inRange(Location location, Location location2) {
        if (!location.getWorld().equals(location2.getWorld())) {
            return false;
        }
        if (Math.abs(location.getX() - location2.getX()) > 32.0) {
            return false;
        }
        if (Math.abs(location.getY() - location2.getY()) > 32.0) {
            return false;
        }
        return !(Math.abs(location.getZ() - location2.getZ()) > 32.0);
    }

    public double getScale() {
        return this.scale;
    }

    public int getLineWidth() {
        return this.LineWidth;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public boolean isShadow() {
        return this.shadow;
    }
}

