/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.DynMap;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Hooks.CMIHookType;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import org.bukkit.entity.Player;
import org.dynmap.DynmapCommonAPI;

public class DynMapManager {
    private CMI plugin;
    private DynmapCommonAPI dynmap;

    public DynMapManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void init() {
        if (!CMIHookType.dynmap.isEnabled()) {
            return;
        }
        try {
            this.dynmap = (DynmapCommonAPI)CMIHookType.dynmap.getPlugin();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            CMIHookType.dynmap.setEnabled(false);
        }
    }

    public void processPlayer(Player player) {
        this.processPlayer(this.plugin.getPlayerManager().getUser(player));
    }

    public void processPlayer(CMIUser cMIUser) {
        if (!CMIHookType.dynmap.isEnabled()) {
            return;
        }
        if (cMIUser == null) {
            return;
        }
        if (this.dynmap == null) {
            return;
        }
        if (cMIUser.isVanished() && !cMIUser.hasPermission(PermissionsManager.CMIPerm.dynmap_hidden)) {
            return;
        }
        String string = cMIUser.getName();
        if (string == null) {
            return;
        }
        this.dynmap.assertPlayerInvisibility(string, cMIUser.isVanished(), "CMIVanish");
    }

    public void sentMessage(Player player, String string) {
        if (!CMIHookType.dynmap.isEnabled()) {
            return;
        }
        try {
            this.dynmap.postPlayerMessageToWeb(player.getName(), player.getName(), string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

