/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.MoneyCheque;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.AttachedCommands.CustomNBTManager;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.cheque;
import com.Zrips.CMI.events.CMIAnvilItemRenameEvent;
import com.Zrips.CMI.events.CMIChequeUsageEvent;
import com.Zrips.CMI.utils.CMIEncoder;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class MoneyChequeListener
implements Listener {
    private CMI plugin;

    public MoneyChequeListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerInteractOneTime(PlayerInteractEvent playerInteractEvent) {
        try {
            if (Version.isCurrentHigher((Version)Version.v1_8_R3) && playerInteractEvent.getHand() != EquipmentSlot.HAND) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemStack itemStack = CMILib.getInstance().getReflectionManager().getItemInMainHand(playerInteractEvent.getPlayer());
        if (itemStack == null || !itemStack.getType().equals((Object)Material.PAPER)) {
            return;
        }
        Player player = playerInteractEvent.getPlayer();
        CMINBT cMINBT = new CMINBT(CMILib.getInstance().getReflectionManager().getItemInMainHand(player));
        Long l = cMINBT.getLong(CustomNBTManager.CustomNBTType.MoneyCheque.name());
        if (l != null && !this.plugin.getEconomyManager().isChequeAcceptNotEncoded()) {
            CMILC.info(cheque.class, (CommandSender)player, "clarification", new Object[0]);
            return;
        }
        if (l == null && cMINBT.hasNBT(CustomNBTManager.CustomNBTType.CMICheque.name())) {
            try {
                l = Long.parseLong(CMIEncoder.decode(cMINBT.getString(CustomNBTManager.CustomNBTType.CMICheque.name())));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (l == null) {
            return;
        }
        Block block = playerInteractEvent.getClickedBlock();
        CMIMaterial cMIMaterial = CMIMaterial.get((Block)block);
        if (cMIMaterial.equals((Object)CMIMaterial.CHEST) || cMIMaterial.equals((Object)CMIMaterial.TRAPPED_CHEST) || cMIMaterial.equals((Object)CMIMaterial.ENDER_CHEST) || cMIMaterial.isDoor() || cMIMaterial.isTrapDoor() || cMIMaterial.isGate() || cMIMaterial.isButton()) {
            return;
        }
        if (this.plugin.getEconomyManager().isChequeRequiresPermission() && !PermissionsManager.CMIPerm.command_cheque_withdraw.hasPermission((CommandSender)player, true, new String[0])) {
            return;
        }
        if (!this.plugin.getEconomyManager().isChequeInCreative() && player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            LC.info_cantDoInGamemode.sendMessage((Object)player, new Object[0]);
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        CMIChequeUsageEvent cMIChequeUsageEvent = new CMIChequeUsageEvent(player, itemStack, l.longValue());
        Bukkit.getPluginManager().callEvent((Event)cMIChequeUsageEvent);
        if (cMIChequeUsageEvent.isCancelled()) {
            playerInteractEvent.setCancelled(true);
            return;
        }
        itemStack = cMIChequeUsageEvent.getCheque();
        l = (long)cMIChequeUsageEvent.getPrice();
        cMIUser.deposit(l.doubleValue());
        CMILC.info(cheque.class, (CommandSender)player, "transferred", "[amount]", this.plugin.getEconomyManager().format(l.doubleValue()), "[balance]", cMIUser.getFormatedBalance());
        if (itemStack.getAmount() > 1) {
            itemStack.setAmount(itemStack.getAmount() - 1);
        } else {
            itemStack = null;
        }
        CMILib.getInstance().getReflectionManager().setItemInMainHand(player, itemStack);
        playerInteractEvent.setCancelled(true);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void playerInteractOneTime(CMIAnvilItemRenameEvent cMIAnvilItemRenameEvent) {
        ItemStack itemStack = cMIAnvilItemRenameEvent.getItemTo();
        if (itemStack == null || !itemStack.getType().equals((Object)Material.PAPER)) {
            return;
        }
        CMINBT cMINBT = new CMINBT(itemStack);
        if (!cMINBT.hasNBT(CustomNBTManager.CustomNBTType.MoneyCheque.name()) && !cMINBT.hasNBT(CustomNBTManager.CustomNBTType.CMICheque.name())) {
            return;
        }
        cMIAnvilItemRenameEvent.setCancelled(true);
    }
}

