/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayTime;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.PlayTime.CMIPlayDay;
import com.Zrips.CMI.Modules.PlayTime.PlayTimeManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class CMIPlayTime {
    TreeMap<Integer, CMIPlayDay> map = new TreeMap(Collections.reverseOrder());
    private Set<CMIPlayDay> forSave = new HashSet<CMIPlayDay>();
    private CMIUser user;

    public CMIPlayTime(CMIUser cMIUser) {
        this.user = cMIUser;
    }

    public TreeMap<Integer, CMIPlayDay> getDays() {
        return this.map;
    }

    public CMIPlayDay getPlayDay(Integer n) {
        CMIPlayDay cMIPlayDay = this.map.get(n);
        if (cMIPlayDay == null) {
            cMIPlayDay = new CMIPlayDay(this.user, n);
            this.map.put(n, cMIPlayDay);
        }
        return cMIPlayDay;
    }

    public CMIPlayDay getPlayDayOfToday() {
        Integer n = PlayTimeManager.PlaytimeRange.today.getStartTime();
        CMIPlayDay cMIPlayDay = this.map.get(n);
        if (cMIPlayDay == null) {
            cMIPlayDay = new CMIPlayDay(this.user, n);
            this.map.put(n, cMIPlayDay);
            this.checkYestarday();
        }
        return cMIPlayDay;
    }

    private void checkYestarday() {
        Integer n = PlayTimeManager.PlaytimeRange.yesterday.getStartTime();
        CMIPlayDay cMIPlayDay = this.map.get(n);
        if (cMIPlayDay == null) {
            return;
        }
        cMIPlayDay.checkPreviousHour(23);
        this.forSave.add(cMIPlayDay);
    }

    public void addDayForSave(CMIPlayDay cMIPlayDay) {
        this.forSave.add(cMIPlayDay);
    }

    public void updatePlayTime() {
        this.updatePlayTime(true);
    }

    public void updatePlayTime(boolean bl) {
        long l;
        if (!CMI.getInstance().getConfigManager().isCMIPlayTimeTracking()) {
            return;
        }
        if (!this.map.containsKey(0) && (l = this.user.getTotalPlayTime(true)) > 0L) {
            this.getPlayDay(0).setHourPlaytime(0, l, true);
            this.forSave.add(this.getPlayDay(0));
        }
        if (bl && this.user.isOnline() || !bl) {
            CMIPlayDay cMIPlayDay = this.getPlayDayOfToday();
            cMIPlayDay.updatePlayTime();
            this.forSave.add(cMIPlayDay);
        }
    }

    public Long getPlayTime(PlayTimeManager.PlaytimeRange playtimeRange) {
        Integer n = 0;
        switch (playtimeRange) {
            case thisweek: 
            case week: 
            case thismonth: 
            case month: 
            case thisyear: 
            case year: 
            case total: {
                n = playtimeRange.getStartTime();
                break;
            }
            case thishour: {
                Long l = this.getPlayDay(PlayTimeManager.PlaytimeRange.today.getStartTime()).getHourPlaytime(PlayTimeManager.PlaytimeRange.thishour.getStartTime());
                return l;
            }
            case hourback: {
                Long l = playtimeRange.getCache(this.user.getUniqueId());
                if (l == null) {
                    Integer n2 = PlayTimeManager.PlaytimeRange.hourback.equals(23) ? PlayTimeManager.PlaytimeRange.yesterday.getStartTime() : PlayTimeManager.PlaytimeRange.today.getStartTime();
                    CMIPlayDay cMIPlayDay = this.getPlayDay(n2);
                    l = cMIPlayDay.getHourPlaytime(PlayTimeManager.PlaytimeRange.hourback.getStartTime());
                    l = l == null ? 0L : l;
                    playtimeRange.setCache(this.user.getUniqueId(), l);
                }
                return l;
            }
            case today: {
                return this.getPlayDay(PlayTimeManager.PlaytimeRange.today.getStartTime()).getTotalTime();
            }
            case yesterday: {
                Long l = playtimeRange.getCache(this.user.getUniqueId());
                if (l == null) {
                    l = this.getPlayDay(PlayTimeManager.PlaytimeRange.yesterday.getStartTime()).getTotalTime();
                    l = l == null ? 0L : l;
                    playtimeRange.setCache(this.user.getUniqueId(), l);
                    return l;
                }
                return l;
            }
        }
        switch (playtimeRange) {
            case thisweek: 
            case week: 
            case thismonth: 
            case month: 
            case thisyear: 
            case year: 
            case total: {
                Long l = playtimeRange.getCache(this.user.getUniqueId());
                if (l == null) {
                    int n3 = 0;
                    for (Map.Entry<Integer, CMIPlayDay> entry : this.getDays().entrySet()) {
                        if (n3 == 0) {
                            ++n3;
                            continue;
                        }
                        if (entry.getKey() < n) break;
                        if (l == null) {
                            l = 0L;
                        }
                        l = l + entry.getValue().getTotalTime();
                        ++n3;
                    }
                    l = l == null ? 0L : l;
                    playtimeRange.setCache(this.user.getUniqueId(), l);
                }
                return l + this.getPlayTime(PlayTimeManager.PlaytimeRange.today);
            }
        }
        return 0L;
    }

    public Long getTotalPlayTime() {
        Long l = 0L;
        for (Map.Entry<Integer, CMIPlayDay> entry : this.map.entrySet()) {
            l = l + entry.getValue().getTotalTime();
        }
        return l;
    }

    public Set<CMIPlayDay> getForSave() {
        return this.forSave;
    }
}

