/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Recipes;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.commands.list.recipe;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.Zrips.CMILib.Container.CMINamespacedKey;
import net.Zrips.CMILib.Container.PageInfo;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.GUI.CMIGui;
import net.Zrips.CMILib.GUI.CMIGuiButton;
import net.Zrips.CMILib.GUI.GUIManager;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import net.Zrips.CMILib.Messages.CMIMessages;
import net.Zrips.CMILib.Recipes.CMIRecipe;
import net.Zrips.CMILib.Recipes.CMIRecipeChoice;
import net.Zrips.CMILib.Recipes.CMIRecipeCraftData;
import net.Zrips.CMILib.Recipes.CMIRecipeIngredient;
import net.Zrips.CMILib.Recipes.CMIRecipeType;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.FurnaceRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.SmithingRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.plugin.Plugin;

public class RecipeManager {
    private CMI plugin;
    private boolean RecipesRequireBackwards;
    private boolean Recipes4Sized;
    private HashMap<String, Recipe> disabledRecipes = new HashMap();
    private Integer GUIRecipeResultSlot = 24;
    private List<CMIRecipe> recipes = new ArrayList<CMIRecipe>();
    private String fileName = "Recipes.yml";

    public RecipeManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        ConfigReader configReader = this.plugin.getConfigManager().getConfig();
        configReader.addComment("Recipes.Condense.RequireBackwards", new String[]{"When enabled trying to condsense or uncondense we will check for backwards recipe and will not allow to perform those actions if player is unable to revert his actions", "While disabled we will ignore backwards recipe check", "Keep in mind that disabling might result in unpredicted behavior where 4 wood planks gets converted into workbench"});
        this.RecipesRequireBackwards = configReader.get("Recipes.Condense.RequireBackwards", Boolean.valueOf(true));
        configReader.addComment("Recipes.Condense.4Sized", new String[]{"Should we condense recipes with 4 same ingredients", "While this is enabled and RequireBackwards disabled then oak plants might be converted into workbenches"});
        this.Recipes4Sized = configReader.get("Recipes.Condense.4Sized", Boolean.valueOf(true));
    }

    public CMIRecipe getById(String string) {
        if (string == null) {
            return null;
        }
        for (CMIRecipe cMIRecipe : this.recipes) {
            if (!cMIRecipe.getIdentificator().equals(string)) continue;
            return cMIRecipe;
        }
        return null;
    }

    public boolean removeRecipe(CMIRecipe cMIRecipe) {
        this.recipes.remove(cMIRecipe);
        this.saveRecipes();
        return true;
    }

    public Recipe addRecipe(CMIRecipeType cMIRecipeType, ItemStack itemStack, HashMap<Integer, CMIRecipeIngredient> hashMap) {
        return this.addRecipe(cMIRecipeType, itemStack, hashMap, null);
    }

    public Recipe addRecipe(CMIRecipeType cMIRecipeType, ItemStack itemStack, HashMap<Integer, CMIRecipeIngredient> hashMap, CMIRecipeCraftData cMIRecipeCraftData) {
        return this.addRecipe(cMIRecipeType, itemStack, hashMap, cMIRecipeCraftData, null);
    }

    public Recipe addRecipe(CMIRecipeType cMIRecipeType, ItemStack itemStack, HashMap<Integer, CMIRecipeIngredient> hashMap, CMIRecipeCraftData cMIRecipeCraftData, String string) {
        Recipe recipe2 = CMIRecipe.createRecipe((CMIRecipeType)cMIRecipeType, (ItemStack)itemStack, hashMap, (CMIRecipeCraftData)cMIRecipeCraftData, (String)string);
        if (recipe2 == null) {
            return null;
        }
        this.addRecipe(cMIRecipeType, recipe2, cMIRecipeCraftData);
        return recipe2;
    }

    @Deprecated
    public Recipe addRecipe(CMIRecipeType cMIRecipeType, Recipe recipe2) {
        return this.addRecipe(cMIRecipeType, recipe2, null);
    }

    public Recipe addRecipe(CMIRecipeType cMIRecipeType, Recipe recipe2, CMIRecipeCraftData cMIRecipeCraftData) {
        return this.addRecipe(cMIRecipeType, recipe2, cMIRecipeCraftData, null);
    }

    public Recipe addRecipe(CMIRecipeType cMIRecipeType, Recipe recipe2, CMIRecipeCraftData cMIRecipeCraftData, String string) {
        if (recipe2 == null) {
            return null;
        }
        CMINamespacedKey cMINamespacedKey = CMINamespacedKey.getKey((Recipe)recipe2);
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) && CMIRecipe.getRecipe((CMINamespacedKey)cMINamespacedKey) != null) {
            CMIMessages.consoleMessage((String)("Tried to add recipe with " + cMINamespacedKey.toString() + " key which already exists. Skipping"));
            return recipe2;
        }
        Bukkit.getServer().addRecipe(recipe2);
        CMIRecipe cMIRecipe = new CMIRecipe(cMINamespacedKey.getKey(), cMIRecipeType).setRecipe(recipe2).setData(cMIRecipeCraftData);
        cMIRecipe.setCustomKey(string);
        this.recipes.add(cMIRecipe);
        this.saveRecipes();
        return recipe2;
    }

    /*
     * WARNING - void declaration
     */
    public Recipe exist(Recipe recipe2) {
        Iterator iterator = Bukkit.recipeIterator();
        block0: while (iterator.hasNext()) {
            void var9_13;
            Object object;
            void var9_11;
            ItemStack itemStack22;
            ShapelessRecipe shapelessRecipe;
            ShapelessRecipe shapelessRecipe2;
            Recipe recipe3 = (Recipe)iterator.next();
            if (recipe3.getResult().isSimilar(recipe2.getResult())) continue;
            if (recipe3 instanceof ShapelessRecipe && recipe2 instanceof ShapelessRecipe) {
                shapelessRecipe2 = (ShapelessRecipe)recipe3;
                shapelessRecipe = (ShapelessRecipe)recipe2;
                for (ItemStack itemStack22 : shapelessRecipe2.getIngredientList()) {
                    if (!shapelessRecipe.getIngredientList().contains(itemStack22)) continue block0;
                }
                return recipe3;
            }
            if (!(recipe3 instanceof ShapedRecipe) || !(recipe2 instanceof ShapedRecipe)) continue;
            shapelessRecipe2 = (ShapedRecipe)recipe3;
            shapelessRecipe = (ShapedRecipe)recipe2;
            itemStack22 = new HashMap();
            HashMap hashMap = new HashMap();
            String[] stringArray = shapelessRecipe2.getShape();
            boolean n = false;
            while (var9_11 < 9) {
                object = (ItemStack)shapelessRecipe2.getIngredientMap().get(Character.valueOf(stringArray[var9_11].charAt(0)));
                if (object != null) {
                    itemStack22.put((int)var9_11, object);
                }
                ++var9_11;
            }
            stringArray = shapelessRecipe.getShape();
            boolean bl = false;
            while (var9_13 < 9) {
                object = (ItemStack)shapelessRecipe.getIngredientMap().get(Character.valueOf(stringArray[var9_13].charAt(0)));
                if (object != null) {
                    hashMap.put((int)var9_13, object);
                }
                ++var9_13;
            }
            for (Map.Entry entry : itemStack22.entrySet()) {
                ItemStack itemStack = (ItemStack)hashMap.get(entry.getKey());
                if (itemStack == null || !itemStack.isSimilar((ItemStack)entry.getValue())) continue block0;
            }
            return recipe3;
        }
        return null;
    }

    public Recipe getRecipe(HashMap<Integer, ItemStack> hashMap) {
        ArrayList<ItemStack> arrayList = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, ItemStack> object2 : hashMap.entrySet()) {
            arrayList.add(object2.getValue());
        }
        Iterator iterator = Bukkit.recipeIterator();
        block1: while (iterator.hasNext()) {
            ItemStack itemStack;
            ItemStack itemStack22;
            ShapelessRecipe shapelessRecipe;
            Recipe recipe2 = (Recipe)iterator.next();
            if (recipe2 instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe2;
                for (ItemStack itemStack22 : shapelessRecipe.getIngredientList()) {
                    if (!arrayList.contains(itemStack22)) continue block1;
                }
                return recipe2;
            }
            if (!(recipe2 instanceof ShapedRecipe)) continue;
            shapelessRecipe = (ShapedRecipe)recipe2;
            itemStack22 = new HashMap();
            String[] stringArray = shapelessRecipe.getShape();
            int n = 0;
            int n2 = 0;
            while (n2 < 3) {
                if (stringArray.length <= n2) break;
                int n3 = 0;
                while (n3 < 3) {
                    ++n;
                    if (stringArray[n2].length() <= n3) break;
                    itemStack = (ItemStack)shapelessRecipe.getIngredientMap().get(Character.valueOf(stringArray[n2].charAt(n3)));
                    if (itemStack != null) {
                        itemStack22.put(n, itemStack);
                    }
                    ++n3;
                }
                ++n2;
            }
            for (Map.Entry n22 : itemStack22.entrySet()) {
                itemStack = hashMap.get(n22.getKey());
                if (itemStack == null || !itemStack.isSimilar((ItemStack)n22.getValue())) continue block1;
            }
            return recipe2;
        }
        return null;
    }

    private void saveRecipes() {
        if (!this.plugin.isFullyLoaded()) {
            return;
        }
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        yamlConfiguration.set("CRecipes", null);
        yamlConfiguration.set("Disabled", null);
        for (Recipe recipe2 : this.disabledRecipes.values()) {
            CMINamespacedKey cMINamespacedKey = CMINamespacedKey.getKey((Recipe)recipe2);
            yamlConfiguration.set("Disabled." + cMINamespacedKey.getKey(), (Object)cMINamespacedKey.getNamespace());
        }
        for (CMIRecipe cMIRecipe : this.recipes) {
            yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Type", (Object)cMIRecipe.getType().name());
            yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Result", (Object)cMIRecipe.getResult());
            if (cMIRecipe.getCustomKey() != null) {
                yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".CustomKey", (Object)cMIRecipe.getCustomKey());
            }
            for (Map.Entry entry : cMIRecipe.getIngredients().entrySet()) {
                yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Recipe." + entry.getKey() + ".item", (Object)((CMIRecipeIngredient)entry.getValue()).getItem());
                if (!((CMIRecipeIngredient)entry.getValue()).getChoice().equals((Object)CMIRecipeChoice.byItemStack)) continue;
                yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Recipe." + entry.getKey() + ".byItem", (Object)true);
            }
            if (!cMIRecipe.getType().isTimeAndExp() || !Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1) || cMIRecipe.getData() == null) continue;
            yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Cook", (Object)cMIRecipe.getData().getCookingTime());
            yamlConfiguration.set("CRecipes." + cMIRecipe.getIdentificator() + ".Exp", (Object)Float.valueOf(cMIRecipe.getData().getExp()));
        }
        try {
            yamlConfiguration.save(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void load() {
        long l = System.currentTimeMillis();
        CMI.getInstance().safeRenameFile(this.fileName.toLowerCase(), "Saves" + File.separator + this.fileName);
        File file = new File(this.plugin.getDataFolder(), "Saves" + File.separator + this.fileName);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file);
        if (!yamlConfiguration.isConfigurationSection("CRecipes")) {
            return;
        }
        Set set = yamlConfiguration.getConfigurationSection("CRecipes").getKeys(false);
        if (!set.isEmpty()) {
            try {
                Integer.parseInt((String)set.iterator().next());
                ConfigReader configReader = new ConfigReader((Plugin)this.plugin, "Saves" + File.separator + this.fileName);
                configReader.saveToBackup(false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        int n = 0;
        for (Object object : set) {
            void var15_21;
            CMIRecipeType cMIRecipeType;
            ConfigurationSection configurationSection = yamlConfiguration.getConfigurationSection("CRecipes." + (String)object);
            String string = null;
            if (configurationSection.isString("CustomKey")) {
                string = configurationSection.getString("CustomKey");
            }
            if ((cMIRecipeType = CMIRecipeType.getByName((String)configurationSection.getString("Type"))) == null) {
                this.plugin.consoleMessage("&cCant determine recipe type for " + (String)object);
                continue;
            }
            ItemStack itemStack = configurationSection.getItemStack("Result");
            if (itemStack == null) {
                this.plugin.consoleMessage("&cCant determine recipe result type for " + (String)object);
                continue;
            }
            if (!configurationSection.isConfigurationSection("Recipe")) {
                this.plugin.consoleMessage("&cCant determine recipe type for " + (String)object);
                continue;
            }
            Map map = configurationSection.getConfigurationSection("Recipe").getValues(false);
            HashMap<Integer, CMIRecipeIngredient> hashMap = new HashMap<Integer, CMIRecipeIngredient>();
            for (Map.Entry entry : map.entrySet()) {
                try {
                    if (entry.getValue() instanceof ItemStack) {
                        hashMap.put(Integer.parseInt((String)entry.getKey()) - 1, new CMIRecipeIngredient((ItemStack)entry.getValue()));
                        continue;
                    }
                    Map map2 = configurationSection.getConfigurationSection("Recipe." + (String)entry.getKey()).getValues(false);
                    CMIRecipeIngredient cMIRecipeIngredient = new CMIRecipeIngredient((ItemStack)map2.get("item"));
                    if (map2.containsKey("byItem")) {
                        cMIRecipeIngredient.setChoice((Boolean)map2.get("byItem") != false ? CMIRecipeChoice.byItemStack : CMIRecipeChoice.byMaterial);
                    }
                    hashMap.put(Integer.parseInt((String)entry.getKey()), cMIRecipeIngredient);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (hashMap.isEmpty()) {
                this.plugin.consoleMessage("&cCant determine recipe ingredients type for " + (String)object);
                continue;
            }
            Object var15_19 = null;
            if (configurationSection.isDouble("Exp") && configurationSection.isInt("Cook")) {
                CMIRecipeCraftData cMIRecipeCraftData = new CMIRecipeCraftData((float)configurationSection.getDouble("Exp"), configurationSection.getInt("Cook"));
            }
            ++n;
            this.addRecipe(cMIRecipeType, itemStack, hashMap, (CMIRecipeCraftData)var15_21, string);
        }
        if (n > 0) {
            this.plugin.loadMessage(n, "custom recipes", System.currentTimeMillis() - l);
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_16_R1) && yamlConfiguration.isConfigurationSection("Disabled")) {
            Object object;
            set = yamlConfiguration.getConfigurationSection("Disabled").getKeys(false);
            object = new HashMap();
            for (Object object2 : set) {
                if (!yamlConfiguration.isString("Disabled." + (String)object2)) continue;
                ((HashMap)object).put(object2, yamlConfiguration.getString("Disabled." + (String)object2));
            }
            CMIScheduler.runTaskLater(() -> this.lambda$0((HashMap)object), (long)20L);
        }
    }

    public Integer getGUIRecipeResultSlot() {
        return this.GUIRecipeResultSlot;
    }

    public List<CMIRecipe> getRecipes() {
        return this.recipes;
    }

    @Deprecated
    public void setRecipes(List<CMIRecipe> list2) {
        this.recipes = list2;
    }

    public Boolean openRecipeUI(Player player, CMIItemStack cMIItemStack, int n) {
        return this.openRecipeUI(player, cMIItemStack, n, false);
    }

    public Boolean openRecipeUI(Player player, CMIItemStack cMIItemStack, int n, boolean bl) {
        List list2 = cMIItemStack.getRecipesFor();
        list2.addAll(cMIItemStack.getRecipesFrom());
        if (PermissionsManager.CMIPerm.command_recipe_admin.hasPermission((CommandSender)player)) {
            list2.addAll(this.getDisabled(cMIItemStack.getItemStack()));
        }
        LinkedHashMap<String, Recipe> linkedHashMap = new LinkedHashMap<String, Recipe>();
        for (Recipe recipe2 : list2) {
            if (bl && CMINamespacedKey.getKey((Recipe)recipe2).toString().startsWith("minecraft:")) continue;
            linkedHashMap.put(CMINamespacedKey.getKey((Recipe)recipe2).getKey(), recipe2);
        }
        list2.clear();
        list2.addAll(linkedHashMap.values());
        return this.openRecipeUI(player, cMIItemStack, n, list2);
    }

    public Boolean openRecipeUI(final Player player, final CMIItemStack cMIItemStack, int n, final List<Recipe> list2) {
        if (n > list2.size()) {
            n = list2.size();
        }
        if (list2.isEmpty()) {
            CMILC.info(recipe.class.getSimpleName(), player, "noRecipes", new Object[0]);
            return null;
        }
        PageInfo pageInfo = new PageInfo(1, list2.size(), n);
        for (final Recipe recipe2 : list2) {
            Object object;
            Object object22;
            ShapelessRecipe shapelessRecipe;
            if (!pageInfo.isEntryOk()) continue;
            if (pageInfo.isBreak()) break;
            CMIGui cMIGui = new CMIGui(player){

                public void pageChange(int n) {
                    RecipeManager.this.openRecipeUI(player, cMIItemStack, n, list2);
                }

                public boolean click(int n, GUIManager.GUIClickType gUIClickType, ItemStack itemStack) {
                    if (n < 54) {
                        return true;
                    }
                    if (itemStack == null) {
                        return true;
                    }
                    RecipeManager.this.openRecipeUI(player, new CMIItemStack(itemStack), 1);
                    return true;
                }
            };
            cMIGui.addLock(GUIManager.InvType.Gui);
            cMIGui.addLock(GUIManager.InvType.Main);
            CMIRecipeType cMIRecipeType = CMIRecipeType.getByName((String)recipe2.getClass().getSimpleName());
            String string = CMILC.getIM(recipe.class.getSimpleName(), "type", "[type]", CMILC.getIM(recipe.class.getSimpleName(), "types." + cMIRecipeType, new Object[0]));
            if (list2.size() > 1) {
                string = String.valueOf(string) + CMILC.getIM(recipe.class.getSimpleName(), "page", "[current]", n, "[total]", list2.size());
            }
            cMIGui.setTitle(string);
            cMIGui.setInvSize(GUIManager.GUIRows.r6);
            cMIGui.setCmiInventoryType(GUIManager.CmiInventoryType.Recipes);
            if (recipe2 instanceof ShapelessRecipe) {
                shapelessRecipe = (ShapelessRecipe)recipe2;
                int n2 = 0;
                for (Object object22 : shapelessRecipe.getIngredientList()) {
                    Object object3;
                    object = object22.clone();
                    if (CMIMaterial.isPotion((Material)object.getType()) || object.getType().name().contains("SPLASH_POTION") || object.getType().name().contains("LINGERING_POTION")) {
                        object3 = (PotionMeta)object.getItemMeta();
                        object3.setDisplayName(CMIMaterial.get((ItemStack)object).getName());
                        object.setItemMeta((ItemMeta)object3);
                    }
                    object3 = (Integer)cMIRecipeType.getIngredientSlots().get(n2);
                    CMIGuiButton cMIGuiButton = new CMIGuiButton((Integer)object3, (ItemStack)object, (ItemStack)object22){
                        private final /* synthetic */ ItemStack val$oneI;
                        {
                            this.val$oneI = itemStack2;
                            super(n, itemStack);
                        }

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            RecipeManager.this.openRecipeUI(player, new CMIItemStack(this.val$oneI), 1);
                        }
                    };
                    cMIGui.addButton(cMIGuiButton);
                    ++n2;
                }
            } else if (recipe2 instanceof ShapedRecipe) {
                shapelessRecipe = (ShapedRecipe)recipe2;
                String[] stringArray = shapelessRecipe.getShape();
                int n3 = 0;
                int n4 = 0;
                while (n4 < 3) {
                    if (stringArray.length > n4) {
                        object = stringArray[n4];
                        int n5 = 0;
                        while (n5 < 3) {
                            if (((String)object).length() <= n5) {
                                ++n3;
                            } else {
                                char c = ((String)object).charAt(n5);
                                Integer n6 = (Integer)cMIRecipeType.getIngredientSlots().get(n3);
                                ItemStack itemStack = (ItemStack)shapelessRecipe.getIngredientMap().get(Character.valueOf(c));
                                if (itemStack == null) {
                                    ++n3;
                                } else {
                                    Object object4;
                                    final ItemStack itemStack2 = itemStack.clone();
                                    if (CMIMaterial.isPotion((Material)itemStack2.getType()) || itemStack2.getType().name().contains("SPLASH_POTION") || itemStack2.getType().name().contains("LINGERING_POTION")) {
                                        object4 = (PotionMeta)itemStack2.getItemMeta();
                                        object4.setDisplayName(CMIMaterial.get((ItemStack)itemStack2).getName());
                                        itemStack2.setItemMeta((ItemMeta)object4);
                                    }
                                    object4 = new CMIGuiButton(n6, itemStack2){

                                        public void click(GUIManager.GUIClickType gUIClickType) {
                                            RecipeManager.this.openRecipeUI(player, new CMIItemStack(itemStack2), 1);
                                        }
                                    };
                                    cMIGui.addButton((CMIGuiButton)object4);
                                    ++n3;
                                }
                            }
                            ++n5;
                        }
                        ++n4;
                        continue;
                    }
                    break;
                }
            } else if (recipe2 instanceof FurnaceRecipe) {
                shapelessRecipe = (FurnaceRecipe)recipe2;
                CMIGuiButton cMIGuiButton = new CMIGuiButton((Integer)cMIRecipeType.getIngredientSlots().get(0), shapelessRecipe.getInput(), (FurnaceRecipe)shapelessRecipe){
                    private final /* synthetic */ FurnaceRecipe val$rc;
                    {
                        this.val$rc = furnaceRecipe;
                        super(n, itemStack);
                    }

                    public void click(GUIManager.GUIClickType gUIClickType) {
                        RecipeManager.this.openRecipeUI(player, new CMIItemStack(this.val$rc.getInput()), 1);
                    }
                };
                cMIGui.addButton(cMIGuiButton);
                cMIGuiButton = new CMIGuiButton(Integer.valueOf((Integer)cMIRecipeType.getIngredientSlots().get(0) + 9), Material.LAVA_BUCKET);
                cMIGui.addButton(cMIGuiButton);
            } else {
                switch (cMIRecipeType) {
                    case Smithing: {
                        shapelessRecipe = (SmithingRecipe)recipe2;
                        CMIGuiButton cMIGuiButton = new CMIGuiButton((Integer)cMIRecipeType.getIngredientSlots().get(0), shapelessRecipe.getBase().getItemStack(), (SmithingRecipe)shapelessRecipe){
                            private final /* synthetic */ SmithingRecipe val$src;
                            {
                                this.val$src = smithingRecipe;
                                super(n, itemStack);
                            }

                            public void click(GUIManager.GUIClickType gUIClickType) {
                                RecipeManager.this.openRecipeUI(player, new CMIItemStack(this.val$src.getBase().getItemStack()), 1);
                            }
                        };
                        cMIGui.addButton(cMIGuiButton);
                        cMIGuiButton = new CMIGuiButton((Integer)cMIRecipeType.getIngredientSlots().get(1), shapelessRecipe.getAddition().getItemStack(), (SmithingRecipe)shapelessRecipe){
                            private final /* synthetic */ SmithingRecipe val$src;
                            {
                                this.val$src = smithingRecipe;
                                super(n, itemStack);
                            }

                            public void click(GUIManager.GUIClickType gUIClickType) {
                                RecipeManager.this.openRecipeUI(player, new CMIItemStack(this.val$src.getAddition().getItemStack()), 1);
                            }
                        };
                        cMIGui.addButton(cMIGuiButton);
                        break;
                    }
                    case Campfire: {
                        cMIGui.addButton(new CMIGuiButton(Integer.valueOf((Integer)cMIRecipeType.getIngredientSlots().get(0) + 9), CMIMaterial.CAMPFIRE));
                        break;
                    }
                    case Smoking: {
                        cMIGui.addButton(new CMIGuiButton(Integer.valueOf((Integer)cMIRecipeType.getIngredientSlots().get(0) + 9), CMIMaterial.COAL));
                        break;
                    }
                    default: {
                        final List list3 = CMIRecipe.getIngredientsList((Recipe)recipe2);
                        if (list3.isEmpty()) break;
                        CMIGuiButton cMIGuiButton = new CMIGuiButton((Integer)cMIRecipeType.getIngredientSlots().get(0), (ItemStack)list3.get(0)){

                            public void click(GUIManager.GUIClickType gUIClickType) {
                                RecipeManager.this.openRecipeUI(player, new CMIItemStack((ItemStack)list3.get(0)), 1);
                            }
                        };
                        cMIGui.addButton(cMIGuiButton);
                    }
                }
            }
            shapelessRecipe = new CMIGuiButton(CMI.getInstance().getRecipeManager().getGUIRecipeResultSlot(), recipe2.getResult());
            cMIGui.addButton((CMIGuiButton)shapelessRecipe);
            if (recipe2 instanceof ShapedRecipe || recipe2 instanceof ShapelessRecipe) {
                int n7 = 0;
                while (n7 < 9) {
                    object22 = (Integer)cMIRecipeType.getIngredientSlots().get(n7);
                    if (cMIGui.getButtons().get(object22) == null) {
                        shapelessRecipe = new CMIGuiButton((Integer)object22);
                        cMIGui.addButton((CMIGuiButton)shapelessRecipe);
                    }
                    ++n7;
                }
            }
            if (Version.isCurrentEqualOrHigher((Version)Version.v1_12_R1) && PermissionsManager.CMIPerm.command_recipe_admin.hasPermission((CommandSender)player)) {
                final CMINamespacedKey cMINamespacedKey = CMINamespacedKey.getKey((Recipe)recipe2);
                if (Bukkit.getServer().getRecipe(new NamespacedKey(cMINamespacedKey.getNamespace(), cMINamespacedKey.getKey())) != null || this.disabledRecipes.containsKey(cMINamespacedKey.getKey())) {
                    object22 = new CMIGuiButton(8, CMIMaterial.GREEN_WOOL){

                        public void click(GUIManager.GUIClickType gUIClickType) {
                            if (RecipeManager.this.disabledRecipes.containsKey(cMINamespacedKey.getKey())) {
                                Recipe recipe22 = (Recipe)RecipeManager.this.disabledRecipes.remove(cMINamespacedKey.getKey());
                                Bukkit.getServer().addRecipe(recipe22);
                            } else {
                                RecipeManager.this.disabledRecipes.put(cMINamespacedKey.getKey(), recipe2);
                                Bukkit.getServer().removeRecipe(new NamespacedKey(cMINamespacedKey.getNamespace(), cMINamespacedKey.getKey()));
                            }
                            this.updateLooks();
                            this.update();
                            RecipeManager.this.saveRecipes();
                        }

                        public void updateLooks() {
                            if (RecipeManager.this.disabledRecipes.containsKey(cMINamespacedKey.getKey())) {
                                this.setItem(CMIMaterial.YELLOW_WOOL);
                                this.setName(LC.modify_disabled.getLocale(new Object[0]));
                            } else {
                                this.setItem(CMIMaterial.GREEN_WOOL);
                                this.setName(LC.modify_enabled.getLocale(new Object[0]));
                            }
                        }
                    };
                    cMIGui.addButton((CMIGuiButton)object22);
                }
            }
            cMIGui.addPagination(pageInfo);
            cMIGui.fillEmptyButtons();
            cMIGui.open();
            return true;
        }
        return null;
    }

    private Set<Recipe> getDisabled(ItemStack itemStack) {
        HashSet<Recipe> hashSet = new HashSet<Recipe>();
        if (itemStack == null) {
            return hashSet;
        }
        itemStack = itemStack.clone();
        for (Recipe recipe2 : this.disabledRecipes.values()) {
            for (ItemStack itemStack2 : CMIRecipe.getIngredientsList((Recipe)recipe2)) {
                if (!itemStack2.isSimilar(itemStack)) continue;
                hashSet.add(recipe2);
                break;
            }
            if (!recipe2.getResult().isSimilar(itemStack)) continue;
            hashSet.add(recipe2);
        }
        return hashSet;
    }

    public boolean isRecipesRequireBackwards() {
        return this.RecipesRequireBackwards;
    }

    public boolean isRecipes4Sized() {
        return this.Recipes4Sized;
    }

    private /* synthetic */ void lambda$0(HashMap hashMap) {
        int n = 0;
        long l = System.currentTimeMillis();
        for (Map.Entry entry : hashMap.entrySet()) {
            CMINamespacedKey cMINamespacedKey = new CMINamespacedKey((String)entry.getValue(), (String)entry.getKey());
            Recipe recipe2 = CMIRecipe.getRecipe((CMINamespacedKey)cMINamespacedKey);
            if (recipe2 != null && (Version.isCurrentEqualOrLower((Version)Version.v1_14_R2) || Bukkit.getServer().removeRecipe(new NamespacedKey(cMINamespacedKey.getNamespace(), cMINamespacedKey.getKey())))) {
                this.disabledRecipes.put(cMINamespacedKey.getKey(), recipe2);
                ++n;
                continue;
            }
            CMIMessages.consoleMessage((String)("&eUnrecognized recipe which needs to be disabled (" + (String)entry.getKey() + ")"));
        }
        if (n > 0) {
            this.plugin.loadMessage(n, "disabled recipes", System.currentTimeMillis() - l);
        }
    }
}

