/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Warps;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.commands.list.warp;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Locale.LC;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CmiWarp {
    private CMILocation loc;
    private List<CMILocation> locations = null;
    private String name;
    private String displayName = null;
    private ItemStack item;
    private ItemStack offItem;
    private Integer slot;
    private Integer page = 1;
    private Boolean reqPerm = false;
    private Boolean showUnavailable = false;
    private Boolean autoLore = true;
    private boolean randomizeYaw = false;
    private boolean repeatingLocation = false;
    private String group = null;
    private boolean hidden = false;
    private UUID creator = null;
    private List<CMILocation> temp = null;

    public CmiWarp(String string) {
        this.name = string;
    }

    public void reset() {
        this.loc = null;
        this.item = null;
    }

    public CmiWarp(String string, CMILocation cMILocation) {
        this.name = string;
        this.loc = cMILocation;
    }

    public CMILocation getLoc() {
        this.loc.recheck();
        return this.loc;
    }

    public void resetQueue() {
        this.temp = null;
    }

    public CMILocation getLocIncRand() {
        CMILocation cMILocation = this.getLoc().clone();
        if (this.locations != null) {
            if (this.temp == null) {
                this.temp = new ArrayList<CMILocation>();
            }
            if (this.temp.isEmpty()) {
                this.temp.add(this.getLoc());
                this.temp.addAll(this.locations);
                Collections.shuffle(this.temp);
            }
            if (!this.temp.isEmpty()) {
                if (!this.repeatingLocation) {
                    cMILocation = this.temp.remove(0).clone();
                } else {
                    if (this.temp.size() < 1 + this.locations.size()) {
                        this.temp.clear();
                        this.temp.add(this.getLoc());
                        this.temp.addAll(this.locations);
                        Collections.shuffle(this.temp);
                    }
                    Collections.shuffle(this.temp);
                    cMILocation = this.temp.get(0).clone();
                }
            } else {
                cMILocation = this.getLoc().clone();
            }
        }
        if (cMILocation == null) {
            cMILocation = this.getLoc().clone();
        }
        if (this.isRandomizeYaw()) {
            cMILocation.setYaw((float)new Random().nextInt(359));
        }
        return cMILocation;
    }

    public String getName() {
        return this.name;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public ItemStack getIcon() {
        CMIMaterial cMIMaterial;
        ItemStack itemStack = null;
        if (this.getItem() == null) {
            CMIMaterial cMIMaterial2 = cMIMaterial = this.getItem() == null || this.getItem().getType().equals((Object)Material.AIR) ? null : CMIMaterial.get((ItemStack)this.getItem());
            if (cMIMaterial == null) {
                int n = new BigInteger(this.getName().getBytes()).intValue() % 3;
                CMIMaterial cMIMaterial3 = CMIMaterial.WHITE_WOOL;
                switch (n) {
                    case 1: {
                        cMIMaterial3 = CMIMaterial.WHITE_CARPET;
                        break;
                    }
                    case 2: {
                        cMIMaterial3 = CMIMaterial.WHITE_STAINED_GLASS;
                        break;
                    }
                    case 3: {
                        cMIMaterial3 = CMIMaterial.WHITE_BANNER;
                    }
                }
                cMIMaterial = CMIMaterial.getByColorId((CMIMaterial)cMIMaterial3, (int)(new BigInteger(this.getName().getBytes()).intValue() % 15));
            }
            if (cMIMaterial != null) {
                itemStack = cMIMaterial.newItemStack();
            }
        } else {
            itemStack = this.getItem();
        }
        if (itemStack == null || CMIMaterial.isAir((Material)itemStack.getType())) {
            itemStack = CMIMaterial.getRandom((CMIMaterial)CMIMaterial.BLACK_WOOL).newItemStack();
        }
        itemStack = itemStack.clone();
        if (this.isAutoLore().booleanValue() && this.getLoc() != null && this.getLoc().getWorld() != null && (cMIMaterial = itemStack.getItemMeta()) != null) {
            cMIMaterial.setDisplayName(CMILC.getIM(warp.class, "autoLoreName", "[warpName]", this.getShownName()));
            List<String> list2 = CMILC.getIML(warp.class, "autoLoreFormat", "[worldName]", this.getLoc().getWorld().getName(), "[x]", this.getLoc().getBlockX(), "[y]", this.getLoc().getBlockY(), "[z]", this.getLoc().getBlockZ(), "[creator]", CMI.getInstance().getWarpManager().isWarpShowCreator() && this.getCreator() != null ? this.getCreatorName() : "");
            cMIMaterial.setLore(list2);
            itemStack.setItemMeta((ItemMeta)cMIMaterial);
        }
        return itemStack;
    }

    public ItemStack getOffIcon() {
        ItemStack itemStack = this.getOffItem() == null || this.getOffItem().getType().equals((Object)Material.AIR) ? CMIMaterial.RED_WOOL.newItemStack() : this.getOffItem();
        itemStack = itemStack.clone();
        if (this.isAutoLore().booleanValue()) {
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setDisplayName(this.getShownName());
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(CMILC.getIM(warp.class, "noAccess", new Object[0]));
            itemMeta.setLore(arrayList);
            itemStack.setItemMeta(itemMeta);
        }
        return itemStack;
    }

    public void setItem(ItemStack itemStack) {
        this.item = itemStack;
    }

    public void setLoc(CMILocation cMILocation) {
        this.loc = cMILocation;
    }

    public boolean isReqPerm() {
        return this.reqPerm;
    }

    public void setReqPerm(boolean bl) {
        this.reqPerm = bl;
    }

    public Integer getSlot() {
        return this.slot;
    }

    public void setSlot(Integer n) {
        if (n != null) {
            if (n > 27) {
                n = 27;
            }
            if (n < 0) {
                n = null;
            }
        }
        this.slot = n;
    }

    public UUID getCreator() {
        return this.creator;
    }

    public String getCreatorName() {
        return this.creator.equals(CMI.getInstance().getServerUUID()) ? LC.info_Console.getLocale(new Object[0]) : (CMI.getInstance().getPlayerManager().getUser(this.creator) == null ? "N/A" : CMI.getInstance().getPlayerManager().getUser(this.creator).getName());
    }

    public void setCreator(UUID uUID) {
        this.creator = uUID;
    }

    public Boolean isAutoLore() {
        return this.autoLore;
    }

    public void setAutoLore(Boolean bl) {
        this.autoLore = bl;
    }

    public ItemStack getOffItem() {
        return this.offItem;
    }

    public void setOffItem(ItemStack itemStack) {
        this.offItem = itemStack;
    }

    public Boolean isShowUnavailable() {
        return this.showUnavailable;
    }

    public void setShowUnavailable(Boolean bl) {
        this.showUnavailable = bl;
    }

    public Integer getPage() {
        return this.page;
    }

    public void setPage(int n) {
        if (n < 1) {
            n = 1;
        }
        this.page = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public boolean isRandomizeYaw() {
        return this.randomizeYaw;
    }

    public void setRandomizeYaw(boolean bl) {
        this.randomizeYaw = bl;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public boolean sameGroup(String string) {
        return this.group == null && string == null || this.group != null && string != null && this.group.equalsIgnoreCase(string);
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean bl) {
        this.hidden = bl;
    }

    public String getShownName() {
        return this.displayName == null ? this.getName() : this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public boolean isRepeatingLocation() {
        return this.repeatingLocation;
    }

    public void setRepeatingLocation(boolean bl) {
        this.repeatingLocation = bl;
    }

    public boolean hasSecondaryLocations() {
        return this.locations != null && !this.locations.isEmpty();
    }

    public List<CMILocation> getLocations() {
        if (this.locations == null) {
            this.locations = new ArrayList<CMILocation>();
        }
        return this.locations;
    }

    public void setLocations(List<CMILocation> list2) {
        this.locations = list2;
    }

    public void addLocation(CMILocation cMILocation) {
        this.getLocations().add(cMILocation);
    }
}

