/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.AllListeners;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.PlayerOptions.PlayerOption;
import java.util.HashMap;
import java.util.UUID;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Items.CMIItemStack;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerItemDamageEvent;

public class PlayerItemDamageListener
implements Listener {
    private CMI plugin;
    HashMap<UUID, Long> informed = new HashMap();

    public PlayerItemDamageListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void itemDurabilityLoss(PlayerItemDamageEvent playerItemDamageEvent) {
        short s;
        if (playerItemDamageEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isToolDurabilityLossUse()) {
            return;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(playerItemDamageEvent.getItem());
        if (cMIItemStack == null || !cMIItemStack.isTool()) {
            return;
        }
        int n = cMIItemStack.getDurability() + playerItemDamageEvent.getDamage();
        double d = 100.0 - (double)n * 100.0 / (double)(s = cMIItemStack.getMaxDurability());
        if (d > (double)this.plugin.getConfigManager().getToolDurabilityLossPercentage()) {
            return;
        }
        Long l = this.informed.get(playerItemDamageEvent.getPlayer().getUniqueId());
        if (l == null || System.currentTimeMillis() - l > 1000L) {
            this.informed.put(playerItemDamageEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
            if (CMIUser.getUser(playerItemDamageEvent.getPlayer()).getOptionState(PlayerOption.InformDurability).booleanValue() && PermissionsManager.CMIPerm.informDurability.hasPermission((CommandSender)playerItemDamageEvent.getPlayer())) {
                CMILC.info_ItemWillBreak.sendMessage(playerItemDamageEvent.getPlayer(), "[itemName]", cMIItemStack.getDisplayName(), "[current]", s - n, "[max]", cMIItemStack.getMaxDurability());
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void armorDurabilityLoss(PlayerItemDamageEvent playerItemDamageEvent) {
        short s;
        if (playerItemDamageEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getConfigManager().isArmorDurabilityLossUse()) {
            return;
        }
        CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem(playerItemDamageEvent.getItem());
        if (cMIItemStack == null || !cMIItemStack.isArmor()) {
            return;
        }
        int n = cMIItemStack.getDurability() + playerItemDamageEvent.getDamage();
        double d = 100.0 - (double)n * 100.0 / (double)(s = cMIItemStack.getMaxDurability());
        if (d > (double)this.plugin.getConfigManager().getArmorDurabilityLossPercentage()) {
            return;
        }
        Long l = this.informed.get(playerItemDamageEvent.getPlayer().getUniqueId());
        if (l == null || System.currentTimeMillis() - l > 1000L) {
            this.informed.put(playerItemDamageEvent.getPlayer().getUniqueId(), System.currentTimeMillis());
            if (CMIUser.getUser(playerItemDamageEvent.getPlayer()).getOptionState(PlayerOption.InformDurability).booleanValue() && PermissionsManager.CMIPerm.informDurability.hasPermission((CommandSender)playerItemDamageEvent.getPlayer())) {
                CMILC.info_ArmorWillBreak.sendMessage(playerItemDamageEvent.getPlayer(), "[itemName]", cMIItemStack.getDisplayName(), "[current]", s - n, "[max]", cMIItemStack.getMaxDurability());
            }
        }
    }
}

