/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Containers;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMIVectorInt3D;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Location;
import org.bukkit.World;

public class RandomTeleport {
    private boolean enabled = true;
    private int MaxDistance;
    private int MinDistance;
    private CMILocation loc;
    private boolean circle = false;
    private boolean ignoreWater = true;
    private boolean ignoreLava = true;
    private boolean ignorePowderSnow = true;
    private boolean ignoreLeaves = true;
    private boolean surfaceOnly = false;
    private Set<CMIMaterial> ignoredMaterials = new HashSet<CMIMaterial>();
    private int MaxY = 256;
    private int MinY = 0;
    static Random random = new Random(System.nanoTime());

    public RandomTeleport(boolean bl, int n, int n2, CMILocation cMILocation) {
        this.loc = cMILocation;
        this.MaxDistance = n;
        this.MinDistance = n2;
        this.enabled = bl;
    }

    public RandomTeleport(World world2, int n, int n2, int n3, int n4) {
        this(true, n, n2, new CMILocation(world2, (double)n3, 63.0, (double)n4));
    }

    public RandomTeleport(World world2) {
        this(true, 100, 0, new CMILocation(world2, 0.0, 63.0, 0.0));
    }

    public Location getCenter() {
        return this.loc;
    }

    @Deprecated
    public int getMaxCord() {
        return this.MaxDistance;
    }

    public int getMaxDistance() {
        return this.MaxDistance;
    }

    @Deprecated
    public int getMinCord() {
        return this.MinDistance;
    }

    public int getMinDistance() {
        return this.MinDistance;
    }

    public boolean isCircle() {
        return this.circle;
    }

    public RandomTeleport setCircle(boolean bl) {
        this.circle = bl;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public RandomTeleport setEnabled(boolean bl) {
        this.enabled = bl;
        return this;
    }

    public RandomTeleport setMinDistance(int n) {
        this.MinDistance = n;
        return this;
    }

    public RandomTeleport setMaxDistance(int n) {
        this.MaxDistance = n;
        return this;
    }

    public RandomTeleport setCenter(CMILocation cMILocation) {
        this.loc = cMILocation;
        return this;
    }

    public boolean isIgnoreWater() {
        return this.ignoreWater;
    }

    public RandomTeleport setIgnoreWater(boolean bl) {
        this.ignoreWater = bl;
        return this;
    }

    public boolean isIgnoreLava() {
        return this.ignoreLava;
    }

    public RandomTeleport setIgnoreLava(boolean bl) {
        this.ignoreLava = bl;
        return this;
    }

    public int getMaxY() {
        return this.MaxY;
    }

    public RandomTeleport setMaxY(int n) {
        this.MaxY = n;
        return this;
    }

    public int getMinY() {
        return this.MinY;
    }

    public RandomTeleport setMinY(int n) {
        this.MinY = n;
        return this;
    }

    public boolean isIgnorePowderedSnow() {
        return this.ignorePowderSnow;
    }

    public RandomTeleport setIgnorePowderSnow(boolean bl) {
        this.ignorePowderSnow = bl;
        return this;
    }

    public boolean isSurfaceOnly() {
        return this.surfaceOnly;
    }

    public RandomTeleport setSurfaceOnly(boolean bl) {
        this.surfaceOnly = bl;
        return this;
    }

    public CMIVectorInt3D getRandomLocation() {
        double d;
        double d2;
        int n = this.getMinDistance();
        int n2 = this.getMaxDistance();
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 <= n) {
            n2 = n + 1;
        }
        if (this.isCircle()) {
            double d3 = Math.random() * 2.0 * Math.PI;
            double d4 = (double)(n2 - n) * Math.sqrt(Math.random()) + (double)n;
            d2 = d4 * Math.cos(d3);
            d = d4 * Math.sin(d3);
            d2 = (double)((int)d2) + this.getCenter().getX();
            d = (double)((int)d) + this.getCenter().getZ();
        } else {
            int n3 = (n2 - n) * 2;
            d2 = random.nextInt(n3);
            d2 = d2 > (double)n3 / 2.0 ? d2 - (double)n3 / 2.0 : -d2;
            d2 = d2 > 0.0 ? d2 + (double)n : d2 - (double)n;
            d2 += (double)this.getCenter().getBlockX();
            d = random.nextInt(n3);
            d = d > (double)n3 / 2.0 ? d - (double)n3 / 2.0 : -d;
            d = d > 0.0 ? d + (double)n : d - (double)n;
            d += (double)this.getCenter().getBlockZ();
        }
        return new CMIVectorInt3D((int)d2, (int)this.getCenter().getY(), (int)d);
    }

    public boolean isIgnoreLeaves() {
        return this.ignoreLeaves;
    }

    public RandomTeleport setIgnoreLeaves(boolean bl) {
        this.ignoreLeaves = bl;
        return this;
    }

    public boolean isIgnoreMaterials() {
        return !this.ignoredMaterials.isEmpty();
    }

    public boolean isIgnoredMaterial(CMIMaterial cMIMaterial) {
        return this.ignoredMaterials.contains(cMIMaterial);
    }

    public RandomTeleport setIgnoredMaterials(Set<CMIMaterial> set) {
        this.ignoredMaterials = set;
        return this;
    }
}

