/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.PlayerCombat;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Containers.Snd;
import com.Zrips.CMI.Modules.Totems.ResurectionListener;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.Zrips.CMILib.CMILib;
import net.Zrips.CMILib.Colors.CMIChatColor;
import net.Zrips.CMILib.Entities.CMIEntityType;
import net.Zrips.CMILib.Entities.MobHeadInfo;
import net.Zrips.CMILib.Items.CMIAsyncHead;
import net.Zrips.CMILib.Items.CMIItemStack;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.NBT.CMINBT;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.Skull;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class HeadDropListener
implements Listener {
    private CMI plugin;
    String HEX_PATTERN = "([a-zA-Z0-9+/]{32,}+={0,2})";
    Pattern pattern = Pattern.compile(this.HEX_PATTERN);

    public HeadDropListener(CMI cMI) {
        this.plugin = cMI;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void PlayerCombatEvent(EntityDamageEvent entityDamageEvent) {
        Object object;
        if (entityDamageEvent.isCancelled()) {
            return;
        }
        if (!(entityDamageEvent.getEntity() instanceof Player)) {
            return;
        }
        final Player player = (Player)entityDamageEvent.getEntity();
        if (!this.plugin.getPlayerCombatManager().getPlayerWorlds().isEmpty() && !this.plugin.getPlayerCombatManager().getPlayerWorlds().contains(player.getWorld().getName().toLowerCase())) {
            return;
        }
        CMIUser cMIUser = this.plugin.getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return;
        }
        if (entityDamageEvent.getFinalDamage() <= 0.0) {
            return;
        }
        Player player2 = null;
        if (!(entityDamageEvent instanceof EntityDamageByEntityEvent)) {
            return;
        }
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            player2 = (Player)entity;
        } else if (entity instanceof Projectile && (object = (Projectile)entity).getShooter() instanceof Player) {
            player2 = (Player)object.getShooter();
        }
        if (player2 == null || player.equals(player2)) {
            return;
        }
        if (player.getHealth() > entityDamageEvent.getFinalDamage()) {
            return;
        }
        object = this.plugin.getPlayerManager().getUser(player2);
        if (object == null) {
            return;
        }
        if (!this.plugin.getPlayerCombatManager().isDropPlayerHead().booleanValue()) {
            return;
        }
        if (!this.plugin.getTotemManager().isOnCd(player) && this.plugin.getTotemManager().isTotemRemoveFromInventory() && ResurectionListener.haveTotem(player) || cMIUser.getItemInOffHand() != null && CMIMaterial.get((ItemStack)cMIUser.getItemInOffHand()) == CMIMaterial.TOTEM_OF_UNDYING || cMIUser.getItemInHand() != null && CMIMaterial.get((ItemStack)cMIUser.getItemInHand()) == CMIMaterial.TOTEM_OF_UNDYING) {
            return;
        }
        double d = ((CMIUser)object).getHeadDropChance(cMIUser.getUniqueId(), true);
        Random random = new Random(System.currentTimeMillis());
        double d2 = (double)random.nextInt(100000) / 1000.0;
        if (d2 >= d) {
            return;
        }
        ((CMIUser)object).addHeadDropCount(cMIUser.getUniqueId());
        try {
            Object object2;
            List<String> list2 = this.plugin.getPlayerCombatManager().getPlayerHeadLore();
            if (!list2.isEmpty()) {
                object2 = new Snd();
                ((Snd)object2).setSource(cMIUser);
                ((Snd)object2).setTarget((CMIUser)object);
                list2 = this.plugin.getLM().updateSnd((Snd)object2, list2);
                list2 = this.plugin.getPlaceholderAPIManager().updatePlaceHolders(player, list2);
                int n = 0;
                while (n < list2.size()) {
                    list2.set(n, CMIChatColor.translate((String)list2.get(n)));
                    ++n;
                }
            }
            object2 = list2;
            CMIAsyncHead cMIAsyncHead = new CMIAsyncHead((List)object2){
                private final /* synthetic */ List val$l;
                {
                    this.val$l = list2;
                }

                public void afterAsyncUpdate(ItemStack itemStack) {
                    CMIScheduler.runTask(() -> HeadDropListener.drop(player, itemStack, this.val$l));
                }
            };
            cMIAsyncHead.setForce(true);
            String string = CMIUser.getUser(player).getSkin();
            string = string == null ? player.getName() : string;
            CMIItemStack cMIItemStack = CMILib.getInstance().getItemManager().getItem("head:" + string, cMIAsyncHead);
            if (!cMIAsyncHead.isAsyncHead()) {
                HeadDropListener.drop(player, cMIItemStack.getItemStack(), list2);
            }
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    private static void drop(Player player, ItemStack itemStack, List<String> list2) {
        SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
        if (!list2.isEmpty()) {
            skullMeta.setLore(list2);
        }
        skullMeta.setOwningPlayer((OfflinePlayer)player);
        itemStack.setItemMeta((ItemMeta)skullMeta);
        player.getWorld().dropItemNaturally(player.getLocation(), itemStack);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void BlockBreakEvent(BlockBreakEvent blockBreakEvent) {
        String string;
        if (blockBreakEvent.isCancelled()) {
            return;
        }
        if (!this.plugin.getPlayerCombatManager().isDropEntityHead().booleanValue()) {
            return;
        }
        Block block = blockBreakEvent.getBlock();
        if (!(block.getState() instanceof Skull)) {
            return;
        }
        Object object = CMINBT.getNbt((Block)block);
        if (object == null) {
            return;
        }
        Matcher matcher = this.pattern.matcher(object.toString());
        if (!matcher.find()) {
            return;
        }
        CMINBT cMINBT = new CMINBT(block);
        if (cMINBT.hasNBT("PublicBukkitValues.slimefun:slimefun_block") && (string = cMINBT.getString("SkullOwner.Name")) != null && string.startsWith("CS-")) {
            return;
        }
        string = matcher.group(0);
        if (string == null) {
            return;
        }
        CMIEntityType[] cMIEntityTypeArray = CMIEntityType.values();
        int n = cMIEntityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIEntityType cMIEntityType = cMIEntityTypeArray[n2];
            MobHeadInfo mobHeadInfo = (MobHeadInfo)cMIEntityType.getHeadTexturesMap().get(string);
            if (mobHeadInfo != null) {
                ItemStack itemStack = cMIEntityType.getHead(string);
                if (itemStack == null) break;
                blockBreakEvent.setDropItems(false);
                blockBreakEvent.getBlock().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), itemStack);
                break;
            }
            ++n2;
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onEntityDeath(EntityDeathEvent entityDeathEvent) {
        Object object;
        if (!this.plugin.getPlayerCombatManager().isDropEntityHead().booleanValue()) {
            return;
        }
        if (entityDeathEvent.getEntity() instanceof Player) {
            return;
        }
        LivingEntity livingEntity = entityDeathEvent.getEntity();
        if (!(livingEntity.getLastDamageCause() instanceof EntityDamageByEntityEvent)) {
            return;
        }
        if (!this.plugin.getPlayerCombatManager().getMobWorlds().isEmpty() && !this.plugin.getPlayerCombatManager().getMobWorlds().contains(livingEntity.getWorld().getName().toLowerCase())) {
            return;
        }
        Player player = null;
        EntityDamageByEntityEvent entityDamageByEntityEvent = (EntityDamageByEntityEvent)livingEntity.getLastDamageCause();
        Entity entity = entityDamageByEntityEvent.getDamager();
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile && (object = (Projectile)entity).getShooter() instanceof Player) {
            player = (Player)object.getShooter();
        }
        if (player == null) {
            return;
        }
        object = this.plugin.getPlayerManager().getUser(player);
        if (object == null) {
            return;
        }
        EntityType entityType = livingEntity.getType();
        ((CMIUser)object).addEntityKill(entityType);
        double d = ((CMIUser)object).getEntityHeadDropChance(entityType, true);
        Random random = new Random(System.currentTimeMillis());
        double d2 = (double)random.nextInt(100000) / 1000.0;
        if (d2 >= d) {
            return;
        }
        ItemStack itemStack = this.plugin.getPlayerCombatManager().tryToGetEntityHead(player, (Entity)livingEntity);
        if (itemStack == null) {
            return;
        }
        ((CMIUser)object).getEntityKills().get(entityType).addHeadDropCount();
        try {
            livingEntity.getWorld().dropItemNaturally(livingEntity.getLocation(), itemStack);
        }
        catch (Error | Exception throwable) {
            throwable.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerDeath(EntityDeathEvent entityDeathEvent) {
    }
}

