/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Portals;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Portals.CMIPortal;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.vehicle.VehicleEnterEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.util.Vector;

public class PortalListener
implements Listener {
    private CMI plugin;
    protected Map<UUID, Long> lastUpdate;
    protected Map<UUID, Long> lastUpdateRange;

    public PortalListener(CMI cMI) {
        this.plugin = cMI;
        this.lastUpdate = new HashMap<UUID, Long>();
        this.lastUpdateRange = new HashMap<UUID, Long>();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleMove(VehicleMoveEvent vehicleMoveEvent) {
        Entity entity = vehicleMoveEvent.getVehicle().getPassenger();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = vehicleMoveEvent.getFrom();
        Location location2 = vehicleMoveEvent.getTo();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (!this.processMove(player, location, location2)) {
            vehicleMoveEvent.getVehicle().teleport(location);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onVehicleMove(VehicleEnterEvent vehicleEnterEvent) {
        Entity entity = vehicleEnterEvent.getEntered();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.hasMetadata("NPC")) {
            return;
        }
        Location location = player.getLocation();
        Location location2 = vehicleEnterEvent.getVehicle().getLocation();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (!this.processMove(player, location, location2)) {
            vehicleEnterEvent.getVehicle().teleport(location);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent playerMoveEvent) {
        Player player = playerMoveEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerMoveEvent.getFrom();
        Location location2 = playerMoveEvent.getTo();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l == null || l2 - l >= (long)this.plugin.getPortalManager().getPortalsCheckParticleInterval()) {
            this.lastUpdateRange.put(player.getUniqueId(), l2);
            this.plugin.getPortalManager().handlePortalVisualizerUpdates(player, location, location2);
        }
        if (!this.processMove(player, location, location2)) {
            playerMoveEvent.setCancelled(true);
        }
    }

    private boolean processMove(Player player, Location location, Location location2) {
        if (!this.plugin.getPortalManager().isNearPortal(player.getUniqueId())) {
            Long l = this.lastUpdate.get(player.getUniqueId());
            if (l != null) {
                long l2 = System.currentTimeMillis();
                if (player.getFallDistance() > 0.0f ? l2 - l < (long)(this.plugin.getPortalManager().getPortalsCheckInterval() / 10) : l2 - l < (long)this.plugin.getPortalManager().getPortalsCheckInterval()) {
                    return true;
                }
            }
            this.lastUpdate.put(player.getUniqueId(), System.currentTimeMillis());
            return true;
        }
        Set<CMIPortal> set = this.plugin.getPortalManager().getByLocList(location2);
        if (set == null) {
            return true;
        }
        Set<CMIPortal> set2 = null;
        if (!set.isEmpty()) {
            set2 = this.plugin.getPortalManager().getByLocList(location);
        }
        for (CMIPortal cMIPortal : set) {
            if (cMIPortal == null || !cMIPortal.isEnabled() || set2 != null && set2.contains(cMIPortal)) continue;
            if (cMIPortal.isRequiresPermission() && !PermissionsManager.CMIPerm.command_portal_$1.hasPermission((CommandSender)player, cMIPortal.getName().toLowerCase())) {
                if (cMIPortal.isInformOnMissingPerm()) {
                    CMILC.info("portals", player, "cantUsePortal", new Object[0]);
                }
                if (cMIPortal.isKickBack()) {
                    int n = 0;
                    int n2 = 0;
                    int n3 = 0;
                    if (location2.getBlockX() > location.getBlockX()) {
                        n = 1;
                    } else if (location2.getBlockX() < location.getBlockX()) {
                        n = -1;
                    }
                    if (location2.getBlockY() > location.getBlockY()) {
                        n2 = 1;
                    } else if (location2.getBlockY() < location.getBlockY()) {
                        n2 = -1;
                    }
                    if (location2.getBlockZ() > location.getBlockZ()) {
                        n3 = 1;
                    } else if (location2.getBlockZ() < location.getBlockZ()) {
                        n3 = -1;
                    }
                    Vector vector = location2.toVector().subtract(location.toVector());
                    double d = vector.getX() * 0.9;
                    double d2 = vector.getY() * 0.9;
                    double d3 = vector.getZ() * 0.9;
                    if ((n < 0 || n > 0) && this.plugin.getPortalManager().getByLoc(location2.clone().add((double)(-n), 0.0, 0.0)) == cMIPortal) {
                        n = 0;
                    }
                    if ((n2 < 0 || n2 > 0) && this.plugin.getPortalManager().getByLoc(location2.clone().add(0.0, (double)(-n2), 0.0)) == cMIPortal) {
                        n2 = 0;
                    }
                    if ((n3 < 0 || n3 > 0) && this.plugin.getPortalManager().getByLoc(location2.clone().add(0.0, 0.0, (double)(-n3))) == cMIPortal) {
                        n3 = 0;
                    }
                    if (n3 < 0 || n3 > 0) {
                        d3 = -d3;
                    }
                    if (n < 0 || n > 0) {
                        d = -d;
                    }
                    if (n2 < 0 || n2 > 0) {
                        d2 = -d2;
                    }
                    player.setVelocity(new Vector(d, d2, d3));
                    player.setFallDistance(0.0f);
                    return false;
                }
                return true;
            }
            if (cMIPortal.teleport(player)) break;
        }
        return true;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRange(PlayerMoveEvent playerMoveEvent) {
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerMoveExtendedRnage(PlayerTeleportEvent playerTeleportEvent) {
        Player player = playerTeleportEvent.getPlayer();
        if (player == null) {
            return;
        }
        Location location = playerTeleportEvent.getFrom();
        Location location2 = playerTeleportEvent.getTo();
        if (location.getBlockX() == location2.getBlockX() && location.getBlockY() == location2.getBlockY() && location.getBlockZ() == location2.getBlockZ()) {
            return;
        }
        if (player.hasMetadata("NPC")) {
            return;
        }
        Long l = this.lastUpdateRange.get(player.getUniqueId());
        long l2 = System.currentTimeMillis();
        if (l != null && l2 - l < 20L) {
            return;
        }
        this.lastUpdateRange.put(player.getUniqueId(), l2);
        this.plugin.getPortalManager().handlePortalVisualizerUpdates(player, location, location2);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuitEvent(PlayerQuitEvent playerQuitEvent) {
        Player player = playerQuitEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.lastUpdate.remove(player.getUniqueId());
        this.lastUpdateRange.remove(player.getUniqueId());
        this.plugin.getPortalManager().removeLastPortalInRange(player.getUniqueId());
        this.plugin.getPortalManager().removeNearPortal(player.getUniqueId());
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (player == null) {
            return;
        }
        this.plugin.getPortalManager().handlePortalVisualizerUpdates(player, null, player.getLocation());
        CMIPortal cMIPortal = this.plugin.getPortalManager().getByLoc(player.getLocation());
        if (cMIPortal != null && cMIPortal.getSafeLoc() != null) {
            CMI.getInstance().getTeleportHandler().teleportPlayer(player, cMIPortal.getSafeLoc(), true, CMITeleportType.Portal);
        }
    }
}

