/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Teleportations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.RandomTeleport;
import com.Zrips.CMI.Locale.CMILC;
import com.Zrips.CMI.Modules.Teleportations.CMIChunkSnapShot;
import com.Zrips.CMI.Modules.Teleportations.CMIRunningRandomTeleports;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportLocation;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.Modules.Teleportations.PositionRelativeData;
import com.Zrips.CMI.commands.list.rt;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import net.Zrips.CMILib.Container.CMILocation;
import net.Zrips.CMILib.Container.CMINumber;
import net.Zrips.CMILib.Container.CMIVectorInt3D;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Container.CuboidArea;
import net.Zrips.CMILib.FileHandler.ConfigReader;
import net.Zrips.CMILib.Items.CMIMC;
import net.Zrips.CMILib.Items.CMIMaterial;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class RandomTeleportationManager {
    private CMI plugin;
    Set<String> cacheFilling = new HashSet<String>();
    private HashMap<String, RandomTeleport> randomTeleports = new HashMap();
    private int randomTeleportCooldown = 3;
    private int randomTeleportMaxTries = 10;
    private List<Biome> randomTeleportExcludedBiomes = new ArrayList<Biome>();
    static Random random = new Random(System.nanoTime());
    private static final String fileName = "RandomTeleportations.yml";
    ConcurrentHashMap<UUID, CMIRunningRandomTeleports> playerRandomTeleports = new ConcurrentHashMap();
    String[] substrings = new String[]{"...", "..", "."};

    public RandomTeleportationManager(CMI cMI) {
        this.plugin = cMI;
    }

    public void loadConfig() {
        Iterator iterator;
        RandomTeleport randomTeleport;
        int n;
        int n2;
        boolean bl;
        Set set;
        ArrayList arrayList;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        String string;
        Object object3;
        ConfigReader configReader = null;
        try {
            configReader = new ConfigReader((Plugin)CMI.getInstance(), "Settings" + File.separator + fileName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (configReader == null) {
            CMI.getInstance().consoleMessage("&cFailed to load Settings" + File.separator + fileName + " file");
            return;
        }
        ConfigReader configReader2 = CMI.getInstance().getConfigManager().getConfig();
        if (configReader2.getC().isConfigurationSection("RandomTeleportation")) {
            configReader.getC().set("RandomTeleportation", configReader2.getC().get("RandomTeleportation"));
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (World world2 : Bukkit.getWorlds()) {
            hashSet.add(world2.getName());
        }
        boolean bl7 = false;
        this.randomTeleports.clear();
        configReader.addComment("RandomTeleportation.AutoGenerateWorlds", new String[]{"If this set to true we will generate random teleport default settings for all detected worlds", "Setting to false will not longer generate world setups, but you can add them manually if needed"});
        Boolean bl8 = configReader.get("RandomTeleportation.AutoGenerateWorlds", Boolean.valueOf(true));
        if (configReader.getC().isConfigurationSection("RandomTeleportation.Worlds") && (object3 = configReader.getC().getConfigurationSection("RandomTeleportation.Worlds")) != null) {
            for (Object object2 : object3.getKeys(false)) {
                string = "RandomTeleportation.Worlds." + (String)object2 + ".";
                n7 = configReader.get(String.valueOf(string) + "Enabled", Boolean.valueOf(true)).booleanValue();
                if (!bl7) {
                    configReader.addComment("RandomTeleportation.Worlds." + (String)object2, new String[]{"World name to use this feature. Add annother one with appropriate name to enable random teleportation"});
                }
                if (!bl7) {
                    configReader.addComment(String.valueOf(string) + "MaxRange", new String[]{"Max coordinate to teleport, setting to 1000, player can be teleported between -1000 and 1000 blocks between defined center location", "For example having centerX at 2000 and centerZ at 3000 while MaxRange is set to 1500 we will teleport player between x:500;z:1500 and x:3500;z:4500 coordinates"});
                }
                n6 = configReader.get(String.valueOf(string) + "MaxRange", configReader.getC().getInt(String.valueOf(string) + "MaxCoord", 1000));
                if (!bl7) {
                    configReader.addComment(String.valueOf(string) + "MinRange", new String[]{"If maxcord set to 1000 and mincord to 500, then player can be teleported between -1000 to -500 and 1000 to 500 coordinates"});
                }
                n5 = configReader.get(String.valueOf(string) + "MinRange", configReader.getC().getInt(String.valueOf(string) + "MinCoord", 500));
                n4 = configReader.get(String.valueOf(string) + "CenterX", 0);
                n3 = configReader.get(String.valueOf(string) + "CenterZ", 0);
                bl6 = configReader.get(String.valueOf(string) + "Circle", Boolean.valueOf(false));
                bl5 = configReader.get(String.valueOf(string) + "IgnoreWater", Boolean.valueOf(true));
                bl4 = configReader.get(String.valueOf(string) + "IgnoreLava", Boolean.valueOf(true));
                bl3 = configReader.get(String.valueOf(string) + "IgnoreLeaves", Boolean.valueOf(true));
                bl2 = configReader.get(String.valueOf(string) + "ignorePowderSnow", Boolean.valueOf(false));
                arrayList = new ArrayList();
                arrayList.addAll(configReader.get(String.valueOf(string) + "ignoredMaterials", arrayList));
                set = arrayList.stream().map(CMIMaterial::get).filter(cMIMaterial -> cMIMaterial != null && !cMIMaterial.isNone()).collect(Collectors.toCollection(HashSet::new));
                if (!bl7) {
                    configReader.addComment(String.valueOf(string) + "surfaceOnly", new String[]{"With this option we will only attempt to teleport player on highest block and ignore any cave teleportations"});
                }
                bl = configReader.get(String.valueOf(string) + "surfaceOnly", Boolean.valueOf(false));
                n2 = configReader.get(String.valueOf(string) + "minY", 0);
                n = configReader.get(String.valueOf(string) + "maxY", 256);
                randomTeleport = this.plugin.getUtilManager().getWorld((String)object2);
                if (randomTeleport == null) {
                    this.plugin.consoleMessage("&e(RandomTeleportation) Can't find world with (" + (String)object2 + ") name");
                }
                bl7 = true;
                hashSet.remove(object2);
                RandomTeleport randomTeleport2 = new RandomTeleport(n7 != 0, n6, n5, new CMILocation((String)object2, (double)n4, 63.0, (double)n3)).setCircle(bl6).setIgnoreLava(bl4).setIgnoreLeaves(bl3).setIgnoreWater(bl5).setIgnorePowderSnow(bl2).setIgnoredMaterials(set).setMinY(n2).setMaxY(n).setSurfaceOnly(bl);
                if (!bl6 && randomTeleport != null) {
                    try {
                        Location location = randomTeleport.getWorldBorder().getCenter();
                        double d = randomTeleport.getWorldBorder().getSize() / 2.0;
                        double d2 = location.getX() - d;
                        double d3 = location.getX() + d;
                        double d4 = location.getZ() - d;
                        double d5 = location.getZ() + d;
                        double d6 = randomTeleport2.getCenter().getX() - (double)randomTeleport2.getMaxDistance();
                        double d7 = randomTeleport2.getCenter().getX() + (double)randomTeleport2.getMaxDistance();
                        double d8 = randomTeleport2.getCenter().getZ() - (double)randomTeleport2.getMaxDistance();
                        double d9 = randomTeleport2.getCenter().getZ() + (double)randomTeleport2.getMaxDistance();
                        if (d2 > d6) {
                            this.plugin.consoleMessage("&5Random teleport location is out of minimal world border X coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d3 < d7) {
                            this.plugin.consoleMessage("&5Random teleport location is out of maximal world border X coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d4 > d8) {
                            this.plugin.consoleMessage("&5Random teleport location is out of minimal world border Z coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                        if (d5 < d9) {
                            this.plugin.consoleMessage("&5Random teleport location is out of maximal world border Z coordinate bounds for &6" + randomTeleport.getName() + " &5world. Please update values.");
                        }
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                this.randomTeleports.put((String)object2, randomTeleport2);
            }
        }
        if (bl8.booleanValue()) {
            for (Object object3 : Bukkit.getWorlds()) {
                if (!hashSet.contains(object3.getName())) continue;
                iterator = object3.getName();
                iterator = ((String)((Object)iterator)).replace(".", "_");
                string = "RandomTeleportation.Worlds." + (String)((Object)iterator) + ".";
                n7 = configReader.get(String.valueOf(string) + "Enabled", Boolean.valueOf(true)).booleanValue();
                n6 = configReader.get(String.valueOf(string) + "MaxRange", 1000);
                n5 = configReader.get(String.valueOf(string) + "MinRange", 500);
                n4 = configReader.get(String.valueOf(string) + "CenterX", 0);
                n3 = configReader.get(String.valueOf(string) + "CenterZ", 0);
                bl6 = configReader.get(String.valueOf(string) + "Circle", Boolean.valueOf(false));
                bl5 = configReader.get(String.valueOf(string) + "IgnoreWater", Boolean.valueOf(true));
                bl4 = configReader.get(String.valueOf(string) + "IgnoreLava", Boolean.valueOf(true));
                bl3 = configReader.get(String.valueOf(string) + "IgnoreLeaves", Boolean.valueOf(true));
                bl2 = configReader.get(String.valueOf(string) + "ignorePowderSnow", Boolean.valueOf(false));
                arrayList = new ArrayList();
                arrayList.addAll(configReader.get(String.valueOf(string) + "ignoredMaterials", arrayList));
                set = arrayList.stream().map(CMIMaterial::get).filter(cMIMaterial -> cMIMaterial != null && !cMIMaterial.isNone()).collect(Collectors.toCollection(HashSet::new));
                bl = configReader.get(String.valueOf(string) + "surfaceOnly", Boolean.valueOf(false));
                n2 = configReader.get(String.valueOf(string) + "minY", CMIWorld.getMinHeight((World)object3));
                n = configReader.get(String.valueOf(string) + "maxY", CMIWorld.getMaxHeight((World)object3));
                randomTeleport = new RandomTeleport(n7 != 0, n6, n5, new CMILocation((World)object3, (double)n4, (double)(CMIWorld.getMaxHeight((World)object3) / 2), (double)n3));
                randomTeleport.setCircle(bl6);
                randomTeleport.setCircle(bl6).setIgnoreLava(bl4).setIgnoreWater(bl5).setIgnoreLeaves(bl3).setIgnorePowderSnow(bl2).setIgnoredMaterials(set).setMinY(n2).setMaxY(n).setSurfaceOnly(bl);
                this.randomTeleports.put(object3.getName(), randomTeleport);
            }
        }
        configReader.addComment("RandomTeleportation.Cooldown", new String[]{"How long force player to wait before using command again."});
        this.randomTeleportCooldown = configReader.get("RandomTeleportation.Cooldown", 5);
        configReader.addComment("RandomTeleportation.MaxTries", new String[]{"How many times to try find correct location for teleportation.", "Keep it at low number, as player always can try again after delay"});
        this.randomTeleportMaxTries = configReader.get("RandomTeleportation.MaxTries", 20);
        configReader.addComment("RandomTeleportation.ExcludedBiomes", new String[]{"List of biomes to exclude from random teleportation"});
        object3 = configReader.get("RandomTeleportation.ExcludedBiomes", Arrays.asList("Ocean", "Deep ocean"));
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            Object object2;
            object2 = (String)iterator.next();
            object2 = ((String)object2).replace(" ", "").replace("_", "");
            Biome[] biomeArray = Biome.values();
            n6 = biomeArray.length;
            n7 = 0;
            while (n7 < n6) {
                string = biomeArray[n7];
                if (string.name().replace("_", "").equalsIgnoreCase((String)object2)) {
                    this.randomTeleportExcludedBiomes.add((Biome)string);
                }
                n7 += 1;
            }
        }
        configReader.save();
    }

    public RandomTeleport getRandomTeleport(World world2) {
        return this.getRandomTeleport(world2, false);
    }

    public RandomTeleport getRandomTeleport(World world2, boolean bl) {
        RandomTeleport randomTeleport = this.randomTeleports.get(world2.getName());
        return randomTeleport == null ? null : (randomTeleport.isEnabled() && randomTeleport.getCenter().getWorld() != null ? randomTeleport : (bl ? randomTeleport : null));
    }

    public HashMap<String, RandomTeleport> getRandomTeleports() {
        return this.randomTeleports;
    }

    public int getRandomTeleportMaxTries() {
        return this.randomTeleportMaxTries;
    }

    public int getRandomTeleportCooldown() {
        return this.randomTeleportCooldown;
    }

    public List<Biome> getRandomTeleportExcludedBiomes() {
        return this.randomTeleportExcludedBiomes;
    }

    public CompletableFuture<CMITeleportLocation> getRandomTeleportationLocation(RandomTeleport randomTeleport, Location location, CompletableFuture<CMIChunkSnapShot> completableFuture) {
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            CMITeleportLocation cMITeleportLocation = new CMITeleportLocation(cMIChunkSnapShot.getWorld());
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            int n = -999;
            int n2 = -999;
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n3 = randomTeleport.getMaxY() - 2;
            while (n3 > randomTeleport.getMinY()) {
                if (n != -999 || this.plugin.getTeleportHandler().isEmptySpaceForPlayer(chunkSnapshot, n3, positionRelativeData)) {
                    n = n3;
                    CMIMaterial cMIMaterial = this.plugin.getTeleportHandler().getBlockType(chunkSnapshot, n3 - 1, positionRelativeData);
                    if (!this.plugin.getTeleportHandler().isEmpty(cMIMaterial, false) && this.plugin.getTeleportHandler().isEmptySpaceForPlayer(chunkSnapshot, n3, positionRelativeData)) {
                        try {
                            if (this.plugin.getRandomTeleportationManager().getRandomTeleportExcludedBiomes().contains(chunkSnapshot.getBiome(positionRelativeData.getLocalX(), n3, positionRelativeData.getLocalZ()))) {
                                return cMITeleportLocation;
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (randomTeleport.isIgnoreLava() && this.plugin.getTeleportHandler().isBad(cMIMaterial)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreWater() && (cMIMaterial.isWater() || this.plugin.getTeleportHandler().getBlockType(chunkSnapshot, n3, positionRelativeData).isWater())) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnorePowderedSnow() && cMIMaterial.equals((Object)CMIMaterial.POWDER_SNOW)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreLeaves() && cMIMaterial.containsCriteria(CMIMC.LEAVES)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else if (randomTeleport.isIgnoreMaterials() && randomTeleport.isIgnoredMaterial(cMIMaterial)) {
                            if (randomTeleport.isSurfaceOnly()) {
                                break;
                            }
                        } else {
                            n2 = n3;
                            break;
                        }
                    }
                }
                --n3;
            }
            cMITeleportLocation.setYaw(random.nextInt(359));
            if (n2 > -999) {
                return cMITeleportLocation.setPosition(new Vector((double)location.getBlockX() + 0.5, (double)n2, (double)location.getBlockZ() + 0.5));
            }
            return cMITeleportLocation;
        }));
    }

    public CompletableFuture<Boolean> randomTeleport(Player player, World world2) {
        if (world2 == null) {
            return CompletableFuture.completedFuture(false);
        }
        RandomTeleport randomTeleport = this.plugin.getRandomTeleportationManager().getRandomTeleport(world2);
        if (randomTeleport == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.playerRandomTeleports.containsKey(player.getUniqueId()) && this.playerRandomTeleports.get(player.getUniqueId()).getEndTime() > System.currentTimeMillis()) {
            return CompletableFuture.completedFuture(false);
        }
        int n = CMINumber.clamp((int)this.plugin.getRandomTeleportationManager().getRandomTeleportMaxTries(), (int)1, (int)50);
        int n2 = this.plugin.getUtilManager().getMaxWorldHeight(world2);
        this.playerRandomTeleports.put(player.getUniqueId(), new CMIRunningRandomTeleports());
        return CompletableFuture.supplyAsync(() -> {
            Vector vector;
            CuboidArea cuboidArea = null;
            try {
                Location location = world2.getWorldBorder().getCenter();
                double d = world2.getWorldBorder().getSize();
                vector = location.toVector();
                cuboidArea = new CuboidArea(world2);
                cuboidArea.setHighPoint(vector.clone().setY(600).setX(vector.getX() + d).setZ(vector.getZ() + d));
                cuboidArea.setLowPoint(vector.clone().setY(-600).setX(vector.getX() - d).setZ(vector.getZ() - d));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n3 = n;
            while (n3 > 0) {
                int n4 = n3 % this.substrings.length;
                CMILC.sendMessage(player, String.valueOf(CMILC.getIM(rt.class.getSimpleName(), "searching", new Object[0])) + this.substrings[n4]);
                --n3;
                CMIVectorInt3D cMIVectorInt3D = randomTeleport.getRandomLocation();
                vector = new Location(world2, (double)cMIVectorInt3D.getX(), (double)(world2.getEnvironment().equals((Object)World.Environment.NETHER) ? n2 - 10 : n2 / 2), (double)cMIVectorInt3D.getZ());
                if (vector.getBlockY() > randomTeleport.getMaxY()) {
                    vector.setY((double)randomTeleport.getMaxY());
                }
                if (cuboidArea != null && !cuboidArea.containsLoc((Location)vector)) continue;
                CompletableFuture<CMIChunkSnapShot> completableFuture = this.plugin.getTeleportHandler().getSnapshot((Location)vector, true, true);
                CompletableFuture<CMITeleportLocation> completableFuture2 = this.getRandomTeleportationLocation(randomTeleport, (Location)vector, completableFuture);
                Boolean bl = false;
                try {
                    bl = RandomTeleportationManager.teleportPlayerRandom(player, PlayerTeleportEvent.TeleportCause.PLUGIN, completableFuture2).get();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.playerRandomTeleports.remove(player.getUniqueId());
                    Thread.currentThread().interrupt();
                }
                if (!bl.booleanValue()) continue;
                this.playerRandomTeleports.remove(player.getUniqueId());
                return bl;
            }
            this.playerRandomTeleports.remove(player.getUniqueId());
            return false;
        });
    }

    private static CompletableFuture<Boolean> teleportPlayerRandom(Player player, PlayerTeleportEvent.TeleportCause teleportCause, CompletableFuture<CMITeleportLocation> completableFuture) {
        return completableFuture.thenComposeAsync(cMITeleportLocation -> {
            if (cMITeleportLocation.getPosition() == null) {
                return CompletableFuture.completedFuture(false);
            }
            cMITeleportLocation.setType(CMITeleportType.randomTp);
            return CMI.getInstance().getTeleportHandler().finalizeTeleportation(player, teleportCause, (CMITeleportLocation)cMITeleportLocation);
        });
    }
}

