/*
 * Decompiled with CFR 0.152.
 */
package com.Zrips.CMI.Modules.Teleportations;

import com.Zrips.CMI.CMI;
import com.Zrips.CMI.Containers.CMIUser;
import com.Zrips.CMI.Modules.Permissions.PermissionsManager;
import com.Zrips.CMI.Modules.Teleportations.CMIChunkSnapShot;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportCondition;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportFeedback;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportLocation;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportType;
import com.Zrips.CMI.Modules.Teleportations.CMITeleportationBounds;
import com.Zrips.CMI.Modules.Teleportations.DangerousTp;
import com.Zrips.CMI.Modules.Teleportations.PositionRelativeData;
import com.Zrips.CMI.Modules.Teleportations.SafeTeleport;
import com.Zrips.CMI.events.CMIAsyncPlayerTeleportEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.Zrips.CMILib.Container.CMIWorld;
import net.Zrips.CMILib.Items.CMIMC;
import net.Zrips.CMILib.Items.CMIMaterial;
import net.Zrips.CMILib.Version.PaperMethods.PaperLib;
import net.Zrips.CMILib.Version.Schedulers.CMIScheduler;
import net.Zrips.CMILib.Version.Version;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Slime;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.util.Vector;

public class TeleportHandler {
    private CMI plugin;
    private Set<CMIMaterial> emptyBlockMap = new HashSet<CMIMaterial>();
    private Set<CMIMaterial> badBlockMap = new HashSet<CMIMaterial>();
    private HashMap<UUID, DangerousTp> badTeleports = new HashMap();
    private int btprange = 15;
    static Method getBlockTypeId = null;

    public TeleportHandler(CMI cMI) {
        this.plugin = cMI;
        this.fill();
    }

    public void addBadTeleport(UUID uUID, Location location) {
        DangerousTp dangerousTp = new DangerousTp(uUID, location);
        this.badTeleports.put(uUID, dangerousTp);
    }

    public void removeBadTeleport(UUID uUID) {
        this.badTeleports.remove(uUID);
    }

    public Location getBadTeleport(UUID uUID) {
        DangerousTp dangerousTp = this.badTeleports.get(uUID);
        if (dangerousTp == null) {
            return null;
        }
        if (dangerousTp.getTime() + (long)(this.btprange * 1000) < System.currentTimeMillis()) {
            this.badTeleports.remove(uUID);
            return null;
        }
        return dangerousTp.getLocation();
    }

    public CompletableFuture<CMIChunkSnapShot> getSnapshot(Location location, boolean bl, boolean bl2) {
        return this.getSnapshot(location.getWorld(), location.getBlockX() >> 4, location.getBlockZ() >> 4, bl, bl2);
    }

    public CompletableFuture<CMIChunkSnapShot> getSnapshot(World world2, int n, int n2, boolean bl, boolean bl2) {
        CompletableFuture completableFuture = PaperLib.getChunkAtAsync((World)world2, (int)n, (int)n2, (boolean)bl);
        return completableFuture.thenComposeAsync(chunk -> CompletableFuture.supplyAsync(() -> {
            CMIChunkSnapShot cMIChunkSnapShot = new CMIChunkSnapShot(world2);
            if (chunk == null) {
                return cMIChunkSnapShot;
            }
            try {
                CompletableFuture completableFuture = CMIScheduler.runAtLocation((Location)new Location(world2, (double)(n * 16), 0.0, (double)(n2 * 16)), () -> {
                    CMIChunkSnapShot cMIChunkSnapShot2 = cMIChunkSnapShot.setSnapshot(chunk.getChunkSnapshot(true, bl2, false));
                });
                completableFuture.get();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                Thread.currentThread().interrupt();
            }
            return cMIChunkSnapShot;
        }));
    }

    public CMIMaterial getBlockType(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        if (n >= positionRelativeData.getMaxWorldY() || n < positionRelativeData.getMinWorldY()) {
            return CMIMaterial.AIR;
        }
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            return CMIMaterial.get((Material)chunkSnapshot.getBlockType(positionRelativeData.getLocalX(), n, positionRelativeData.getLocalZ()));
        }
        if (getBlockTypeId == null) {
            try {
                getBlockTypeId = chunkSnapshot.getClass().getMethod("getBlockTypeId", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        try {
            return CMIMaterial.get((int)((Integer)getBlockTypeId.invoke((Object)chunkSnapshot, positionRelativeData.getLocalX(), n, positionRelativeData.getLocalZ())));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return CMIMaterial.NONE;
        }
    }

    public CompletableFuture<CMITeleportLocation> getSafeTeleportationLocation(CMITeleportationBounds cMITeleportationBounds, CompletableFuture<CMIChunkSnapShot> completableFuture) {
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            int n;
            CMITeleportLocation cMITeleportLocation = new CMITeleportLocation(cMIChunkSnapShot.getWorld());
            cMITeleportLocation.setYaw(cMITeleportationBounds.getYaw());
            cMITeleportLocation.setPitch(cMITeleportationBounds.getPitch());
            if (cMIChunkSnapShot.getWorld() == null) {
                return cMITeleportLocation.setCondition(CMITeleportCondition.MissingWorld);
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(new Location(cMIChunkSnapShot.getWorld(), cMITeleportationBounds.getPosition().getX(), 64.0, cMITeleportationBounds.getPosition().getZ()));
            int n2 = -999;
            if (cMITeleportationBounds.getWorld().getEnvironment() == World.Environment.NETHER) {
                cMITeleportationBounds.setMaxY(CMI.getInstance().getUtilManager().getMaxWorldHeight(cMITeleportationBounds.getWorld()) - 3);
            }
            if (!this.isEmptySpaceForPlayer(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData)) {
                n = (int)cMITeleportationBounds.getPosition().getY();
                while (n <= cMITeleportationBounds.getMaxY() + 2) {
                    if (!this.isEmptySpaceForPlayer(chunkSnapshot, n, positionRelativeData)) {
                        if (cMITeleportationBounds.isImortal()) {
                            n2 = n;
                        }
                    } else {
                        CMIMaterial cMIMaterial = this.getBlockType(chunkSnapshot, n - 1, positionRelativeData);
                        if (!cMIMaterial.isAir()) {
                            n2 = n;
                            break;
                        }
                    }
                    ++n;
                }
            }
            if (n2 == -999 && this.isEmptySpaceForPlayer(chunkSnapshot, (int)cMITeleportationBounds.getPosition().getY(), positionRelativeData)) {
                n = (int)cMITeleportationBounds.getPosition().getY();
                while (n >= cMITeleportationBounds.getMinY()) {
                    if (!this.isEmptySpaceForPlayer(chunkSnapshot, n, positionRelativeData)) {
                        if (!cMITeleportationBounds.isImortal()) break;
                        n2 = n + 1;
                        break;
                    }
                    n2 = n--;
                }
            }
            if (n2 == -999 && cMITeleportationBounds.isImortal()) {
                n2 = (int)cMITeleportationBounds.getPosition().getY();
            }
            if (n2 > -999) {
                n = 0;
                int n3 = CMIWorld.getMinHeight((World)cMITeleportationBounds.getWorld());
                CMIMaterial cMIMaterial = null;
                try {
                    int n4 = n2;
                    while (n4 >= n3) {
                        cMIMaterial = n4 >= positionRelativeData.getMaxWorldY() ? CMIMaterial.AIR : this.getBlockType(chunkSnapshot, n4, positionRelativeData);
                        if (this.isEmpty(cMIMaterial, false)) {
                            ++n;
                            --n4;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (!cMITeleportationBounds.isImortal() && n > 5) {
                    if (n2 - n <= n3) {
                        cMITeleportLocation.setCondition(CMITeleportCondition.Void);
                    } else if (cMIMaterial == null || !cMIMaterial.isWater() && !cMIMaterial.equals((Object)CMIMaterial.SLIME_BLOCK)) {
                        cMITeleportLocation.setCondition(CMITeleportCondition.Fall);
                    }
                }
                cMITeleportLocation.setFallDistance(n);
                if (!cMITeleportationBounds.isImortal() && this.isBad(cMIMaterial)) {
                    cMITeleportLocation.setFloor(cMIMaterial);
                    cMITeleportLocation.setCondition(CMITeleportCondition.BadFloor);
                }
                double d = 0.0;
                if (!this.getBlockType(chunkSnapshot, n2, positionRelativeData).isAir()) {
                    d = 0.501;
                }
                return cMITeleportLocation.setPosition(new Vector(cMITeleportationBounds.getPosition().getX(), (double)n2 + cMITeleportationBounds.getPosition().getY() % 1.0 + d, cMITeleportationBounds.getPosition().getZ()));
            }
            cMITeleportLocation.setCondition(CMITeleportCondition.Suffocation);
            return cMITeleportLocation;
        }));
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, boolean bl) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, bl, null);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, false, null);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, CMITeleportType cMITeleportType) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, false, cMITeleportType);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, boolean bl, CMITeleportType cMITeleportType) {
        return this.teleportPlayer(player, location, PlayerTeleportEvent.TeleportCause.PLUGIN, bl, cMITeleportType);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.teleportPlayer(player, location, teleportCause, false, null);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, boolean bl) {
        return this.teleportPlayer(player, location, teleportCause, bl, null);
    }

    public CompletableFuture<Boolean> finalizeTeleportation(Player player, PlayerTeleportEvent.TeleportCause teleportCause, CMITeleportLocation cMITeleportLocation) {
        SafeTeleport safeTeleport = new SafeTeleport(cMITeleportLocation.getLocation(), cMITeleportLocation.getLocation(), cMITeleportLocation.getCondition());
        CMIAsyncPlayerTeleportEvent cMIAsyncPlayerTeleportEvent = new CMIAsyncPlayerTeleportEvent((CommandSender)player, player, safeTeleport, cMITeleportLocation.getType());
        Bukkit.getServer().getPluginManager().callEvent((Event)cMIAsyncPlayerTeleportEvent);
        if (cMIAsyncPlayerTeleportEvent.isCancelled()) {
            return CompletableFuture.completedFuture(false);
        }
        if (this.setTeleportInvulnerability(player) && cMITeleportLocation.getCondition().equals((Object)CMITeleportCondition.Fall)) {
            cMITeleportLocation.setCondition(CMITeleportCondition.Good);
        }
        if (player.isOnline()) {
            return PaperLib.teleportAsync((Entity)player, (Location)cMITeleportLocation.getLocation(), (PlayerTeleportEvent.TeleportCause)teleportCause);
        }
        this.plugin.getNMS().setMiscLocation(player, cMITeleportLocation.getLocation());
        return CompletableFuture.completedFuture(true);
    }

    public CompletableFuture<CMITeleportFeedback> teleportPlayer(Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, boolean bl, CMITeleportType cMITeleportType) {
        Object object;
        Location location2 = player.getLocation();
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        CompletableFuture<CMITeleportLocation> completableFuture2 = null;
        if (bl) {
            object = new CMITeleportationBounds(location);
            ((CMITeleportationBounds)object).setUpRange(-1.0);
            ((CMITeleportationBounds)object).setMinY(CMIWorld.getMinHeight((World)location.getWorld()) + 1);
            ((CMITeleportationBounds)object).setImortal(TeleportHandler.isImortal(player));
            ((CMITeleportationBounds)object).setCanFly(player.getAllowFlight());
            ((CMITeleportationBounds)object).setFlying(player.isFlying());
            completableFuture2 = this.getSafeTeleportationLocation((CMITeleportationBounds)object, completableFuture);
        } else {
            completableFuture2 = CompletableFuture.completedFuture(new CMITeleportLocation(location.getWorld()).setPosition(location.toVector()).setPitch(location.getPitch()).setYaw(location.getYaw()));
        }
        object = new CMITeleportFeedback(location, false);
        CompletionStage completionStage = completableFuture2.thenComposeAsync(arg_0 -> this.lambda$5((CMITeleportFeedback)object, cMITeleportType, bl, player, location, teleportCause, arg_0));
        return ((CompletableFuture)completionStage).thenComposeAsync(arg_0 -> TeleportHandler.lambda$6(cMITeleportType, location2, (CMITeleportFeedback)object, arg_0));
    }

    public List<Entity> shakePassengers(Entity entity) {
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        if (Version.isCurrentEqualOrHigher((Version)Version.v1_11_R1)) {
            for (Entity entity2 : entity.getPassengers()) {
                if (entity2 == null) continue;
                arrayList.add(entity2);
                entity2.leaveVehicle();
                if (entity2 instanceof Slime && entity2.getCustomName().equalsIgnoreCase("CMIFakeSlime")) {
                    entity2.remove();
                }
                return arrayList;
            }
        }
        if (entity.getPassenger() == null) {
            return arrayList;
        }
        arrayList.add(entity.getPassenger());
        entity.getPassenger().leaveVehicle();
        if (entity.getPassenger() instanceof Slime && entity.getPassenger().getCustomName().equalsIgnoreCase("CMIFakeSlime")) {
            entity.getPassenger().remove();
        }
        return arrayList;
    }

    public boolean isEmptySpaceForPlayer(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        if (n <= positionRelativeData.getMaxWorldY() && n >= positionRelativeData.getMinWorldY() && !this.isEmpty(this.getBlockType(chunkSnapshot, n, positionRelativeData), true)) {
            return false;
        }
        return n >= positionRelativeData.getMaxWorldY() || n < positionRelativeData.getMinWorldY() || this.isEmpty(this.getBlockType(chunkSnapshot, n + 1, positionRelativeData), true);
    }

    public boolean isEmpty(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        return n >= positionRelativeData.getMaxWorldY() - 1 || n < positionRelativeData.getMinWorldY() || this.isEmpty(this.getBlockType(chunkSnapshot, n, positionRelativeData), true);
    }

    public boolean isEmpty(CMIMaterial cMIMaterial, boolean bl) {
        if (cMIMaterial == null) {
            return false;
        }
        if (cMIMaterial.isNone()) {
            return true;
        }
        if (cMIMaterial.isAir()) {
            return true;
        }
        if (cMIMaterial.isLava()) {
            return false;
        }
        if (bl && cMIMaterial.isWater()) {
            return true;
        }
        return this.emptyBlockMap.contains(cMIMaterial);
    }

    public boolean isBad(CMIMaterial cMIMaterial) {
        return this.badBlockMap.contains(cMIMaterial);
    }

    private boolean setTeleportInvulnerability(Player player) {
        boolean bl;
        if (!player.isOnline() || this.plugin.getTeleportManager().getInvulnerabilityTime() <= 0) {
            return false;
        }
        CMIUser cMIUser = CMIUser.getUser(player);
        boolean bl2 = bl = cMIUser.getTgod() > System.currentTimeMillis();
        if (!bl) {
            player.setNoDamageTicks(this.plugin.getTeleportManager().getInvulnerabilityTime() * 20);
        }
        cMIUser.setTeleportInvulnerability(System.currentTimeMillis() + 1000L * (long)this.plugin.getTeleportManager().getInvulnerabilityTime());
        return true;
    }

    public boolean needToFly(Player player) {
        int n = 0;
        Location location = player.getLocation().clone();
        int n2 = location.getBlockY();
        int n3 = CMIWorld.getMinHeight((World)location.getWorld());
        while (this.isEmpty(CMIMaterial.get((Block)location.getBlock()), true) && n2 > n3) {
            ++n;
            location.setY((double)(--n2));
        }
        if (this.isBad(CMIMaterial.get((Block)location.getBlock()))) {
            return true;
        }
        if (n2 <= n3) {
            return true;
        }
        return n > 4;
    }

    public CompletableFuture<Double> getDistanceToDrop(Location location) {
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = 0;
            int n2 = location.getBlockY();
            while (n2 >= CMIWorld.getMinHeight((World)location.getWorld())) {
                if (!this.isEmpty(cMIChunkSnapShot.getSnapshot(), n2, positionRelativeData)) break;
                ++n;
                --n2;
            }
            return n;
        }));
    }

    public CompletableFuture<CMITeleportFeedback> getSafeLocation(Player player, Location location, int n, int n2) {
        return this.getSafeLocation(player, location, n, n2, true);
    }

    public CompletableFuture<CMITeleportFeedback> getSafeLocation(Player player, Location location, int n, int n2, boolean bl) {
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        CMITeleportationBounds cMITeleportationBounds = new CMITeleportationBounds(location);
        cMITeleportationBounds.setUpRange(n);
        cMITeleportationBounds.setDownRange(n2);
        if (bl) {
            cMITeleportationBounds.setImortal(TeleportHandler.isImortal(player));
            cMITeleportationBounds.setCanFly(player.getAllowFlight());
            cMITeleportationBounds.setFlying(player.isFlying());
        }
        CompletableFuture<CMITeleportLocation> completableFuture2 = this.getSafeTeleportationLocation(cMITeleportationBounds, completableFuture);
        CMITeleportFeedback cMITeleportFeedback = new CMITeleportFeedback(location, false);
        return completableFuture2.thenComposeAsync(cMITeleportLocation -> CompletableFuture.supplyAsync(() -> {
            cMITeleportFeedback.setCondition(cMITeleportLocation.getCondition());
            if (cMITeleportLocation.getPosition() == null) {
                return cMITeleportFeedback;
            }
            cMITeleportFeedback.setLocation(cMITeleportLocation.getLocation());
            cMITeleportFeedback.setFallDistance(cMITeleportLocation.getFallDistance());
            cMITeleportFeedback.setFloor(cMITeleportLocation.getFloor());
            if ((cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Void) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.BadFloor)) && player.isFlying() && player.getWorld().equals(location.getWorld()) && cMITeleportFeedback.getFallDistance() >= 1) {
                cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
            }
            return cMITeleportFeedback;
        }));
    }

    private static boolean isImortal(Player player) {
        CMIUser cMIUser = CMI.getInstance().getPlayerManager().getUser(player);
        if (cMIUser == null) {
            return false;
        }
        return cMIUser.isGod() || !player.getGameMode().equals((Object)GameMode.SURVIVAL) && !player.getGameMode().equals((Object)GameMode.ADVENTURE);
    }

    public boolean bypassesBadLocation(Player player, CMITeleportCondition cMITeleportCondition) {
        return PermissionsManager.CMIPerm.safeteleport_bypass_$1.hasPermission((CommandSender)player, cMITeleportCondition.name());
    }

    public CompletableFuture<Location> getTopLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            int n;
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n2 = n = location.getWorld().getEnvironment().equals((Object)World.Environment.NETHER) ? positionRelativeData.getMaxWorldY() - 3 : positionRelativeData.getMaxWorldY();
            while (n2 > positionRelativeData.getMinWorldY()) {
                if (this.isValidPosition(chunkSnapshot, n2, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n2 + 1), location.getZ());
                }
                --n2;
            }
            return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)cMIChunkSnapShot.getSnapshot().getHighestBlockYAt(positionRelativeData.getLocalX(), positionRelativeData.getLocalZ()), location.getZ());
        }));
    }

    public CompletableFuture<Location> getDownLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = location.getBlockY() - 2;
            while (n > positionRelativeData.getMinWorldY()) {
                if (this.isValidPosition(chunkSnapshot, n, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n + 1), location.getZ());
                }
                --n;
            }
            return null;
        }));
    }

    private boolean isValidPosition(ChunkSnapshot chunkSnapshot, int n, PositionRelativeData positionRelativeData) {
        CMIMaterial cMIMaterial = this.getBlockType(chunkSnapshot, n, positionRelativeData);
        if (cMIMaterial.isAir()) {
            return false;
        }
        if (this.isEmpty(cMIMaterial, false)) {
            return false;
        }
        return this.isEmptySpaceForPlayer(chunkSnapshot, n + 1, positionRelativeData);
    }

    public CompletableFuture<Location> getBottomLocation(Location location) {
        if (location == null) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<CMIChunkSnapShot> completableFuture = this.getSnapshot(location, true, true);
        return completableFuture.thenComposeAsync(cMIChunkSnapShot -> CompletableFuture.supplyAsync(() -> {
            if (cMIChunkSnapShot.getWorld() == null) {
                return null;
            }
            ChunkSnapshot chunkSnapshot = cMIChunkSnapShot.getSnapshot();
            PositionRelativeData positionRelativeData = new PositionRelativeData(location);
            int n = positionRelativeData.getMinWorldY();
            while (n < location.getBlockY()) {
                if (this.isValidPosition(chunkSnapshot, n, positionRelativeData)) {
                    return new Location(cMIChunkSnapShot.getWorld(), location.getX(), (double)(n + 1), location.getZ());
                }
                ++n;
            }
            return null;
        }));
    }

    private void fill() {
        this.emptyBlockMap.clear();
        CMIMaterial[] cMIMaterialArray = CMIMaterial.values();
        int n = cMIMaterialArray.length;
        int n2 = 0;
        while (n2 < n) {
            CMIMaterial cMIMaterial = cMIMaterialArray[n2];
            if (cMIMaterial.containsCriteria(new CMIMC[]{CMIMC.CARPET, CMIMC.NOCOLLISIONBOX})) {
                this.emptyBlockMap.add(cMIMaterial);
            }
            ++n2;
        }
        this.badBlockMap.add(CMIMaterial.LAVA);
        this.badBlockMap.add(CMIMaterial.FIRE);
        if (!Version.isCurrentEqualOrHigher((Version)Version.v1_13_R1)) {
            this.badBlockMap.add(CMIMaterial.LEGACY_STATIONARY_LAVA);
        }
        this.badBlockMap.add(CMIMaterial.MAGMA_BLOCK);
        this.badBlockMap.add(CMIMaterial.CACTUS);
    }

    private /* synthetic */ CompletionStage lambda$5(CMITeleportFeedback cMITeleportFeedback, CMITeleportType cMITeleportType, boolean bl, Player player, Location location, PlayerTeleportEvent.TeleportCause teleportCause, CMITeleportLocation cMITeleportLocation) {
        cMITeleportFeedback.setCondition(cMITeleportLocation.getCondition());
        if (cMITeleportLocation.getPosition() == null) {
            return CompletableFuture.completedFuture(false);
        }
        cMITeleportFeedback.setLocation(cMITeleportLocation.getLocation());
        cMITeleportLocation.setType(cMITeleportType);
        try {
            if (bl && !cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Good)) {
                cMITeleportFeedback.setFallDistance(cMITeleportLocation.getFallDistance());
                cMITeleportFeedback.setFloor(cMITeleportLocation.getFloor());
                if ((cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Void) || cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.BadFloor)) && player.isFlying() && player.getWorld().equals(location.getWorld()) && cMITeleportFeedback.getFallDistance() >= 1) {
                    cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
                    return this.finalizeTeleportation(player, teleportCause, cMITeleportLocation);
                }
                if (this.plugin.getTeleportManager().getInvulnerabilityTime() >= 0 && cMITeleportFeedback.getCondition().equals((Object)CMITeleportCondition.Fall)) {
                    cMITeleportFeedback.setCondition(CMITeleportCondition.Good);
                    return this.finalizeTeleportation(player, teleportCause, cMITeleportLocation);
                }
                return CompletableFuture.completedFuture(false);
            }
            return this.finalizeTeleportation(player, teleportCause, cMITeleportLocation);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return CompletableFuture.completedFuture(false);
        }
    }

    private static /* synthetic */ CompletionStage lambda$6(CMITeleportType cMITeleportType, Location location, CMITeleportFeedback cMITeleportFeedback, Boolean bl) {
        if (bl.booleanValue() && cMITeleportType != null) {
            try {
                if (cMITeleportType.getFrom() != null) {
                    cMITeleportType.getFrom().show(location);
                }
                if (cMITeleportType.getTo() != null) {
                    cMITeleportType.getTo().show(cMITeleportFeedback.getLocation());
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return CompletableFuture.completedFuture(cMITeleportFeedback.setSuccess(bl));
    }
}

